# Ayuda a FastAPI - Consigue Ayuda { #help-fastapi-get-help }

¿Te gusta **FastAPI**?

¿Te gustaría ayudar a FastAPI, a otros usuarios y al autor?

¿O te gustaría conseguir ayuda con **FastAPI**?

Hay formas muy sencillas de ayudar (varias implican solo uno o dos clics).

Y también hay varias formas de conseguir ayuda.

## Suscríbete al boletín { #subscribe-to-the-newsletter }

Puedes suscribirte al (esporádico) boletín [**FastAPI and friends**](newsletter.md){.internal-link target=_blank} para mantenerte al día sobre:

* Noticias sobre FastAPI y amigos 🚀
* Guías 📝
* Funcionalidades ✨
* Cambios importantes 🚨
* Consejos y trucos ✅

## Sigue a FastAPI en X (Twitter) { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Sigue a @fastapi en **X (Twitter)**</a> para obtener las últimas noticias sobre **FastAPI**. 🐦

## Dale una estrella a **FastAPI** en GitHub { #star-fastapi-in-github }

Puedes "darle una estrella" a FastAPI en GitHub (haciendo clic en el botón de estrella en la parte superior derecha): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Al agregar una estrella, otros usuarios podrán encontrarlo más fácilmente y ver que ya ha sido útil para otros.

## Observa el repositorio de GitHub para lanzamientos { #watch-the-github-repository-for-releases }

Puedes "observar" FastAPI en GitHub (haciendo clic en el botón "watch" en la parte superior derecha): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Allí puedes seleccionar "Releases only".

Al hacerlo, recibirás notificaciones (en tu email) cada vez que haya un nuevo lanzamiento (una nueva versión) de **FastAPI** con correcciones de bugs y nuevas funcionalidades.

## Conéctate con el autor { #connect-with-the-author }

Puedes conectar <a href="https://tiangolo.com" class="external-link" target="_blank">conmigo (Sebastián Ramírez / `tiangolo`)</a>, el autor.

Puedes:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Seguirme en **GitHub**</a>.
    * Ver otros proyectos de Código Abierto que he creado y que podrían ayudarte.
    * Seguirme para ver cuándo creo un nuevo proyecto de Código Abierto.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Seguirme en **X (Twitter)**</a> o <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Contarme cómo usas FastAPI (me encanta oír eso).
    * Enterarte cuando hago anuncios o lanzo nuevas herramientas.
    * También puedes <a href="https://x.com/fastapi" class="external-link" target="_blank">seguir @fastapi en X (Twitter)</a> (una cuenta aparte).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Seguirme en **LinkedIn**</a>.
    * Enterarte cuando hago anuncios o lanzo nuevas herramientas (aunque uso X (Twitter) más a menudo 🤷‍♂).
* Leer lo que escribo (o seguirme) en <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> o <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Leer otras ideas, artículos, y leer sobre las herramientas que he creado.
    * Seguirme para leer lo que publico nuevo.

## Twittea sobre **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Twittea sobre **FastAPI**</a> y dime a mí y a otros por qué te gusta. 🎉

Me encanta escuchar cómo se está utilizando **FastAPI**, qué te ha gustado, en qué proyecto/empresa lo estás usando, etc.

## Vota por FastAPI { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Vota por **FastAPI** en Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Vota por **FastAPI** en AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Di que usas **FastAPI** en StackShare</a>.

## Ayuda a otros con preguntas en GitHub { #help-others-with-questions-in-github }

Puedes intentar ayudar a otros con sus preguntas en:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

En muchos casos, probablemente ya conozcas la respuesta a esas preguntas. 🤓

Si estás ayudando mucho a la gente con sus preguntas, te convertirás en un [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank} oficial. 🎉

Solo recuerda, el punto más importante es: trata de ser amable. La gente llega con sus frustraciones y, en muchos casos, no pregunta de la mejor manera, pero haz todo lo posible por ser amable. 🤗

La idea es que la comunidad de **FastAPI** sea amable y acogedora. Al mismo tiempo, no aceptes acoso o comportamiento irrespetuoso hacia los demás. Tenemos que cuidarnos unos a otros.

---

Aquí te explico cómo ayudar a otros con preguntas (en discusiones o issues):

### Entiende la pregunta { #understand-the-question }

* Revisa si puedes entender cuál es el **propósito** y el caso de uso de la persona que pregunta.

* Luego revisa si la pregunta (la gran mayoría son preguntas) es **clara**.

* En muchos casos, la pregunta planteada es sobre una solución imaginaria del usuario, pero podría haber una **mejor**. Si puedes entender mejor el problema y el caso de uso, podrías sugerir una mejor **solución alternativa**.

* Si no puedes entender la pregunta, pide más **detalles**.

### Reproduce el problema { #reproduce-the-problem }

En la mayoría de los casos y preguntas hay algo relacionado con el **código original** de la persona.

En muchos casos solo copiarán un fragmento del código, pero eso no es suficiente para **reproducir el problema**.

* Puedes pedirles que proporcionen un <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">ejemplo mínimo, reproducible</a>, que puedas **copiar-pegar** y ejecutar localmente para ver el mismo error o comportamiento que están viendo, o para entender mejor su caso de uso.

* Si te sientes muy generoso, puedes intentar **crear un ejemplo** así tú mismo, solo basado en la descripción del problema. Solo ten en cuenta que esto podría llevar mucho tiempo y podría ser mejor pedirles que aclaren el problema primero.

### Sugerir soluciones { #suggest-solutions }

* Después de poder entender la pregunta, puedes darles un posible **respuesta**.

* En muchos casos, es mejor entender su **problema subyacente o caso de uso**, porque podría haber una mejor manera de resolverlo que lo que están intentando hacer.

### Pide cerrar { #ask-to-close }

Si responden, hay una alta probabilidad de que hayas resuelto su problema, felicidades, ¡**eres un héroe**! 🦸

* Ahora, si eso resolvió su problema, puedes pedirles que:

    * En GitHub Discussions: marquen el comentario como la **respuesta**.
    * En GitHub Issues: **cierren** el issue.

## Observa el repositorio de GitHub { #watch-the-github-repository }

Puedes "observar" FastAPI en GitHub (haciendo clic en el botón "watch" en la parte superior derecha): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Si seleccionas "Watching" en lugar de "Releases only", recibirás notificaciones cuando alguien cree un nuevo issue o pregunta. También puedes especificar que solo deseas que te notifiquen sobre nuevos issues, discusiones, PRs, etc.

Luego puedes intentar ayudarlos a resolver esas preguntas.

## Haz preguntas { #ask-questions }

Puedes <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">crear una nueva pregunta</a> en el repositorio de GitHub, por ejemplo, para:

* Hacer una **pregunta** o preguntar sobre un **problema**.
* Sugerir una nueva **funcionalidad**.

**Nota**: si lo haces, entonces te voy a pedir que también ayudes a otros. 😉

## Revisa Pull Requests { #review-pull-requests }

Puedes ayudarme a revisar pull requests de otros.

De nuevo, por favor, haz tu mejor esfuerzo por ser amable. 🤗

---

Aquí está lo que debes tener en cuenta y cómo revisar un pull request:

### Entiende el problema { #understand-the-problem }

* Primero, asegúrate de **entender el problema** que el pull request está intentando resolver. Podría tener una discusión más larga en una GitHub Discussion o issue.

* También hay una buena posibilidad de que el pull request no sea realmente necesario porque el problema se puede resolver de una manera **diferente**. Entonces puedes sugerir o preguntar sobre eso.

### No te preocupes por el estilo { #dont-worry-about-style }

* No te preocupes demasiado por cosas como los estilos de los mensajes de commit, yo haré squash y merge personalizando el commit manualmente.

* Tampoco te preocupes por las reglas de estilo, hay herramientas automatizadas verificando eso.

Y si hay alguna otra necesidad de estilo o consistencia, pediré directamente eso, o agregaré commits encima con los cambios necesarios.

### Revisa el código { #check-the-code }

* Revisa y lee el código, ve si tiene sentido, **ejecútalo localmente** y ve si realmente resuelve el problema.

* Luego **comenta** diciendo que hiciste eso, así sabré que realmente lo revisaste.

/// info | Información

Desafortunadamente, no puedo simplemente confiar en PRs que solo tienen varias aprobaciones.

Varias veces ha sucedido que hay PRs con 3, 5 o más aprobaciones, probablemente porque la descripción es atractiva, pero cuando reviso los PRs, en realidad están rotos, tienen un bug, o no resuelven el problema que dicen resolver. 😅

Así que, es realmente importante que realmente leas y ejecutes el código, y me hagas saber en los comentarios que lo hiciste. 🤓

///

* Si el PR se puede simplificar de alguna manera, puedes pedir eso, pero no hay necesidad de ser demasiado exigente, podría haber muchos puntos de vista subjetivos (y yo tendré el mío también 🙈), así que es mejor si puedes centrarte en las cosas fundamentales.

### Tests { #tests }

* Ayúdame a verificar que el PR tenga **tests**.

* Verifica que los tests **fallen** antes del PR. 🚨

* Luego verifica que los tests **pasen** después del PR. ✅

* Muchos PRs no tienen tests, puedes **recordarles** que agreguen tests, o incluso puedes **sugerir** algunos tests tú mismo. Eso es una de las cosas que consume más tiempo y puedes ayudar mucho con eso.

* Luego también comenta lo que intentaste, de esa manera sabré que lo revisaste. 🤓

## Crea un Pull Request { #create-a-pull-request }

Puedes [contribuir](contributing.md){.internal-link target=_blank} al código fuente con Pull Requests, por ejemplo:

* Para corregir un error tipográfico que encontraste en la documentación.
* Para compartir un artículo, video o podcast que creaste o encontraste sobre FastAPI <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">editando este archivo</a>.
    * Asegúrate de agregar tu enlace al inicio de la sección correspondiente.
* Para ayudar a [traducir la documentación](contributing.md#translations){.internal-link target=_blank} a tu idioma.
    * También puedes ayudar a revisar las traducciones creadas por otros.
* Para proponer nuevas secciones de documentación.
* Para corregir un issue/bug existente.
    * Asegúrate de agregar tests.
* Para agregar una nueva funcionalidad.
    * Asegúrate de agregar tests.
    * Asegúrate de agregar documentación si es relevante.

## Ayuda a Mantener FastAPI { #help-maintain-fastapi }

¡Ayúdame a mantener **FastAPI**! 🤓

Hay mucho trabajo por hacer, y para la mayoría de ello, **TÚ** puedes hacerlo.

Las tareas principales que puedes hacer ahora son:

* [Ayudar a otros con preguntas en GitHub](#help-others-with-questions-in-github){.internal-link target=_blank} (ver la sección arriba).
* [Revisar Pull Requests](#review-pull-requests){.internal-link target=_blank} (ver la sección arriba).

Esas dos tareas son las que **consumen más tiempo**. Ese es el trabajo principal de mantener FastAPI.

Si puedes ayudarme con eso, **me estás ayudando a mantener FastAPI** y asegurando que siga **avanzando más rápido y mejor**. 🚀

## Únete al chat { #join-the-chat }

Únete al servidor de chat 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord</a> 👥 y charla con otros en la comunidad de FastAPI.

/// tip | Consejo

Para preguntas, házlas en <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>, hay muchas más probabilidades de que recibas ayuda de parte de los [FastAPI Experts](fastapi-people.md#fastapi-experts){.internal-link target=_blank}.

Usa el chat solo para otras conversaciones generales.

///

### No uses el chat para preguntas { #dont-use-the-chat-for-questions }

Ten en cuenta que dado que los chats permiten una "conversación más libre", es fácil hacer preguntas que son demasiado generales y más difíciles de responder, por lo que es posible que no recibas respuestas.

En GitHub, la plantilla te guiará para escribir la pregunta correcta para que puedas obtener más fácilmente una buena respuesta, o incluso resolver el problema por ti mismo antes de preguntar. Y en GitHub puedo asegurarme de responder siempre todo, incluso si lleva tiempo. No puedo hacer eso personalmente con los sistemas de chat. 😅

Las conversaciones en los sistemas de chat tampoco son tan fácilmente buscables como en GitHub, por lo que las preguntas y respuestas podrían perderse en la conversación. Y solo las que están en GitHub cuentan para convertirse en un [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, por lo que probablemente recibirás más atención en GitHub.

Por otro lado, hay miles de usuarios en los sistemas de chat, por lo que hay muchas posibilidades de que encuentres a alguien con quien hablar allí, casi todo el tiempo. 😄

## Patrocina al autor { #sponsor-the-author }

Si tu **producto/empresa** depende de o está relacionado con **FastAPI** y quieres llegar a sus usuarios, puedes patrocinar al autor (a mí) a través de <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>. Según el nivel, podrías obtener algunos beneficios extra, como una insignia en la documentación. 🎁

---

¡Gracias! 🚀
