// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#include "vtkBrush.h"
#include "vtkContext2D.h"
#include "vtkContextItem.h"
#include "vtkContextScene.h"
#include "vtkContextView.h"
#include "vtkObjectFactory.h"
#include "vtkPen.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSmartPointer.h"
#include "vtkTextProperty.h"

#include <QApplication>

//------------------------------------------------------------------------------
class QtContextUnicode : public vtkContextItem
{
public:
  static QtContextUnicode* New();
  vtkTypeMacro(QtContextUnicode, vtkContextItem);
  // Paint event for the chart, called whenever the chart needs to be drawn
  virtual bool Paint(vtkContext2D* painter);
};

//------------------------------------------------------------------------------
int TestQtContextUnicode(int argc, char* argv[])
{
  QApplication app(argc, argv);
  // Set up a 2D context view, context test object and add it to the scene
  vtkSmartPointer<vtkContextView> view = vtkSmartPointer<vtkContextView>::New();
  view->GetRenderWindow()->SetSize(200, 100);
  vtkSmartPointer<QtContextUnicode> test = vtkSmartPointer<QtContextUnicode>::New();
  view->GetScene()->AddItem(test);

  view->GetRenderWindow()->SetMultiSamples(0);
  view->GetInteractor()->Initialize();
  view->GetInteractor()->Start();
  return EXIT_SUCCESS;
}

// Make our new derived class to draw a diagram
vtkStandardNewMacro(QtContextUnicode);
// This function aims to test the primitives provided by the 2D API.
bool QtContextUnicode::Paint(vtkContext2D* painter)
{
  // Test the string drawing functionality of the context
  painter->GetTextProp()->SetVerticalJustificationToCentered();
  painter->GetTextProp()->SetJustificationToCentered();
  painter->GetTextProp()->SetColor(0.0, 0.0, 0.0);
  painter->GetTextProp()->SetFontSize(24);
  painter->DrawString(70, 20, "Angstrom");
  painter->DrawString(150, 20, "\xe2\x84\xab");
  painter->DrawString(100, 80, "a\xce\xb1\xe0\xb8\x81\xf0\x90\x80\x80");
  painter->DrawString(100, 50, "\xce\xb1\xce\xb2\xce\xb3");
  return true;
}
