// RUN: mlir-opt %s \
// RUN:  | mlir-opt -gpu-lower-to-nvvm-pipeline -debug-only=serialize-to-isa \
// RUN:  2>&1 | FileCheck %s

// CHECK-LABEL: Generated by LLVM NVPTX Back-End
// CHECK: .visible .func kernel_a()
// CHECK: ret;
gpu.module @bar {
  llvm.func @kernel_a()
    attributes  { gpu.kernel } {
    llvm.return
  }
}

// CHECK-LABEL: Generated by LLVM NVPTX Back-End
// CHECK: .visible .func  ({{.+}}) fma(
// CHECK: fma.rn.f32

gpu.module @foo {
  llvm.func @fma(%arg0: f32, %arg1: f32) -> f32
    attributes { gpu.kernel } {
    %res = llvm.intr.fma (%arg0, %arg1, %arg1) : (f32, f32, f32) -> f32
    llvm.return %res : f32
  }
}
