/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_c_epc17.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t8, t9, t10, t11;
  double t12, t15, t18, t19, tzk0;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t8 = POW_2(0.1e1 + t6);
  t9 = t8 * rho[0];
  t10 = rho[0] * rho[0];
  t11 = t8 * t10;
  t12 = sqrt(t11);
  t15 = params->c * t8;
  t18 = params->a - params->b * t12 / 0.2e1 + t15 * t10 / 0.4e1;
  t19 = 0.1e1 / t18;
  tzk0 = my_piecewise3(t2, 0, -t9 * t19 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t8, t9, t10, t11;
  double t12, t15, t18, t19, tzk0;

  double t23, t24, t26, t30, t35, tvrho0;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t8 = POW_2(0.1e1 + t6);
  t9 = t8 * rho[0];
  t10 = rho[0] * rho[0];
  t11 = t8 * t10;
  t12 = sqrt(t11);
  t15 = params->c * t8;
  t18 = params->a - params->b * t12 / 0.2e1 + t15 * t10 / 0.4e1;
  t19 = 0.1e1 / t18;
  tzk0 = my_piecewise3(t2, 0, -t9 * t19 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t23 = t18 * t18;
  t24 = 0.1e1 / t23;
  t26 = params->b / t12;
  t30 = t15 * rho[0] / 0.2e1 - t26 * t9 / 0.2e1;
  t35 = my_piecewise3(t2, 0, t9 * t24 * t30 / 0.4e1 - t8 * t19 / 0.4e1);
  tvrho0 = rho[0] * t35 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t8, t9, t10, t11;
  double t12, t15, t18, t19, tzk0;

  double t23, t24, t26, t30, t35, tvrho0;

  double t38, t42, t43, t49, t50, t55, t60, tv2rho20;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t8 = POW_2(0.1e1 + t6);
  t9 = t8 * rho[0];
  t10 = rho[0] * rho[0];
  t11 = t8 * t10;
  t12 = sqrt(t11);
  t15 = params->c * t8;
  t18 = params->a - params->b * t12 / 0.2e1 + t15 * t10 / 0.4e1;
  t19 = 0.1e1 / t18;
  tzk0 = my_piecewise3(t2, 0, -t9 * t19 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t23 = t18 * t18;
  t24 = 0.1e1 / t23;
  t26 = params->b / t12;
  t30 = t15 * rho[0] / 0.2e1 - t26 * t9 / 0.2e1;
  t35 = my_piecewise3(t2, 0, t9 * t24 * t30 / 0.4e1 - t8 * t19 / 0.4e1);
  tvrho0 = rho[0] * t35 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t38 = t8 * t24;
  t42 = 0.1e1 / t23 / t18;
  t43 = t30 * t30;
  t49 = params->b / t12 / t11;
  t50 = t8 * t8;
  t55 = t49 * t50 * t10 / 0.2e1 - t26 * t8 / 0.2e1 + t15 / 0.2e1;
  t60 = my_piecewise3(t2, 0, t38 * t30 / 0.2e1 - t9 * t42 * t43 / 0.2e1 + t9 * t24 * t55 / 0.4e1);
  tv2rho20 = rho[0] * t60 + 0.2e1 * t35;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t8, t9, t10, t11;
  double t12, t15, t18, t19, tzk0;

  double t23, t24, t26, t30, t35, tvrho0;

  double t38, t42, t43, t49, t50, t55, t60, tv2rho20;

  double t63, t68, t69, t70, t74, t78, t82, t83;
  double t90, t95, tv3rho30;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t8 = POW_2(0.1e1 + t6);
  t9 = t8 * rho[0];
  t10 = rho[0] * rho[0];
  t11 = t8 * t10;
  t12 = sqrt(t11);
  t15 = params->c * t8;
  t18 = params->a - params->b * t12 / 0.2e1 + t15 * t10 / 0.4e1;
  t19 = 0.1e1 / t18;
  tzk0 = my_piecewise3(t2, 0, -t9 * t19 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t23 = t18 * t18;
  t24 = 0.1e1 / t23;
  t26 = params->b / t12;
  t30 = t15 * rho[0] / 0.2e1 - t26 * t9 / 0.2e1;
  t35 = my_piecewise3(t2, 0, t9 * t24 * t30 / 0.4e1 - t8 * t19 / 0.4e1);
  tvrho0 = rho[0] * t35 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t38 = t8 * t24;
  t42 = 0.1e1 / t23 / t18;
  t43 = t30 * t30;
  t49 = params->b / t12 / t11;
  t50 = t8 * t8;
  t55 = t49 * t50 * t10 / 0.2e1 - t26 * t8 / 0.2e1 + t15 / 0.2e1;
  t60 = my_piecewise3(t2, 0, t38 * t30 / 0.2e1 - t9 * t42 * t43 / 0.2e1 + t9 * t24 * t55 / 0.4e1);
  tv2rho20 = rho[0] * t60 + 0.2e1 * t35;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t63 = t8 * t42;
  t68 = t23 * t23;
  t69 = 0.1e1 / t68;
  t70 = t43 * t30;
  t74 = t42 * t30;
  t78 = t10 * t10;
  t82 = params->b / t12 / t50 / t78;
  t83 = t50 * t8;
  t90 = -0.3e1 / 0.2e1 * t82 * t83 * t10 * rho[0] + 0.3e1 / 0.2e1 * t49 * t50 * rho[0];
  t95 = my_piecewise3(t2, 0, -0.3e1 / 0.2e1 * t63 * t43 + 0.3e1 / 0.4e1 * t38 * t55 + 0.3e1 / 0.2e1 * t9 * t69 * t70 - 0.3e1 / 0.2e1 * t9 * t74 * t55 + t9 * t24 * t90 / 0.4e1);
  tv3rho30 = rho[0] * t95 + 0.3e1 * t60;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t8, t9, t10, t11;
  double t12, t15, t18, t19, tzk0;

  double t23, t24, t26, t30, t35, tvrho0;

  double t38, t42, t43, t49, t50, t55, t60, tv2rho20;

  double t63, t68, t69, t70, t74, t78, t82, t83;
  double t90, t95, tv3rho30;

  double t107, t115, t127, t141, tv4rho40;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t8 = POW_2(0.1e1 + t6);
  t9 = t8 * rho[0];
  t10 = rho[0] * rho[0];
  t11 = t8 * t10;
  t12 = sqrt(t11);
  t15 = params->c * t8;
  t18 = params->a - params->b * t12 / 0.2e1 + t15 * t10 / 0.4e1;
  t19 = 0.1e1 / t18;
  tzk0 = my_piecewise3(t2, 0, -t9 * t19 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t23 = t18 * t18;
  t24 = 0.1e1 / t23;
  t26 = params->b / t12;
  t30 = t15 * rho[0] / 0.2e1 - t26 * t9 / 0.2e1;
  t35 = my_piecewise3(t2, 0, t9 * t24 * t30 / 0.4e1 - t8 * t19 / 0.4e1);
  tvrho0 = rho[0] * t35 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t38 = t8 * t24;
  t42 = 0.1e1 / t23 / t18;
  t43 = t30 * t30;
  t49 = params->b / t12 / t11;
  t50 = t8 * t8;
  t55 = t49 * t50 * t10 / 0.2e1 - t26 * t8 / 0.2e1 + t15 / 0.2e1;
  t60 = my_piecewise3(t2, 0, t38 * t30 / 0.2e1 - t9 * t42 * t43 / 0.2e1 + t9 * t24 * t55 / 0.4e1);
  tv2rho20 = rho[0] * t60 + 0.2e1 * t35;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t63 = t8 * t42;
  t68 = t23 * t23;
  t69 = 0.1e1 / t68;
  t70 = t43 * t30;
  t74 = t42 * t30;
  t78 = t10 * t10;
  t82 = params->b / t12 / t50 / t78;
  t83 = t50 * t8;
  t90 = -0.3e1 / 0.2e1 * t82 * t83 * t10 * rho[0] + 0.3e1 / 0.2e1 * t49 * t50 * rho[0];
  t95 = my_piecewise3(t2, 0, -0.3e1 / 0.2e1 * t63 * t43 + 0.3e1 / 0.4e1 * t38 * t55 + 0.3e1 / 0.2e1 * t9 * t69 * t70 - 0.3e1 / 0.2e1 * t9 * t74 * t55 + t9 * t24 * t90 / 0.4e1);
  tv3rho30 = rho[0] * t95 + 0.3e1 * t60;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t107 = t43 * t43;
  t115 = t55 * t55;
  t127 = t50 * t50;
  t141 = my_piecewise3(t2, 0, 0.6e1 * t8 * t69 * t70 - 0.6e1 * t63 * t30 * t55 + t38 * t90 - 0.6e1 * t9 / t68 / t18 * t107 + 0.9e1 * t9 * t69 * t43 * t55 - 0.3e1 / 0.2e1 * t9 * t42 * t115 - 0.2e1 * t9 * t74 * t90 + t9 * t24 * (0.15e2 / 0.2e1 * params->b / t12 / t83 / t10 * t127 - 0.9e1 * t82 * t83 * t10 + 0.3e1 / 0.2e1 * t49 * t50) / 0.4e1);
  tv4rho40 = rho[0] * t141 + 0.4e1 * t95;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t26, t29, t30, t33, t34, t35, tzk0;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = t4 * t4;
  t24 = t17 * t23;
  t25 = t24 * t22;
  t26 = sqrt(t25);
  t29 = params->c * t17;
  t30 = t23 * t22;
  t33 = params->a - params->b * t26 / 0.2e1 + t29 * t30 / 0.4e1;
  t34 = 0.1e1 / t33;
  t35 = t22 * t34;
  tzk0 = my_piecewise3(t3, 0, -t18 * t35 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t26, t29, t30, t33, t34, t35, tzk0;

  double t38, t39, t41, t42, t44, t45, t46, t48;
  double t49, t51, t52, t53, t55, t56, t58, t59;
  double t61, t64, t67, t69, t70, t73, t74, t78;
  double tvrho0, t81, t82, t85, t86, t88, t91, t94;
  double t97, t100, t101, t105, tvrho1;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = t4 * t4;
  t24 = t17 * t23;
  t25 = t24 * t22;
  t26 = sqrt(t25);
  t29 = params->c * t17;
  t30 = t23 * t22;
  t33 = params->a - params->b * t26 / 0.2e1 + t29 * t30 / 0.4e1;
  t34 = 0.1e1 / t33;
  t35 = t22 * t34;
  tzk0 = my_piecewise3(t3, 0, -t18 * t35 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = 0.1e1 / t23;
  t39 = t14 * t38;
  t41 = my_piecewise5(t8, 0, t12, 0, t5 - t39);
  t42 = t41 * t4;
  t44 = t17 * t22;
  t45 = t44 * t34;
  t46 = t19 * t38;
  t48 = my_piecewise5(t12, 0, t8, 0, -t5 - t46);
  t49 = t48 * t34;
  t51 = t33 * t33;
  t52 = 0.1e1 / t51;
  t53 = t22 * t52;
  t55 = params->b / t26;
  t56 = t41 * t23;
  t58 = t18 * t22;
  t59 = 0.2e1 * t58;
  t61 = t56 * t22 + t24 * t48 + t59;
  t64 = params->c * t41;
  t67 = t4 * t22;
  t69 = t29 * t67 / 0.2e1;
  t70 = t23 * t48;
  t73 = -t55 * t61 / 0.4e1 + t64 * t30 / 0.4e1 + t69 + t29 * t70 / 0.4e1;
  t74 = t53 * t73;
  t78 = my_piecewise3(t3, 0, -t18 * t49 / 0.4e1 + t18 * t74 / 0.4e1 - t42 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho0 = t4 * t78 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = my_piecewise5(t8, 0, t12, 0, -t5 - t39);
  t82 = t81 * t4;
  t85 = my_piecewise5(t12, 0, t8, 0, t5 - t46);
  t86 = t85 * t34;
  t88 = t81 * t23;
  t91 = t88 * t22 + t24 * t85 + t59;
  t94 = params->c * t81;
  t97 = t23 * t85;
  t100 = -t55 * t91 / 0.4e1 + t94 * t30 / 0.4e1 + t69 + t29 * t97 / 0.4e1;
  t101 = t53 * t100;
  t105 = my_piecewise3(t3, 0, t18 * t101 / 0.4e1 - t18 * t86 / 0.4e1 - t82 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho1 = t4 * t105 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t26, t29, t30, t33, t34, t35, tzk0;

  double t38, t39, t41, t42, t44, t45, t46, t48;
  double t49, t51, t52, t53, t55, t56, t58, t59;
  double t61, t64, t67, t69, t70, t73, t74, t78;
  double tvrho0, t81, t82, t85, t86, t88, t91, t94;
  double t97, t100, t101, t105, tvrho1;

  double t109, t110, t113, t114, t117, t118, t124, t125;
  double t127, t128, t130, t133, t134, t137, t138, t142;
  double t143, t144, t145, t150, t151, t154, t156, t160;
  double t161, t164, t167, t170, t174, t175, t176, t177;
  double t180, t181, t185, tv2rho20, t188, t189, t192, t193;
  double t204, t205, t208, t209, t212, t213, t218, t219;
  double t221, t224, t225, t228, t231, t233, t239, t242;
  double t245, t248, t256, t257, t259, t262, t263, t266;
  double t267, tv2rho21, t272, t273, t285, t286, t289, t292;
  double t293, t296, t299, t306, t309, t314, t317, t318;
  double t322, tv2rho22;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = t4 * t4;
  t24 = t17 * t23;
  t25 = t24 * t22;
  t26 = sqrt(t25);
  t29 = params->c * t17;
  t30 = t23 * t22;
  t33 = params->a - params->b * t26 / 0.2e1 + t29 * t30 / 0.4e1;
  t34 = 0.1e1 / t33;
  t35 = t22 * t34;
  tzk0 = my_piecewise3(t3, 0, -t18 * t35 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = 0.1e1 / t23;
  t39 = t14 * t38;
  t41 = my_piecewise5(t8, 0, t12, 0, t5 - t39);
  t42 = t41 * t4;
  t44 = t17 * t22;
  t45 = t44 * t34;
  t46 = t19 * t38;
  t48 = my_piecewise5(t12, 0, t8, 0, -t5 - t46);
  t49 = t48 * t34;
  t51 = t33 * t33;
  t52 = 0.1e1 / t51;
  t53 = t22 * t52;
  t55 = params->b / t26;
  t56 = t41 * t23;
  t58 = t18 * t22;
  t59 = 0.2e1 * t58;
  t61 = t56 * t22 + t24 * t48 + t59;
  t64 = params->c * t41;
  t67 = t4 * t22;
  t69 = t29 * t67 / 0.2e1;
  t70 = t23 * t48;
  t73 = -t55 * t61 / 0.4e1 + t64 * t30 / 0.4e1 + t69 + t29 * t70 / 0.4e1;
  t74 = t53 * t73;
  t78 = my_piecewise3(t3, 0, -t18 * t49 / 0.4e1 + t18 * t74 / 0.4e1 - t42 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho0 = t4 * t78 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = my_piecewise5(t8, 0, t12, 0, -t5 - t39);
  t82 = t81 * t4;
  t85 = my_piecewise5(t12, 0, t8, 0, t5 - t46);
  t86 = t85 * t34;
  t88 = t81 * t23;
  t91 = t88 * t22 + t24 * t85 + t59;
  t94 = params->c * t81;
  t97 = t23 * t85;
  t100 = -t55 * t91 / 0.4e1 + t94 * t30 / 0.4e1 + t69 + t29 * t97 / 0.4e1;
  t101 = t53 * t100;
  t105 = my_piecewise3(t3, 0, t18 * t101 / 0.4e1 - t18 * t86 / 0.4e1 - t82 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho1 = t4 * t105 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t109 = 0.1e1 / t23 / t4;
  t110 = t14 * t109;
  t113 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t38 + 0.2e1 * t110);
  t114 = t113 * t4;
  t117 = t41 * t22;
  t118 = t117 * t34;
  t124 = t17 * t48;
  t125 = t124 * t34;
  t127 = t52 * t73;
  t128 = t44 * t127;
  t130 = t19 * t109;
  t133 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t38 + 0.2e1 * t130);
  t134 = t133 * t34;
  t137 = t48 * t52;
  t138 = t137 * t73;
  t142 = 0.1e1 / t51 / t33;
  t143 = t22 * t142;
  t144 = t73 * t73;
  t145 = t143 * t144;
  t150 = params->b / t26 / t25;
  t151 = t61 * t61;
  t154 = t113 * t23;
  t156 = t42 * t22;
  t160 = 0.2e1 * t44;
  t161 = t18 * t48;
  t164 = t24 * t133 + t154 * t22 + 0.2e1 * t56 * t48 + 0.4e1 * t156 + t160 + 0.4e1 * t161;
  t167 = params->c * t113;
  t170 = t64 * t67;
  t174 = t29 * t22 / 0.2e1;
  t175 = t4 * t48;
  t176 = t29 * t175;
  t177 = t23 * t133;
  t180 = t150 * t151 / 0.8e1 - t55 * t164 / 0.4e1 + t167 * t30 / 0.4e1 + t170 + t64 * t70 / 0.2e1 + t174 + t176 + t29 * t177 / 0.4e1;
  t181 = t53 * t180;
  t185 = my_piecewise3(t3, 0, -t114 * t35 / 0.4e1 - t118 / 0.2e1 - t42 * t49 / 0.2e1 + t42 * t74 / 0.2e1 - t125 / 0.2e1 + t128 / 0.2e1 - t18 * t134 / 0.4e1 + t18 * t138 / 0.2e1 - t18 * t145 / 0.2e1 + t18 * t181 / 0.4e1);
  tv2rho20 = t4 * t185 + 0.2e1 * t78;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t188 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t110);
  t189 = t188 * t4;
  t192 = t81 * t22;
  t193 = t192 * t34;
  t204 = t17 * t85;
  t205 = t204 * t34;
  t208 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t130);
  t209 = t208 * t34;
  t212 = t85 * t52;
  t213 = t212 * t73;
  t218 = t52 * t100;
  t219 = t44 * t218;
  t221 = t137 * t100;
  t224 = t142 * t100;
  t225 = t224 * t73;
  t228 = t91 * t61;
  t231 = t188 * t23;
  t233 = t82 * t22;
  t239 = t18 * t85;
  t242 = t24 * t208 + t231 * t22 + t88 * t48 + t56 * t85 + 0.2e1 * t156 + t160 + 0.2e1 * t161 + 0.2e1 * t233 + 0.2e1 * t239;
  t245 = params->c * t188;
  t248 = t94 * t67;
  t256 = t4 * t85;
  t257 = t29 * t256;
  t259 = t23 * t208;
  t262 = t150 * t228 / 0.8e1 - t55 * t242 / 0.4e1 + t245 * t30 / 0.4e1 + t248 / 0.2e1 + t94 * t70 / 0.4e1 + t170 / 0.2e1 + t174 + t176 / 0.2e1 + t64 * t97 / 0.4e1 + t257 / 0.2e1 + t29 * t259 / 0.4e1;
  t263 = t53 * t262;
  t266 = -t189 * t35 / 0.4e1 - t193 / 0.4e1 - t82 * t49 / 0.4e1 + t82 * t74 / 0.4e1 - t118 / 0.4e1 - t125 / 0.4e1 + t128 / 0.4e1 - t42 * t86 / 0.4e1 - t205 / 0.4e1 - t18 * t209 / 0.4e1 + t18 * t213 / 0.4e1 + t42 * t101 / 0.4e1 + t219 / 0.4e1 + t18 * t221 / 0.4e1 - t58 * t225 / 0.2e1 + t18 * t263 / 0.4e1;
  t267 = my_piecewise3(t3, 0, t266);
  tv2rho21 = t4 * t267 + t105 + t78;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t272 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t38 + 0.2e1 * t110);
  t273 = t272 * t4;
  t285 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t38 + 0.2e1 * t130);
  t286 = t285 * t34;
  t289 = t212 * t100;
  t292 = t100 * t100;
  t293 = t143 * t292;
  t296 = t91 * t91;
  t299 = t272 * t23;
  t306 = t299 * t22 + t24 * t285 + 0.2e1 * t88 * t85 + t160 + 0.4e1 * t233 + 0.4e1 * t239;
  t309 = params->c * t272;
  t314 = t23 * t285;
  t317 = t150 * t296 / 0.8e1 - t55 * t306 / 0.4e1 + t309 * t30 / 0.4e1 + t248 + t94 * t97 / 0.2e1 + t174 + t257 + t29 * t314 / 0.4e1;
  t318 = t53 * t317;
  t322 = my_piecewise3(t3, 0, -t273 * t35 / 0.4e1 - t193 / 0.2e1 - t82 * t86 / 0.2e1 + t82 * t101 / 0.2e1 - t205 / 0.2e1 + t219 / 0.2e1 - t18 * t286 / 0.4e1 + t18 * t289 / 0.2e1 - t18 * t293 / 0.2e1 + t18 * t318 / 0.4e1);
  tv2rho22 = t4 * t322 + 0.2e1 * t105;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t26, t29, t30, t33, t34, t35, tzk0;

  double t38, t39, t41, t42, t44, t45, t46, t48;
  double t49, t51, t52, t53, t55, t56, t58, t59;
  double t61, t64, t67, t69, t70, t73, t74, t78;
  double tvrho0, t81, t82, t85, t86, t88, t91, t94;
  double t97, t100, t101, t105, tvrho1;

  double t109, t110, t113, t114, t117, t118, t124, t125;
  double t127, t128, t130, t133, t134, t137, t138, t142;
  double t143, t144, t145, t150, t151, t154, t156, t160;
  double t161, t164, t167, t170, t174, t175, t176, t177;
  double t180, t181, t185, tv2rho20, t188, t189, t192, t193;
  double t204, t205, t208, t209, t212, t213, t218, t219;
  double t221, t224, t225, t228, t231, t233, t239, t242;
  double t245, t248, t256, t257, t259, t262, t263, t266;
  double t267, tv2rho21, t272, t273, t285, t286, t289, t292;
  double t293, t296, t299, t306, t309, t314, t317, t318;
  double t322, tv2rho22;

  double t325, t326, t328, t329, t331, t332, t333, t336;
  double t337, t340, t341, t345, t349, t351, t352, t354;
  double t357, t358, t364, t365, t368, t369, t370, t371;
  double t372, t375, t376, t385, t386, t388, t389, t392;
  double t395, t397, t401, t402, t408, t410, t415, t420;
  double t423, t426, t429, t433, t435, t439, t441, t442;
  double t444, t447, t448, t451, t453, tv3rho30, t455, t457;
  double t461, t462, t464, t465, t470, t471, t477, t478;
  double t479, t481, t484, t485, t486, t487, t489, t496;
  double t499, t504, t507, t514, t516, t517, t518, t525;
  double t526, t527, t528, t529, t536, t537, t540, t552;
  double t553, t556, t563, t564, t567, t569, t570, t572;
  double t573, t575, t576, t578, t580, t584, t586, t587;
  double t593, t601, t603, t607, t612, t613, t618, t619;
  double t621, t624, t627, tv3rho31, t629, t630, t632, t633;
  double t635, t637, t648, t649, t653, t654, t658, t663;
  double t675, t677, t683, t691, t694, t697, t700, t707;
  double t714, t715, t717, t720, t721, t722, t727, t728;
  double t733, t736, t741, t751, t752, t754, t755, t757;
  double t758, t763, t764, t767, t769, t770, t773, t776;
  double tv3rho32, t784, t785, t794, t795, t800, t803, t804;
  double t808, t821, t824, t827, t830, t833, t845, t848;
  double t860, t863, t864, t867, t869, tv3rho33;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = t4 * t4;
  t24 = t17 * t23;
  t25 = t24 * t22;
  t26 = sqrt(t25);
  t29 = params->c * t17;
  t30 = t23 * t22;
  t33 = params->a - params->b * t26 / 0.2e1 + t29 * t30 / 0.4e1;
  t34 = 0.1e1 / t33;
  t35 = t22 * t34;
  tzk0 = my_piecewise3(t3, 0, -t18 * t35 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = 0.1e1 / t23;
  t39 = t14 * t38;
  t41 = my_piecewise5(t8, 0, t12, 0, t5 - t39);
  t42 = t41 * t4;
  t44 = t17 * t22;
  t45 = t44 * t34;
  t46 = t19 * t38;
  t48 = my_piecewise5(t12, 0, t8, 0, -t5 - t46);
  t49 = t48 * t34;
  t51 = t33 * t33;
  t52 = 0.1e1 / t51;
  t53 = t22 * t52;
  t55 = params->b / t26;
  t56 = t41 * t23;
  t58 = t18 * t22;
  t59 = 0.2e1 * t58;
  t61 = t56 * t22 + t24 * t48 + t59;
  t64 = params->c * t41;
  t67 = t4 * t22;
  t69 = t29 * t67 / 0.2e1;
  t70 = t23 * t48;
  t73 = -t55 * t61 / 0.4e1 + t64 * t30 / 0.4e1 + t69 + t29 * t70 / 0.4e1;
  t74 = t53 * t73;
  t78 = my_piecewise3(t3, 0, -t18 * t49 / 0.4e1 + t18 * t74 / 0.4e1 - t42 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho0 = t4 * t78 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = my_piecewise5(t8, 0, t12, 0, -t5 - t39);
  t82 = t81 * t4;
  t85 = my_piecewise5(t12, 0, t8, 0, t5 - t46);
  t86 = t85 * t34;
  t88 = t81 * t23;
  t91 = t88 * t22 + t24 * t85 + t59;
  t94 = params->c * t81;
  t97 = t23 * t85;
  t100 = -t55 * t91 / 0.4e1 + t94 * t30 / 0.4e1 + t69 + t29 * t97 / 0.4e1;
  t101 = t53 * t100;
  t105 = my_piecewise3(t3, 0, t18 * t101 / 0.4e1 - t18 * t86 / 0.4e1 - t82 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho1 = t4 * t105 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t109 = 0.1e1 / t23 / t4;
  t110 = t14 * t109;
  t113 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t38 + 0.2e1 * t110);
  t114 = t113 * t4;
  t117 = t41 * t22;
  t118 = t117 * t34;
  t124 = t17 * t48;
  t125 = t124 * t34;
  t127 = t52 * t73;
  t128 = t44 * t127;
  t130 = t19 * t109;
  t133 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t38 + 0.2e1 * t130);
  t134 = t133 * t34;
  t137 = t48 * t52;
  t138 = t137 * t73;
  t142 = 0.1e1 / t51 / t33;
  t143 = t22 * t142;
  t144 = t73 * t73;
  t145 = t143 * t144;
  t150 = params->b / t26 / t25;
  t151 = t61 * t61;
  t154 = t113 * t23;
  t156 = t42 * t22;
  t160 = 0.2e1 * t44;
  t161 = t18 * t48;
  t164 = t24 * t133 + t154 * t22 + 0.2e1 * t56 * t48 + 0.4e1 * t156 + t160 + 0.4e1 * t161;
  t167 = params->c * t113;
  t170 = t64 * t67;
  t174 = t29 * t22 / 0.2e1;
  t175 = t4 * t48;
  t176 = t29 * t175;
  t177 = t23 * t133;
  t180 = t150 * t151 / 0.8e1 - t55 * t164 / 0.4e1 + t167 * t30 / 0.4e1 + t170 + t64 * t70 / 0.2e1 + t174 + t176 + t29 * t177 / 0.4e1;
  t181 = t53 * t180;
  t185 = my_piecewise3(t3, 0, -t114 * t35 / 0.4e1 - t118 / 0.2e1 - t42 * t49 / 0.2e1 + t42 * t74 / 0.2e1 - t125 / 0.2e1 + t128 / 0.2e1 - t18 * t134 / 0.4e1 + t18 * t138 / 0.2e1 - t18 * t145 / 0.2e1 + t18 * t181 / 0.4e1);
  tv2rho20 = t4 * t185 + 0.2e1 * t78;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t188 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t110);
  t189 = t188 * t4;
  t192 = t81 * t22;
  t193 = t192 * t34;
  t204 = t17 * t85;
  t205 = t204 * t34;
  t208 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t130);
  t209 = t208 * t34;
  t212 = t85 * t52;
  t213 = t212 * t73;
  t218 = t52 * t100;
  t219 = t44 * t218;
  t221 = t137 * t100;
  t224 = t142 * t100;
  t225 = t224 * t73;
  t228 = t91 * t61;
  t231 = t188 * t23;
  t233 = t82 * t22;
  t239 = t18 * t85;
  t242 = t24 * t208 + t231 * t22 + t88 * t48 + t56 * t85 + 0.2e1 * t156 + t160 + 0.2e1 * t161 + 0.2e1 * t233 + 0.2e1 * t239;
  t245 = params->c * t188;
  t248 = t94 * t67;
  t256 = t4 * t85;
  t257 = t29 * t256;
  t259 = t23 * t208;
  t262 = t150 * t228 / 0.8e1 - t55 * t242 / 0.4e1 + t245 * t30 / 0.4e1 + t248 / 0.2e1 + t94 * t70 / 0.4e1 + t170 / 0.2e1 + t174 + t176 / 0.2e1 + t64 * t97 / 0.4e1 + t257 / 0.2e1 + t29 * t259 / 0.4e1;
  t263 = t53 * t262;
  t266 = -t189 * t35 / 0.4e1 - t193 / 0.4e1 - t82 * t49 / 0.4e1 + t82 * t74 / 0.4e1 - t118 / 0.4e1 - t125 / 0.4e1 + t128 / 0.4e1 - t42 * t86 / 0.4e1 - t205 / 0.4e1 - t18 * t209 / 0.4e1 + t18 * t213 / 0.4e1 + t42 * t101 / 0.4e1 + t219 / 0.4e1 + t18 * t221 / 0.4e1 - t58 * t225 / 0.2e1 + t18 * t263 / 0.4e1;
  t267 = my_piecewise3(t3, 0, t266);
  tv2rho21 = t4 * t267 + t105 + t78;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t272 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t38 + 0.2e1 * t110);
  t273 = t272 * t4;
  t285 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t38 + 0.2e1 * t130);
  t286 = t285 * t34;
  t289 = t212 * t100;
  t292 = t100 * t100;
  t293 = t143 * t292;
  t296 = t91 * t91;
  t299 = t272 * t23;
  t306 = t299 * t22 + t24 * t285 + 0.2e1 * t88 * t85 + t160 + 0.4e1 * t233 + 0.4e1 * t239;
  t309 = params->c * t272;
  t314 = t23 * t285;
  t317 = t150 * t296 / 0.8e1 - t55 * t306 / 0.4e1 + t309 * t30 / 0.4e1 + t248 + t94 * t97 / 0.2e1 + t174 + t257 + t29 * t314 / 0.4e1;
  t318 = t53 * t317;
  t322 = my_piecewise3(t3, 0, -t273 * t35 / 0.4e1 - t193 / 0.2e1 - t82 * t86 / 0.2e1 + t82 * t101 / 0.2e1 - t205 / 0.2e1 + t219 / 0.2e1 - t18 * t286 / 0.4e1 + t18 * t289 / 0.2e1 - t18 * t293 / 0.2e1 + t18 * t318 / 0.4e1);
  tv2rho22 = t4 * t322 + 0.2e1 * t105;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t325 = t41 * t48;
  t326 = t325 * t34;
  t328 = t17 * t133;
  t329 = t328 * t34;
  t331 = t23 * t23;
  t332 = 0.1e1 / t331;
  t333 = t14 * t332;
  t336 = my_piecewise5(t8, 0, t12, 0, 0.6e1 * t109 - 0.6e1 * t333);
  t337 = t336 * t4;
  t340 = t113 * t22;
  t341 = t340 * t34;
  t345 = t117 * t127;
  t349 = t124 * t127;
  t351 = t52 * t180;
  t352 = t44 * t351;
  t354 = t19 * t332;
  t357 = my_piecewise5(t12, 0, t8, 0, -0.6e1 * t109 - 0.6e1 * t354);
  t358 = t357 * t34;
  t364 = t48 * t142;
  t365 = t364 * t144;
  t368 = t51 * t51;
  t369 = 0.1e1 / t368;
  t370 = t22 * t369;
  t371 = t144 * t73;
  t372 = t370 * t371;
  t375 = t142 * t73;
  t376 = t375 * t180;
  t385 = t142 * t144;
  t386 = t44 * t385;
  t388 = t133 * t52;
  t389 = t388 * t73;
  t392 = t137 * t180;
  t395 = t17 * t17;
  t397 = t22 * t22;
  t401 = params->b / t26 / t395 / t331 / t397;
  t402 = t151 * t61;
  t408 = t336 * t23;
  t410 = t114 * t22;
  t415 = t42 * t48;
  t420 = t18 * t133;
  t423 = 0.3e1 * t56 * t133 + 0.3e1 * t154 * t48 + t408 * t22 + t24 * t357 + 0.6e1 * t117 + 0.6e1 * t124 + 0.6e1 * t410 + 0.12e2 * t415 + 0.6e1 * t420;
  t426 = params->c * t336;
  t429 = t167 * t67;
  t433 = t64 * t22;
  t435 = t64 * t175;
  t439 = t29 * t48;
  t441 = t4 * t133;
  t442 = t29 * t441;
  t444 = t23 * t357;
  t447 = -0.3e1 / 0.16e2 * t401 * t402 + 0.3e1 / 0.8e1 * t150 * t61 * t164 - t55 * t423 / 0.4e1 + t426 * t30 / 0.4e1 + 0.3e1 / 0.2e1 * t429 + 0.3e1 / 0.4e1 * t167 * t70 + 0.3e1 / 0.2e1 * t433 + 0.3e1 * t435 + 0.3e1 / 0.4e1 * t64 * t177 + 0.3e1 / 0.2e1 * t439 + 0.3e1 / 0.2e1 * t442 + t29 * t444 / 0.4e1;
  t448 = t53 * t447;
  t451 = -0.3e1 / 0.2e1 * t42 * t145 - 0.3e1 / 0.2e1 * t18 * t365 + 0.3e1 / 0.2e1 * t18 * t372 - 0.3e1 / 0.2e1 * t58 * t376 + 0.3e1 / 0.4e1 * t114 * t74 + 0.3e1 / 0.2e1 * t42 * t138 + 0.3e1 / 0.4e1 * t42 * t181 - 0.3e1 / 0.2e1 * t386 + 0.3e1 / 0.4e1 * t18 * t389 + 0.3e1 / 0.4e1 * t18 * t392 + t18 * t448 / 0.4e1;
  t453 = my_piecewise3(t3, 0, -0.3e1 / 0.2e1 * t326 - 0.3e1 / 0.4e1 * t329 - t337 * t35 / 0.4e1 - 0.3e1 / 0.4e1 * t341 - 0.3e1 / 0.4e1 * t114 * t49 + 0.3e1 / 0.2e1 * t345 - 0.3e1 / 0.4e1 * t42 * t134 + 0.3e1 / 0.2e1 * t349 + 0.3e1 / 0.4e1 * t352 - t18 * t358 / 0.4e1 + t451);
  tv3rho30 = t4 * t453 + 0.3e1 * t185;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t455 = 0.2e1 * t267;
  t457 = t117 * t218 / 0.2e1;
  t461 = 0.2e1 * t109;
  t462 = 0.6e1 * t333;
  t464 = my_piecewise5(t8, 0, t12, 0, t461 - t462);
  t465 = t464 * t23;
  t470 = t82 * t48;
  t471 = 0.4e1 * t470;
  t477 = t18 * t208;
  t478 = 0.4e1 * t477;
  t479 = 0.6e1 * t354;
  t481 = my_piecewise5(t12, 0, t8, 0, -t461 - t479);
  t484 = t189 * t22;
  t485 = 0.4e1 * t484;
  t486 = t42 * t85;
  t487 = 0.4e1 * t486;
  t489 = t88 * t133 + t154 * t85 + 0.2e1 * t56 * t208 + t465 * t22 + 0.2e1 * t231 * t48 + t24 * t481 + 0.4e1 * t117 + 0.4e1 * t124 + 0.2e1 * t192 + 0.2e1 * t204 + 0.2e1 * t410 + 0.4e1 * t415 + 0.2e1 * t420 + t471 + t478 + t485 + t487;
  t496 = t91 * t164;
  t499 = params->c * t464;
  t504 = t94 * t22;
  t507 = t94 * t175;
  t514 = t29 * t85;
  t516 = t4 * t208;
  t517 = t29 * t516;
  t518 = t23 * t481;
  t525 = t245 * t67;
  t526 = t64 * t256;
  t527 = t507 + t94 * t177 / 0.4e1 + t167 * t97 / 0.4e1 + t64 * t259 / 0.2e1 + t514 / 0.2e1 + t517 + t29 * t518 / 0.4e1 + t429 / 0.2e1 - 0.3e1 / 0.16e2 * t401 * t91 * t151 + t525 + t526;
  t528 = t439 - t55 * t489 / 0.4e1 + t433 + t435 + t442 / 0.2e1 + t150 * t242 * t61 / 0.4e1 + t150 * t496 / 0.8e1 + t499 * t30 / 0.4e1 + t245 * t70 / 0.2e1 + t504 / 0.2e1 + t527;
  t529 = t53 * t528;
  t536 = t44 * t225;
  t537 = t388 * t100;
  t540 = t137 * t262;
  t552 = t208 * t52;
  t553 = t552 * t73;
  t556 = t212 * t180;
  t563 = t85 * t142;
  t564 = t563 * t144;
  t567 = t188 * t22;
  t569 = t567 * t34 / 0.2e1;
  t570 = t41 * t85;
  t572 = t570 * t34 / 0.2e1;
  t573 = t81 * t48;
  t575 = t573 * t34 / 0.2e1;
  t576 = t17 * t208;
  t578 = t576 * t34 / 0.2e1;
  t580 = t42 * t213 / 0.2e1 + t18 * t553 / 0.2e1 + t18 * t556 / 0.4e1 + t114 * t101 / 0.4e1 - t82 * t145 / 0.2e1 - t18 * t564 / 0.2e1 - t569 - t572 - t575 - t578 - t326 / 0.2e1;
  t584 = t52 * t262;
  t586 = t44 * t584 / 0.2e1;
  t587 = t464 * t4;
  t593 = t192 * t127 / 0.2e1;
  t601 = t204 * t127 / 0.2e1;
  t603 = t481 * t34;
  t607 = t124 * t218 / 0.2e1;
  t612 = t369 * t100;
  t613 = t612 * t144;
  t618 = t142 * t262;
  t619 = t618 * t73;
  t621 = t224 * t180;
  t624 = -t18 * t603 / 0.4e1 + t607 - t386 / 0.2e1 + t352 / 0.4e1 + t345 / 0.2e1 + t349 / 0.2e1 + 0.3e1 / 0.2e1 * t58 * t613 - t156 * t225 - t161 * t225 - t58 * t619 - t58 * t621 / 0.2e1;
  t627 = my_piecewise3(t3, 0, t457 + t18 * t529 / 0.4e1 + t42 * t221 / 0.2e1 + t42 * t263 / 0.2e1 - t536 + t18 * t537 / 0.4e1 + t18 * t540 / 0.2e1 + t189 * t74 / 0.2e1 + t82 * t138 / 0.2e1 + t82 * t181 / 0.4e1 + t580 - t329 / 0.4e1 - t341 / 0.4e1 + t586 - t587 * t35 / 0.4e1 - t189 * t49 / 0.2e1 + t593 - t82 * t134 / 0.4e1 - t114 * t86 / 0.4e1 - t42 * t209 / 0.2e1 + t601 + t624);
  tv3rho31 = t4 * t627 + t185 + t455;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t629 = t142 * t292;
  t630 = t44 * t629;
  t632 = t52 * t317;
  t633 = t44 * t632;
  t635 = t204 * t218;
  t637 = t192 * t218;
  t648 = my_piecewise5(t12, 0, t8, 0, t461 - t479);
  t649 = t648 * t34;
  t653 = my_piecewise5(t8, 0, t12, 0, -t461 - t462);
  t654 = t653 * t4;
  t658 = t364 * t292;
  t663 = t137 * t317;
  t675 = t653 * t23;
  t677 = t273 * t22;
  t683 = t82 * t85;
  t691 = t18 * t285;
  t694 = 0.2e1 * t88 * t208 + t675 * t22 + 0.2e1 * t231 * t85 + t24 * t648 + t56 * t285 + t299 * t48 + 0.2e1 * t117 + 0.2e1 * t124 + 0.4e1 * t192 + 0.4e1 * t204 + t471 + t478 + t485 + t487 + 0.2e1 * t677 + 0.4e1 * t683 + 0.2e1 * t691;
  t697 = params->c * t653;
  t700 = t309 * t67;
  t707 = t94 * t256;
  t714 = t4 * t285;
  t715 = t29 * t714;
  t717 = t23 * t648;
  t720 = t245 * t97 / 0.2e1 + t707 + t94 * t259 / 0.2e1 + t433 / 0.2e1 + t439 / 0.2e1 + t526 + t514 + t517 + t64 * t314 / 0.4e1 + t715 / 0.2e1 + t29 * t717 / 0.4e1;
  t721 = -0.3e1 / 0.16e2 * t401 * t296 * t61 + t150 * t91 * t242 / 0.4e1 + t150 * t306 * t61 / 0.8e1 - t55 * t694 / 0.4e1 + t697 * t30 / 0.4e1 + t700 / 0.2e1 + t309 * t70 / 0.4e1 + t525 + t504 + t507 + t720;
  t722 = t53 * t721;
  t727 = t285 * t52;
  t728 = t727 * t73;
  t733 = t552 * t100;
  t736 = t212 * t262;
  t741 = t457 - t18 * t658 / 0.2e1 + t42 * t318 / 0.4e1 + t18 * t663 / 0.4e1 + t18 * t722 / 0.4e1 + t82 * t263 / 0.2e1 + t18 * t728 / 0.4e1 + t42 * t289 / 0.2e1 + t18 * t733 / 0.2e1 + t18 * t736 / 0.2e1 - t42 * t293 / 0.2e1;
  t751 = t272 * t22;
  t752 = t751 * t34;
  t754 = t81 * t85;
  t755 = t754 * t34;
  t757 = t17 * t285;
  t758 = t757 * t34;
  t763 = t369 * t292;
  t764 = t763 * t73;
  t767 = t224 * t262;
  t769 = t142 * t317;
  t770 = t769 * t73;
  t773 = -t575 - t578 + t586 + t593 + t601 + t607 - t233 * t225 - t239 * t225 + 0.3e1 / 0.2e1 * t58 * t764 - t58 * t767 - t58 * t770 / 0.2e1;
  t776 = my_piecewise3(t3, 0, -t630 / 0.2e1 + t633 / 0.4e1 + t635 / 0.2e1 + t637 / 0.2e1 - t273 * t49 / 0.4e1 - t189 * t86 / 0.2e1 - t82 * t209 / 0.2e1 - t42 * t286 / 0.4e1 - t18 * t649 / 0.4e1 - t654 * t35 / 0.4e1 + t741 + t273 * t74 / 0.4e1 + t82 * t213 / 0.2e1 + t189 * t101 / 0.2e1 + t82 * t221 / 0.2e1 - t536 - t752 / 0.4e1 - t755 / 0.2e1 - t758 / 0.4e1 - t569 - t572 + t773);
  tv3rho32 = t4 * t776 + t322 + t455;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t784 = my_piecewise5(t8, 0, t12, 0, -0.6e1 * t109 - 0.6e1 * t333);
  t785 = t784 * t4;
  t794 = my_piecewise5(t12, 0, t8, 0, 0.6e1 * t109 - 0.6e1 * t354);
  t795 = t794 * t34;
  t800 = t563 * t292;
  t803 = t292 * t100;
  t804 = t370 * t803;
  t808 = t224 * t317;
  t821 = t727 * t100;
  t824 = t212 * t317;
  t827 = t296 * t91;
  t830 = t91 * t306;
  t833 = t784 * t23;
  t845 = t833 * t22 + t24 * t794 + 0.3e1 * t88 * t285 + 0.3e1 * t299 * t85 + 0.6e1 * t192 + 0.6e1 * t204 + 0.6e1 * t677 + 0.12e2 * t683 + 0.6e1 * t691;
  t848 = params->c * t784;
  t860 = t23 * t794;
  t863 = -0.3e1 / 0.16e2 * t401 * t827 + 0.3e1 / 0.8e1 * t150 * t830 - t55 * t845 / 0.4e1 + t848 * t30 / 0.4e1 + 0.3e1 / 0.2e1 * t700 + 0.3e1 / 0.4e1 * t309 * t97 + 0.3e1 / 0.2e1 * t504 + 0.3e1 * t707 + 0.3e1 / 0.4e1 * t94 * t314 + 0.3e1 / 0.2e1 * t514 + 0.3e1 / 0.2e1 * t715 + t29 * t860 / 0.4e1;
  t864 = t53 * t863;
  t867 = -0.3e1 / 0.2e1 * t58 * t808 + 0.3e1 / 0.2e1 * t637 + 0.3e1 / 0.2e1 * t635 - 0.3e1 / 0.2e1 * t630 + 0.3e1 / 0.4e1 * t633 + 0.3e1 / 0.4e1 * t273 * t101 + 0.3e1 / 0.2e1 * t82 * t289 + 0.3e1 / 0.4e1 * t82 * t318 + 0.3e1 / 0.4e1 * t18 * t821 + 0.3e1 / 0.4e1 * t18 * t824 + t18 * t864 / 0.4e1;
  t869 = my_piecewise3(t3, 0, -0.3e1 / 0.4e1 * t752 - 0.3e1 / 0.2e1 * t755 - 0.3e1 / 0.4e1 * t758 - t785 * t35 / 0.4e1 - 0.3e1 / 0.4e1 * t273 * t86 - 0.3e1 / 0.4e1 * t82 * t286 - t18 * t795 / 0.4e1 - 0.3e1 / 0.2e1 * t82 * t293 - 0.3e1 / 0.2e1 * t18 * t800 + 0.3e1 / 0.2e1 * t18 * t804 + t867);
  tv3rho33 = t4 * t869 + 0.3e1 * t322;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t26, t29, t30, t33, t34, t35, tzk0;

  double t38, t39, t41, t42, t44, t45, t46, t48;
  double t49, t51, t52, t53, t55, t56, t58, t59;
  double t61, t64, t67, t69, t70, t73, t74, t78;
  double tvrho0, t81, t82, t85, t86, t88, t91, t94;
  double t97, t100, t101, t105, tvrho1;

  double t109, t110, t113, t114, t117, t118, t124, t125;
  double t127, t128, t130, t133, t134, t137, t138, t142;
  double t143, t144, t145, t150, t151, t154, t156, t160;
  double t161, t164, t167, t170, t174, t175, t176, t177;
  double t180, t181, t185, tv2rho20, t188, t189, t192, t193;
  double t204, t205, t208, t209, t212, t213, t218, t219;
  double t221, t224, t225, t228, t231, t233, t239, t242;
  double t245, t248, t256, t257, t259, t262, t263, t266;
  double t267, tv2rho21, t272, t273, t285, t286, t289, t292;
  double t293, t296, t299, t306, t309, t314, t317, t318;
  double t322, tv2rho22;

  double t325, t326, t328, t329, t331, t332, t333, t336;
  double t337, t340, t341, t345, t349, t351, t352, t354;
  double t357, t358, t364, t365, t368, t369, t370, t371;
  double t372, t375, t376, t385, t386, t388, t389, t392;
  double t395, t397, t401, t402, t408, t410, t415, t420;
  double t423, t426, t429, t433, t435, t439, t441, t442;
  double t444, t447, t448, t451, t453, tv3rho30, t455, t457;
  double t461, t462, t464, t465, t470, t471, t477, t478;
  double t479, t481, t484, t485, t486, t487, t489, t496;
  double t499, t504, t507, t514, t516, t517, t518, t525;
  double t526, t527, t528, t529, t536, t537, t540, t552;
  double t553, t556, t563, t564, t567, t569, t570, t572;
  double t573, t575, t576, t578, t580, t584, t586, t587;
  double t593, t601, t603, t607, t612, t613, t618, t619;
  double t621, t624, t627, tv3rho31, t629, t630, t632, t633;
  double t635, t637, t648, t649, t653, t654, t658, t663;
  double t675, t677, t683, t691, t694, t697, t700, t707;
  double t714, t715, t717, t720, t721, t722, t727, t728;
  double t733, t736, t741, t751, t752, t754, t755, t757;
  double t758, t763, t764, t767, t769, t770, t773, t776;
  double tv3rho32, t784, t785, t794, t795, t800, t803, t804;
  double t808, t821, t824, t827, t830, t833, t845, t848;
  double t860, t863, t864, t867, t869, tv3rho33;

  double t873, t875, t877, t880, t882, t883, t886, t890;
  double t892, t895, t900, t904, t907, t910, t911, t918;
  double t922, t926, t929, t933, t936, t938, t947, t948;
  double t954, t964, t966, t970, t974, t979, t981, t993;
  double t1000, t1002, t1009, t1013, t1018, t1019, t1020, t1024;
  double t1032, t1035, t1038, t1050, t1052, tv4rho40, t1055, t1057;
  double t1059, t1079, t1084, t1086, t1094, t1106, t1114, t1118;
  double t1120, t1124, t1128, t1131, t1133, t1135, t1136, t1138;
  double t1140, t1142, t1146, t1154, t1158, t1160, t1163, t1164;
  double t1166, t1170, t1172, t1174, t1176, t1186, t1189, t1192;
  double t1194, t1196, t1199, t1202, t1218, t1226, t1228, t1230;
  double t1232, t1251, t1254, t1262, t1263, t1264, t1265, t1275;
  double t1278, t1284, t1287, t1289, t1291, t1293, t1299, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1317;
  double t1325, t1349, t1382, t1386, tv4rho41, t1393, t1397, t1398;
  double t1400, t1403, t1405, t1407, t1418, t1424, t1433, t1434;
  double t1436, t1437, t1446, t1447, t1454, t1458, t1460, t1461;
  double t1464, t1473, t1480, t1487, t1490, t1491, t1493, t1495;
  double t1510, t1525, t1530, t1533, t1535, t1536, t1537, t1538;
  double t1539, t1546, t1553, t1558, t1559, t1565, t1567, t1569;
  double t1571, t1573, t1576, t1596, t1626, t1627, t1628, t1633;
  double t1636, t1638, t1659, t1686, t1691, t1707, t1718, t1722;
  double tv4rho42, t1725, t1727, t1729, t1731, t1734, t1736, t1738;
  double t1740, t1750, t1777, t1797, t1803, t1805, t1815, t1820;
  double t1829, t1832, t1835, t1838, t1840, t1844, t1858, t1860;
  double t1862, t1865, t1885, t1889, t1891, t1893, t1895, t1910;
  double t1920, t1936, t1953, t1966, t1994, t2018, t2022, tv4rho43;
  double t2027, t2037, t2049, t2058, t2067, t2089, t2105, t2128;
  double t2133, t2152, t2154, tv4rho44;

  lda_c_epc17_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc17_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = t4 * t4;
  t24 = t17 * t23;
  t25 = t24 * t22;
  t26 = sqrt(t25);
  t29 = params->c * t17;
  t30 = t23 * t22;
  t33 = params->a - params->b * t26 / 0.2e1 + t29 * t30 / 0.4e1;
  t34 = 0.1e1 / t33;
  t35 = t22 * t34;
  tzk0 = my_piecewise3(t3, 0, -t18 * t35 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = 0.1e1 / t23;
  t39 = t14 * t38;
  t41 = my_piecewise5(t8, 0, t12, 0, t5 - t39);
  t42 = t41 * t4;
  t44 = t17 * t22;
  t45 = t44 * t34;
  t46 = t19 * t38;
  t48 = my_piecewise5(t12, 0, t8, 0, -t5 - t46);
  t49 = t48 * t34;
  t51 = t33 * t33;
  t52 = 0.1e1 / t51;
  t53 = t22 * t52;
  t55 = params->b / t26;
  t56 = t41 * t23;
  t58 = t18 * t22;
  t59 = 0.2e1 * t58;
  t61 = t56 * t22 + t24 * t48 + t59;
  t64 = params->c * t41;
  t67 = t4 * t22;
  t69 = t29 * t67 / 0.2e1;
  t70 = t23 * t48;
  t73 = -t55 * t61 / 0.4e1 + t64 * t30 / 0.4e1 + t69 + t29 * t70 / 0.4e1;
  t74 = t53 * t73;
  t78 = my_piecewise3(t3, 0, -t18 * t49 / 0.4e1 + t18 * t74 / 0.4e1 - t42 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho0 = t4 * t78 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t81 = my_piecewise5(t8, 0, t12, 0, -t5 - t39);
  t82 = t81 * t4;
  t85 = my_piecewise5(t12, 0, t8, 0, t5 - t46);
  t86 = t85 * t34;
  t88 = t81 * t23;
  t91 = t88 * t22 + t24 * t85 + t59;
  t94 = params->c * t81;
  t97 = t23 * t85;
  t100 = -t55 * t91 / 0.4e1 + t94 * t30 / 0.4e1 + t69 + t29 * t97 / 0.4e1;
  t101 = t53 * t100;
  t105 = my_piecewise3(t3, 0, t18 * t101 / 0.4e1 - t18 * t86 / 0.4e1 - t82 * t35 / 0.4e1 - t45 / 0.4e1);
  tvrho1 = t4 * t105 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t109 = 0.1e1 / t23 / t4;
  t110 = t14 * t109;
  t113 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t38 + 0.2e1 * t110);
  t114 = t113 * t4;
  t117 = t41 * t22;
  t118 = t117 * t34;
  t124 = t17 * t48;
  t125 = t124 * t34;
  t127 = t52 * t73;
  t128 = t44 * t127;
  t130 = t19 * t109;
  t133 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t38 + 0.2e1 * t130);
  t134 = t133 * t34;
  t137 = t48 * t52;
  t138 = t137 * t73;
  t142 = 0.1e1 / t51 / t33;
  t143 = t22 * t142;
  t144 = t73 * t73;
  t145 = t143 * t144;
  t150 = params->b / t26 / t25;
  t151 = t61 * t61;
  t154 = t113 * t23;
  t156 = t42 * t22;
  t160 = 0.2e1 * t44;
  t161 = t18 * t48;
  t164 = t24 * t133 + t154 * t22 + 0.2e1 * t56 * t48 + 0.4e1 * t156 + t160 + 0.4e1 * t161;
  t167 = params->c * t113;
  t170 = t64 * t67;
  t174 = t29 * t22 / 0.2e1;
  t175 = t4 * t48;
  t176 = t29 * t175;
  t177 = t23 * t133;
  t180 = t150 * t151 / 0.8e1 - t55 * t164 / 0.4e1 + t167 * t30 / 0.4e1 + t170 + t64 * t70 / 0.2e1 + t174 + t176 + t29 * t177 / 0.4e1;
  t181 = t53 * t180;
  t185 = my_piecewise3(t3, 0, -t114 * t35 / 0.4e1 - t118 / 0.2e1 - t42 * t49 / 0.2e1 + t42 * t74 / 0.2e1 - t125 / 0.2e1 + t128 / 0.2e1 - t18 * t134 / 0.4e1 + t18 * t138 / 0.2e1 - t18 * t145 / 0.2e1 + t18 * t181 / 0.4e1);
  tv2rho20 = t4 * t185 + 0.2e1 * t78;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t188 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t110);
  t189 = t188 * t4;
  t192 = t81 * t22;
  t193 = t192 * t34;
  t204 = t17 * t85;
  t205 = t204 * t34;
  t208 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t130);
  t209 = t208 * t34;
  t212 = t85 * t52;
  t213 = t212 * t73;
  t218 = t52 * t100;
  t219 = t44 * t218;
  t221 = t137 * t100;
  t224 = t142 * t100;
  t225 = t224 * t73;
  t228 = t91 * t61;
  t231 = t188 * t23;
  t233 = t82 * t22;
  t239 = t18 * t85;
  t242 = t24 * t208 + t231 * t22 + t88 * t48 + t56 * t85 + 0.2e1 * t156 + t160 + 0.2e1 * t161 + 0.2e1 * t233 + 0.2e1 * t239;
  t245 = params->c * t188;
  t248 = t94 * t67;
  t256 = t4 * t85;
  t257 = t29 * t256;
  t259 = t23 * t208;
  t262 = t150 * t228 / 0.8e1 - t55 * t242 / 0.4e1 + t245 * t30 / 0.4e1 + t248 / 0.2e1 + t94 * t70 / 0.4e1 + t170 / 0.2e1 + t174 + t176 / 0.2e1 + t64 * t97 / 0.4e1 + t257 / 0.2e1 + t29 * t259 / 0.4e1;
  t263 = t53 * t262;
  t266 = -t189 * t35 / 0.4e1 - t193 / 0.4e1 - t82 * t49 / 0.4e1 + t82 * t74 / 0.4e1 - t118 / 0.4e1 - t125 / 0.4e1 + t128 / 0.4e1 - t42 * t86 / 0.4e1 - t205 / 0.4e1 - t18 * t209 / 0.4e1 + t18 * t213 / 0.4e1 + t42 * t101 / 0.4e1 + t219 / 0.4e1 + t18 * t221 / 0.4e1 - t58 * t225 / 0.2e1 + t18 * t263 / 0.4e1;
  t267 = my_piecewise3(t3, 0, t266);
  tv2rho21 = t4 * t267 + t105 + t78;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t272 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t38 + 0.2e1 * t110);
  t273 = t272 * t4;
  t285 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t38 + 0.2e1 * t130);
  t286 = t285 * t34;
  t289 = t212 * t100;
  t292 = t100 * t100;
  t293 = t143 * t292;
  t296 = t91 * t91;
  t299 = t272 * t23;
  t306 = t299 * t22 + t24 * t285 + 0.2e1 * t88 * t85 + t160 + 0.4e1 * t233 + 0.4e1 * t239;
  t309 = params->c * t272;
  t314 = t23 * t285;
  t317 = t150 * t296 / 0.8e1 - t55 * t306 / 0.4e1 + t309 * t30 / 0.4e1 + t248 + t94 * t97 / 0.2e1 + t174 + t257 + t29 * t314 / 0.4e1;
  t318 = t53 * t317;
  t322 = my_piecewise3(t3, 0, -t273 * t35 / 0.4e1 - t193 / 0.2e1 - t82 * t86 / 0.2e1 + t82 * t101 / 0.2e1 - t205 / 0.2e1 + t219 / 0.2e1 - t18 * t286 / 0.4e1 + t18 * t289 / 0.2e1 - t18 * t293 / 0.2e1 + t18 * t318 / 0.4e1);
  tv2rho22 = t4 * t322 + 0.2e1 * t105;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t325 = t41 * t48;
  t326 = t325 * t34;
  t328 = t17 * t133;
  t329 = t328 * t34;
  t331 = t23 * t23;
  t332 = 0.1e1 / t331;
  t333 = t14 * t332;
  t336 = my_piecewise5(t8, 0, t12, 0, 0.6e1 * t109 - 0.6e1 * t333);
  t337 = t336 * t4;
  t340 = t113 * t22;
  t341 = t340 * t34;
  t345 = t117 * t127;
  t349 = t124 * t127;
  t351 = t52 * t180;
  t352 = t44 * t351;
  t354 = t19 * t332;
  t357 = my_piecewise5(t12, 0, t8, 0, -0.6e1 * t109 - 0.6e1 * t354);
  t358 = t357 * t34;
  t364 = t48 * t142;
  t365 = t364 * t144;
  t368 = t51 * t51;
  t369 = 0.1e1 / t368;
  t370 = t22 * t369;
  t371 = t144 * t73;
  t372 = t370 * t371;
  t375 = t142 * t73;
  t376 = t375 * t180;
  t385 = t142 * t144;
  t386 = t44 * t385;
  t388 = t133 * t52;
  t389 = t388 * t73;
  t392 = t137 * t180;
  t395 = t17 * t17;
  t397 = t22 * t22;
  t401 = params->b / t26 / t395 / t331 / t397;
  t402 = t151 * t61;
  t408 = t336 * t23;
  t410 = t114 * t22;
  t415 = t42 * t48;
  t420 = t18 * t133;
  t423 = 0.3e1 * t56 * t133 + 0.3e1 * t154 * t48 + t408 * t22 + t24 * t357 + 0.6e1 * t117 + 0.6e1 * t124 + 0.6e1 * t410 + 0.12e2 * t415 + 0.6e1 * t420;
  t426 = params->c * t336;
  t429 = t167 * t67;
  t433 = t64 * t22;
  t435 = t64 * t175;
  t439 = t29 * t48;
  t441 = t4 * t133;
  t442 = t29 * t441;
  t444 = t23 * t357;
  t447 = -0.3e1 / 0.16e2 * t401 * t402 + 0.3e1 / 0.8e1 * t150 * t61 * t164 - t55 * t423 / 0.4e1 + t426 * t30 / 0.4e1 + 0.3e1 / 0.2e1 * t429 + 0.3e1 / 0.4e1 * t167 * t70 + 0.3e1 / 0.2e1 * t433 + 0.3e1 * t435 + 0.3e1 / 0.4e1 * t64 * t177 + 0.3e1 / 0.2e1 * t439 + 0.3e1 / 0.2e1 * t442 + t29 * t444 / 0.4e1;
  t448 = t53 * t447;
  t451 = -0.3e1 / 0.2e1 * t42 * t145 - 0.3e1 / 0.2e1 * t18 * t365 + 0.3e1 / 0.2e1 * t18 * t372 - 0.3e1 / 0.2e1 * t58 * t376 + 0.3e1 / 0.4e1 * t114 * t74 + 0.3e1 / 0.2e1 * t42 * t138 + 0.3e1 / 0.4e1 * t42 * t181 - 0.3e1 / 0.2e1 * t386 + 0.3e1 / 0.4e1 * t18 * t389 + 0.3e1 / 0.4e1 * t18 * t392 + t18 * t448 / 0.4e1;
  t453 = my_piecewise3(t3, 0, -0.3e1 / 0.2e1 * t326 - 0.3e1 / 0.4e1 * t329 - t337 * t35 / 0.4e1 - 0.3e1 / 0.4e1 * t341 - 0.3e1 / 0.4e1 * t114 * t49 + 0.3e1 / 0.2e1 * t345 - 0.3e1 / 0.4e1 * t42 * t134 + 0.3e1 / 0.2e1 * t349 + 0.3e1 / 0.4e1 * t352 - t18 * t358 / 0.4e1 + t451);
  tv3rho30 = t4 * t453 + 0.3e1 * t185;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t455 = 0.2e1 * t267;
  t457 = t117 * t218 / 0.2e1;
  t461 = 0.2e1 * t109;
  t462 = 0.6e1 * t333;
  t464 = my_piecewise5(t8, 0, t12, 0, t461 - t462);
  t465 = t464 * t23;
  t470 = t82 * t48;
  t471 = 0.4e1 * t470;
  t477 = t18 * t208;
  t478 = 0.4e1 * t477;
  t479 = 0.6e1 * t354;
  t481 = my_piecewise5(t12, 0, t8, 0, -t461 - t479);
  t484 = t189 * t22;
  t485 = 0.4e1 * t484;
  t486 = t42 * t85;
  t487 = 0.4e1 * t486;
  t489 = t88 * t133 + t154 * t85 + 0.2e1 * t56 * t208 + t465 * t22 + 0.2e1 * t231 * t48 + t24 * t481 + 0.4e1 * t117 + 0.4e1 * t124 + 0.2e1 * t192 + 0.2e1 * t204 + 0.2e1 * t410 + 0.4e1 * t415 + 0.2e1 * t420 + t471 + t478 + t485 + t487;
  t496 = t91 * t164;
  t499 = params->c * t464;
  t504 = t94 * t22;
  t507 = t94 * t175;
  t514 = t29 * t85;
  t516 = t4 * t208;
  t517 = t29 * t516;
  t518 = t23 * t481;
  t525 = t245 * t67;
  t526 = t64 * t256;
  t527 = t507 + t94 * t177 / 0.4e1 + t167 * t97 / 0.4e1 + t64 * t259 / 0.2e1 + t514 / 0.2e1 + t517 + t29 * t518 / 0.4e1 + t429 / 0.2e1 - 0.3e1 / 0.16e2 * t401 * t91 * t151 + t525 + t526;
  t528 = t439 - t55 * t489 / 0.4e1 + t433 + t435 + t442 / 0.2e1 + t150 * t242 * t61 / 0.4e1 + t150 * t496 / 0.8e1 + t499 * t30 / 0.4e1 + t245 * t70 / 0.2e1 + t504 / 0.2e1 + t527;
  t529 = t53 * t528;
  t536 = t44 * t225;
  t537 = t388 * t100;
  t540 = t137 * t262;
  t552 = t208 * t52;
  t553 = t552 * t73;
  t556 = t212 * t180;
  t563 = t85 * t142;
  t564 = t563 * t144;
  t567 = t188 * t22;
  t569 = t567 * t34 / 0.2e1;
  t570 = t41 * t85;
  t572 = t570 * t34 / 0.2e1;
  t573 = t81 * t48;
  t575 = t573 * t34 / 0.2e1;
  t576 = t17 * t208;
  t578 = t576 * t34 / 0.2e1;
  t580 = t42 * t213 / 0.2e1 + t18 * t553 / 0.2e1 + t18 * t556 / 0.4e1 + t114 * t101 / 0.4e1 - t82 * t145 / 0.2e1 - t18 * t564 / 0.2e1 - t569 - t572 - t575 - t578 - t326 / 0.2e1;
  t584 = t52 * t262;
  t586 = t44 * t584 / 0.2e1;
  t587 = t464 * t4;
  t593 = t192 * t127 / 0.2e1;
  t601 = t204 * t127 / 0.2e1;
  t603 = t481 * t34;
  t607 = t124 * t218 / 0.2e1;
  t612 = t369 * t100;
  t613 = t612 * t144;
  t618 = t142 * t262;
  t619 = t618 * t73;
  t621 = t224 * t180;
  t624 = -t18 * t603 / 0.4e1 + t607 - t386 / 0.2e1 + t352 / 0.4e1 + t345 / 0.2e1 + t349 / 0.2e1 + 0.3e1 / 0.2e1 * t58 * t613 - t156 * t225 - t161 * t225 - t58 * t619 - t58 * t621 / 0.2e1;
  t627 = my_piecewise3(t3, 0, t457 + t18 * t529 / 0.4e1 + t42 * t221 / 0.2e1 + t42 * t263 / 0.2e1 - t536 + t18 * t537 / 0.4e1 + t18 * t540 / 0.2e1 + t189 * t74 / 0.2e1 + t82 * t138 / 0.2e1 + t82 * t181 / 0.4e1 + t580 - t329 / 0.4e1 - t341 / 0.4e1 + t586 - t587 * t35 / 0.4e1 - t189 * t49 / 0.2e1 + t593 - t82 * t134 / 0.4e1 - t114 * t86 / 0.4e1 - t42 * t209 / 0.2e1 + t601 + t624);
  tv3rho31 = t4 * t627 + t185 + t455;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t629 = t142 * t292;
  t630 = t44 * t629;
  t632 = t52 * t317;
  t633 = t44 * t632;
  t635 = t204 * t218;
  t637 = t192 * t218;
  t648 = my_piecewise5(t12, 0, t8, 0, t461 - t479);
  t649 = t648 * t34;
  t653 = my_piecewise5(t8, 0, t12, 0, -t461 - t462);
  t654 = t653 * t4;
  t658 = t364 * t292;
  t663 = t137 * t317;
  t675 = t653 * t23;
  t677 = t273 * t22;
  t683 = t82 * t85;
  t691 = t18 * t285;
  t694 = 0.2e1 * t88 * t208 + t675 * t22 + 0.2e1 * t231 * t85 + t24 * t648 + t56 * t285 + t299 * t48 + 0.2e1 * t117 + 0.2e1 * t124 + 0.4e1 * t192 + 0.4e1 * t204 + t471 + t478 + t485 + t487 + 0.2e1 * t677 + 0.4e1 * t683 + 0.2e1 * t691;
  t697 = params->c * t653;
  t700 = t309 * t67;
  t707 = t94 * t256;
  t714 = t4 * t285;
  t715 = t29 * t714;
  t717 = t23 * t648;
  t720 = t245 * t97 / 0.2e1 + t707 + t94 * t259 / 0.2e1 + t433 / 0.2e1 + t439 / 0.2e1 + t526 + t514 + t517 + t64 * t314 / 0.4e1 + t715 / 0.2e1 + t29 * t717 / 0.4e1;
  t721 = -0.3e1 / 0.16e2 * t401 * t296 * t61 + t150 * t91 * t242 / 0.4e1 + t150 * t306 * t61 / 0.8e1 - t55 * t694 / 0.4e1 + t697 * t30 / 0.4e1 + t700 / 0.2e1 + t309 * t70 / 0.4e1 + t525 + t504 + t507 + t720;
  t722 = t53 * t721;
  t727 = t285 * t52;
  t728 = t727 * t73;
  t733 = t552 * t100;
  t736 = t212 * t262;
  t741 = t457 - t18 * t658 / 0.2e1 + t42 * t318 / 0.4e1 + t18 * t663 / 0.4e1 + t18 * t722 / 0.4e1 + t82 * t263 / 0.2e1 + t18 * t728 / 0.4e1 + t42 * t289 / 0.2e1 + t18 * t733 / 0.2e1 + t18 * t736 / 0.2e1 - t42 * t293 / 0.2e1;
  t751 = t272 * t22;
  t752 = t751 * t34;
  t754 = t81 * t85;
  t755 = t754 * t34;
  t757 = t17 * t285;
  t758 = t757 * t34;
  t763 = t369 * t292;
  t764 = t763 * t73;
  t767 = t224 * t262;
  t769 = t142 * t317;
  t770 = t769 * t73;
  t773 = -t575 - t578 + t586 + t593 + t601 + t607 - t233 * t225 - t239 * t225 + 0.3e1 / 0.2e1 * t58 * t764 - t58 * t767 - t58 * t770 / 0.2e1;
  t776 = my_piecewise3(t3, 0, -t630 / 0.2e1 + t633 / 0.4e1 + t635 / 0.2e1 + t637 / 0.2e1 - t273 * t49 / 0.4e1 - t189 * t86 / 0.2e1 - t82 * t209 / 0.2e1 - t42 * t286 / 0.4e1 - t18 * t649 / 0.4e1 - t654 * t35 / 0.4e1 + t741 + t273 * t74 / 0.4e1 + t82 * t213 / 0.2e1 + t189 * t101 / 0.2e1 + t82 * t221 / 0.2e1 - t536 - t752 / 0.4e1 - t755 / 0.2e1 - t758 / 0.4e1 - t569 - t572 + t773);
  tv3rho32 = t4 * t776 + t322 + t455;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t784 = my_piecewise5(t8, 0, t12, 0, -0.6e1 * t109 - 0.6e1 * t333);
  t785 = t784 * t4;
  t794 = my_piecewise5(t12, 0, t8, 0, 0.6e1 * t109 - 0.6e1 * t354);
  t795 = t794 * t34;
  t800 = t563 * t292;
  t803 = t292 * t100;
  t804 = t370 * t803;
  t808 = t224 * t317;
  t821 = t727 * t100;
  t824 = t212 * t317;
  t827 = t296 * t91;
  t830 = t91 * t306;
  t833 = t784 * t23;
  t845 = t833 * t22 + t24 * t794 + 0.3e1 * t88 * t285 + 0.3e1 * t299 * t85 + 0.6e1 * t192 + 0.6e1 * t204 + 0.6e1 * t677 + 0.12e2 * t683 + 0.6e1 * t691;
  t848 = params->c * t784;
  t860 = t23 * t794;
  t863 = -0.3e1 / 0.16e2 * t401 * t827 + 0.3e1 / 0.8e1 * t150 * t830 - t55 * t845 / 0.4e1 + t848 * t30 / 0.4e1 + 0.3e1 / 0.2e1 * t700 + 0.3e1 / 0.4e1 * t309 * t97 + 0.3e1 / 0.2e1 * t504 + 0.3e1 * t707 + 0.3e1 / 0.4e1 * t94 * t314 + 0.3e1 / 0.2e1 * t514 + 0.3e1 / 0.2e1 * t715 + t29 * t860 / 0.4e1;
  t864 = t53 * t863;
  t867 = -0.3e1 / 0.2e1 * t58 * t808 + 0.3e1 / 0.2e1 * t637 + 0.3e1 / 0.2e1 * t635 - 0.3e1 / 0.2e1 * t630 + 0.3e1 / 0.4e1 * t633 + 0.3e1 / 0.4e1 * t273 * t101 + 0.3e1 / 0.2e1 * t82 * t289 + 0.3e1 / 0.4e1 * t82 * t318 + 0.3e1 / 0.4e1 * t18 * t821 + 0.3e1 / 0.4e1 * t18 * t824 + t18 * t864 / 0.4e1;
  t869 = my_piecewise3(t3, 0, -0.3e1 / 0.4e1 * t752 - 0.3e1 / 0.2e1 * t755 - 0.3e1 / 0.4e1 * t758 - t785 * t35 / 0.4e1 - 0.3e1 / 0.4e1 * t273 * t86 - 0.3e1 / 0.4e1 * t82 * t286 - t18 * t795 / 0.4e1 - 0.3e1 / 0.2e1 * t82 * t293 - 0.3e1 / 0.2e1 * t18 * t800 + 0.3e1 / 0.2e1 * t18 * t804 + t867);
  tv3rho33 = t4 * t869 + 0.3e1 * t322;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t873 = t44 * t369 * t371;
  t875 = t124 * t385;
  t877 = t117 * t385;
  t880 = t336 * t22 * t34;
  t882 = 0.1e1 / t331 / t4;
  t883 = t19 * t882;
  t886 = my_piecewise5(t12, 0, t8, 0, 0.24e2 * t332 + 0.24e2 * t883);
  t890 = t328 * t127;
  t892 = t14 * t882;
  t895 = my_piecewise5(t8, 0, t12, 0, -0.24e2 * t332 + 0.24e2 * t892);
  t900 = t340 * t127;
  t904 = t117 * t351;
  t907 = t124 * t351;
  t910 = t44 * t52 * t447;
  t911 = t325 * t127;
  t918 = t114 * t48;
  t922 = t42 * t133;
  t926 = t18 * t357;
  t929 = t337 * t22;
  t933 = t895 * t23 * t22 + 0.6e1 * t154 * t133 + t24 * t886 + 0.4e1 * t56 * t357 + 0.4e1 * t408 * t48 + 0.24e2 * t325 + 0.12e2 * t328 + 0.12e2 * t340 + 0.24e2 * t918 + 0.24e2 * t922 + 0.8e1 * t926 + 0.8e1 * t929;
  t936 = t64 * t48;
  t938 = t29 * t133;
  t947 = params->b / t26 / t395 / t17 / t331 / t23 / t397 / t22;
  t948 = t151 * t151;
  t954 = t164 * t164;
  t964 = t167 * t22;
  t966 = t167 * t175;
  t970 = t64 * t441;
  t974 = t29 * t4 * t357;
  t979 = t426 * t67;
  t981 = -t55 * t933 / 0.4e1 + 0.6e1 * t936 + 0.3e1 * t938 + 0.15e2 / 0.32e2 * t947 * t948 - 0.9e1 / 0.8e1 * t401 * t151 * t164 + 0.3e1 / 0.8e1 * t150 * t954 + t150 * t61 * t423 / 0.2e1 + params->c * t895 * t30 / 0.4e1 + t426 * t70 + 0.3e1 * t964 + 0.6e1 * t966 + 0.3e1 / 0.2e1 * t167 * t177 + 0.6e1 * t970 + t64 * t444 + 0.2e1 * t974 + t29 * t23 * t886 / 0.4e1 + 0.2e1 * t979;
  t993 = 0.6e1 * t873 - 0.6e1 * t875 - 0.6e1 * t877 - t880 - t18 * t886 * t34 / 0.4e1 + 0.3e1 * t890 - t895 * t4 * t35 / 0.4e1 - t337 * t49 + 0.3e1 * t900 - 0.3e1 / 0.2e1 * t114 * t134 + 0.3e1 * t904 - t42 * t358 + 0.3e1 * t907 + t910 + 0.6e1 * t911 + t18 * t53 * t981 / 0.4e1 + 0.3e1 / 0.2e1 * t114 * t181 + 0.3e1 * t42 * t392 + t42 * t448 + 0.3e1 / 0.2e1 * t18 * t388 * t180;
  t1000 = t44 * t376;
  t1002 = t357 * t52;
  t1009 = t133 * t142;
  t1013 = t48 * t369;
  t1018 = 0.1e1 / t368 / t33;
  t1019 = t22 * t1018;
  t1020 = t144 * t144;
  t1024 = t180 * t180;
  t1032 = t113 * t48 * t34;
  t1035 = t41 * t133 * t34;
  t1038 = t17 * t357 * t34;
  t1050 = t18 * t137 * t447 + 0.3e1 * t114 * t138 + 0.3e1 * t42 * t389 - 0.6e1 * t1000 + t18 * t1002 * t73 - 0.3e1 * t114 * t145 - 0.6e1 * t42 * t365 - 0.3e1 * t18 * t1009 * t144 + 0.6e1 * t18 * t1013 * t371 - 0.6e1 * t18 * t1019 * t1020 - 0.3e1 / 0.2e1 * t18 * t143 * t1024 + t337 * t74 + 0.6e1 * t42 * t372 - 0.3e1 * t1032 - 0.3e1 * t1035 - t1038 - 0.6e1 * t156 * t376 - 0.6e1 * t161 * t376 + 0.9e1 * t58 * t369 * t144 * t180 - 0.2e1 * t58 * t375 * t447;
  t1052 = my_piecewise3(t3, 0, t993 + t1050);
  tv4rho40 = t4 * t1052 + 0.4e1 * t453;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1055 = t340 * t218;
  t1057 = t192 * t385;
  t1059 = t204 * t385;
  t1079 = 0.3e1 / 0.4e1 * t1055 - 0.3e1 / 0.2e1 * t1057 - 0.3e1 / 0.2e1 * t1059 + 0.3e1 / 0.4e1 * t114 * t263 + 0.3e1 / 0.4e1 * t42 * t537 + 0.3e1 / 0.2e1 * t42 * t540 + 0.3e1 / 0.4e1 * t42 * t529 + t82 * t448 / 0.4e1 + 0.3e1 / 0.4e1 * t42 * t556 + 0.3e1 / 0.4e1 * t18 * t552 * t180 + t18 * t212 * t447 / 0.4e1;
  t1084 = t124 * t225;
  t1086 = t44 * t619;
  t1094 = t208 * t142;
  t1106 = t337 * t101 / 0.4e1 + 0.3e1 / 0.4e1 * t114 * t221 - 0.3e1 * t1084 - 0.3e1 * t1086 - 0.3e1 / 0.2e1 * t189 * t145 - 0.3e1 / 0.2e1 * t82 * t365 - 0.3e1 / 0.2e1 * t42 * t564 - 0.3e1 / 0.2e1 * t18 * t1094 * t144 + 0.3e1 / 0.4e1 * t189 * t181 + 0.3e1 / 0.4e1 * t82 * t392 + 0.3e1 / 0.4e1 * t587 * t74 + 0.3e1 / 0.2e1 * t189 * t138;
  t1114 = t481 * t52;
  t1118 = t44 * t621;
  t1120 = t117 * t225;
  t1124 = t85 * t369;
  t1128 = t44 * t613;
  t1131 = t44 * t52 * t528;
  t1133 = t325 * t218;
  t1135 = 0.3e1 / 0.4e1 * t82 * t389 + 0.3e1 / 0.4e1 * t114 * t213 + 0.3e1 / 0.2e1 * t42 * t553 + 0.3e1 / 0.4e1 * t18 * t1114 * t73 - 0.3e1 / 0.2e1 * t1118 - 0.3e1 * t1120 + 0.3e1 / 0.2e1 * t82 * t372 + 0.3e1 / 0.2e1 * t18 * t1124 * t371 + 0.9e1 / 0.2e1 * t1128 + 0.3e1 / 0.4e1 * t1131 + 0.3e1 / 0.2e1 * t1133;
  t1136 = t328 * t218;
  t1138 = t124 * t584;
  t1140 = t117 * t584;
  t1142 = t567 * t127;
  t1146 = t192 * t351;
  t1154 = t570 * t127;
  t1158 = t204 * t351;
  t1160 = 0.3e1 / 0.4e1 * t1136 + 0.3e1 / 0.2e1 * t1138 + 0.3e1 / 0.2e1 * t1140 + 0.3e1 / 0.2e1 * t1142 - 0.3e1 / 0.4e1 * t189 * t134 + 0.3e1 / 0.4e1 * t1146 - t82 * t358 / 0.4e1 - t337 * t86 / 0.4e1 - 0.3e1 / 0.4e1 * t114 * t209 + 0.3e1 / 0.2e1 * t1154 - 0.3e1 / 0.4e1 * t42 * t603 + 0.3e1 / 0.4e1 * t1158;
  t1163 = 0.12e2 * t332;
  t1164 = 0.24e2 * t883;
  t1166 = my_piecewise5(t12, 0, t8, 0, t1163 + t1164);
  t1170 = t573 * t127;
  t1172 = t576 * t127;
  t1174 = 0.24e2 * t892;
  t1176 = my_piecewise5(t8, 0, t12, 0, -t1163 + t1174);
  t1186 = t113 * t85 * t34;
  t1189 = t464 * t22 * t34;
  t1192 = t188 * t48 * t34;
  t1194 = -t18 * t1166 * t34 / 0.4e1 + 0.3e1 / 0.2e1 * t1170 + 0.3e1 / 0.2e1 * t1172 - t1176 * t4 * t35 / 0.4e1 - 0.3e1 / 0.4e1 * t587 * t49 + 0.3e1 / 0.2e1 * t873 - 0.3e1 / 0.2e1 * t875 - 0.3e1 / 0.2e1 * t877 - 0.3e1 / 0.4e1 * t1186 - 0.3e1 / 0.4e1 * t1189 - 0.3e1 / 0.2e1 * t1192;
  t1196 = t81 * t133 * t34;
  t1199 = t41 * t208 * t34;
  t1202 = t17 * t481 * t34;
  t1218 = t29 * t4 * t481;
  t1226 = t499 * t67;
  t1228 = t245 * t175;
  t1230 = t167 * t256;
  t1232 = t64 * t516;
  t1251 = t426 * t97 / 0.4e1 + 0.3e1 / 0.4e1 * t167 * t259 + 0.3e1 / 0.4e1 * t64 * t518 + 0.3e1 / 0.2e1 * t1218 + t29 * t23 * t1166 / 0.4e1 - 0.9e1 / 0.16e2 * t401 * t242 * t151 + 0.3e1 / 0.2e1 * t1226 + 0.3e1 * t1228 + 0.3e1 / 0.2e1 * t1230 + 0.3e1 * t1232 + 0.15e2 / 0.32e2 * t947 * t91 * t402 + 0.3e1 / 0.8e1 * t150 * t489 * t61 + 0.3e1 / 0.8e1 * t150 * t242 * t164 + t150 * t91 * t423 / 0.8e1 + params->c * t1176 * t30 / 0.4e1 + 0.3e1 / 0.4e1 * t499 * t70;
  t1254 = t94 * t441;
  t1262 = 0.6e1 * t567;
  t1263 = 0.6e1 * t573;
  t1264 = 0.6e1 * t570;
  t1265 = 0.6e1 * t576;
  t1275 = t82 * t133;
  t1278 = t1176 * t23 * t22 + 0.3e1 * t231 * t133 + t88 * t357 + 0.3e1 * t465 * t48 + t1262 + t1263 + t1264 + t1265 + 0.6e1 * t1275 + 0.12e2 * t325 + 0.6e1 * t328 + 0.6e1 * t340;
  t1284 = t18 * t481;
  t1287 = t587 * t22;
  t1289 = t189 * t48;
  t1291 = t114 * t85;
  t1293 = t42 * t208;
  t1299 = t24 * t1166 + 0.3e1 * t154 * t208 + t408 * t85 + 0.3e1 * t56 * t481 + 0.6e1 * t1284 + 0.6e1 * t1287 + 0.12e2 * t1289 + 0.6e1 * t1291 + 0.12e2 * t1293 + 0.6e1 * t918 + 0.6e1 * t922 + 0.2e1 * t926 + 0.2e1 * t929;
  t1303 = t245 * t22;
  t1304 = 0.3e1 / 0.2e1 * t1303;
  t1305 = t94 * t48;
  t1306 = 0.3e1 / 0.2e1 * t1305;
  t1307 = t64 * t85;
  t1308 = 0.3e1 / 0.2e1 * t1307;
  t1309 = t29 * t208;
  t1310 = 0.3e1 / 0.2e1 * t1309;
  t1317 = 0.3e1 / 0.4e1 * t245 * t177 + 0.3e1 / 0.2e1 * t1254 + t94 * t444 / 0.4e1 + 0.3e1 / 0.2e1 * t966 + 0.3e1 / 0.2e1 * t970 + t974 / 0.2e1 + t979 / 0.2e1 - t55 * (t1278 + t1299) / 0.4e1 + t1304 + t1306 + t1308 + t1310 + 0.3e1 / 0.2e1 * t964 + 0.3e1 * t936 + 0.3e1 / 0.2e1 * t938 - 0.9e1 / 0.16e2 * t401 * t496 * t61;
  t1325 = -0.3e1 / 0.4e1 * t1196 - 0.3e1 / 0.2e1 * t1199 - 0.3e1 / 0.4e1 * t1202 - t880 / 0.4e1 + 0.3e1 / 0.4e1 * t890 + 0.3e1 / 0.4e1 * t900 + 0.3e1 / 0.4e1 * t904 + 0.3e1 / 0.4e1 * t907 + t910 / 0.4e1 + 0.3e1 / 0.2e1 * t911 + t18 * t53 * (t1251 + t1317) / 0.4e1 + t18 * t1002 * t100 / 0.4e1;
  t1349 = 0.3e1 / 0.4e1 * t18 * t388 * t262 + 0.3e1 / 0.4e1 * t18 * t137 * t528 - 0.3e1 / 0.2e1 * t1000 - 0.3e1 / 0.4e1 * t1032 - 0.3e1 / 0.4e1 * t1035 - t1038 / 0.4e1 + 0.9e1 / 0.2e1 * t58 * t369 * t262 * t144 - 0.3e1 / 0.2e1 * t233 * t376 - 0.3e1 / 0.2e1 * t239 * t376 - 0.3e1 / 0.2e1 * t410 * t225 - 0.3e1 * t415 * t225;
  t1382 = -0.3e1 * t156 * t619 - 0.3e1 / 0.2e1 * t156 * t621 - 0.3e1 / 0.2e1 * t420 * t225 - 0.3e1 * t161 * t619 - 0.3e1 / 0.2e1 * t161 * t621 - 0.3e1 / 0.2e1 * t58 * t142 * t528 * t73 - 0.3e1 / 0.2e1 * t58 * t618 * t180 - t58 * t224 * t447 / 0.2e1 + 0.9e1 / 0.2e1 * t58 * t612 * t73 * t180 - 0.6e1 * t58 * t1018 * t100 * t371 + 0.9e1 / 0.2e1 * t156 * t613 + 0.9e1 / 0.2e1 * t161 * t613;
  t1386 = my_piecewise3(t3, 0, t1079 + t1106 + t1135 + t1160 + t1194 + t1325 + t1349 + t1382);
  tv4rho41 = t4 * t1386 + t453 + 0.3e1 * t627;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1393 = t285 * t142;
  t1397 = t44 * t770;
  t1398 = t44 * t767;
  t1400 = t262 * t262;
  t1403 = t44 * t764;
  t1405 = t204 * t225;
  t1407 = t192 * t225;
  t1418 = my_piecewise5(t8, 0, t12, 0, t1174);
  t1424 = t309 * t175;
  t1433 = t697 * t67;
  t1434 = t245 * t256;
  t1436 = t64 * t714;
  t1437 = t94 * t516;
  t1446 = t29 * t4 * t648;
  t1447 = my_piecewise5(t12, 0, t8, 0, t1164);
  t1454 = t150 * t91 * t489 / 0.4e1 + t150 * t694 * t61 / 0.4e1 + t150 * t306 * t164 / 0.8e1 + params->c * t1418 * t30 / 0.4e1 + t697 * t70 / 0.2e1 + t1424 + t309 * t177 / 0.4e1 + t499 * t97 / 0.2e1 + t245 * t259 - 0.3e1 / 0.16e2 * t401 * t306 * t151 + t1433 + 0.2e1 * t1434 + t1436 + 0.2e1 * t1437 + t94 * t518 / 0.2e1 + t167 * t314 / 0.4e1 + t64 * t717 / 0.2e1 + t1446 + t29 * t23 * t1447 / 0.4e1 + 0.15e2 / 0.32e2 * t947 * t296 * t151;
  t1458 = t309 * t22;
  t1460 = t94 * t85;
  t1461 = t242 * t242;
  t1464 = t29 * t285;
  t1473 = t273 * t48;
  t1480 = t82 * t208;
  t1487 = t18 * t648;
  t1490 = t1418 * t23 * t22 + t299 * t133 + t24 * t1447 + t154 * t285 + 0.4e1 * t231 * t208 + 0.2e1 * t465 * t85 + 0.2e1 * t675 * t48 + 0.2e1 * t88 * t481 + 0.2e1 * t56 * t648 + 0.4e1 * t1473 + 0.8e1 * t1480 + 0.4e1 * t1487 + 0.2e1 * t751 + 0.4e1 * t754 + 0.2e1 * t757;
  t1491 = t654 * t22;
  t1493 = t189 * t85;
  t1495 = t42 * t285;
  t1510 = 0.4e1 * t1491 + 0.8e1 * t1493 + 0.4e1 * t1495 + 0.8e1 * t567 + 0.8e1 * t573 + 0.8e1 * t570 + 0.8e1 * t576 + 0.2e1 * t340 + 0.4e1 * t325 + 0.2e1 * t328 + 0.4e1 * t1275 + 0.4e1 * t1284 + 0.4e1 * t1287 + 0.8e1 * t1289 + 0.4e1 * t1291 + 0.8e1 * t1293;
  t1525 = -0.3e1 / 0.16e2 * t401 * t296 * t164 + t1458 / 0.2e1 + t1460 + t150 * t1461 / 0.4e1 + t1464 / 0.2e1 - t55 * (t1490 + t1510) / 0.4e1 - 0.3e1 / 0.4e1 * t401 * t228 * t242 + t1218 + t1226 + 0.2e1 * t1228 + t1230 + 0.2e1 * t1232 + t1254 + 0.2e1 * t1303 + 0.2e1 * t1305 + 0.2e1 * t1307 + 0.2e1 * t1309 + t964 / 0.2e1 + t936 + t938 / 0.2e1;
  t1530 = t124 * t632;
  t1533 = t44 * t52 * t721;
  t1535 = t576 * t218;
  t1536 = t204 * t584;
  t1537 = -t273 * t145 / 0.2e1 - t82 * t564 - t18 * t1393 * t144 / 0.2e1 - t1397 - 0.2e1 * t1398 - t18 * t143 * t1400 + 0.3e1 * t1403 - 0.2e1 * t1405 - 0.2e1 * t1407 + t18 * t53 * (t1454 + t1525) / 0.4e1 + t1530 / 0.2e1 + t1533 / 0.2e1 + t1535 + t1536;
  t1538 = t124 * t629;
  t1539 = t751 * t127;
  t1546 = t754 * t127;
  t1553 = t757 * t127;
  t1558 = t573 * t218;
  t1559 = t192 * t584;
  t1565 = -t1538 + t1539 / 0.2e1 - t273 * t134 / 0.4e1 - t587 * t86 / 0.2e1 - t189 * t209 + t1546 - t82 * t603 / 0.2e1 - t114 * t286 / 0.4e1 - t42 * t649 / 0.2e1 + t1553 / 0.2e1 - t18 * t1447 * t34 / 0.4e1 + t1558 + t1559 - t1418 * t4 * t35 / 0.4e1 - t654 * t49 / 0.2e1;
  t1567 = t117 * t632;
  t1569 = t117 * t629;
  t1571 = t188 * t85 * t34;
  t1573 = t41 * t285 * t34;
  t1576 = t653 * t22 * t34;
  t1596 = t1567 / 0.2e1 - t1569 - t1571 - t1573 / 0.2e1 - t1576 / 0.2e1 - 0.2e1 * t156 * t767 - 0.2e1 * t161 * t767 - t58 * t224 * t528 - t156 * t770 - t161 * t770 - t58 * t142 * t721 * t73 - t58 * t769 * t180 / 0.2e1 + 0.3e1 * t233 * t613 + 0.3e1 * t239 * t613;
  t1626 = t570 * t218;
  t1627 = t567 * t218;
  t1628 = -0.6e1 * t58 * t1018 * t292 * t144 + 0.3e1 / 0.2e1 * t58 * t369 * t317 * t144 - 0.2e1 * t484 * t225 - 0.2e1 * t470 * t225 - 0.2e1 * t233 * t619 - t233 * t621 - 0.2e1 * t486 * t225 - 0.2e1 * t477 * t225 - 0.2e1 * t239 * t619 - t239 * t621 + 0.3e1 * t156 * t764 + 0.3e1 * t161 * t764 + 0.3e1 / 0.2e1 * t58 * t763 * t180 + t1626 + t1627;
  t1633 = t272 * t48 * t34;
  t1636 = t81 * t208 * t34;
  t1638 = t17 * t648 * t34;
  t1659 = t1055 / 0.2e1 - t1057 - t1059 - t1633 / 0.2e1 - t1636 - t1638 / 0.2e1 + t42 * t663 / 0.2e1 + t42 * t722 / 0.2e1 + t18 * t388 * t317 / 0.4e1 + t18 * t137 * t721 / 0.2e1 + t18 * t212 * t528 / 0.2e1 - t114 * t293 / 0.2e1 - t42 * t658 - t18 * t1009 * t292 / 0.2e1;
  t1686 = t114 * t318 / 0.4e1 + t82 * t529 / 0.2e1 + t18 * t727 * t180 / 0.4e1 + t114 * t289 / 0.2e1 + t42 * t733 + t42 * t736 + t18 * t1114 * t100 / 0.2e1 + t18 * t552 * t262 + t189 * t221 + t189 * t263 + t82 * t537 / 0.2e1 + t82 * t540 + t654 * t74 / 0.2e1 + t273 * t138 / 0.2e1 + t189 * t213;
  t1691 = t648 * t52;
  t1707 = t82 * t553 + t42 * t728 / 0.2e1 + t18 * t1691 * t73 / 0.2e1 + t273 * t181 / 0.4e1 + t82 * t556 / 0.2e1 + t587 * t101 / 0.2e1 - 0.2e1 * t1084 - 0.2e1 * t1086 - t1118 - 0.2e1 * t1120 + 0.3e1 * t1128 + t1131 / 0.2e1 + t1133 + t1136 / 0.2e1;
  t1718 = t1138 + t1140 + t1142 + t1146 / 0.2e1 + t1154 + t1158 / 0.2e1 + t1170 + t1172 - t1186 / 0.2e1 - t1189 / 0.2e1 - t1192 - t1196 / 0.2e1 - t1199 - t1202 / 0.2e1 + 0.6e1 * t58 * t612 * t73 * t262;
  t1722 = my_piecewise3(t3, 0, t1537 + t1565 + t1596 + t1628 + t1659 + t1686 + t1707 + t1718);
  tv4rho42 = t4 * t1722 + 0.2e1 * t627 + 0.2e1 * t776;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1725 = t204 * t632;
  t1727 = t757 * t218;
  t1729 = t192 * t632;
  t1731 = t754 * t218;
  t1734 = t44 * t369 * t803;
  t1736 = t751 * t218;
  t1738 = t192 * t629;
  t1740 = t204 * t629;
  t1750 = 0.3e1 / 0.4e1 * t1725 + 0.3e1 / 0.4e1 * t1727 + 0.3e1 / 0.4e1 * t1729 + 0.3e1 / 0.2e1 * t1731 + 0.3e1 / 0.2e1 * t1734 + 0.3e1 / 0.4e1 * t1736 - 0.3e1 / 0.2e1 * t1738 - 0.3e1 / 0.2e1 * t1740 + 0.3e1 / 0.4e1 * t18 * t727 * t262 + 0.3e1 / 0.4e1 * t42 * t824 + 0.3e1 / 0.4e1 * t18 * t552 * t317;
  t1777 = 0.3e1 / 0.4e1 * t18 * t212 * t721 + 0.3e1 / 0.4e1 * t189 * t318 + 0.3e1 / 0.4e1 * t82 * t663 + 0.3e1 / 0.4e1 * t82 * t722 + 0.3e1 / 0.4e1 * t42 * t821 + 0.3e1 / 0.4e1 * t18 * t1691 * t100 + 0.3e1 / 0.4e1 * t273 * t221 + 0.3e1 / 0.4e1 * t273 * t263 + 0.3e1 / 0.2e1 * t189 * t289 + 0.3e1 / 0.2e1 * t82 * t733 + 0.3e1 / 0.2e1 * t82 * t736 - 0.3e1 / 0.2e1 * t82 * t658;
  t1797 = t794 * t52;
  t1803 = t44 * t808;
  t1805 = -0.3e1 / 0.2e1 * t42 * t800 - 0.3e1 / 0.2e1 * t18 * t1094 * t292 + 0.3e1 / 0.2e1 * t42 * t804 + 0.3e1 / 0.2e1 * t18 * t1013 * t803 + 0.3e1 / 0.4e1 * t654 * t101 + t785 * t74 / 0.4e1 + 0.3e1 / 0.4e1 * t273 * t213 + 0.3e1 / 0.4e1 * t82 * t728 + t18 * t1797 * t73 / 0.4e1 - 0.3e1 / 0.2e1 * t189 * t293 - 0.3e1 / 0.2e1 * t1803;
  t1815 = my_piecewise5(t12, 0, t8, 0, -t1163 + t1164);
  t1820 = my_piecewise5(t8, 0, t12, 0, t1163 + t1174);
  t1829 = t44 * t52 * t863;
  t1832 = t81 * t285 * t34;
  t1835 = t17 * t794 * t34;
  t1838 = t784 * t22 * t34;
  t1840 = -0.3e1 / 0.4e1 * t273 * t209 - 0.3e1 / 0.4e1 * t189 * t286 - 0.3e1 / 0.4e1 * t82 * t649 - t42 * t795 / 0.4e1 - t18 * t1815 * t34 / 0.4e1 - t1820 * t4 * t35 / 0.4e1 - t785 * t49 / 0.4e1 - 0.3e1 / 0.4e1 * t654 * t86 + t1829 / 0.4e1 - 0.3e1 / 0.4e1 * t1832 - t1835 / 0.4e1 - t1838 / 0.4e1;
  t1844 = t272 * t85 * t34;
  t1858 = t848 * t67;
  t1860 = t309 * t256;
  t1862 = t94 * t714;
  t1865 = t29 * t4 * t794;
  t1885 = 0.3e1 / 0.8e1 * t150 * t242 * t306 + 0.3e1 / 0.8e1 * t150 * t91 * t694 + t150 * t845 * t61 / 0.8e1 + params->c * t1820 * t30 / 0.4e1 + t1858 / 0.2e1 + 0.3e1 / 0.2e1 * t1860 + 0.3e1 / 0.2e1 * t1862 + t1865 / 0.2e1 + t848 * t70 / 0.4e1 + 0.3e1 / 0.4e1 * t697 * t97 + 0.3e1 / 0.4e1 * t309 * t259 + 0.3e1 / 0.4e1 * t245 * t314 + 0.3e1 / 0.4e1 * t94 * t717 + t64 * t860 / 0.4e1 + t29 * t23 * t1815 / 0.4e1 + 0.15e2 / 0.32e2 * t947 * t827 * t61;
  t1889 = t785 * t22;
  t1891 = t273 * t85;
  t1893 = t82 * t285;
  t1895 = t18 * t794;
  t1910 = t1820 * t23 * t22 + t24 * t1815 + 0.3e1 * t299 * t208 + 0.3e1 * t231 * t285 + t833 * t48 + t56 * t794 + 0.3e1 * t88 * t648 + 0.3e1 * t675 * t85 + 0.2e1 * t1889 + 0.6e1 * t1891 + 0.6e1 * t1893 + 0.2e1 * t1895;
  t1920 = 0.6e1 * t751 + 0.12e2 * t754 + 0.6e1 * t757 + 0.6e1 * t1473 + 0.12e2 * t1480 + 0.6e1 * t1487 + 0.6e1 * t1491 + 0.12e2 * t1493 + 0.6e1 * t1495 + t1262 + t1263 + t1264 + t1265;
  t1936 = -0.9e1 / 0.16e2 * t401 * t296 * t242 - t55 * (t1910 + t1920) / 0.4e1 - 0.9e1 / 0.16e2 * t401 * t830 * t61 + 0.3e1 / 0.2e1 * t1424 + 0.3e1 / 0.2e1 * t1433 + 0.3e1 * t1434 + 0.3e1 / 0.2e1 * t1436 + 0.3e1 * t1437 + 0.3e1 / 0.2e1 * t1446 + 0.3e1 / 0.2e1 * t1458 + 0.3e1 * t1460 + 0.3e1 / 0.2e1 * t1464 + t1304 + t1306 + t1308 + t1310;
  t1953 = -0.3e1 / 0.4e1 * t1844 + t18 * t53 * (t1885 + t1936) / 0.4e1 + t42 * t864 / 0.4e1 + t18 * t137 * t863 / 0.4e1 - 0.3e1 / 0.2e1 * t1397 - 0.3e1 * t1398 + 0.9e1 / 0.2e1 * t1403 - 0.3e1 * t1405 - 0.3e1 * t1407 + 0.3e1 / 0.4e1 * t1530 + 0.3e1 / 0.4e1 * t1533;
  t1966 = 0.3e1 / 0.2e1 * t1535 + 0.3e1 / 0.2e1 * t1536 - 0.3e1 / 0.2e1 * t1538 + 0.3e1 / 0.4e1 * t1539 + 0.3e1 / 0.2e1 * t1546 + 0.3e1 / 0.4e1 * t1553 + 0.3e1 / 0.2e1 * t1558 + 0.3e1 / 0.2e1 * t1559 + 0.3e1 / 0.4e1 * t1567 - 0.3e1 / 0.2e1 * t1569 - 0.3e1 / 0.2e1 * t1571 - 0.3e1 / 0.4e1 * t1573;
  t1994 = -0.3e1 / 0.4e1 * t1576 + 0.9e1 / 0.2e1 * t233 * t764 - 0.3e1 * t233 * t767 + 0.9e1 / 0.2e1 * t239 * t764 - 0.3e1 * t239 * t767 - 0.6e1 * t58 * t1018 * t803 * t73 + 0.9e1 / 0.2e1 * t58 * t763 * t262 - 0.3e1 / 0.2e1 * t156 * t808 - 0.3e1 / 0.2e1 * t161 * t808 - 0.3e1 / 0.2e1 * t58 * t618 * t317 - 0.3e1 / 0.2e1 * t58 * t224 * t721;
  t2018 = -0.3e1 / 0.2e1 * t677 * t225 - 0.3e1 * t683 * t225 - 0.3e1 / 0.2e1 * t233 * t770 - 0.3e1 / 0.2e1 * t691 * t225 - 0.3e1 / 0.2e1 * t239 * t770 - t58 * t142 * t863 * t73 / 0.2e1 + 0.3e1 / 0.2e1 * t1626 + 0.3e1 / 0.2e1 * t1627 - 0.3e1 / 0.4e1 * t1633 - 0.3e1 / 0.2e1 * t1636 - 0.3e1 / 0.4e1 * t1638 + 0.9e1 / 0.2e1 * t58 * t612 * t317 * t73;
  t2022 = my_piecewise3(t3, 0, t1750 + t1777 + t1805 + t1840 + t1953 + t1966 + t1994 + t2018);
  tv4rho43 = t4 * t2022 + 0.3e1 * t776 + t869;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2027 = my_piecewise5(t8, 0, t12, 0, 0.24e2 * t332 + 0.24e2 * t892);
  t2037 = my_piecewise5(t12, 0, t8, 0, -0.24e2 * t332 + 0.24e2 * t883);
  t2049 = t317 * t317;
  t2058 = t292 * t292;
  t2067 = -t2027 * t4 * t35 / 0.4e1 - t785 * t86 - 0.3e1 / 0.2e1 * t273 * t286 - t82 * t795 - t18 * t2037 * t34 / 0.4e1 + 0.3e1 * t1725 + 0.3e1 * t1727 + 0.3e1 * t1729 + 0.6e1 * t1731 + 0.6e1 * t1734 + 0.3e1 * t1736 - 0.6e1 * t1738 - 0.6e1 * t1740 - 0.3e1 / 0.2e1 * t18 * t143 * t2049 + 0.6e1 * t82 * t804 + 0.6e1 * t18 * t1124 * t803 - 0.6e1 * t18 * t1019 * t2058 + t785 * t101 + 0.3e1 * t273 * t289 + 0.3e1 * t82 * t821;
  t2089 = t306 * t306;
  t2105 = t296 * t296;
  t2128 = t2027 * t23 * t22 + t24 * t2037 + 0.6e1 * t299 * t285 + 0.4e1 * t88 * t794 + 0.4e1 * t833 * t85 + 0.8e1 * t1889 + 0.24e2 * t1891 + 0.24e2 * t1893 + 0.8e1 * t1895 + 0.12e2 * t751 + 0.24e2 * t754 + 0.12e2 * t757;
  t2133 = 0.2e1 * t1858 + 0.6e1 * t1860 + 0.6e1 * t1862 + 0.2e1 * t1865 + 0.3e1 / 0.8e1 * t150 * t2089 + t150 * t91 * t845 / 0.2e1 + params->c * t2027 * t30 / 0.4e1 + t848 * t97 + 0.3e1 / 0.2e1 * t309 * t314 + t94 * t860 + t29 * t23 * t2037 / 0.4e1 + 0.15e2 / 0.32e2 * t947 * t2105 - 0.9e1 / 0.8e1 * t401 * t296 * t306 + 0.3e1 * t1464 - t55 * t2128 / 0.4e1 + 0.3e1 * t1458 + 0.6e1 * t1460;
  t2152 = t18 * t1797 * t100 - 0.3e1 * t273 * t293 - 0.6e1 * t82 * t800 - 0.3e1 * t18 * t1393 * t292 + 0.3e1 * t82 * t824 + t82 * t864 + 0.3e1 / 0.2e1 * t18 * t727 * t317 + t18 * t212 * t863 + t18 * t53 * t2133 / 0.4e1 + 0.3e1 / 0.2e1 * t273 * t318 - 0.6e1 * t1803 + t1829 - 0.3e1 * t1832 - t1835 - t1838 - 0.3e1 * t1844 - 0.6e1 * t233 * t808 - 0.6e1 * t239 * t808 + 0.9e1 * t58 * t763 * t317 - 0.2e1 * t58 * t224 * t863;
  t2154 = my_piecewise3(t3, 0, t2067 + t2152);
  tv4rho44 = t4 * t2154 + 0.4e1 * t869;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

