/* SPDX-FileCopyrightText: 2024 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#pragma once

#include "BLI_utildefines.h"

/** \file
 * \ingroup imbuf
 */

#define IM_MAX_SPACE 64

/** #ImBuf.ftype: main image types. */
enum eImbFileType {
  IMB_FTYPE_NONE = 0,
  IMB_FTYPE_PNG = 1,
  IMB_FTYPE_TGA = 2,
  IMB_FTYPE_JPG = 3,
  IMB_FTYPE_BMP = 4,
  IMB_FTYPE_OPENEXR = 5,
  IMB_FTYPE_IRIS = 6,
  IMB_FTYPE_PSD = 7,
#ifdef WITH_IMAGE_OPENJPEG
  IMB_FTYPE_JP2 = 8,
#endif
  IMB_FTYPE_RADHDR = 9,
  IMB_FTYPE_TIF = 10,
#ifdef WITH_IMAGE_CINEON
  IMB_FTYPE_CINEON = 11,
  IMB_FTYPE_DPX = 12,
#endif

  IMB_FTYPE_DDS = 13,
#ifdef WITH_IMAGE_WEBP
  IMB_FTYPE_WEBP = 14,
#endif
};

/** NOTE: Keep in sync with #MovieClipProxy.build_size_flag */
enum IMB_Proxy_Size {
  IMB_PROXY_NONE = 0,
  IMB_PROXY_25 = 1,
  IMB_PROXY_50 = 2,
  IMB_PROXY_75 = 4,
  IMB_PROXY_100 = 8,
  IMB_PROXY_MAX_SLOT = 4,
};
ENUM_OPERATORS(IMB_Proxy_Size, IMB_PROXY_100);
