##-*****************************************************************************
##
## Copyright (c) 2009-2016,
##  Sony Pictures Imageworks Inc. and
##  Industrial Light & Magic, a division of Lucasfilm Entertainment Company Ltd.
##
## All rights reserved.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are
## met:
## *       Redistributions of source code must retain the above copyright
## notice, this list of conditions and the following disclaimer.
## *       Redistributions in binary form must reproduce the above
## copyright notice, this list of conditions and the following disclaimer
## in the documentation and/or other materials provided with the
## distribution.
## *       Neither the name of Industrial Light & Magic nor the names of
## its contributors may be used to endorse or promote products derived
## from this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
## "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
## LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
## A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
## OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
## SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
## LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
## DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
## THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
## OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
##-*****************************************************************************

FIND_PACKAGE(Imath)

SET(PYTHON_VERSION_MAJOR ${PYALEMBIC_PYTHON_MAJOR})
SET(PYTHON_VERSION_MINOR ${Python${PYALEMBIC_PYTHON_MAJOR}_VERSION_MINOR})
SET(PYTHON_INCLUDE_DIR ${Python${PYTHON_VERSION_MAJOR}_INCLUDE_DIRS})

IF (Imath_FOUND)
    SET(ALEMBIC_PYILMBASE_PYIMATH_LIB Imath::PyImath_Python${PYTHON_VERSION_MAJOR}_${PYTHON_VERSION_MINOR})
    MESSAGE(STATUS "Found package Imath using: ${ALEMBIC_PYILMBASE_PYIMATH_LIB}")
ELSE()
    FIND_PACKAGE(PyIlmBase)
    IF (PYILMBASE_FOUND)
        SET(ALEMBIC_PYILMBASE_FOUND 1 CACHE STRING "Set to 1 if PyIlmBase is found, 0 otherwise")

        SET(ALEMBIC_PYILMBASE_LIBS
            ${ALEMBIC_PYILMBASE_PYIMATH_LIB}
        )

        GET_FILENAME_COMPONENT(ALEMBIC_PYILMBASE_LIB_DIRECTORY
            ${ALEMBIC_PYILMBASE_PYIMATH_LIB}
            PATH
        )

    ELSE()
        SET(ALEMBIC_PYILMBASE_FOUND 0 CACHE STRING "Set to 1 if PyIlmBase is found, 0 otherwise")
    ENDIF()
ENDIF()