﻿!mod$ v1 sum:7dea6eae1272c714
!need$ eb4f12a3d903af23 n multicharge_ewald
!need$ 34a8c0a7002d5e17 n multicharge_model_type
!need$ 8412b2dc2e454320 n multicharge_model_cache
!need$ d6b91e53bed6f38f n mctc_io_constants
!need$ c301c17a17af4c8a n mctc_io_math
!need$ 3993c955ea946ce5 n mctc_ncoord
!need$ ae78003ee30bd742 n mctc_env
!need$ 1f6fcd35e7441abe n mctc_io
!need$ 627db9e470f4de18 n multicharge_wignerseitz
module multicharge_model_eeq
use mctc_env,only:error_type
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_constants,only:pi
use mctc_io_math,only:matdet_3x3
use mctc_ncoord,only:new_ncoord
use mctc_ncoord,only:cn_count
use multicharge_wignerseitz,only:wignerseitz_cell_type
use multicharge_wignerseitz,only:new_wignerseitz_cell
use multicharge_ewald,only:get_alpha
use multicharge_model_type,only:mchrg_model_type
use multicharge_model_type,only:get_dir_trans
use multicharge_model_type,only:get_rec_trans
use multicharge_model_cache,only:cache_container
use multicharge_model_cache,only:model_cache
private::error_type
private::wp
private::structure_type
private::pi
private::matdet_3x3
private::new_ncoord
private::cn_count
private::wignerseitz_cell_type
private::new_wignerseitz_cell
private::get_alpha
private::mchrg_model_type
private::get_dir_trans
private::get_rec_trans
private::cache_container
private::model_cache
type,extends(model_cache)::eeq_cache
end type
type,extends(mchrg_model_type)::eeq_model
contains
procedure::update
procedure::get_coulomb_matrix
procedure::get_coulomb_derivs
procedure::get_xvec
procedure::get_xvec_derivs
end type
real(8),parameter,private::sqrtpi=1.772453850905515881919427556567825376987457275390625_8
intrinsic::sqrt
private::sqrt
real(8),parameter,private::sqrt2pi=7.9788456080286540572643616542336530983448028564453125e-1_8
real(8),parameter,private::eps=1.490116119384765625e-8_8
intrinsic::epsilon
private::epsilon
private::update
private::get_xvec
private::get_xvec_derivs
private::get_coulomb_matrix
private::get_amat_0d
private::get_amat_3d
private::get_amat_dir_3d
private::get_amat_rec_3d
private::get_coulomb_derivs
private::get_damat_0d
private::get_damat_3d
private::get_damat_dir_3d
private::get_damat_rec_3d
private::taint
private::view
contains
subroutine new_eeq_model(self,mol,error,chi,rad,eta,kcnchi,cutoff,cn_exp,rcov,cn_max)
type(eeq_model),intent(out)::self
type(structure_type),intent(in)::mol
type(error_type),allocatable,intent(out)::error
real(8),intent(in)::chi(:)
real(8),intent(in)::rad(:)
real(8),intent(in)::eta(:)
real(8),intent(in)::kcnchi(:)
real(8),intent(in),optional::cutoff
real(8),intent(in),optional::cn_exp
real(8),intent(in),optional::rcov(:)
real(8),intent(in),optional::cn_max
end
subroutine update(self,mol,cache,cn,qloc,dcndr,dcndl,dqlocdr,dqlocdl)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(in)::cn(:)
real(8),intent(in),optional::qloc(:)
real(8),intent(in),optional::dcndr(:,:,:)
real(8),intent(in),optional::dcndl(:,:,:)
real(8),intent(in),optional::dqlocdr(:,:,:)
real(8),intent(in),optional::dqlocdl(:,:,:)
end
subroutine get_xvec(self,mol,cache,xvec)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(out)::xvec(:)
end
subroutine get_xvec_derivs(self,mol,cache,dxdr,dxdl)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),contiguous,intent(out)::dxdr(:,:,:)
real(8),contiguous,intent(out)::dxdl(:,:,:)
end
subroutine get_coulomb_matrix(self,mol,cache,amat)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(out)::amat(:,:)
end
subroutine get_amat_0d(self,mol,amat)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
real(8),intent(out)::amat(:,:)
end
subroutine get_amat_3d(self,mol,wsc,alpha,amat)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(wignerseitz_cell_type),intent(in)::wsc
real(8),intent(in)::alpha
real(8),intent(out)::amat(:,:)
end
subroutine get_amat_dir_3d(rij,gam,alp,trans,amat)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::gam
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::amat
end
subroutine get_amat_rec_3d(rij,vol,alp,trans,amat)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::vol
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::amat
end
subroutine get_coulomb_derivs(self,mol,cache,qvec,dadr,dadl,atrace)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(in)::qvec(:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_0d(self,mol,qvec,dadr,dadl,atrace)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::qvec(:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_3d(self,mol,wsc,alpha,qvec,dadr,dadl,atrace)
class(eeq_model),intent(in)::self
type(structure_type),intent(in)::mol
type(wignerseitz_cell_type),intent(in)::wsc
real(8),intent(in)::alpha
real(8),intent(in)::qvec(:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_dir_3d(rij,gam,alp,trans,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::gam
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
subroutine get_damat_rec_3d(rij,vol,alp,trans,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::vol
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
subroutine taint(cache,ptr)
type(cache_container),intent(inout),target::cache
type(eeq_cache),intent(out),pointer::ptr
end
subroutine view(cache,ptr)
type(cache_container),intent(inout),target::cache
type(eeq_cache),intent(out),pointer::ptr
end
end
