@echo off

set MRUBY_PACKAGE_DIR=%~dp0..

:top
shift
if "%0" equ "" goto :eof
if "%0" equ "--cc" goto cc
if "%0" equ "--cflags" goto cflags
if "%0" equ "--cxx" goto cxx
if "%0" equ "--cxxflags" goto cxxflags
if "%0" equ "--as" goto as
if "%0" equ "--asflags" goto asflags
if "%0" equ "--objc" goto objc
if "%0" equ "--objcflags" goto objcflags
if "%0" equ "--ld" goto ld
if "%0" equ "--ldflags" goto ldflags
if "%0" equ "--ldflags-before-libs" goto ldflagsbeforelibs
if "%0" equ "--libs" goto libs
if "%0" equ "--libmruby-path" goto libmrubypath
if "%0" equ "--help" goto showhelp
echo Invalid Option
goto :eof

:cc
echo clang
goto top

:cflags
echo -std=gnu99 -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -DHAVE_MRUBY_IO_GEM -DMRB_USE_RATIONAL -DMRB_USE_COMPLEX -DMRB_USE_BIGINT -DMRB_USE_DEBUG_HOOK -I"%MRUBY_PACKAGE_DIR%/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-time/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-io/include"
goto top

:cxx
echo clang++
goto top

:cxxflags
echo -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -DHAVE_MRUBY_IO_GEM -DMRB_USE_RATIONAL -DMRB_USE_COMPLEX -DMRB_USE_BIGINT -DMRB_USE_DEBUG_HOOK -I"%MRUBY_PACKAGE_DIR%/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-time/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-io/include"
goto top

:as
echo clang
goto top

:asflags
echo -std=gnu99 -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -DHAVE_MRUBY_IO_GEM -DMRB_USE_RATIONAL -DMRB_USE_COMPLEX -DMRB_USE_BIGINT -DMRB_USE_DEBUG_HOOK -I"%MRUBY_PACKAGE_DIR%/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-time/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-io/include"
goto top

:objc
echo clang
goto top

:objcflags
echo -std=gnu99 -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -DHAVE_MRUBY_IO_GEM -DMRB_USE_RATIONAL -DMRB_USE_COMPLEX -DMRB_USE_BIGINT -DMRB_USE_DEBUG_HOOK -I"%MRUBY_PACKAGE_DIR%/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-time/include" -I"%MRUBY_PACKAGE_DIR%/include/mruby/gems/mruby-io/include"
goto top

:ld
echo clang++
goto top

:libs
echo -lmruby -lws2_32 -lwsock32 -lws2_32
goto top

:ldflags
echo  -L%MRUBY_PACKAGE_DIR%/lib
goto top

:ldflagsbeforelibs

goto top

:libmrubypath
echo %MRUBY_PACKAGE_DIR%/lib/libmruby.a
goto top

:showhelp
echo Usage: mruby-config [switches]
echo   switches:
echo   --cc                       print C compiler name
echo   --cflags                   print flags passed to C compiler
echo   --cxx                      print C++ compiler name
echo   --cxxflags                 print flags passed to C++ compiler
echo   --as                       print assembler name
echo   --asflags                  print flags passed to assembler
echo   --objc                     print Objective C compiler name
echo   --objcflags                print flags passed to Objective C compiler
echo   --ld                       print linker name
echo   --ldflags                  print flags passed to linker
echo   --ldflags-before-libs      print flags passed to linker before linked libraries
echo   --libs                     print linked libraries
echo   --libmruby-path            print libmruby path
