﻿!mod$ v1 sum:5be459034880436c
!need$ 34a8c0a7002d5e17 n multicharge_model_type
!need$ 4749dcdf2ccf93c6 n multicharge_blas
!need$ 8412b2dc2e454320 n multicharge_model_cache
!need$ d6b91e53bed6f38f n mctc_io_constants
!need$ 3993c955ea946ce5 n mctc_ncoord
!need$ ae78003ee30bd742 n mctc_env
!need$ 1f6fcd35e7441abe n mctc_io
!need$ 627db9e470f4de18 n multicharge_wignerseitz
module multicharge_model_eeqbc
use mctc_env,only:error_type
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_constants,only:pi
use mctc_ncoord,only:new_ncoord
use mctc_ncoord,only:cn_count
use multicharge_wignerseitz,only:new_wignerseitz_cell
use multicharge_wignerseitz,only:wignerseitz_cell_type
use multicharge_model_type,only:mchrg_model_type
use multicharge_model_type,only:get_dir_trans
use multicharge_blas,only:gemv
use multicharge_blas,only:gemm
use multicharge_model_cache,only:cache_container
use multicharge_model_cache,only:model_cache
use multicharge_blas,only:multicharge_blas$multicharge_blas$mchrg_dgemm323=>mchrg_dgemm323
use multicharge_blas,only:multicharge_blas$multicharge_blas$mchrg_dgemv=>mchrg_dgemv
private::error_type
private::wp
private::structure_type
private::pi
private::new_ncoord
private::cn_count
private::new_wignerseitz_cell
private::wignerseitz_cell_type
private::mchrg_model_type
private::get_dir_trans
private::gemv
private::gemm
private::cache_container
private::model_cache
private::multicharge_blas$multicharge_blas$mchrg_dgemm323
private::multicharge_blas$multicharge_blas$mchrg_dgemv
type,private,extends(model_cache)::eeqbc_cache
real(8),allocatable::qloc(:)
real(8),allocatable::dqlocdr(:,:,:)
real(8),allocatable::dqlocdl(:,:,:)
real(8),allocatable::cmat(:,:)
real(8),allocatable::dcdr(:,:,:)
real(8),allocatable::dcdl(:,:,:)
real(8),allocatable::xtmp(:)
end type
type,extends(mchrg_model_type)::eeqbc_model
real(8),allocatable::cap(:)
real(8),allocatable::avg_cn(:)
real(8)::kbc
real(8)::norm_exp
real(8),allocatable::rvdw(:,:)
contains
procedure::update
procedure::get_coulomb_matrix
procedure::get_coulomb_derivs
procedure::get_xvec
procedure::get_xvec_derivs
procedure::get_cmat_0d
procedure::get_cmat_3d
procedure::get_dcmat_0d
procedure::get_dcmat_3d
end type
real(8),parameter,private::sqrtpi=1.772453850905515881919427556567825376987457275390625_8
intrinsic::sqrt
private::sqrt
real(8),parameter,private::sqrt2pi=7.9788456080286540572643616542336530983448028564453125e-1_8
real(8),parameter,private::eps=1.490116119384765625e-8_8
intrinsic::epsilon
private::epsilon
real(8),parameter,private::default_norm_exp=1._8
real(8),parameter,private::default_kbc=6.5000000000000002220446049250313080847263336181640625e-1_8
private::update
private::get_xvec
private::get_xvec_derivs
private::get_coulomb_matrix
private::get_amat_0d
private::get_amat_3d
private::get_amat_dir_3d
private::get_coulomb_derivs
private::get_damat_0d
private::get_damat_3d
private::get_damat_dir
private::get_damat_dc_dir
private::get_cmat_0d
private::get_cmat_3d
private::get_cpair
private::get_cpair_dir
private::get_dcpair
private::get_dcmat_0d
private::get_dcmat_3d
private::get_dcpair_dir
private::taint
private::view
contains
subroutine new_eeqbc_model(self,mol,error,chi,rad,eta,kcnchi,kqchi,kqeta,kcnrad,cap,avg_cn,rvdw,kbc,cutoff,cn_exp,rcov,en,cn_max,norm_exp)
type(eeqbc_model),intent(out)::self
type(structure_type),intent(in)::mol
type(error_type),allocatable,intent(out)::error
real(8),intent(in)::chi(:)
real(8),intent(in)::rad(:)
real(8),intent(in)::eta(:)
real(8),intent(in)::kcnchi(:)
real(8),intent(in)::kqchi(:)
real(8),intent(in)::kqeta(:)
real(8),intent(in)::kcnrad
real(8),intent(in)::cap(:)
real(8),intent(in)::avg_cn(:)
real(8),intent(in)::rvdw(:,:)
real(8),intent(in),optional::kbc
real(8),intent(in),optional::cutoff
real(8),intent(in),optional::cn_exp
real(8),intent(in),optional::rcov(:)
real(8),intent(in),optional::en(:)
real(8),intent(in),optional::cn_max
real(8),intent(in),optional::norm_exp
end
subroutine update(self,mol,cache,cn,qloc,dcndr,dcndl,dqlocdr,dqlocdl)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(in)::cn(:)
real(8),intent(in),optional::qloc(:)
real(8),intent(in),optional::dcndr(:,:,:)
real(8),intent(in),optional::dcndl(:,:,:)
real(8),intent(in),optional::dqlocdr(:,:,:)
real(8),intent(in),optional::dqlocdl(:,:,:)
end
subroutine get_xvec(self,mol,cache,xvec)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(out)::xvec(:)
end
subroutine get_xvec_derivs(self,mol,cache,dxdr,dxdl)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),contiguous,intent(out)::dxdr(:,:,:)
real(8),contiguous,intent(out)::dxdl(:,:,:)
end
subroutine get_coulomb_matrix(self,mol,cache,amat)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(out)::amat(:,:)
end
subroutine get_amat_0d(self,mol,cn,qloc,cmat,amat)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::cn(:)
real(8),intent(in)::qloc(:)
real(8),intent(in)::cmat(:,:)
real(8),intent(out)::amat(:,:)
end
subroutine get_amat_3d(self,mol,wsc,cn,qloc,cmat,amat)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(wignerseitz_cell_type),intent(in)::wsc
real(8),intent(in)::cn(:)
real(8),intent(in)::qloc(:)
real(8),intent(in)::cmat(:,:)
real(8),intent(out)::amat(:,:)
end
subroutine get_amat_dir_3d(rij,gam,trans,kbc,rvdw,capi,capj,amat)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::gam
real(8),intent(in)::trans(:,:)
real(8),intent(in)::kbc
real(8),intent(in)::rvdw
real(8),intent(in)::capi
real(8),intent(in)::capj
real(8),intent(out)::amat
end
subroutine get_coulomb_derivs(self,mol,cache,qvec,dadr,dadl,atrace)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(cache_container),intent(inout)::cache
real(8),intent(in)::qvec(:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_0d(self,mol,cn,qloc,qvec,dcndr,dcndl,dqlocdr,dqlocdl,cmat,dcdr,dcdl,dadr,dadl,atrace)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::cn(:)
real(8),intent(in)::qloc(:)
real(8),intent(in)::qvec(:)
real(8),intent(in)::dcndr(:,:,:)
real(8),intent(in)::dcndl(:,:,:)
real(8),intent(in)::dqlocdr(:,:,:)
real(8),intent(in)::dqlocdl(:,:,:)
real(8),intent(in)::cmat(:,:)
real(8),intent(in)::dcdr(:,:,:)
real(8),intent(in)::dcdl(:,:,:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_3d(self,mol,wsc,cn,qloc,qvec,dcndr,dcndl,dqlocdr,dqlocdl,cmat,dcdr,dcdl,dadr,dadl,atrace)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(wignerseitz_cell_type),intent(in)::wsc
real(8),intent(in)::cn(:)
real(8),intent(in)::qloc(:)
real(8),intent(in)::qvec(:)
real(8),intent(in)::dcndr(:,:,:)
real(8),intent(in)::dcndl(:,:,:)
real(8),intent(in)::dqlocdr(:,:,:)
real(8),intent(in)::dqlocdl(:,:,:)
real(8),intent(in)::cmat(:,:)
real(8),intent(in)::dcdr(:,:,:)
real(8),intent(in)::dcdl(:,:,:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_dir(rij,trans,capi,capj,rvdw,kbc,gam,dg,ds,dgam)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::trans(:,:)
real(8),intent(in)::capi
real(8),intent(in)::capj
real(8),intent(in)::rvdw
real(8),intent(in)::kbc
real(8),intent(in)::gam
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
real(8),intent(out)::dgam
end
subroutine get_damat_dc_dir(rij,trans,capi,capj,rvdw,kbc,gam,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::trans(:,:)
real(8),intent(in)::capi
real(8),intent(in)::capj
real(8),intent(in)::rvdw
real(8),intent(in)::kbc
real(8),intent(in)::gam
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
subroutine get_cmat_0d(self,mol,cmat)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
real(8),intent(out)::cmat(:,:)
end
subroutine get_cmat_3d(self,mol,wsc,cmat)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(wignerseitz_cell_type),intent(in)::wsc
real(8),intent(out)::cmat(:,:)
end
subroutine get_cpair(kbc,cpair,r1,rvdw,capi,capj)
real(8),intent(in)::kbc
real(8),intent(out)::cpair
real(8),intent(in)::r1
real(8),intent(in)::rvdw
real(8),intent(in)::capi
real(8),intent(in)::capj
end
subroutine get_cpair_dir(kbc,rij,trans,rvdw,capi,capj,cpair)
real(8),intent(in)::kbc
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::trans(:,:)
real(8),intent(in)::rvdw
real(8),intent(in)::capi
real(8),intent(in)::capj
real(8),intent(out)::cpair
end
subroutine get_dcpair(kbc,vec,rvdw,capi,capj,dgpair,dspair)
real(8),intent(in)::kbc
real(8),intent(in)::vec(1_8:3_8)
real(8),intent(in)::rvdw
real(8),intent(in)::capi
real(8),intent(in)::capj
real(8),intent(out)::dgpair(1_8:3_8)
real(8),intent(out)::dspair(1_8:3_8,1_8:3_8)
end
subroutine get_dcmat_0d(self,mol,dcdr,dcdl)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
real(8),intent(out)::dcdr(:,:,:)
real(8),intent(out)::dcdl(:,:,:)
end
subroutine get_dcmat_3d(self,mol,wsc,dcdr,dcdl)
class(eeqbc_model),intent(in)::self
type(structure_type),intent(in)::mol
type(wignerseitz_cell_type),intent(in)::wsc
real(8),intent(out)::dcdr(:,:,:)
real(8),intent(out)::dcdl(:,:,:)
end
subroutine get_dcpair_dir(kbc,rij,trans,rvdw,capi,capj,dgpair,dspair)
real(8),intent(in)::kbc
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::trans(:,:)
real(8),intent(in)::rvdw
real(8),intent(in)::capi
real(8),intent(in)::capj
real(8),intent(out)::dgpair(1_8:3_8)
real(8),intent(out)::dspair(1_8:3_8,1_8:3_8)
end
subroutine taint(cache,ptr)
type(cache_container),intent(inout),target::cache
type(eeqbc_cache),intent(out),pointer::ptr
end
subroutine view(cache,ptr)
type(cache_container),intent(inout),target::cache
type(eeqbc_cache),intent(out),pointer::ptr
end
end
