window.search = Object.assign(window.search, JSON.parse('{"doc_urls":["index.html#introduction","index.html#contributing","index.html#license","guide/installation.html#installation","guide/installation.html#pre-compiled-binaries","guide/installation.html#build-from-source-using-rust","guide/installation.html#modifying-and-contributing","guide/reading.html#reading-books","guide/reading.html#navigation","guide/reading.html#top-menu-bar","guide/reading.html#search","guide/reading.html#code-blocks","guide/creating.html#creating-a-book","guide/creating.html#initializing-a-book","guide/creating.html#anatomy-of-a-book","guide/creating.html#publishing-a-book","cli/index.html#command-line-tool","cli/init.html#the-init-command","cli/build.html#the-build-command","cli/watch.html#the-watch-command","cli/serve.html#the-serve-command","cli/test.html#the-test-command","cli/clean.html#the-clean-command","cli/completions.html#the-completions-command","format/index.html#format","format/summary.html#summarymd","format/configuration/index.html#configuration","format/configuration/general.html#general-configuration","format/configuration/general.html#supported-configuration-options","format/configuration/preprocessors.html#configuring-preprocessors","format/configuration/preprocessors.html#custom-preprocessor-configuration","format/configuration/preprocessors.html#locking-a-preprocessor-dependency-to-a-renderer","format/configuration/preprocessors.html#provide-your-own-command","format/configuration/preprocessors.html#require-a-certain-order","format/configuration/renderers.html#configuring-renderers","format/configuration/renderers.html#output-tables","format/configuration/renderers.html#html-renderer-options","format/configuration/renderers.html#markdown-renderer","format/configuration/environment-variables.html#environment-variables","format/theme/index.html#theme","format/theme/index-hbs.html#indexhbs","format/theme/index-hbs.html#data","format/theme/index-hbs.html#handlebars-helpers","format/theme/syntax-highlighting.html#syntax-highlighting","format/theme/syntax-highlighting.html#supported-languages","format/theme/syntax-highlighting.html#custom-theme","format/theme/syntax-highlighting.html#improve-default-theme","format/theme/editor.html#editor","format/theme/editor.html#customizing-the-editor","format/mathjax.html#mathjax-support","format/mdbook.html#mdbook-specific-features","format/mdbook.html#hiding-code-lines","format/mdbook.html#rust-playground","format/mdbook.html#rust-code-block-attributes","format/mdbook.html#including-files","format/mdbook.html#including-portions-of-a-file","format/mdbook.html#including-a-file-but-initially-hiding-all-except-specified-lines","format/mdbook.html#inserting-runnable-rust-files","format/mdbook.html#controlling-page-title","format/mdbook.html#html-classes-provided-by-mdbook","format/mdbook.html#font-awesome-icons","format/markdown.html#markdown","format/markdown.html#text-and-paragraphs","format/markdown.html#headings","format/markdown.html#lists","format/markdown.html#links","format/markdown.html#images","format/markdown.html#extensions","continuous-integration.html#running-mdbook-in-continuous-integration","continuous-integration.html#installing-mdbook","continuous-integration.html#running-tests","continuous-integration.html#deploying","for_developers/index.html#for-developers","for_developers/index.html#the-build-process","for_developers/index.html#using-mdbook-as-a-library","for_developers/preprocessors.html#preprocessors","for_developers/preprocessors.html#hooking-into-mdbook","for_developers/preprocessors.html#hints-for-implementing-a-preprocessor","for_developers/preprocessors.html#implementing-a-preprocessor-with-a-different-language","for_developers/backends.html#alternative-backends","for_developers/backends.html#setting-up","for_developers/backends.html#inspecting-the-book","for_developers/backends.html#enabling-the-backend","for_developers/backends.html#configuration","for_developers/backends.html#output-and-signalling-failure","for_developers/backends.html#wrapping-up","misc/contributors.html#contributors"],"index":{"documentStore":{"docInfo":{"0":{"body":89,"breadcrumbs":2,"title":1},"1":{"body":32,"breadcrumbs":2,"title":1},"10":{"body":59,"breadcrumbs":3,"title":1},"11":{"body":75,"breadcrumbs":4,"title":2},"12":{"body":9,"breadcrumbs":4,"title":2},"13":{"body":87,"breadcrumbs":4,"title":2},"14":{"body":194,"breadcrumbs":4,"title":2},"15":{"body":48,"breadcrumbs":4,"title":2},"16":{"body":73,"breadcrumbs":6,"title":3},"17":{"body":174,"breadcrumbs":6,"title":2},"18":{"body":105,"breadcrumbs":6,"title":2},"19":{"body":172,"breadcrumbs":6,"title":2},"2":{"body":9,"breadcrumbs":2,"title":1},"20":{"body":210,"breadcrumbs":6,"title":2},"21":{"body":169,"breadcrumbs":6,"title":2},"22":{"body":61,"breadcrumbs":6,"title":2},"23":{"body":76,"breadcrumbs":6,"title":2},"24":{"body":14,"breadcrumbs":2,"title":1},"25":{"body":320,"breadcrumbs":3,"title":1},"26":{"body":32,"breadcrumbs":3,"title":1},"27":{"body":43,"breadcrumbs":5,"title":2},"28":{"body":303,"breadcrumbs":6,"title":3},"29":{"body":73,"breadcrumbs":5,"title":2},"3":{"body":25,"breadcrumbs":2,"title":1},"30":{"body":40,"breadcrumbs":6,"title":3},"31":{"body":16,"breadcrumbs":7,"title":4},"32":{"body":51,"breadcrumbs":5,"title":2},"33":{"body":51,"breadcrumbs":6,"title":3},"34":{"body":50,"breadcrumbs":5,"title":2},"35":{"body":153,"breadcrumbs":5,"title":2},"36":{"body":1117,"breadcrumbs":6,"title":3},"37":{"body":50,"breadcrumbs":5,"title":2},"38":{"body":125,"breadcrumbs":6,"title":2},"39":{"body":211,"breadcrumbs":3,"title":1},"4":{"body":29,"breadcrumbs":4,"title":3},"40":{"body":25,"breadcrumbs":4,"title":1},"41":{"body":120,"breadcrumbs":4,"title":1},"42":{"body":212,"breadcrumbs":5,"title":2},"43":{"body":21,"breadcrumbs":6,"title":2},"44":{"body":53,"breadcrumbs":6,"title":2},"45":{"body":45,"breadcrumbs":6,"title":2},"46":{"body":32,"breadcrumbs":7,"title":3},"47":{"body":56,"breadcrumbs":4,"title":1},"48":{"body":30,"breadcrumbs":5,"title":2},"49":{"body":111,"breadcrumbs":5,"title":2},"5":{"body":108,"breadcrumbs":5,"title":4},"50":{"body":0,"breadcrumbs":7,"title":3},"51":{"body":118,"breadcrumbs":7,"title":3},"52":{"body":65,"breadcrumbs":6,"title":2},"53":{"body":97,"breadcrumbs":8,"title":4},"54":{"body":35,"breadcrumbs":6,"title":2},"55":{"body":143,"breadcrumbs":7,"title":3},"56":{"body":134,"breadcrumbs":11,"title":7},"57":{"body":80,"breadcrumbs":8,"title":4},"58":{"body":15,"breadcrumbs":7,"title":3},"59":{"body":27,"breadcrumbs":8,"title":4},"6":{"body":11,"breadcrumbs":3,"title":2},"60":{"body":45,"breadcrumbs":7,"title":3},"61":{"body":34,"breadcrumbs":3,"title":1},"62":{"body":16,"breadcrumbs":4,"title":2},"63":{"body":21,"breadcrumbs":3,"title":1},"64":{"body":22,"breadcrumbs":3,"title":1},"65":{"body":111,"breadcrumbs":3,"title":1},"66":{"body":43,"breadcrumbs":3,"title":1},"67":{"body":404,"breadcrumbs":3,"title":1},"68":{"body":27,"breadcrumbs":6,"title":4},"69":{"body":214,"breadcrumbs":4,"title":2},"7":{"body":38,"breadcrumbs":4,"title":2},"70":{"body":63,"breadcrumbs":4,"title":2},"71":{"body":162,"breadcrumbs":3,"title":1},"72":{"body":51,"breadcrumbs":2,"title":1},"73":{"body":34,"breadcrumbs":3,"title":2},"74":{"body":55,"breadcrumbs":4,"title":3},"75":{"body":38,"breadcrumbs":3,"title":1},"76":{"body":403,"breadcrumbs":4,"title":2},"77":{"body":229,"breadcrumbs":5,"title":3},"78":{"body":79,"breadcrumbs":6,"title":4},"79":{"body":44,"breadcrumbs":5,"title":2},"8":{"body":56,"breadcrumbs":3,"title":1},"80":{"body":115,"breadcrumbs":5,"title":2},"81":{"body":50,"breadcrumbs":5,"title":2},"82":{"body":209,"breadcrumbs":5,"title":2},"83":{"body":122,"breadcrumbs":4,"title":1},"84":{"body":270,"breadcrumbs":6,"title":3},"85":{"body":45,"breadcrumbs":5,"title":2},"86":{"body":60,"breadcrumbs":2,"title":1},"9":{"body":60,"breadcrumbs":5,"title":3}},"docs":{"0":{"body":"Version: 0.5.2 mdBook is a command line tool to create books with Markdown.\\nIt is ideal for creating product or API documentation, tutorials, course materials or anything that requires a clean,\\neasily navigable and customizable presentation. Lightweight Markdown syntax helps you focus more on your content Integrated search support Color syntax highlighting for code blocks for many different languages Theme files allow customizing the formatting of the output Preprocessors can provide extensions for custom syntax and modifying content Backends can render the output to multiple formats Written in Rust for speed, safety, and simplicity Automated testing of Rust code samples This guide is an example of what mdBook produces.\\nmdBook is used by the Rust programming language project, and The Rust Programming Language book is another fine example of mdBook in action.","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"mdBook is free and open source. You can find the source code on GitHub and issues and feature requests can be posted on\\nthe GitHub issue tracker. mdBook relies on the community to fix bugs and\\nadd features: if you’d like to contribute, please read\\nthe CONTRIBUTING guide and consider opening\\na pull request.","breadcrumbs":"Introduction » Contributing","id":"1","title":"Contributing"},"10":{"body":"Each book has a built-in search system.\\nPressing the search icon in the menu bar, or pressing the / or S key on the keyboard will open an input box for entering search terms.\\nTyping some terms will show matching chapters and sections in real time. Clicking any of the results will jump to that section.\\nThe up and down arrow keys can be used to navigate the results, and enter will open the highlighted section. After loading a search result, the matching search terms will be highlighted in the text.\\nClicking a highlighted word or pressing the Escape key will remove the highlighting.","breadcrumbs":"Reading books » Search","id":"10","title":"Search"},"11":{"body":"mdBook books are often used for programming projects, and thus support highlighting code blocks and samples.\\nCode blocks may contain several different icons for interacting with them: Icon Description Copies the code block into your local clipboard, to allow pasting into another application. For Rust code examples, this will execute the sample code and display the compiler output just below the example (see playground). For Rust code examples, this will toggle visibility of “hidden” lines. Sometimes, larger examples will hide lines which are not particularly relevant to what is being illustrated (see hiding code lines). For editable code examples, this will undo any changes you have made. Here’s an example: #![allow(unused)] fn main() {\\nprintln!(\\"Hello, World!\\"); }","breadcrumbs":"Reading books » Code blocks","id":"11","title":"Code blocks"},"12":{"body":"Once you have the mdbook CLI tool installed, you can use it to create and render a book.","breadcrumbs":"Creating a book » Creating a book","id":"12","title":"Creating a book"},"13":{"body":"The mdbook init command will create a new directory containing an empty book for you to get started.\\nGive it the name of the directory that you want to create: mdbook init my-first-book It will ask a few questions before generating the book.\\nAfter answering the questions, you can change the current directory into the new book: cd my-first-book There are several ways to render a book, but one of the easiest methods is to use the serve command, which will build your book and start a local webserver: mdbook serve --open The --open option will open your default web browser to view your new book.\\nYou can leave the server running even while you edit the content of the book, and mdbook will automatically rebuild the output and automatically refresh your web browser. Check out the CLI Guide for more information about other mdbook commands and CLI options.","breadcrumbs":"Creating a book » Initializing a book","id":"13","title":"Initializing a book"},"14":{"body":"A book is built from several files which define the settings and layout of the book. book.toml In the root of your book, there is a book.toml file which contains settings for describing how to build your book.\\nThis is written in the TOML markup language.\\nThe default settings are usually good enough to get you started.\\nWhen you are interested in exploring more features and options that mdBook provides, check out the Configuration chapter for more details. A very basic book.toml can be as simple as this: [book]\\ntitle = \\"My First Book\\" SUMMARY.md The next major part of a book is the summary file located at src/SUMMARY.md.\\nThis file contains a list of all the chapters in the book.\\nBefore a chapter can be viewed, it must be added to this list. Here’s a basic summary file with a few chapters: # Summary [Introduction](README.md) - [My First Chapter](my-first-chapter.md)\\n- [Nested example](nested/README.md) - [Sub-chapter](nested/sub-chapter.md) Try opening up src/SUMMARY.md in your editor and adding a few chapters.\\nIf any of the chapter files do not exist, mdbook will automatically create them for you. For more details on other formatting options for the summary file, check out the Summary chapter. Source files The content of your book is all contained in the src directory.\\nEach chapter is a separate Markdown file.\\nTypically, each chapter starts with a level 1 heading with the title of the chapter. # My First Chapter Fill out your content here. The precise layout of the files is up to you.\\nThe organization of the files will correspond to the HTML files generated, so keep in mind that the file layout is part of the URL of each chapter. While the mdbook serve command is running, you can open any of the chapter files and start editing them.\\nEach time you save the file, mdbook will rebuild the book and refresh your web browser. Check out the Markdown chapter for more information on formatting the content of your chapters. All other files in the src directory will be included in the output.\\nSo if you have images or other static files, just include them somewhere in the src directory.","breadcrumbs":"Creating a book » Anatomy of a book","id":"14","title":"Anatomy of a book"},"15":{"body":"Once you’ve written your book, you may want to host it somewhere for others to view.\\nThe first step is to build the output of the book.\\nThis can be done with the mdbook build command in the same directory where the book.toml file is located: mdbook build This will generate a directory named book which contains the HTML content of your book.\\nYou can then place this directory on any web server to host it. For more information about publishing and deploying, check out the Continuous Integration chapter for more.","breadcrumbs":"Creating a book » Publishing a book","id":"15","title":"Publishing a book"},"16":{"body":"The mdbook command-line tool is used to create and build books.\\nAfter you have installed mdbook, you can run the mdbook help command in your terminal to view the available commands. This following sections provide in-depth information on the different commands available. mdbook init <directory> — Creates a new book with minimal boilerplate to start with. mdbook build — Renders the book. mdbook watch — Rebuilds the book any time a source file changes. mdbook serve — Runs a web server to view the book, and rebuilds on changes. mdbook test — Tests Rust code samples. mdbook clean — Deletes the rendered output. mdbook completions — Support for shell auto-completion.","breadcrumbs":"Command-line tool » Command-line tool","id":"16","title":"Command-line tool"},"17":{"body":"There is some minimal boilerplate that is the same for every new book. It’s for\\nthis purpose that mdBook includes an init command. The init command is used like this: mdbook init When using the init command for the first time, a couple of files will be set\\nup for you: book-test/\\n├── book\\n└── src ├── chapter_1.md └── SUMMARY.md The src directory is where you write your book in markdown. It contains all\\nthe source files, configuration files, etc. The book directory is where your book is rendered. All the output is ready\\nto be uploaded to a server to be seen by your audience. The SUMMARY.md is the skeleton of your\\nbook, and is discussed in more detail in another\\nchapter. Tip: Generate chapters from SUMMARY.md When a SUMMARY.md file already exists, the init command will first parse it\\nand generate the missing files according to the paths used in the SUMMARY.md.\\nThis allows you to think and create the whole structure of your book and then\\nlet mdBook generate it for you. Specify a directory The init command can take a directory as an argument to use as the book’s root\\ninstead of the current working directory. mdbook init path/to/book --theme When you use the --theme flag, the default theme will be copied into a\\ndirectory called theme in your source directory so that you can modify it. The theme is selectively overwritten, this means that if you don’t want to\\noverwrite a specific file, just delete it and the default file will be used. --title Specify a title for the book. If not supplied, an interactive prompt will ask for\\na title. mdbook init --title=\\"my amazing book\\" --ignore Create a .gitignore file configured to ignore the book directory created when building a book.\\nIf not supplied, an interactive prompt will ask whether it should be created. mdbook init --ignore=none mdbook init --ignore=git --force Skip the prompts to create a .gitignore and for the title for the book.","breadcrumbs":"Command-line tool » init » The init command","id":"17","title":"The init command"},"18":{"body":"The build command is used to render your book: mdbook build It will try to parse your SUMMARY.md file to understand the structure of your\\nbook and fetch the corresponding files. Note that this will also create files\\nmentioned in SUMMARY.md which are not yet present. The rendered output will maintain the same directory structure as the source for\\nconvenience. Large books will therefore remain structured when rendered. Specify a directory The build command can take a directory as an argument to use as the book’s\\nroot instead of the current working directory. mdbook build path/to/book --open When you use the --open ( -o) flag, mdbook will open the rendered book in\\nyour default web browser after building it. --dest-dir The --dest-dir ( -d) option allows you to change the output directory for the\\nbook. Relative paths are interpreted relative to the current directory. If\\nnot specified it will default to the value of the build.build-dir key in book.toml, or to ./book. Note: The build command copies all files (excluding files with .md extension) from the source directory\\ninto the build directory.","breadcrumbs":"Command-line tool » build » The build command","id":"18","title":"The build command"},"19":{"body":"The watch command is useful when you want your book to be rendered on every\\nfile change. You could repeatedly issue mdbook build every time a file is\\nchanged. But using mdbook watch once will watch your files and will trigger a\\nbuild automatically whenever you modify a file; this includes re-creating\\ndeleted files still mentioned in SUMMARY.md! Specify a directory The watch command can take a directory as an argument to use as the book’s\\nroot instead of the current working directory. mdbook watch path/to/book --open When you use the --open ( -o) option, mdbook will open the rendered book in\\nyour default web browser. --dest-dir The --dest-dir ( -d) option allows you to change the output directory for the\\nbook. Relative paths are interpreted relative to the current directory. If\\nnot specified it will default to the value of the build.build-dir key in book.toml, or to ./book. --watcher There are different backends used to determine when a file has changed. poll (default) — Checks for file modifications by scanning the filesystem every second. native — Uses the native operating system facilities to receive notifications when files change.\\nThis can have less constant overhead, but may not be as reliable as the poll based watcher. See these issues for more information: #383 #1441 #1707 #2035 #2102 Specify exclude patterns The watch command will not automatically trigger a build for files listed in\\nthe .gitignore file in the book root directory. The .gitignore file may\\ncontain file patterns described in the gitignore\\ndocumentation. This can be useful for\\nignoring temporary files created by some editors. Note: Only .gitignore from book root directory is used. Global $HOME/.gitignore or .gitignore files in parent directories are not used.","breadcrumbs":"Command-line tool » watch » The watch command","id":"19","title":"The watch command"},"2":{"body":"The mdBook source and documentation are released under\\nthe Mozilla Public License v2.0.","breadcrumbs":"Introduction » License","id":"2","title":"License"},"20":{"body":"The serve command is used to preview a book by serving it via HTTP at localhost:3000 by default: mdbook serve The serve command watches the book’s src directory for\\nchanges, rebuilding the book and refreshing clients for each change; this includes\\nre-creating deleted files still mentioned in SUMMARY.md! A websocket\\nconnection is used to trigger the client-side refresh. Note: The serve command is for testing a book’s HTML output, and is not\\nintended to be a complete HTTP server for a website. Specify a directory The serve command can take a directory as an argument to use as the book’s\\nroot instead of the current working directory. mdbook serve path/to/book Server options The serve hostname defaults to localhost, and the port defaults to 3000. Either option can be specified on the command line: mdbook serve path/to/book -p 8000 -n 127.0.0.1 --open When you use the --open ( -o) flag, mdbook will open the book in your\\ndefault web browser after starting the server. --dest-dir The --dest-dir ( -d) option allows you to change the output directory for the\\nbook. Relative paths are interpreted relative to the current directory. If\\nnot specified it will default to the value of the build.build-dir key in book.toml, or to ./book. --watcher There are different backends used to determine when a file has changed. poll (default) — Checks for file modifications by scanning the filesystem every second. native — Uses the native operating system facilities to receive notifications when files change.\\nThis can have less constant overhead, but may not be as reliable as the poll based watcher. See these issues for more information: #383 #1441 #1707 #2035 #2102 Specify exclude patterns The serve command will not automatically trigger a build for files listed in\\nthe .gitignore file in the book root directory. The .gitignore file may\\ncontain file patterns described in the gitignore\\ndocumentation. This can be useful for\\nignoring temporary files created by some editors. Note: Only the .gitignore from the book root directory is used. Global $HOME/.gitignore or .gitignore files in parent directories are not used.","breadcrumbs":"Command-line tool » serve » The serve command","id":"20","title":"The serve command"},"21":{"body":"When writing a book, you sometimes need to automate some tests. For example, The Rust Programming Book uses a lot\\nof code examples that could get outdated. Therefore it is very important for\\nthem to be able to automatically test these code examples. mdBook supports a test command that will run all available tests in a book. At\\nthe moment, only Rust tests are supported. Disable tests on a code block rustdoc doesn’t test code blocks which contain the ignore attribute: ```rust,ignore\\nfn main() {}\\n``` rustdoc also doesn’t test code blocks which specify a language other than Rust: ```markdown\\n**Foo**: _bar_\\n``` rustdoc does test code blocks which have no language specified: ```\\nThis is going to cause an error!\\n``` Specify a directory The test command can take a directory as an argument to use as the book’s root\\ninstead of the current working directory. mdbook test path/to/book --library-path The --library-path ( -L) option allows you to add directories to the library\\nsearch path used by rustdoc when it builds and tests the examples. Multiple\\ndirectories can be specified with multiple options ( -L foo -L bar) or with a\\ncomma-delimited list ( -L foo,bar). The path should point to the Cargo build cache deps directory that\\ncontains the build output of your project. For example, if your Rust project’s book is in a directory\\nnamed my-book, the following command would include the crate’s dependencies when running test: mdbook test my-book -L target/debug/deps/ See the rustdoc command-line documentation\\nfor more information. --chapter The --chapter ( -c) option allows you to test a specific chapter of the\\nbook using the chapter name or the relative path to the chapter.","breadcrumbs":"Command-line tool » test » The test command","id":"21","title":"The test command"},"22":{"body":"The clean command is used to delete the generated book and any other build\\nartifacts. mdbook clean Specify a directory The clean command can take a directory as an argument to use as the book’s\\nroot instead of the current working directory. mdbook clean path/to/book --dest-dir The --dest-dir ( -d) option allows you to override the book’s output\\ndirectory, which will be deleted by this command. Relative paths are interpreted\\nrelative to the current directory. If not specified it will default to the\\nvalue of the build.build-dir key in book.toml, or to ./book. mdbook clean --dest-dir=path/to/book path/to/book could be absolute or relative.","breadcrumbs":"Command-line tool » clean » The clean command","id":"22","title":"The clean command"},"23":{"body":"The completions command is used to generate auto-completions for some common shells.\\nThis means when you type mdbook in your shell, you can then press your shell’s auto-complete key (usually the Tab key) and it may display what the valid options are, or finish partial input. The completions first need to be installed for your shell: # bash\\nmdbook completions bash > ~/.local/share/bash-completion/completions/mdbook\\n# oh-my-zsh\\nmdbook completions zsh > ~/.oh-my-zsh/completions/_mdbook\\nautoload -U compinit && compinit The command prints a completion script for the given shell.\\nRun mdbook completions --help for a list of supported shells. Where to place the completions depend on which shell you are using and your operating system.\\nConsult your shell’s documentation for more information one where to place the script.","breadcrumbs":"Command-line tool » completions » The completions command","id":"23","title":"The completions command"},"24":{"body":"In this section you will learn how to: Structure your book correctly Format your SUMMARY.md file Configure your book using book.toml Customize your theme","breadcrumbs":"Format » Format","id":"24","title":"Format"},"25":{"body":"The summary file is used by mdBook to know what chapters to include, in what\\norder they should appear, what their hierarchy is and where the source files\\nare. Without this file, there is no book. This markdown file must be named SUMMARY.md. Its formatting\\nis very strict and must follow the structure outlined below to allow for easy\\nparsing. Any element not specified below, be it formatting or textual, is likely\\nto be ignored at best, or may cause an error when attempting to build the book. Structure Title - While optional, it’s common practice to begin with a title, generally # Summary. This is ignored by the parser however, and\\ncan be omitted. # Summary Prefix Chapter - Before the main numbered chapters, prefix chapters can be added\\nthat will not be numbered. This is useful for forewords,\\nintroductions, etc. There are, however, some constraints. Prefix chapters cannot be\\nnested; they should all be on the root level. And you cannot add\\nprefix chapters once you have added numbered chapters. [A Prefix Chapter](relative/path/to/markdown.md) - [First Chapter](relative/path/to/markdown2.md) Part Title -\\nLevel 1 headers can be used as a title for the following numbered chapters.\\nThis can be used to logically separate different sections of the book.\\nThe title is rendered as unclickable text.\\nTitles are optional, and the numbered chapters can be broken into as many parts as desired.\\nPart titles must be h1 headers (one #), other heading levels are ignored. # My Part Title - [First Chapter](relative/path/to/markdown.md) Numbered Chapter - Numbered chapters outline the main content of the book\\nand can be nested, resulting in a nice hierarchy\\n(chapters, sub-chapters, etc.). # Title of Part - [First Chapter](relative/path/to/markdown.md)\\n- [Second Chapter](relative/path/to/markdown2.md) - [Sub Chapter](relative/path/to/markdown3.md) # Title of Another Part - [Another Chapter](relative/path/to/markdown4.md) Numbered chapters can be denoted with either - or * (do not mix delimiters). Suffix Chapter - Like prefix chapters, suffix chapters are unnumbered, but they come after\\nnumbered chapters. - [Last Chapter](relative/path/to/markdown.md) [Title of Suffix Chapter](relative/path/to/markdown2.md) Draft chapters - Draft chapters are chapters without a file and thus content.\\nThe purpose of a draft chapter is to signal future chapters still to be written.\\nOr when still laying out the structure of the book to avoid creating the files\\nwhile you are still changing the structure of the book a lot.\\nDraft chapters will be rendered in the HTML renderer as disabled links in the table\\nof contents, as you can see for the next chapter in the table of contents on the left.\\nDraft chapters are written like normal chapters but without writing the path to the file. - [Draft Chapter]() Separators - Separators can be added before, in between, and after any other element. They result\\nin an HTML rendered line in the built table of contents. A separator is\\na line containing exclusively dashes and at least three of them: ---. # My Part Title [A Prefix Chapter](relative/path/to/markdown.md) --- - [First Chapter](relative/path/to/markdown2.md) Example Below is the markdown source for the SUMMARY.md for this guide, with the resulting table\\nof contents as rendered to the left. # Summary [Introduction](README.md) # User guide - [Installation](guide/installation.md)\\n- [Reading books](guide/reading.md)\\n- [Creating a book](guide/creating.md) # Reference guide - [Command-line tool](cli/README.md) - [init](cli/init.md) - [build](cli/build.md) - [watch](cli/watch.md) - [serve](cli/serve.md) - [test](cli/test.md) - [clean](cli/clean.md) - [completions](cli/completions.md)\\n- [Format](format/README.md) - [SUMMARY.md](format/summary.md) - [Draft chapter]() - [Configuration](format/configuration/README.md) - [General](format/configuration/general.md) - [Preprocessors](format/configuration/preprocessors.md) - [Renderers](format/configuration/renderers.md) - [Environment variables](format/configuration/environment-variables.md) - [Theme](format/theme/README.md) - [index.hbs](format/theme/index-hbs.md) - [Syntax highlighting](format/theme/syntax-highlighting.md) - [Editor](format/theme/editor.md) - [MathJax support](format/mathjax.md) - [mdBook-specific features](format/mdbook.md) - [Markdown](format/markdown.md)\\n- [Continuous integration](continuous-integration.md)\\n- [For developers](for_developers/README.md) - [Preprocessors](for_developers/preprocessors.md) - [Alternative backends](for_developers/backends.md) ----------- [Contributors](misc/contributors.md)","breadcrumbs":"Format » SUMMARY.md » SUMMARY.md","id":"25","title":"SUMMARY.md"},"26":{"body":"This section details the configuration options available in the book.toml: General configuration including the book, rust, build sections Preprocessor configuration for default and custom book preprocessors Renderer configuration for the HTML, Markdown and custom renderers Environment Variable configuration for overriding configuration options in your environment","breadcrumbs":"Format » Configuration » Configuration","id":"26","title":"Configuration"},"27":{"body":"You can configure the parameters for your book in the book.toml file. Here is an example of what a book.toml file might look like: [book]\\ntitle = \\"Example book\\"\\nauthors = [\\"John Doe\\"]\\ndescription = \\"The example book covers examples.\\" [rust]\\nedition = \\"2018\\" [build]\\nbuild-dir = \\"my-example-book\\"\\ncreate-missing = false [preprocessor.index] [preprocessor.links] [output.html]\\nadditional-css = [\\"custom.css\\"] [output.html.search]\\nlimit-results = 15","breadcrumbs":"Format » Configuration » General » General configuration","id":"27","title":"General configuration"},"28":{"body":"It is important to note that any relative path specified in the\\nconfiguration will always be taken relative from the root of the book where the\\nconfiguration file is located. General metadata This is general information about your book. title: The title of the book authors: The author(s) of the book description: A description for the book, which is added as meta\\ninformation in the html <head> of each page src: By default, the source directory is found in the directory named src directly under the root folder. But this is configurable with the src\\nkey in the configuration file. language: The main language of the book, which is used as a language attribute <html lang=\\"en\\"> for example.\\nThis is also used to derive the direction of text (RTL, LTR) within the book. text-direction: The direction of text in the book: Left-to-right (LTR) or Right-to-left (RTL). Possible values: ltr, rtl.\\nWhen not specified, the text direction is derived from the book’s language attribute. book.toml [book]\\ntitle = \\"Example book\\"\\nauthors = [\\"John Doe\\", \\"Jane Doe\\"]\\ndescription = \\"The example book covers examples.\\"\\nsrc = \\"my-src\\" # the source files will be found in `root/my-src` instead of `root/src`\\nlanguage = \\"en\\"\\ntext-direction = \\"ltr\\" Rust options Options for the Rust language, relevant to running tests and playground\\nintegration. [rust]\\nedition = \\"2015\\" # the default edition for code blocks edition: Rust edition to use by default for the code snippets. Default\\nis \\"2015\\". Individual code blocks can be controlled with the edition2015, edition2018, edition2021 or edition2024 annotations, such as: ```rust,edition2015\\n// This only works in 2015.\\nlet try = true;\\n``` Build options This controls the build process of your book. [build]\\nbuild-dir = \\"book\\" # the directory where the output is placed\\ncreate-missing = true # whether or not to create missing pages\\nuse-default-preprocessors = true # use the default preprocessors\\nextra-watch-dirs = [] # directories to watch for triggering builds build-dir: The directory to put the rendered book in. By default this is book/ in the book’s root directory.\\nThis can overridden with the --dest-dir CLI option. create-missing: By default, any missing files specified in SUMMARY.md\\nwill be created when the book is built (i.e. create-missing = true). If this\\nis false then the build process will instead exit with an error if any files\\ndo not exist. use-default-preprocessors: Disable the default preprocessors (of links & index) by setting this option to false. If you have the same, and/or other preprocessors declared via their table\\nof configuration, they will run instead. For clarity, with no preprocessor configuration, the default links and index will run. Setting use-default-preprocessors = false will disable these\\ndefault preprocessors from running. Adding [preprocessor.links], for example, will ensure, regardless of use-default-preprocessors that links it will run. extra-watch-dirs: A list of paths to directories that will be watched in\\nthe watch and serve commands. Changes to files under these directories will\\ntrigger rebuilds. Useful if your book depends on files outside its src directory.","breadcrumbs":"Format » Configuration » General » Supported configuration options","id":"28","title":"Supported configuration options"},"29":{"body":"Preprocessors are extensions that can modify the raw Markdown source before it gets sent to the renderer. The following preprocessors are built-in and included by default: links: Expands the {{ #playground }}, {{ #include }}, and {{ #rustdoc_include }} handlebars\\nhelpers in a chapter to include the contents of a file.\\nSee Including files for more. index: Convert all chapter files named README.md into index.md. That is\\nto say, all README.md would be rendered to an index file index.html in the\\nrendered book. The built-in preprocessors can be disabled with the build.use-default-preprocessors config option. The community has developed several preprocessors.\\nSee the Third Party Plugins wiki page for a list of available preprocessors. For information on how to create a new preprocessor, see the Preprocessors for Developers chapter.","breadcrumbs":"Format » Configuration » Preprocessors » Configuring Preprocessors","id":"29","title":"Configuring Preprocessors"},"3":{"body":"There are multiple ways to install the mdBook CLI tool.\\nChoose any one of the methods below that best suit your needs.\\nIf you are installing mdBook for automatic deployment, check out the continuous integration chapter for more examples on how to install.","breadcrumbs":"Installation » Installation","id":"3","title":"Installation"},"30":{"body":"Preprocessors can be added by including a preprocessor table in book.toml with the name of the preprocessor.\\nFor example, if you have a preprocessor called mdbook-example, then you can include it with: [preprocessor.example] With this table, mdBook will execute the mdbook-example preprocessor. This table can include additional key-value pairs that are specific to the preprocessor.\\nFor example, if our example preprocessor needed some extra configuration options: [preprocessor.example]\\nsome-extra-feature = true","breadcrumbs":"Format » Configuration » Preprocessors » Custom preprocessor configuration","id":"30","title":"Custom preprocessor configuration"},"31":{"body":"You can explicitly specify that a preprocessor should run for a renderer by\\nbinding the two together. [preprocessor.example]\\nrenderers = [\\"html\\"] # example preprocessor only runs with the HTML renderer","breadcrumbs":"Format » Configuration » Preprocessors » Locking a preprocessor dependency to a renderer","id":"31","title":"Locking a preprocessor dependency to a renderer"},"32":{"body":"By default when you add a [preprocessor.foo] table to your book.toml file, mdbook will try to invoke the mdbook-foo executable. If you want to use a\\ndifferent program name or pass in command-line arguments, this behaviour can\\nbe overridden by adding a command field. [preprocessor.random]\\ncommand = \\"python random.py\\" Optional preprocessors If you enable a preprocessor that isn’t installed, the default behavior is to throw an error.\\nThis behavior can be changed by marking the preprocessor as optional: [preprocessor.example]\\noptional = true This demotes the error to a warning.","breadcrumbs":"Format » Configuration » Preprocessors » Provide your own command","id":"32","title":"Provide your own command"},"33":{"body":"The order in which preprocessors are run can be controlled with the before and after fields.\\nFor example, suppose you want your linenos preprocessor to process lines that may have been {{#include}}d; then you want it to run after the built-in links preprocessor, which you can require using either the before or after field: [preprocessor.linenos]\\nafter = [ \\"links\\" ] or [preprocessor.links]\\nbefore = [ \\"linenos\\" ] It would also be possible, though redundant, to specify both of the above in the same config file. Preprocessors having the same priority specified through before and after are sorted by name.\\nAny infinite loops will be detected and produce an error.","breadcrumbs":"Format » Configuration » Preprocessors » Require a certain order","id":"33","title":"Require a certain order"},"34":{"body":"Renderers (also called “backends”) are responsible for creating the output of the book. The following backends are built-in: html — This renders the book to HTML.\\nThis is enabled by default if no other [output] tables are defined in book.toml. markdown — This outputs the book as markdown after running the preprocessors.\\nThis is useful for debugging preprocessors. The community has developed several backends.\\nSee the Third Party Plugins wiki page for a list of available backends. For information on how to create a new backend, see the Backends for Developers chapter.","breadcrumbs":"Format » Configuration » Renderers » Configuring Renderers","id":"34","title":"Configuring Renderers"},"35":{"body":"Backends can be added by including a output table in book.toml with the name of the backend.\\nFor example, if you have a backend called mdbook-wordcount, then you can include it with: [output.wordcount] With this table, mdBook will execute the mdbook-wordcount backend. This table can include additional key-value pairs that are specific to the backend.\\nFor example, if our example backend needed some extra configuration options: [output.wordcount]\\nignores = [\\"Example Chapter\\"] If you define any [output] tables, then the html backend is not enabled by default.\\nIf you want to keep the html backend running, then just include it in the book.toml file.\\nFor example: [book]\\ntitle = \\"My Awesome Book\\" [output.wordcount] [output.html] If more than one output table is included, this changes the behavior for the layout of the output directory.\\nIf there is only one backend, then it places its output directly in the book directory (see build.build-dir to override this location).\\nIf there is more than one backend, then each backend is placed in a separate directory underneath book.\\nFor example, the above would have directories book/html and book/wordcount. Custom backend commands By default when you add an [output.foo] table to your book.toml file, mdbook will try to invoke the mdbook-foo executable.\\nIf you want to use a different program name or pass in command-line arguments,\\nthis behaviour can be overridden by adding a command field. [output.random]\\ncommand = \\"python random.py\\" Optional backends If you enable a backend that isn’t installed, the default behavior is to throw an error.\\nThis behavior can be changed by marking the backend as optional: [output.wordcount]\\noptional = true This demotes the error to a warning.","breadcrumbs":"Format » Configuration » Renderers » Output tables","id":"35","title":"Output tables"},"36":{"body":"The HTML renderer has a variety of options detailed below.\\nThey should be specified in the [output.html] table of the book.toml file. # Example book.toml file with all output options.\\n[book]\\ntitle = \\"Example book\\"\\nauthors = [\\"John Doe\\", \\"Jane Doe\\"]\\ndescription = \\"The example book covers examples.\\" [output.html]\\ntheme = \\"my-theme\\"\\ndefault-theme = \\"light\\"\\npreferred-dark-theme = \\"navy\\"\\nsmart-punctuation = true\\ndefinition-lists = true\\nadmonitions = true\\nmathjax-support = false\\nadditional-css = [\\"custom.css\\", \\"custom2.css\\"]\\nadditional-js = [\\"custom.js\\"]\\nno-section-label = false\\ngit-repository-url = \\"https://github.com/rust-lang/mdBook\\"\\ngit-repository-icon = \\"fab-github\\"\\nedit-url-template = \\"https://github.com/rust-lang/mdBook/edit/master/guide/{path}\\"\\nsite-url = \\"/example-book/\\"\\ncname = \\"myproject.rs\\"\\ninput-404 = \\"not-found.md\\"\\nsidebar-header-nav = true The following configuration options are available: theme: mdBook comes with a default theme and all the resource files needed\\nfor it. But if this option is set, mdBook will selectively overwrite the theme\\nfiles with the ones found in the specified folder. default-theme: The theme color scheme to select by default in the\\n‘Change Theme’ dropdown. Defaults to light. preferred-dark-theme: The default dark theme. This theme will be used if\\nthe browser requests the dark version of the site via the prefers-color-scheme\\nCSS media query. Defaults to navy. smart-punctuation: Converts quotes to curly quotes, ... to …, -- to en-dash, and --- to em-dash.\\nSee Smart Punctuation.\\nDefaults to true. definition-lists: Enables definition lists. Defaults to true. admonitions: Enables admonitions. Defaults to true. mathjax-support: Adds support for MathJax. Defaults to false. additional-css: If you need to slightly change the appearance of your book\\nwithout overwriting the whole style, you can specify a set of stylesheets that\\nwill be loaded after the default ones where you can surgically change the\\nstyle. additional-js: If you need to add some behaviour to your book without\\nremoving the current behaviour, you can specify a set of JavaScript files that\\nwill be loaded alongside the default one. no-section-label: mdBook by defaults adds numeric section labels in the table of\\ncontents column. For example, “1.”, “2.1”. Set this option to true to disable\\nthose labels. Defaults to false. git-repository-url: A url to the git repository for the book. If provided\\nan icon link will be output in the menu bar of the book. git-repository-icon: The Font Awesome icon class to use for the git repository link. Defaults to fab-github which looks like . If you are not using GitHub, another option to consider is fas-code-fork which looks like . The start of the string should be fa- for regular icons, fas- for solid icons, or fab- for brand icons. See the free icon set for the available icons. edit-url-template: Edit url template, when provided shows a\\n“Suggest an edit” button (which looks like ) for directly jumping to editing the currently\\nviewed page. For e.g. GitHub projects set this to https://github.com/<owner>/<repo>/edit/<branch>/{path} or for\\nBitbucket projects set it to https://bitbucket.org/<owner>/<repo>/src/<branch>/{path}?mode=edit\\nwhere {path} will be replaced with the full path of the file in the\\nrepository. input-404: The name of the markdown file used for missing files.\\nThe corresponding output file will be the same, with the extension replaced with html.\\nDefaults to 404.md. site-url: The url where the book will be hosted. This is required to ensure\\nnavigation links and script/css imports in the 404 file work correctly, even when accessing\\nurls in subdirectories. Defaults to /. If site-url is set,\\nmake sure to use document relative links for your assets, meaning they should not start with /. cname: The DNS subdomain or apex domain at which your book will be hosted.\\nThis string will be written to a file named CNAME in the root of your site, as\\nrequired by GitHub Pages (see Managing a custom domain for your GitHub Pages\\nsite). hash-files: Include a cryptographic “fingerprint” of the files’ contents in static asset filenames,\\nso that if the contents of the file are changed, the name of the file will also change.\\nFor example, css/chrome.css may become css/chrome-9b8f428e.css.\\nChapter HTML files are not renamed.\\nStatic CSS and JS files can reference each other using {{ resource \\"filename\\" }} directives.\\nDefaults to true. sidebar-header-nav: If true, the sidebar will contain navigation for headers on the current page. Default is true. [output.html.print] The [output.html.print] table provides options for controlling the printable output.\\nBy default, mdBook will include an icon on the top right of the book (which looks like ) that will print the book as a single page. [output.html.print]\\nenable = true # include support for printable output\\npage-break = true # insert page-break after each chapter enable: Enable print support. When false, all print support will not be\\nrendered. Defaults to true. page-break: Insert page breaks between chapters. Defaults to true. [output.html.fold] The [output.html.fold] table provides options for controlling folding of the chapter listing in the navigation sidebar. [output.html.fold]\\nenable = false # whether or not to enable section folding\\nlevel = 0 # the depth to start folding enable: Enable section-folding. When off, all folds are open.\\nDefaults to false. level: The higher the more folded regions are open. When level is 0, all\\nfolds are closed. Defaults to 0. [output.html.playground] The [output.html.playground] table provides options for controlling Rust sample code blocks, and their integration with the Rust Playground. [output.html.playground]\\neditable = false # allows editing the source code\\ncopyable = true # include the copy button for copying code snippets\\ncopy-js = true # includes the JavaScript for the code editor\\nline-numbers = false # displays line numbers for editable code\\nrunnable = true # displays a run button for rust code editable: Allow editing the source code. Defaults to false. copyable: Display the copy button on code snippets. Defaults to true. copy-js: Copy JavaScript files for the editor to the output directory.\\nDefaults to true. line-numbers: Display line numbers on editable sections of code. Requires both editable and copy-js to be true. Defaults to false. runnable: Displays a run button for rust code snippets. Changing this to false will disable the run in playground feature globally. Defaults to true. [output.html.code] The [output.html.code] table provides options for controlling code blocks. [output.html.code]\\n# A prefix string per language (one or more chars).\\n# Any line starting with whitespace+prefix is hidden.\\nhidelines = { python = \\"~\\" } hidelines: A table that defines how hidden code lines work for each language.\\nThe key is the language and the value is a string that will cause code lines starting with that prefix to be hidden. [output.html.search] The [output.html.search] table provides options for controlling the built-in text search.\\nmdBook must be compiled with the search feature enabled (on by default). [output.html.search]\\nenable = true # enables the search feature\\nlimit-results = 30 # maximum number of search results\\nteaser-word-count = 30 # number of words used for a search result teaser\\nuse-boolean-and = true # multiple search terms must all match\\nboost-title = 2 # ranking boost factor for matches in headers\\nboost-hierarchy = 1 # ranking boost factor for matches in page names\\nboost-paragraph = 1 # ranking boost factor for matches in text\\nexpand = true # partial words will match longer terms\\nheading-split-level = 3 # link results to heading levels\\ncopy-js = true # include Javascript code for search enable: Enables the search feature. Defaults to true. limit-results: The maximum number of search results. Defaults to 30. teaser-word-count: The number of words used for a search result teaser.\\nDefaults to 30. use-boolean-and: Define the logical link between multiple search words. If\\ntrue, all search words must appear in each result. Defaults to false. boost-title: Boost factor for the search result score if a search word\\nappears in the header. Defaults to 2. boost-hierarchy: Boost factor for the search result score if a search word\\nappears in the hierarchy. The hierarchy contains all titles of the parent\\ndocuments and all parent headings. Defaults to 1. boost-paragraph: Boost factor for the search result score if a search word\\nappears in the text. Defaults to 1. expand: True if search should match longer results e.g. search micro\\nshould match microwave. Defaults to true. heading-split-level: Search results will link to a section of the document\\nwhich contains the result. Documents are split into sections by headings this\\nlevel or less. Defaults to 3. ( ### This is a level 3 heading) copy-js: Copy JavaScript files for the search implementation to the output\\ndirectory. Defaults to true. [output.html.search.chapter] The [ output.html.search.chapter] table provides the ability to modify search settings per chapter or directory. Each key is the path to the chapter source file or directory, and the value is a table of settings to apply to that path. This will merge recursively, with more specific paths taking precedence. [output.html.search.chapter]\\n# Disables search indexing for all chapters in the `appendix` directory.\\n\\"appendix\\" = { enable = false }\\n# Enables search indexing for just this one appendix chapter.\\n\\"appendix/glossary.md\\" = { enable = true } enable: Enables or disables search indexing for the given chapters. Defaults to true. This does not override the overall output.html.search.enable setting; that must be true for any search functionality to be enabled. Be cautious when disabling indexing for chapters because that can potentially lead to user confusion when they search for terms and expect them to be found. This should only be used in exceptional circumstances where keeping the chapter in the index will cause issues with the quality of the search results. [output.html.redirect] The [output.html.redirect] table provides a way to add redirects.\\nThis is useful when you move, rename, or remove a page to ensure that links to the old URL will go to the new location. [output.html.redirect]\\n\\"/appendices/bibliography.html\\" = \\"https://rustc-dev-guide.rust-lang.org/appendix/bibliography.html\\"\\n\\"/other-installation-methods.html\\" = \\"../infra/other-installation-methods.html\\" # Fragment redirects also work.\\n\\"/some-existing-page.html#old-fragment\\" = \\"some-existing-page.html#new-fragment\\" # Fragment redirects also work for deleted pages.\\n\\"/old-page.html\\" = \\"new-page.html\\"\\n\\"/old-page.html#old-fragment\\" = \\"new-page.html#new-fragment\\" The table contains key-value pairs where the key is where the redirect file needs to be created, as an absolute path from the build directory, (e.g. /appendices/bibliography.html).\\nThe value can be any valid URI the browser should navigate to (e.g. https://rust-lang.org/, /overview.html, or ../bibliography.html). This will generate an HTML page which will automatically redirect to the given location. When fragment redirects are specified, the page must use JavaScript to redirect to the correct location. This is useful if you rename or move a section header. Fragment redirects work with existing pages and deleted pages.","breadcrumbs":"Format » Configuration » Renderers » HTML renderer options","id":"36","title":"HTML renderer options"},"37":{"body":"The Markdown renderer will run preprocessors and then output the resulting\\nMarkdown. This is mostly useful for debugging preprocessors, especially in\\nconjunction with mdbook test to see the Markdown that mdbook is passing\\nto rustdoc. The Markdown renderer is included with mdbook but disabled by default.\\nEnable it by adding an empty table to your book.toml as follows: [output.markdown] There are no configuration options for the Markdown renderer at this time;\\nonly whether it is enabled or disabled. See the preprocessors documentation for how to\\nspecify which preprocessors should run before the Markdown renderer.","breadcrumbs":"Format » Configuration » Renderers » Markdown renderer","id":"37","title":"Markdown renderer"},"38":{"body":"All configuration values can be overridden from the command line by setting the\\ncorresponding environment variable. Because many operating systems restrict\\nenvironment variables to be alphanumeric characters or _, the configuration\\nkey needs to be formatted slightly differently to the normal foo.bar.baz form. Variables starting with MDBOOK_ are used for configuration. The key is created\\nby removing the MDBOOK_ prefix and turning the resulting string into kebab-case. Double underscores ( __) separate nested keys, while a single\\nunderscore ( _) is replaced with a dash ( -). For example: MDBOOK_book -> book MDBOOK_BOOK -> book MDBOOK_BOOK__TITLE -> book.title MDBOOK_BOOK__TEXT_DIRECTION -> book.text-direction So by setting the MDBOOK_BOOK__TITLE environment variable you can override the\\nbook’s title without needing to touch your book.toml. Note: To facilitate setting more complex config items, the value of an\\nenvironment variable is first parsed as JSON, falling back to a string if the\\nparse fails. This means, if you so desired, you could override all book metadata when\\nbuilding the book with something like $ export MDBOOK_BOOK=\'{\\"title\\": \\"My Awesome Book\\", \\"authors\\": [\\"Michael-F-Bryan\\"]}\'\\n$ mdbook build The latter case may be useful in situations where mdbook is invoked from a\\nscript or CI, where it sometimes isn’t possible to update the book.toml before\\nbuilding.","breadcrumbs":"Format » Configuration » Environment variables » Environment variables","id":"38","title":"Environment variables"},"39":{"body":"The default renderer uses a handlebars template to\\nrender your markdown files and comes with a default theme included in the mdBook\\nbinary. The theme is totally customizable, you can selectively replace every file from\\nthe theme by your own by adding a theme directory next to src folder in your\\nproject root. Create a new file with the name of the file you want to override\\nand now that file will be used instead of the default file. Here are the files you can override: index.hbs is the handlebars template. head.hbs is appended to the HTML <head> section. header.hbs content is appended on top of every book page. css/ contains the CSS files for styling the book. css/chrome.css is for UI elements. css/general.css is the base styles. css/print.css is the style for printer output. css/variables.css contains variables used in other CSS files. book.js is mostly used to add client side functionality, like hiding /\\nun-hiding the sidebar, changing the theme, … highlight.js is the JavaScript that is used to highlight code snippets,\\nyou should not need to modify this. highlight.css is the theme used for the code highlighting. favicon.svg and favicon.png the favicon that will be used. The SVG\\nversion is used by newer browsers. fonts/fonts.css contains the definition of which fonts to load.\\nCustom fonts can be included in the fonts directory. Generally, when you want to tweak the theme, you don’t need to override all the\\nfiles. If you only need changes in the stylesheet, there is no point in\\noverriding all the other files. Because custom files take precedence over\\nbuilt-in ones, they will not get updated with new fixes / features. Note: When you override a file, it is possible that you break some\\nfunctionality. Therefore I recommend to use the file from the default theme as\\ntemplate and only add / modify what you need. You can copy the default theme\\ninto your source directory automatically by using mdbook init --theme and just\\nremove the files you don’t want to override. mdbook init --theme will not create every file listed above.\\nSome files, such as head.hbs, do not have built-in equivalents.\\nJust create the file if you need it. If you completely replace all built-in themes, be sure to also set output.html.preferred-dark-theme in the config, which defaults to the\\nbuilt-in navy theme.","breadcrumbs":"Format » Theme » Theme","id":"39","title":"Theme"},"4":{"body":"Executable binaries are available for download on the GitHub Releases page.\\nDownload the binary for your platform (Windows, macOS, or Linux) and extract the archive.\\nThe archive contains an mdbook executable which you can run to build your books. To make it easier to run, put the path to the binary into your PATH.","breadcrumbs":"Installation » Pre-compiled binaries","id":"4","title":"Pre-compiled binaries"},"40":{"body":"index.hbs is the handlebars template that is used to render the book. The\\nmarkdown files are processed to html and then injected in that template. If you want to change the layout or style of your book, chances are that you\\nwill have to modify this template a little bit. Here is what you need to know.","breadcrumbs":"Format » Theme » index.hbs » index.hbs","id":"40","title":"index.hbs"},"41":{"body":"A lot of data is exposed to the handlebars template with the “context”. In the\\nhandlebars template you can access this information by using {{name_of_property}} Here is a list of the properties that are exposed: language Language of the book in the form en, as specified in book.toml (if not specified, defaults to en). To use in <html lang=\\"{{ language }}\\"> for example. title Title used for the current page. This is identical to {{ chapter_title }} - {{ book_title }} unless book_title is not set in which case it just defaults to the chapter_title. book_title Title of the book, as specified in book.toml chapter_title Title of the current chapter, as listed in SUMMARY.md path Relative path to the original markdown file from the source\\ndirectory content This is the rendered markdown. path_to_root This is a path containing exclusively ../’s that points\\nto the root of the book from the current file. Since the original directory\\nstructure is maintained, it is useful to prepend relative links with this path_to_root. previous and next These are objects used for linking to the previous and next chapter. They contain the properties title and link of the corresponding chapter. chapters Is an array of dictionaries of the form {\\"section\\": \\"1.2.1\\", \\"name\\": \\"name of this chapter\\", \\"path\\": \\"dir/markdown.md\\"} containing all the chapters of the book. It is used for example to construct\\nthe table of contents (sidebar).","breadcrumbs":"Format » Theme » index.hbs » Data","id":"41","title":"Data"},"42":{"body":"In addition to the properties you can access, there are some handlebars helpers\\nat your disposal. toc The toc helper is used like this {{#toc}}{{/toc}} and outputs something that looks like this, depending on the structure of your\\nbook <ul class=\\"chapter\\"> <li><a href=\\"link/to/file.html\\">Some chapter</a></li> <li> <ul class=\\"section\\"> <li><a href=\\"link/to/other_file.html\\">Some other Chapter</a></li> </ul> </li>\\n</ul> If you would like to make a toc with another structure, you have access to the\\nchapters property containing all the data. The only limitation at the moment\\nis that you would have to do it with JavaScript instead of with a handlebars\\nhelper. <script>\\nvar chapters = {{chapters}};\\n// Processing here\\n</script> resource The path to a static file.\\nIt implicitly includes path_to_root,\\nand accounts for files that are renamed with a hash in their filename. <link rel=\\"stylesheet\\" href=\\"{{ resource \\"css/chrome.css\\" }}\\"> fa mdBook includes a copy of Font Awesome Free’s\\nMIT-licensed SVG files. It accepts three positional arguments: Type: one of “solid”, “regular”, and “brands” (light and duotone are not\\ncurrently supported) Icon: anything chosen from the free icon set ID (optional): if included, an HTML ID attribute will be added to the\\nicon’s wrapping <span> tag For example, this handlebars syntax will become this HTML: {{fa \\"solid\\" \\"print\\" \\"print-button\\"}} <span class=fa-svg id=\\"print-button\\"><svg xmlns=\\"http://www.w3.org/2000/svg\\" viewBox=\\"0 0 512 512\\"><path d=\\"M448 192V77.25c0-8.49-3.37-16.62-9.37-22.63L393.37 9.37c-6-6-14.14-9.37-22.63-9.37H96C78.33 0 64 14.33 64 32v160c-35.35 0-64 28.65-64 64v112c0 8.84 7.16 16 16 16h48v96c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32v-96h48c8.84 0 16-7.16 16-16V256c0-35.35-28.65-64-64-64zm-64 256H128v-96h256v96zm0-224H128V64h192v48c0 8.84 7.16 16 16 16h48v96zm48 72c-13.25 0-24-10.75-24-24 0-13.26 10.75-24 24-24s24 10.74 24 24c0 13.25-10.75 24-24 24z\\"/></svg></span>","breadcrumbs":"Format » Theme » index.hbs » Handlebars helpers","id":"42","title":"Handlebars helpers"},"43":{"body":"mdBook uses Highlight.js with a custom theme\\nfor syntax highlighting. Automatic language detection has been turned off, so you will probably want to\\nspecify the programming language you use like this: ```rust\\nfn main() { // Some code\\n}\\n```","breadcrumbs":"Format » Theme » Syntax highlighting » Syntax highlighting","id":"43","title":"Syntax highlighting"},"44":{"body":"These languages are supported by default, but you can add more by supplying\\nyour own highlight.js file: apache armasm bash c coffeescript cpp csharp css d diff go handlebars haskell http ini java javascript json julia kotlin less lua makefile markdown nginx nim nix objectivec perl php plaintext properties python r ruby rust scala scss shell sql swift typescript x86asm xml yaml","breadcrumbs":"Format » Theme » Syntax highlighting » Supported languages","id":"44","title":"Supported languages"},"45":{"body":"Like the rest of the theme, the files used for syntax highlighting can be\\noverridden with your own. highlight.js normally you shouldn’t have to overwrite this file, unless\\nyou want to use a more recent version. highlight.css theme used by highlight.js for syntax highlighting. If you want to use another theme for highlight.js download it from their\\nwebsite, or make it yourself, rename it to highlight.css and put it in\\nthe theme folder of your book. Now your theme will be used instead of the default theme.","breadcrumbs":"Format » Theme » Syntax highlighting » Custom theme","id":"45","title":"Custom theme"},"46":{"body":"If you think the default theme doesn’t look quite right for a specific language,\\nor could be improved, feel free to submit a new\\nissue explaining what you\\nhave in mind and I will take a look at it. You could also create a pull-request with the proposed improvements. Overall the theme should be light and sober, without too many flashy colors.","breadcrumbs":"Format » Theme » Syntax highlighting » Improve default theme","id":"46","title":"Improve default theme"},"47":{"body":"In addition to providing runnable code playgrounds, mdBook optionally allows them\\nto be editable. In order to enable editable code blocks, the following needs to\\nbe added to the book.toml: [output.html.playground]\\neditable = true After enabling editable code blocks, the editable attribute must be added to a\\ncode block to make it editable: ```rust,editable\\nfn main() { let number = 5; print!(\\"{}\\", number);\\n}\\n``` The above will result in this editable playground: fn main() { let number = 5; print!(\\"{}\\", number);\\n} Note the new Undo Changes button in the editable playgrounds.","breadcrumbs":"Format » Theme » Editor » Editor","id":"47","title":"Editor"},"48":{"body":"By default, the editor is the Ace editor, but, if desired,\\nthe functionality may be overridden by providing a different folder: [output.html.playground]\\neditable = true\\neditor = \\"/path/to/editor\\" Note that for the editor changes to function correctly, the book.js inside of\\nthe theme folder will need to be overridden as it has some couplings with the\\ndefault Ace editor.","breadcrumbs":"Format » Theme » Editor » Customizing the editor","id":"48","title":"Customizing the editor"},"49":{"body":"mdBook has optional support for math equations through MathJax. To enable MathJax, you need to add the mathjax-support key to your book.toml\\nunder the output.html section. [output.html]\\nmathjax-support = true Note: The usual delimiters MathJax uses are not yet supported. You can’t\\ncurrently use $$ ... $$ as delimiters and the \\\\[ ... \\\\] delimiters need an\\nextra backslash to work. Hopefully this limitation will be lifted soon. Note: When you use double backslashes in MathJax blocks (for example in\\ncommands such as \\\\begin{cases} \\\\frac 1 2 \\\\\\\\ \\\\frac 3 4 \\\\end{cases}) you need\\nto add two extra backslashes (e.g., \\\\begin{cases} \\\\frac 1 2 \\\\\\\\\\\\\\\\ \\\\frac 3 4 \\\\end{cases}). Inline equations Inline equations are delimited by \\\\\\\\( and \\\\\\\\). So for example, to render the\\nfollowing inline equation \\\\( \\\\int x dx = \\\\frac{x^2}{2} + C \\\\) you would write\\nthe following: \\\\\\\\( \\\\int x dx = \\\\frac{x^2}{2} + C \\\\\\\\) Block equations Block equations are delimited by \\\\\\\\[ and \\\\\\\\]. To render the following\\nequation \\\\[ \\\\mu = \\\\frac{1}{N} \\\\sum_{i=0} x_i \\\\] you would write: \\\\\\\\[ \\\\mu = \\\\frac{1}{N} \\\\sum_{i=0} x_i \\\\\\\\]","breadcrumbs":"Format » MathJax support » MathJax support","id":"49","title":"MathJax support"},"5":{"body":"To build the mdbook executable from source, you will first need to install Rust and Cargo.\\nFollow the instructions on the Rust installation page.\\nmdBook currently requires at least Rust version 1.88. Once you have installed Rust, the following command can be used to build and install mdBook: cargo install mdbook This will automatically download mdBook from crates.io, build it, and install it in Cargo’s global binary directory ( ~/.cargo/bin/ by default). You can run cargo install mdbook again whenever you want to update to a new version.\\nThat command will check if there is a newer version, and re-install mdBook if a newer version is found. To uninstall, run the command cargo uninstall mdbook. Installing the latest master version The version published to crates.io will ever so slightly be behind the version hosted on GitHub.\\nIf you need the latest version you can build the git version of mdBook yourself.\\nCargo makes this super easy! cargo install --git https://github.com/rust-lang/mdBook.git mdbook Again, make sure to add the Cargo bin directory to your PATH.","breadcrumbs":"Installation » Build from source using Rust","id":"5","title":"Build from source using Rust"},"50":{"body":"","breadcrumbs":"Format » mdBook-specific features » mdBook-specific features","id":"50","title":"mdBook-specific features"},"51":{"body":"There is a feature in mdBook that lets you hide code lines by prepending them with a specific prefix. For the Rust language, you can prefix lines with # ( # followed by a space) to hide them like you would with Rustdoc.\\nThis prefix can be escaped with ## to prevent the hiding of a line that should begin with the literal string # (see Rustdoc’s docs for more details) # fn main() { let x = 5; let y = 6; println!(\\"{}\\", x + y);\\n# } Will render as fn main() { let x = 5; let y = 6; println!(\\"{}\\", x + y); } When you tap or hover the mouse over the code block, there will be an eyeball icon ( ) which will toggle the visibility of the hidden lines. By default, this only works for code examples that are annotated with rust.\\nHowever, you can define custom prefixes for other languages by adding a new line-hiding prefix in your book.toml with the language name and prefix character(s): [output.html.code.hidelines]\\npython = \\"~\\" The prefix will hide any lines that begin with the given prefix. With the python prefix shown above, this: ~hidden()\\nnothidden():\\n~ hidden() ~hidden() nothidden() will render as hidden()\\nnothidden(): hidden() hidden() nothidden() This behavior can be overridden locally with a different prefix. This has the same effect as above: ```python,hidelines=!!!\\n!!!hidden()\\nnothidden():\\n!!! hidden() !!!hidden() nothidden()\\n```","breadcrumbs":"Format » mdBook-specific features » Hiding code lines","id":"51","title":"Hiding code lines"},"52":{"body":"Rust language code blocks will automatically get a play button ( ) which will execute the code and display the output just below the code block.\\nThis works by sending the code to the Rust Playground. #![allow(unused)] fn main() {\\nprintln!(\\"Hello, World!\\"); } If there is no main function, then the code is automatically wrapped inside one. If you wish to disable the play button for a code block, you can include the noplayground option on the code block like this: ```rust,noplayground\\nlet mut name = String::new();\\nstd::io::stdin().read_line(&mut name).expect(\\"failed to read line\\");\\nprintln!(\\"Hello {}!\\", name);\\n``` Or, if you wish to disable the play button for all code blocks in your book, you can write the config to the book.toml like this. [output.html.playground]\\nrunnable = false","breadcrumbs":"Format » mdBook-specific features » Rust playground","id":"52","title":"Rust playground"},"53":{"body":"Additional attributes can be included in Rust code blocks with comma, space, or tab-separated terms just after the language term. For example: ```rust,ignore\\n# This example won\'t be tested.\\npanic!(\\"oops!\\");\\n``` These are particularly important when using mdbook test to test Rust examples.\\nThese use the same attributes as rustdoc attributes, with a few additions: editable — Enables the editor. noplayground — Removes the play button, but will still be tested. mdbook-runnable — Forces the play button to be displayed.\\nThis is intended to be combined with the ignore attribute for examples that should not be tested, but you want to allow the reader to run. ignore — Will not be tested and no play button is shown, but it is still highlighted as Rust syntax. should_panic — When executed, it should produce a panic. no_run — The code is compiled when tested, but it is not run.\\nThe play button is also not shown. compile_fail — The code should fail to compile. edition2015, edition2018, edition2021, edition2024 — Forces the use of a specific Rust edition.\\nSee rust.edition to set this globally.","breadcrumbs":"Format » mdBook-specific features » Rust code block attributes","id":"53","title":"Rust code block attributes"},"54":{"body":"With the following syntax, you can include files into your book: {{#include file.rs}} The path to the file has to be relative from the current source file. mdBook will interpret included files as Markdown. Since the include command\\nis usually used for inserting code snippets and examples, you will often\\nwrap the command with ``` to display the file contents without\\ninterpreting them. ```\\n{{#include file.rs}}\\n```","breadcrumbs":"Format » mdBook-specific features » Including files","id":"54","title":"Including files"},"55":{"body":"Often you only need a specific part of the file, e.g. relevant lines for an\\nexample. We support four different modes of partial includes: {{#include file.rs:2}}\\n{{#include file.rs::10}}\\n{{#include file.rs:2:}}\\n{{#include file.rs:2:10}} The first command only includes the second line from file file.rs. The second\\ncommand includes all lines up to line 10, i.e. the lines from 11 till the end of\\nthe file are omitted. The third command includes all lines from line 2, i.e. the\\nfirst line is omitted. The last command includes the excerpt of file.rs\\nconsisting of lines 2 to 10. To avoid breaking your book when modifying included files, you can also\\ninclude a specific section using anchors instead of line numbers.\\nAn anchor is a pair of matching lines. The line beginning an anchor must\\nmatch the regex ANCHOR:\\\\s*[\\\\w_-]+ and similarly the ending line must match\\nthe regex ANCHOR_END:\\\\s*[\\\\w_-]+. This allows you to put anchors in\\nany kind of commented line. Consider the following file to include: /* ANCHOR: all */ // ANCHOR: component\\nstruct Paddle { hello: f32,\\n}\\n// ANCHOR_END: component ////////// ANCHOR: system\\nimpl System for MySystem { ... }\\n////////// ANCHOR_END: system /* ANCHOR_END: all */ Then in the book, all you have to do is: Here is a component:\\n```rust,no_run,noplayground\\n{{#include file.rs:component}}\\n``` Here is a system:\\n```rust,no_run,noplayground\\n{{#include file.rs:system}}\\n``` This is the full file.\\n```rust,no_run,noplayground\\n{{#include file.rs:all}}\\n``` Lines containing anchor patterns inside the included anchor are ignored.","breadcrumbs":"Format » mdBook-specific features » Including portions of a file","id":"55","title":"Including portions of a file"},"56":{"body":"The rustdoc_include helper is for including code from external Rust files that contain complete\\nexamples, but only initially showing particular lines specified with line numbers or anchors in the\\nsame way as with include. The lines not in the line number range or between the anchors will still be included, but they will\\nbe prefaced with #. This way, a reader can expand the snippet to see the complete example, and\\nRustdoc will use the complete example when you run mdbook test. For example, consider a file named file.rs that contains this Rust program: fn main() { let x = add_one(2); assert_eq!(x, 3);\\n} fn add_one(num: i32) -> i32 { num + 1\\n} We can include a snippet that initially shows only line 2 by using this syntax: To call the `add_one` function, we pass it an `i32` and bind the returned value to `x`: ```rust\\n{{#rustdoc_include file.rs:2}}\\n``` This would have the same effect as if we had manually inserted the code and hidden all but line 2\\nusing #: To call the `add_one` function, we pass it an `i32` and bind the returned value to `x`: ```rust\\n# fn main() { let x = add_one(2);\\n# assert_eq!(x, 3);\\n# }\\n#\\n# fn add_one(num: i32) -> i32 {\\n# num + 1\\n# }\\n``` That is, it looks like this (click the “expand” icon to see the rest of the file): fn main() { let x = add_one(2); assert_eq!(x, 3); } fn add_one(num: i32) -> i32 { num + 1 }","breadcrumbs":"Format » mdBook-specific features » Including a file but initially hiding all except specified lines","id":"56","title":"Including a file but initially hiding all except specified lines"},"57":{"body":"With the following syntax, you can insert runnable Rust files into your book: {{#playground file.rs}} The path to the Rust file has to be relative from the current source file. When play is clicked, the code snippet will be sent to the Rust Playground to be\\ncompiled and run. The result is sent back and displayed directly underneath the\\ncode. Here is what a rendered code snippet looks like: fn main() { println!(\\"Hello World!\\"); // You can even hide lines! :D println!(\\"I am hidden! Expand the code snippet to see me\\");\\n} Any additional values passed after the filename will be included as attributes of the code block.\\nFor example {{#playground example.rs editable}} will create the code block like the following: ```rust,editable\\n# Contents of example.rs here.\\n``` And the editable attribute will enable the editor as described at Rust code block attributes.","breadcrumbs":"Format » mdBook-specific features » Inserting runnable Rust files","id":"57","title":"Inserting runnable Rust files"},"58":{"body":"A chapter can set a <title> that is different from its entry in the table of\\ncontents (sidebar) by including a {{#title ...}} near the top of the page. {{#title My Title}}","breadcrumbs":"Format » mdBook-specific features » Controlling page <title>","id":"58","title":"Controlling page <title>"},"59":{"body":"class=\\"left\\" and \\"right\\" These classes are provided by default, for inline HTML to float images. <img class=\\"right\\" src=\\"images/rust-logo-blk.svg\\" alt=\\"The Rust logo\\"> class=\\"hidden\\" HTML tags with class hidden will not be shown. <div class=\\"hidden\\">This will not be seen.</div> This will not be seen.","breadcrumbs":"Format » mdBook-specific features » HTML classes provided by mdBook","id":"59","title":"HTML classes provided by mdBook"},"6":{"body":"If you are interested in making modifications to mdBook itself, check out the Contributing Guide for more information.","breadcrumbs":"Installation » Modifying and contributing","id":"6","title":"Modifying and contributing"},"60":{"body":"mdBook includes a copy of version 6 of Font Awesome Free’s\\nMIT-licensed SVG files. It emulates the <i> syntax, but converts the results\\nto inline SVG. Only the regular, solid, and brands icons are included; paid\\nfeatures like the light icons are not. For example, given this HTML syntax: The result looks like this: <i class=\\"fa-solid fa-print\\"></i> The result looks like this: See the free icon set for the available icons.","breadcrumbs":"Format » mdBook-specific features » Font-Awesome icons","id":"60","title":"Font-Awesome icons"},"61":{"body":"mdBook’s parser adheres to the CommonMark specification with some extensions described below.\\nYou can take a quick tutorial,\\nor try out CommonMark in real time. A complete Markdown overview is out of scope for\\nthis documentation, but below is a high level overview of some of the basics. For a more in-depth experience, check out the Markdown Guide.","breadcrumbs":"Format » Markdown » Markdown","id":"61","title":"Markdown"},"62":{"body":"Text is rendered relatively predictably: Here is a line of text. This is a new line. Will look like you might expect: Here is a line of text. This is a new line.","breadcrumbs":"Format » Markdown » Text and paragraphs","id":"62","title":"Text and paragraphs"},"63":{"body":"Headings use the # marker and should be on a line by themselves. More # mean smaller headings: ### A heading Some text. #### A smaller heading More text. A heading Some text. A smaller heading More text.","breadcrumbs":"Format » Markdown » Headings","id":"63","title":"Headings"},"64":{"body":"Lists can be unordered or ordered. Ordered lists will order automatically: * milk\\n* eggs\\n* butter 1. carrots\\n1. celery\\n1. radishes milk eggs butter carrots celery radishes","breadcrumbs":"Format » Markdown » Lists","id":"64","title":"Lists"},"65":{"body":"Linking to a URL or local file is easy: Use [mdBook](https://github.com/rust-lang/mdBook). Read about [mdBook](mdbook.md). And now [an mdBook link] that is not inline, unlike the above. A bare url: <https://www.rust-lang.org>. [an mdBook link]: https://github.com/rust-lang/mdBook Use mdBook. Read about mdBook. And now an mdBook link that is not inline, unlike the above. A bare url: https://www.rust-lang.org. Relative links that end with .md will be converted to the .html extension.\\nIt is recommended to use .md links when possible.\\nThis is useful when viewing the Markdown file outside of mdBook, for example on GitHub or GitLab which render Markdown automatically. Links to README.md will be converted to index.html.\\nThis is done since some services like GitHub render README files automatically, but web servers typically expect the root file to be called index.html. You can link to individual headings with # fragments.\\nFor example, mdbook.md#text-and-paragraphs would link to the Text and Paragraphs section above.\\nThe ID is created by transforming the heading such as converting to lowercase and replacing spaces with dashes.\\nYou can click on any heading and look at the URL in your browser to see what the fragment looks like.","breadcrumbs":"Format » Markdown » Links","id":"65","title":"Links"},"66":{"body":"Including images is simply a matter of including a link to them, much like in the Links section above. The following markdown\\nincludes the Rust logo SVG image found in the images directory at the same level as this file: ![The Rust Logo](images/rust-logo-blk.svg) Produces the following HTML when built with mdBook: <p><img src=\\"images/rust-logo-blk.svg\\" alt=\\"The Rust Logo\\" /></p> Which, of course displays the image like so:","breadcrumbs":"Format » Markdown » Images","id":"66","title":"Images"},"67":{"body":"mdBook has several extensions beyond the standard CommonMark specification. Strikethrough Text may be rendered with a horizontal line through the center by wrapping the\\ntext with one or two tilde characters on each side: An example of ~~strikethrough text~~. This example will render as: An example of strikethrough text. This follows the GitHub Strikethrough extension. Footnotes A footnote generates a small numbered link in the text which when clicked\\ntakes the reader to the footnote text at the bottom of the item. The footnote\\nlabel is written similarly to a link reference with a caret at the front. The\\nfootnote text is written like a link reference definition, with the text\\nfollowing the label. Example: This is an example of a footnote[^note]. [^note]: This text is the contents of the footnote, which will be rendered towards the bottom. This example will render as: This is an example of a footnote 1. The footnotes are automatically numbered based on the order the footnotes are\\nwritten. Tables Tables can be written using pipes and dashes to draw the rows and columns of\\nthe table. These will be translated to HTML table matching the shape. Example: | Header1 | Header2 |\\n|---------|---------|\\n| abc | def | This example will render similarly to this: Header1 Header2 abc def See the specification for the GitHub Tables extension for more\\ndetails on the exact syntax supported. Task lists Task lists can be used as a checklist of items that have been completed.\\nExample: - [x] Complete task\\n- [ ] Incomplete task This will render as: Complete task Incomplete task See the specification for the task list extension for more details. Smart punctuation Some ASCII punctuation sequences will be automatically turned into fancy Unicode\\ncharacters: ASCII sequence Unicode -- – --- — ... … \\" “ or ”, depending on context \' ‘ or ’, depending on context So, no need to manually enter those Unicode characters! This feature is enabled by default.\\nTo disable it, see the output.html.smart-punctuation config option. Heading attributes Headings can have a custom HTML ID and classes. This lets you maintain the same ID even if you change the heading’s text, it also lets you add multiple classes in the heading. Example: # Example heading { #first .class1 .class2 } This makes the level 1 heading with the content Example heading, ID first, and classes class1 and class2. Note that the attributes should be space-separated. More information can be found in the heading attrs spec page. Definition lists Definition lists can be used for things like glossary entries. The term is listed on a line by itself, followed by one or more definitions. Each definition must begin with a : (after 0-2 spaces). Example: term A : This is a definition of term A. Text can span multiple lines. term B : This is a definition of term B. : This has more than one definition. This will render as: term A This is a definition of term A. Text\\ncan span multiple lines. term B This is a definition of term B. This has more than one definition. Terms are clickable just like headers, which will set the browser’s URL to point directly to that term. See the definition lists spec for more information on the specifics of the syntax. See the Wikipedia guidelines for glossaries for some guidelines on how to write a glossary. This feature is enabled by default.\\nTo disable it, see the output.html.definition-lists config option. Admonitions An admonition is a special type of callout or notice block used to highlight important information. It is written as a blockquote with a special tag on the first line. > [!NOTE]\\n> General information or additional context. > [!TIP]\\n> A helpful suggestion or best practice. > [!IMPORTANT]\\n> Key information that shouldn\'t be missed. > [!WARNING]\\n> Critical information that highlights a potential risk. > [!CAUTION]\\n> Information about potential issues that require caution. These will render as: Note General information or additional context. Tip A helpful suggestion or best practice. Important Key information that shouldn’t be missed. Warning Critical information that highlights a potential risk. Caution Information about potential issues that require caution. This feature is enabled by default.\\nTo disable it, see the output.html.admonitions config option. This text is the contents of the footnote, which will be rendered\\ntowards the bottom. ↩","breadcrumbs":"Format » Markdown » Extensions","id":"67","title":"Extensions"},"68":{"body":"There are a variety of services such as GitHub Actions or GitLab CI/CD which can be used to test and deploy your book automatically. The following provides some general guidelines on how to configure your service to run mdBook.\\nSpecific recipes can be found at the Automated Deployment wiki page.","breadcrumbs":"Continuous integration » Running mdbook in continuous integration","id":"68","title":"Running mdbook in continuous integration"},"69":{"body":"There are several different strategies for installing mdBook.\\nThe particular method depends on your needs and preferences. Pre-compiled binaries Perhaps the easiest method is to use the pre-compiled binaries found on the GitHub Releases page.\\nA simple approach would be to use the popular curl CLI tool to download the executable: mkdir bin\\ncurl -sSL https://github.com/rust-lang/mdBook/releases/download/0.5.2/mdbook-0.5.2-x86_64-unknown-linux-gnu.tar.gz | tar -xz --directory=bin\\nbin/mdbook build Some considerations for this approach: This is relatively fast, and does not necessarily require dealing with caching. This does not require installing Rust. Specifying a specific URL means you have to manually update your script to get a new version.\\nThis may be a benefit if you want to lock to a specific version.\\nHowever, some users prefer to automatically get a newer version when they are published. You are reliant on the GitHub CDN being available. Building from source Building from source will require having Rust installed.\\nSome services have Rust pre-installed, but if your service does not, you will need to add a step to install it. After Rust is installed, cargo install can be used to build and install mdBook.\\nWe recommend using a SemVer version specifier so that you get the latest non-breaking version of mdBook.\\nFor example: cargo install mdbook --no-default-features --features search --vers \\"^0.4\\" --locked This includes several recommended options: --no-default-features — Disables features like the HTTP server used by mdbook serve that is likely not needed on CI.\\nThis will speed up the build time significantly. --features search — Disabling default features means you should then manually enable features that you want, such as the built-in search capability. --vers \\"^0.4\\" — This will install the most recent version of the 0.4 series.\\nHowever, versions after like 0.5.0 won’t be installed, as they may break your build.\\nCargo will automatically upgrade mdBook if you have an older version already installed. --locked — This will use the dependencies that were used when mdBook was released.\\nWithout --locked, it will use the latest version of all dependencies, which may include some fixes since the last release, but may also (rarely) cause build problems. You will likely want to investigate caching options, as building mdBook can be somewhat slow.","breadcrumbs":"Continuous integration » Installing mdBook","id":"69","title":"Installing mdBook"},"7":{"body":"This chapter gives an introduction on how to interact with a book produced by mdBook.\\nThis assumes you are reading an HTML book.\\nThe options and formatting will be different for other output formats such as PDF. A book is organized into chapters.\\nEach chapter is a separate page.\\nChapters can be nested into a hierarchy of sub-chapters.\\nTypically, each chapter will be organized into a series of headings to subdivide a chapter.","breadcrumbs":"Reading books » Reading books","id":"7","title":"Reading books"},"70":{"body":"You may want to run tests using mdbook test every time you push a change or create a pull request.\\nThis can be used to validate Rust code examples in the book. This will require having Rust installed.\\nSome services have Rust pre-installed, but if your service does not, you will need to add a step to install it. Other than making sure the appropriate version of Rust is installed, there’s not much more than just running mdbook test from the book directory. You may also want to consider running other kinds of tests, like mdbook-linkcheck which will check for broken links.\\nOr if you have your own style checks, spell checker, or any other tests it might be good to run them in CI.","breadcrumbs":"Continuous integration » Running tests","id":"70","title":"Running tests"},"71":{"body":"You may want to automatically deploy your book.\\nSome may want to do this every time a change is pushed, and others may want to only deploy when a specific release is tagged. You’ll also need to understand the specifics on how to push a change to your web service.\\nFor example, GitHub Pages just requires committing the output onto a specific git branch.\\nOther services may require using something like SSH to connect to a remote server. The basic outline is that you need to run mdbook build to generate the output, and then transfer the files (which are in the book directory) to the correct location. You may then want to consider if you need to invalidate any caches on your web service. See the Automated Deployment wiki page for examples of various different services. 404 handling mdBook automatically generates a 404 page to be used for broken links.\\nThe default output is a file named 404.html at the root of the book.\\nSome services like GitHub Pages will automatically use this page for broken links.\\nFor other services, you may want to consider configuring the web server to use this page as it will provide the reader navigation to get back to the book. If your book is not deployed at the root of the domain, then you should set the output.html.site-url setting so that the 404 page works correctly.\\nIt needs to know where the book is deployed in order to load the static files (like CSS) correctly.\\nFor example, this guide is deployed at https://rust-lang.github.io/mdBook/, and the site-url setting is configured like this: # book.toml\\n[output.html]\\nsite-url = \\"/mdBook/\\" You can customize the look of the 404 page by creating a file named src/404.md in your book.\\nIf you want to use a different filename, you can set output.html.input-404 to a different filename.","breadcrumbs":"Continuous integration » Deploying","id":"71","title":"Deploying"},"72":{"body":"While mdbook is mainly used as a command line tool, you can also import the\\nunderlying libraries directly and use those to manage a book. It also has a fairly\\nflexible plugin mechanism, allowing you to create your own custom tooling and\\nconsumers (often referred to as backends) if you need to do some analysis of\\nthe book or render it in a different format. The For Developers chapters are here to show you the more advanced usage of mdbook. The two main ways a developer can hook into the book’s build process is via, Preprocessors Alternative Backends","breadcrumbs":"For developers » For developers","id":"72","title":"For developers"},"73":{"body":"The process of rendering a book project goes through several steps. Load the book Parse the book.toml, falling back to the default Config if it doesn’t\\nexist Load the book chapters into memory Discover which preprocessors/backends should be used For each backend: Run all the preprocessors. Call the backend to render the processed result.","breadcrumbs":"For developers » The build process","id":"73","title":"The build process"},"74":{"body":"The mdbook binary is just a wrapper around the underlying mdBook crates,\\nexposing their functionality as a command-line program. If you want to\\nprogrammatically drive mdBook, you can use the [ mdbook-driver] crate.\\nThis can be used to add your own functionality or tweak the build process. The easiest way to find out how to use the mdbook-driver crate is by looking at the API Docs. The top level documentation explains how one would use the MDBook type to load and build a book, while the config module gives a good\\nexplanation on the configuration system.","breadcrumbs":"For developers » Using mdbook as a library","id":"74","title":"Using mdbook as a library"},"75":{"body":"A preprocessor is simply a bit of code which gets run immediately after the\\nbook is loaded and before it gets rendered, allowing you to update and mutate\\nthe book. Possible use cases are: Creating custom helpers like {{#include /path/to/file.md}} Substituting in latex-style expressions ( $$ \\\\frac{1}{3} $$) with their\\nmathjax equivalents See Configuring Preprocessors for more information about using preprocessors.","breadcrumbs":"For developers » Preprocessors » Preprocessors","id":"75","title":"Preprocessors"},"76":{"body":"MDBook uses a fairly simple mechanism for discovering third party plugins.\\nA new table is added to book.toml (e.g. [preprocessor.foo] for the foo\\npreprocessor) and then mdbook will try to invoke the mdbook-foo program as\\npart of the build process. Once the preprocessor has been defined and the build process starts, mdBook executes the command defined in the preprocessor.foo.command key twice.\\nThe first time it runs the preprocessor to determine if it supports the given renderer.\\nmdBook passes two arguments to the process: the first argument is the string supports and the second argument is the renderer name.\\nThe preprocessor should exit with a status code 0 if it supports the given renderer, or return a non-zero exit code if it does not. If the preprocessor supports the renderer, then mdbook runs it a second time, passing JSON data into stdin.\\nThe JSON consists of an array of [context, book] where context is the serialized object PreprocessorContext and book is a Book object containing the content of the book. The preprocessor should return the JSON format of the Book object to stdout, with any modifications it wishes to perform. The easiest way to get started is by creating your own implementation of the Preprocessor trait (e.g. in lib.rs) and then creating a shell binary which\\ntranslates inputs to the correct Preprocessor method. For convenience, there\\nis an example no-op preprocessor in the examples/ directory which can easily\\nbe adapted for other preprocessors. Example no-op preprocessor // nop-preprocessors.rs //! A basic example of a preprocessor that does nothing. use crate::nop_lib::Nop;\\nuse clap::{Arg, ArgMatches, Command};\\nuse mdbook_preprocessor::book::Book;\\nuse mdbook_preprocessor::errors::Result;\\nuse mdbook_preprocessor::{Preprocessor, PreprocessorContext};\\nuse semver::{Version, VersionReq};\\nuse std::io;\\nuse std::process; fn make_app() -> Command { Command::new(\\"nop-preprocessor\\") .about(\\"A mdbook preprocessor which does precisely nothing\\") .subcommand( Command::new(\\"supports\\") .arg(Arg::new(\\"renderer\\").required(true)) .about(\\"Check whether a renderer is supported by this preprocessor\\"), )\\n} fn main() { let matches = make_app().get_matches(); // Users will want to construct their own preprocessor here let preprocessor = Nop::new(); if let Some(sub_args) = matches.subcommand_matches(\\"supports\\") { handle_supports(&preprocessor, sub_args); } else if let Err(e) = handle_preprocessing(&preprocessor) { eprintln!(\\"{e:?}\\"); process::exit(1); }\\n} fn handle_preprocessing(pre: &dyn Preprocessor) -> Result<()> { let (ctx, book) = mdbook_preprocessor::parse_input(io::stdin())?; let book_version = Version::parse(&ctx.mdbook_version)?; let version_req = VersionReq::parse(mdbook_preprocessor::MDBOOK_VERSION)?; if !version_req.matches(&book_version) { eprintln!( \\"Warning: The {} plugin was built against version {} of mdbook, \\\\ but we\'re being called from version {}\\", pre.name(), mdbook_preprocessor::MDBOOK_VERSION, ctx.mdbook_version ); } let processed_book = pre.run(&ctx, book)?; serde_json::to_writer(io::stdout(), &processed_book)?; Ok(())\\n} fn handle_supports(pre: &dyn Preprocessor, sub_args: &ArgMatches) -> ! { let renderer = sub_args .get_one::<String>(\\"renderer\\") .expect(\\"Required argument\\"); let supported = pre.supports_renderer(renderer).unwrap(); // Signal whether the renderer is supported by exiting with 1 or 0. if supported { process::exit(0); } else { process::exit(1); }\\n} /// The actual implementation of the `Nop` preprocessor. This would usually go\\n/// in your main `lib.rs` file.\\n#[allow(unreachable_pub, reason = \\"wouldn\'t be a problem in a proper lib.rs\\")]\\nmod nop_lib { use super::*; /// A no-op preprocessor. pub struct Nop; impl Nop { pub fn new() -> Nop { Nop } } impl Preprocessor for Nop { fn name(&self) -> &str { \\"nop-preprocessor\\" } fn run(&self, ctx: &PreprocessorContext, book: Book) -> Result<Book> { // In testing we want to tell the preprocessor to blow up by setting a // particular config value match ctx .config .get::<bool>(\\"preprocessor.nop-preprocessor.blow-up\\") { Ok(Some(true)) => anyhow::bail!(\\"Boom!!1!\\"), Ok(_) => {} Err(e) => anyhow::bail!(\\"expect bool for blow-up: {e}\\"), } // we *are* a no-op preprocessor after all Ok(book) } fn supports_renderer(&self, renderer: &str) -> Result<bool> { Ok(renderer != \\"not-supported\\") } } #[cfg(test)] mod test { use super::*; #[test] fn nop_preprocessor_run() { let input_json = r##\\"[ { \\"root\\": \\"/path/to/book\\", \\"config\\": { \\"book\\": { \\"authors\\": [\\"AUTHOR\\"], \\"language\\": \\"en\\", \\"src\\": \\"src\\", \\"title\\": \\"TITLE\\" }, \\"preprocessor\\": { \\"nop\\": {} } }, \\"renderer\\": \\"html\\", \\"mdbook_version\\": \\"0.4.21\\" }, { \\"items\\": [ { \\"Chapter\\": { \\"name\\": \\"Chapter 1\\", \\"content\\": \\"# Chapter 1\\\\n\\", \\"number\\": [1], \\"sub_items\\": [], \\"path\\": \\"chapter_1.md\\", \\"source_path\\": \\"chapter_1.md\\", \\"parent_names\\": [] } } ] } ]\\"##; let input_json = input_json.as_bytes(); let (ctx, book) = mdbook_preprocessor::parse_input(input_json).unwrap(); let expected_book = book.clone(); let result = Nop::new().run(&ctx, book); assert!(result.is_ok()); // The nop-preprocessor should not have made any changes to the book content. let actual_book = result.unwrap(); assert_eq!(actual_book, expected_book); } }\\n}","breadcrumbs":"For developers » Preprocessors » Hooking into MDBook","id":"76","title":"Hooking into MDBook"},"77":{"body":"By pulling in mdbook-preprocessor as a library, preprocessors can have access to the\\nexisting infrastructure for dealing with books. For example, a custom preprocessor could use the parse_input() function to deserialize the JSON written to stdin. Then each chapter of the Book can be mutated in-place via Book::for_each_mut(), and then written to stdout with the serde_json\\ncrate. Chapters can be accessed either directly (by recursively iterating over\\nchapters) or via the Book::for_each_mut() convenience method. The chapter.content is just a string which happens to be markdown. While it’s\\nentirely possible to use regular expressions or do a manual find & replace,\\nyou’ll probably want to process the input into something more computer-friendly.\\nThe mdbook-markdown crate exposes the pulldown-cmark crate used by mdBook to parse Markdown. The pulldown-cmark-to-cmark crate can be used to translate events back into markdown text. The following code block shows how to remove all emphasis from markdown,\\nwithout accidentally breaking the document. //! This is a demonstration of an mdBook preprocessor which parses markdown //! and removes any instances of emphasis. use mdbook_preprocessor::book::{Book, Chapter}; use mdbook_preprocessor::errors::Result; use mdbook_preprocessor::{Preprocessor, PreprocessorContext}; use pulldown_cmark::{Event, Parser, Tag, TagEnd}; use std::io; fn main() { let mut args = std::env::args().skip(1); match args.next().as_deref() { Some(\\"supports\\") => { // Supports all renderers. return; } Some(arg) => { eprintln!(\\"unknown argument: {arg}\\"); std::process::exit(1); } None => {} } if let Err(e) = handle_preprocessing() { eprintln!(\\"{e}\\"); std::process::exit(1); } } struct RemoveEmphasis; impl Preprocessor for RemoveEmphasis { fn name(&self) -> &str { \\"remove-emphasis\\" } fn run(&self, _ctx: &PreprocessorContext, mut book: Book) -> Result<Book> { let mut total = 0; book.for_each_chapter_mut(|ch| match remove_emphasis(&mut total, ch) { Ok(s) => ch.content = s, Err(e) => eprintln!(\\"failed to process chapter: {e:?}\\"), }); eprintln!(\\"removed {total} emphasis\\"); Ok(book) } } fn remove_emphasis(num_removed_items: &mut usize, chapter: &mut Chapter) -> Result<String> { let mut buf = String::with_capacity(chapter.content.len()); let events = Parser::new(&chapter.content).filter(|e| match e { Event::Start(Tag::Emphasis) | Event::Start(Tag::Strong) => { *num_removed_items += 1; false } Event::End(TagEnd::Emphasis) | Event::End(TagEnd::Strong) => false, _ => true, }); Ok(pulldown_cmark_to_cmark::cmark(events, &mut buf).map(|_| buf)?)\\n} pub fn handle_preprocessing() -> Result<()> { let pre = RemoveEmphasis; let (ctx, book) = mdbook_preprocessor::parse_input(io::stdin())?; let processed_book = pre.run(&ctx, book)?; serde_json::to_writer(io::stdout(), &processed_book)?; Ok(()) } Take a look at the full example source for more details.","breadcrumbs":"For developers » Preprocessors » Hints for implementing a preprocessor","id":"77","title":"Hints for implementing a preprocessor"},"78":{"body":"The fact that mdBook utilizes stdin and stdout to communicate with the preprocessors makes it easy to implement them in a language other than Rust.\\nThe following code shows how to implement a simple preprocessor in Python, which will modify the content of the first chapter.\\nThe example below follows the configuration shown above with preprocessor.foo.command actually pointing to a Python script. import json\\nimport sys if __name__ == \'__main__\': if len(sys.argv) > 1: # we check if we received any argument if sys.argv[1] == \\"supports\\": # then we are good to return an exit status code of 0, since the other argument will just be the renderer\'s name sys.exit(0) # load both the context and the book representations from stdin context, book = json.load(sys.stdin) # and now, we can just modify the content of the first chapter book[\'items\'][0][\'Chapter\'][\'content\'] = \'# Hello\' # we are done with the book\'s modification, we can just print it to stdout, print(json.dumps(book))","breadcrumbs":"For developers » Preprocessors » Implementing a preprocessor with a different language","id":"78","title":"Implementing a preprocessor with a different language"},"79":{"body":"A “backend” is simply a program which mdbook will invoke during the book\\nrendering process. This program is passed a JSON representation of the book and\\nconfiguration information via stdin. Once the backend receives this\\ninformation it is free to do whatever it wants. See Configuring Renderers for more information about using backends. The community has developed several backends.\\nSee the Third Party Plugins wiki page for a list of available backends.","breadcrumbs":"For developers » Alternative backends » Alternative backends","id":"79","title":"Alternative backends"},"8":{"body":"There are several methods for navigating through the chapters of a book. The sidebar on the left provides a list of all chapters.\\nClicking on any of the chapter titles will load that page. The sidebar may not automatically appear if the window is too narrow, particularly on mobile displays.\\nIn that situation, the menu icon (three horizontal bars) at the top-left of the page can be pressed to open and close the sidebar. The arrow buttons at the bottom of the page can be used to navigate to the previous or the next chapter. The left and right arrow keys on the keyboard can be used to navigate to the previous or the next chapter.","breadcrumbs":"Reading books » Navigation","id":"8","title":"Navigation"},"80":{"body":"This page will step you through creating your own alternative backend in the form\\nof a simple word counting program. Although it will be written in Rust, there’s\\nno reason why it couldn’t be accomplished using something like Python or Ruby. First you’ll want to create a new binary program and add mdbook-renderer as a\\ndependency. $ cargo new --bin mdbook-wordcount\\n$ cd mdbook-wordcount\\n$ cargo add mdbook-renderer When our mdbook-wordcount plugin is invoked, mdbook will send it a JSON\\nversion of RenderContext via our plugin’s stdin. For convenience, there’s\\na RenderContext::from_json() constructor which will load a RenderContext. This is all the boilerplate necessary for our backend to load the book. // src/main.rs\\nuse std::io;\\nuse mdbook_renderer::RenderContext; fn main() { let mut stdin = io::stdin(); let ctx = RenderContext::from_json(&mut stdin).unwrap();\\n} Note: The RenderContext contains a version field. This lets backends\\nfigure out whether they are compatible with the version of mdbook it’s being\\ncalled by. This version comes directly from the corresponding field in mdbook’s Cargo.toml. It is recommended that backends use the semver crate to inspect this field\\nand emit a warning if there may be a compatibility issue.","breadcrumbs":"For developers » Alternative backends » Setting up","id":"80","title":"Setting up"},"81":{"body":"Now our backend has a copy of the book, lets count how many words are in each\\nchapter! Because the RenderContext contains a Book field ( book), and a Book has\\nthe Book::iter() method for iterating over all items in a Book, this step\\nturns out to be just as easy as the first. fn main() { let mut stdin = io::stdin(); let ctx = RenderContext::from_json(&mut stdin).unwrap(); for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item { let num_words = count_words(ch); println!(\\"{}: {}\\", ch.name, num_words); } }\\n} fn count_words(ch: &Chapter) -> usize { ch.content.split_whitespace().count()\\n}","breadcrumbs":"For developers » Alternative backends » Inspecting the book","id":"81","title":"Inspecting the book"},"82":{"body":"Now we’ve got the basics running, we want to actually use it. First, install the\\nprogram. $ cargo install --path . Then cd to the particular book you’d like to count the words of and update its book.toml file. [book] title = \\"mdBook Documentation\\" description = \\"Create book from markdown files. Like Gitbook but implemented in Rust\\" authors = [\\"Mathieu David\\", \\"Michael-F-Bryan\\"] + [output.html] + [output.wordcount] When it loads a book into memory, mdbook will inspect your book.toml file to\\ntry and figure out which backends to use by looking for all output.* tables.\\nIf none are provided it’ll fall back to using the default HTML renderer. Notably, this means if you want to add your own custom backend you’ll also need\\nto make sure to add the HTML backend, even if its table just stays empty. Now you just need to build your book like normal, and everything should Just\\nWork. $ mdbook build\\n...\\n2018-01-16 07:31:15 [INFO] (mdbook::renderer): Invoking the \\"mdbook-wordcount\\" renderer\\nmdBook: 126\\nCommand Line Tool: 224\\ninit: 283\\nbuild: 145\\nwatch: 146\\nserve: 292\\ntest: 139\\nFormat: 30\\nSUMMARY.md: 259\\nConfiguration: 784\\nTheme: 304\\nindex.hbs: 447\\nSyntax highlighting: 314\\nMathJax Support: 153\\nRust code specific features: 148\\nFor Developers: 788\\nAlternative Backends: 710\\nContributors: 85 The reason we didn’t need to specify the full name/path of our wordcount\\nbackend is because mdbook will try to infer the program’s name via\\nconvention. The executable for the foo backend is typically called mdbook-foo, with an associated [output.foo] entry in the book.toml. To\\nexplicitly tell mdbook what command to invoke (it may require command-line\\narguments or be an interpreted script), you can use the command field. [book] title = \\"mdBook Documentation\\" description = \\"Create book from markdown files. Like Gitbook but implemented in Rust\\" authors = [\\"Mathieu David\\", \\"Michael-F-Bryan\\"] [output.html] [output.wordcount]\\n+ command = \\"python /path/to/wordcount.py\\"","breadcrumbs":"For developers » Alternative backends » Enabling the backend","id":"82","title":"Enabling the backend"},"83":{"body":"Now imagine you don’t want to count the number of words on a particular chapter\\n(it might be generated text/code, etc). The canonical way to do this is via the\\nusual book.toml configuration file by adding items to your [output.foo]\\ntable. The Config can be treated roughly as a nested hashmap which lets you call\\nmethods like get() to access the config’s contents, with a get_deserialized() convenience method for retrieving a value and automatically\\ndeserializing to some arbitrary type T. To implement this, we’ll create our own serializable WordcountConfig struct\\nwhich will encapsulate all configuration for this backend. First add serde and serde_derive to your Cargo.toml, $ cargo add serde serde_derive And then you can create the config struct, #![allow(unused)] fn main() {\\nuse serde_derive::{Serialize, Deserialize}; ... #[derive(Debug, Default, Serialize, Deserialize)]\\n#[serde(default, rename_all = \\"kebab-case\\")]\\npub struct WordcountConfig { pub ignores: Vec<String>,\\n} } Now we just need to deserialize the WordcountConfig from our RenderContext\\nand then add a check to make sure we skip ignored chapters. fn main() { let mut stdin = io::stdin(); let ctx = RenderContext::from_json(&mut stdin).unwrap();\\n+ let cfg: WordcountConfig = ctx.config\\n+ .get_deserialized(\\"output.wordcount\\")\\n+ .unwrap_or_default(); for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item {\\n+ if cfg.ignores.contains(&ch.name) {\\n+ continue;\\n+ }\\n+ let num_words = count_words(ch); println!(\\"{}: {}\\", ch.name, num_words); } } }","breadcrumbs":"For developers » Alternative backends » Configuration","id":"83","title":"Configuration"},"84":{"body":"While it’s nice to print word counts to the terminal when a book is built, it\\nmight also be a good idea to output them to a file somewhere. mdbook tells a\\nbackend where it should place any generated output via the destination field\\nin RenderContext. + use std::fs::{self, File};\\n+ use std::io::{self, Write};\\n- use std::io; use mdbook::renderer::RenderContext; use mdbook::book::{BookItem, Chapter}; fn main() { ... + let _ = fs::create_dir_all(&ctx.destination);\\n+ let mut f = File::create(ctx.destination.join(\\"wordcounts.txt\\")).unwrap();\\n+ for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item { ... let num_words = count_words(ch); println!(\\"{}: {}\\", ch.name, num_words);\\n+ writeln!(f, \\"{}: {}\\", ch.name, num_words).unwrap(); } } } Note: There is no guarantee that the destination directory exists or is\\nempty ( mdbook may leave the previous contents to let backends do caching),\\nso it’s always a good idea to create it with fs::create_dir_all(). If the destination directory already exists, don’t assume it will be empty.\\nTo allow backends to cache the results from previous runs, mdbook may leave\\nold content in the directory. There’s always the possibility that an error will occur while processing a book\\n(just look at all the unwrap()’s we’ve written already), so mdbook will\\ninterpret a non-zero exit code as a rendering failure. For example, if we wanted to make sure all chapters have an even number of\\nwords, erroring out if an odd number is encountered, then you may do something\\nlike this: + use std::process; ... fn main() { ... for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item { ... let num_words = count_words(ch); println!(\\"{}: {}\\", ch.name, num_words); writeln!(f, \\"{}: {}\\", ch.name, num_words).unwrap(); + if cfg.deny_odds && num_words % 2 == 1 {\\n+ eprintln!(\\"{} has an odd number of words!\\", ch.name);\\n+ process::exit(1);\\n+ } } } } #[derive(Debug, Default, Serialize, Deserialize)] #[serde(default, rename_all = \\"kebab-case\\")] pub struct WordcountConfig { pub ignores: Vec<String>,\\n+ pub deny_odds: bool, } Now, if we reinstall the backend and build a book, $ cargo install --path . --force\\n$ mdbook build /path/to/book\\n...\\n2018-01-16 21:21:39 [INFO] (mdbook::renderer): Invoking the \\"wordcount\\" renderer\\nmdBook: 126\\nCommand Line Tool: 224\\ninit: 283\\ninit has an odd number of words!\\n2018-01-16 21:21:39 [ERROR] (mdbook::renderer): Renderer exited with non-zero return code.\\n2018-01-16 21:21:39 [ERROR] (mdbook::utils): Error: Rendering failed\\n2018-01-16 21:21:39 [ERROR] (mdbook::utils): Caused By: The \\"mdbook-wordcount\\" renderer failed As you’ve probably already noticed, output from the plugin’s subprocess is\\nimmediately passed through to the user. It is encouraged for plugins to follow\\nthe “rule of silence” and only generate output when necessary (e.g. an error in\\ngeneration or a warning). All environment variables are passed through to the backend, allowing you to use\\nthe usual MDBOOK_LOG to control logging verbosity.","breadcrumbs":"For developers » Alternative backends » Output and signalling failure","id":"84","title":"Output and signalling failure"},"85":{"body":"Although contrived, hopefully this example was enough to show how you’d create\\nan alternative backend for mdbook. If you feel it’s missing something, don’t\\nhesitate to create an issue in the issue tracker so we can improve the user\\nguide. The existing backends mentioned towards the start of this chapter should serve\\nas a good example of how it’s done in real life, so feel free to skim through\\nthe source code or ask questions.","breadcrumbs":"For developers » Alternative backends » Wrapping up","id":"85","title":"Wrapping up"},"86":{"body":"Here is a list of the contributors who have helped improving mdBook. Big\\nshout-out to them! mdinger Kevin ( kbknapp) Steve Klabnik ( steveklabnik) Adam Solove ( asolove) Wayne Nilsen ( waynenilsen) funnkill Fu Gangqiang ( FuGangqiang) Michael-F-Bryan Chris Spiegel ( cspiegel) projektir Phaiax Matt Ickstadt ( mattico) Weihang Lo ( weihanglo) Avision Ho ( avisionh) Vivek Akupatni ( apatniv) Eric Huss ( ehuss) Josh Rotenberg ( joshrotenberg) If you feel you’re missing from this list, feel free to add yourself in a PR.","breadcrumbs":"Contributors » Contributors","id":"86","title":"Contributors"},"9":{"body":"The menu bar at the top of the page provides some icons for interacting with the book.\\nThe icons displayed will depend on the settings of how the book was generated. Icon Description Opens and closes the chapter listing sidebar. Opens a picker to choose a different color theme. Opens a search bar for searching within the book. Instructs the web browser to print the entire book. Opens a link to the website that hosts the source code of the book. Opens a page to directly edit the source of the page you are currently reading. Tapping the menu bar will scroll the page to the top.","breadcrumbs":"Reading books » Top menu bar","id":"9","title":"Top menu bar"}},"length":87,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"4":{".":{"2":{"1":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.7320508075688772}}},"5":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"2":{"df":2,"docs":{"0":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":2.0}}},"7":{":":{"3":{"1":{":":{"1":{"5":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"36":{"tf":1.7320508075688772},"42":{"tf":2.6457513110645907},"67":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0}}},"1":{".":{"2":{".":{"1":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"8":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"7":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"5":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"55":{"tf":1.0}}},"2":{"6":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}},"7":{".":{"0":{".":{"0":{".":{"1":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"2":{"5":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"4":{".":{"1":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"3":{"3":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"82":{"tf":1.0}}},"6":{"df":1,"docs":{"82":{"tf":1.0}}},"8":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"82":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}}},"6":{".":{"6":{"2":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"42":{"tf":2.449489742783178},"82":{"tf":1.0},"84":{"tf":2.0}},"h":{"4":{"8":{"df":0,"docs":{},"v":{"9":{"6":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"z":{"df":0,"docs":{},"m":{"4":{"8":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"2":{"5":{"6":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"7":{".":{"6":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"7":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"df":0,"docs":{},"v":{"7":{"7":{".":{"2":{"5":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":11,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":2.23606797749979},"49":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}},"2":{".":{"1":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}},"8":{"df":3,"docs":{"27":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":2.0}}},"df":0,"docs":{}},"3":{"5":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"2":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},":":{"2":{"1":{":":{"3":{"9":{"df":1,"docs":{"84":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"6":{"3":{"df":1,"docs":{"42":{"tf":1.0}},"l":{"3":{"9":{"3":{".":{"3":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}},"h":{"1":{"2":{"8":{"df":0,"docs":{},"v":{"6":{"4":{"df":0,"docs":{},"h":{"1":{"9":{"2":{"df":0,"docs":{},"v":{"4":{"8":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"4":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":2.8284271247461903}},"s":{"2":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"z":{"\\"":{"/":{">":{"<":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{">":{"<":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"6":{"df":0,"docs":{},"h":{"1":{"2":{"8":{"df":0,"docs":{},"v":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"9":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"8":{".":{"6":{"5":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"9":{"2":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"36":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"67":{"tf":1.0},"84":{"tf":1.0}}},"3":{".":{"3":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"82":{"tf":1.0}}},"df":2,"docs":{"36":{"tf":2.0},"82":{"tf":1.0}}},"1":{"4":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"42":{"tf":2.0}},"h":{"3":{"2":{"0":{"c":{"1":{"7":{".":{"6":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"1":{"6":{"0":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}}},"5":{".":{"3":{"5":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"3":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"36":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772}}},"4":{"0":{"4":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"36":{"tf":1.7320508075688772},"71":{"tf":2.23606797749979}}},"df":0,"docs":{}},"4":{"7":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"5":{"1":{"2":{"\\"":{">":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951}}},"6":{"4":{"df":1,"docs":{"42":{"tf":2.6457513110645907}},"v":{"1":{"1":{"2":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":3,"docs":{"42":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"7":{".":{"1":{"6":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"2":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"8":{"4":{"df":1,"docs":{"82":{"tf":1.0}}},"8":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"4":{"9":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"8":{"4":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"9":{".":{"3":{"7":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}},"h":{"9":{"6":{"c":{"7":{"8":{".":{"3":{"3":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":0,"docs":{},"h":{"2":{"5":{"6":{"df":0,"docs":{},"v":{"9":{"6":{"df":0,"docs":{},"z":{"df":0,"docs":{},"m":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"c":{"8":{".":{"8":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"8":{"df":0,"docs":{},"f":{"4":{"2":{"8":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"_":{"df":1,"docs":{"38":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"_":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"_":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"_":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":3,"docs":{"38":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.0}}},"a":{"b":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\\"":{"a":{"df":1,"docs":{"76":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":8,"docs":{"33":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"78":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"36":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"r":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"68":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"86":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"e":{"(":{"2":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":18,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"27":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}},"df":13,"docs":{"14":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951}}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"11":{"tf":1.0},"52":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":16,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"25":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"80":{"tf":1.0},"85":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"28":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"\\\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{":":{"\\\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":2,"docs":{"55":{"tf":3.0},"56":{"tf":1.4142135623730951}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.4142135623730951},"36":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"b":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"!":{"(":{"\\"":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"!":{"!":{"1":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"42":{"tf":1.0}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.0}}}},"i":{"df":2,"docs":{"0":{"tf":1.0},"74":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"36":{"tf":2.23606797749979},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":1,"docs":{"36":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\\"":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"7":{"tf":1.0},"84":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"67":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":2.23606797749979},"57":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"28":{"tf":1.0}}},"df":6,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}}},"o":{"df":2,"docs":{"16":{"tf":1.0},"23":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"8":{"tf":1.0},"83":{"tf":1.0}}}},"df":4,"docs":{"0":{"tf":1.0},"21":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"4":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"25":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.4142135623730951}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"38":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":3.872983346207417},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"80":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":2.6457513110645907},"83":{"tf":1.0},"84":{"tf":2.23606797749979},"85":{"tf":1.4142135623730951}},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"36":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.0}},"e":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0}}},"h":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"i":{"c":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"61":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"67":{"tf":2.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.0}}}}},"df":4,"docs":{"11":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.0},"75":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":1.0}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"51":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"11":{"tf":1.0},"25":{"tf":1.7320508075688772},"3":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}},"n":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"39":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}}}},"d":{"df":2,"docs":{"31":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":3,"docs":{"5":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0}}},"t":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"40":{"tf":1.0},"75":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"0":{"tf":1.0},"11":{"tf":2.0},"21":{"tf":2.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"67":{"tf":1.0},"77":{"tf":1.0}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"\'":{"df":1,"docs":{"78":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"|":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"j":{"df":2,"docs":{"39":{"tf":1.0},"48":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":27,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}},"[":{"\'":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"\'":{"]":{"[":{"0":{"]":{"[":{"\'":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\'":{"]":{"[":{"\'":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":52,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":3.1622776601683795},"14":{"tf":3.3166247903554},"15":{"tf":2.23606797749979},"16":{"tf":2.23606797749979},"17":{"tf":3.605551275463989},"18":{"tf":2.449489742783178},"19":{"tf":2.449489742783178},"20":{"tf":2.6457513110645907},"21":{"tf":2.6457513110645907},"22":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":2.449489742783178},"26":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"28":{"tf":4.123105625617661},"29":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":3.4641016151377544},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.6457513110645907},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":3.605551275463989},"77":{"tf":2.449489742783178},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.449489742783178},"82":{"tf":2.6457513110645907},"84":{"tf":1.7320508075688772},"9":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"]":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"’":{"df":9,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"72":{"tf":1.0}}}},"l":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":3.4641016151377544}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"33":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"67":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}}},"d":{"df":3,"docs":{"36":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":5,"docs":{"36":{"tf":2.0},"39":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"25":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"65":{"tf":1.0},"9":{"tf":1.0}},"’":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"38":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}},"g":{"df":1,"docs":{"1":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}},"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":26,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.8284271247461903},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"36":{"tf":1.0},"38":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"69":{"tf":2.8284271247461903},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":2.0},"66":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"\\"":{">":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"36":{"tf":2.23606797749979},"42":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":2.0},"8":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"21":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":11,"docs":{"17":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"80":{"tf":1.0},"83":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":7,"docs":{"21":{"tf":1.0},"5":{"tf":2.6457513110645907},"69":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"’":{"df":1,"docs":{"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"38":{"tf":1.4142135623730951},"41":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":5,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"69":{"tf":1.0},"84":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":2.0}}},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"d":{"df":3,"docs":{"13":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":3,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"&":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"83":{"tf":1.0}}}},"h":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":19,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":2.23606797749979},"20":{"tf":2.23606797749979},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"<":{"/":{"a":{">":{"<":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"2":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"3":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"4":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"1":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"17":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}}},"df":26,"docs":{"10":{"tf":1.0},"14":{"tf":3.872983346207417},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"25":{"tf":5.385164807134504},"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":3.3166247903554},"41":{"tf":2.449489742783178},"42":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":2.6457513110645907},"72":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":2.6457513110645907},"78":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"67":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}},"df":4,"docs":{"77":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"78":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}},"i":{"/":{"c":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"38":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"{":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"1":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"=":{"\\"":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"\\"":{">":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"36":{"tf":1.0},"59":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":2.449489742783178}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0}}}},"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"28":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"36":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":25,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"11":{"tf":3.0},"16":{"tf":1.0},"21":{"tf":2.449489742783178},"28":{"tf":1.7320508075688772},"36":{"tf":3.872983346207417},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"47":{"tf":2.0},"51":{"tf":2.0},"52":{"tf":2.8284271247461903},"53":{"tf":2.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"70":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"36":{"tf":1.4142135623730951},"46":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.0},"67":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"25":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"80":{"tf":1.0}}},"m":{"a":{"df":2,"docs":{"21":{"tf":1.0},"53":{"tf":1.0}},"n":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":26,"docs":{"0":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":2.449489742783178},"18":{"tf":2.0},"19":{"tf":2.0},"20":{"tf":2.6457513110645907},"21":{"tf":2.23606797749979},"22":{"tf":2.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":2.0},"35":{"tf":2.0},"38":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":2.0},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"82":{"tf":2.23606797749979},"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"11":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"69":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"23":{"tf":3.1622776601683795},"39":{"tf":1.0},"56":{"tf":1.7320508075688772},"61":{"tf":1.0},"67":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":10,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":21,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.7320508075688772}}}},"’":{"df":1,"docs":{"83":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"1":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"76":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"m":{"df":1,"docs":{"72":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":19,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":17,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"25":{"tf":2.449489742783178},"29":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"41":{"tf":1.0},"67":{"tf":2.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":5,"docs":{"15":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"68":{"tf":1.0},"83":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"82":{"tf":1.0},"86":{"tf":1.4142135623730951}},"s":{"]":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"85":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":2.23606797749979},"58":{"tf":1.0},"84":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"36":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"i":{"df":8,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":3.1622776601683795},"39":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.0}}},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"24":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"s":{"(":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":6,"docs":{"36":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"66":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"74":{"tf":1.7320508075688772},"77":{"tf":2.0},"80":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":30,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"46":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":5,"docs":{"27":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.7320508075688772},"44":{"tf":1.0},"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"x":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"76":{"tf":2.0},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{},"j":{"df":1,"docs":{"36":{"tf":1.0}}}},"2":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"0":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"0":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}},"d":{"=":{"\\"":{"df":0,"docs":{},"m":{"4":{"4":{"8":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"36":{"tf":2.0},"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":5,"docs":{"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"a":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.0},"77":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":31,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":2.449489742783178},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":3.7416573867739413},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":6.48074069840786},"37":{"tf":1.0},"39":{"tf":2.449489742783178},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":1,"docs":{"67":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"51":{"tf":1.0},"76":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"67":{"tf":3.4641016151377544}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"49":{"tf":2.23606797749979}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"42":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":4,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":2.6457513110645907}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"16":{"tf":1.0},"36":{"tf":1.0},"61":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.4142135623730951}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"36":{"tf":1.0},"82":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"77":{"tf":1.0},"83":{"tf":2.0},"84":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0}}}},"t":{"df":5,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"29":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"79":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"78":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"35":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":2.23606797749979},"36":{"tf":1.0},"38":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":21,"docs":{"13":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":2.8284271247461903},"18":{"tf":2.8284271247461903},"19":{"tf":2.8284271247461903},"20":{"tf":3.0},"21":{"tf":2.6457513110645907},"22":{"tf":2.23606797749979},"28":{"tf":3.0},"35":{"tf":2.0},"36":{"tf":2.449489742783178},"39":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.7320508075688772}}},"y":{"=":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":10,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":2.23606797749979},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"59":{"tf":1.0}}}},"n":{"df":1,"docs":{"36":{"tf":1.0}}},"o":{"c":{"df":2,"docs":{"51":{"tf":1.0},"74":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"46":{"tf":1.0},"73":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"15":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"39":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":4,"docs":{"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":2.6457513110645907}}}},"w":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"74":{"tf":1.0}},"r":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}}},"x":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":5,"docs":{"36":{"tf":2.0},"49":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":11,"docs":{"10":{"tf":1.0},"14":{"tf":2.0},"20":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.23606797749979},"67":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":5,"docs":{"25":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"76":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"36":{"tf":3.4641016151377544},"47":{"tf":2.8284271247461903},"48":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"8":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"4":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":8,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":2.449489742783178},"53":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"36":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":2.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"37":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":4.47213595499958},"37":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"65":{"tf":1.0}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"28":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"76":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"85":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"77":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"58":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"38":{"tf":2.23606797749979},"84":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"{":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"r":{"(":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"84":{"tf":2.6457513110645907}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"c":{"df":3,"docs":{"17":{"tf":1.0},"25":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":33,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":2.449489742783178},"21":{"tf":2.23606797749979},"25":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":2.23606797749979},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":2.449489742783178},"36":{"tf":2.6457513110645907},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":3.7416573867739413},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":2.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"]":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"56":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"25":{"tf":1.0},"41":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.7320508075688772},"73":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"t":{"df":4,"docs":{"28":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"29":{"tf":1.0},"36":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"36":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"74":{"tf":1.0}}}},"n":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"31":{"tf":1.0},"82":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"s":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":7,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":4,"docs":{"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"3":{"2":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"78":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":2.449489742783178}}}}}},"df":3,"docs":{"36":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"53":{"tf":1.0},"84":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"72":{"tf":1.0},"76":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0}}},"s":{"df":5,"docs":{"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"36":{"tf":3.7416573867739413},"52":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"38":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":2.6457513110645907},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"46":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"80":{"tf":1.0},"82":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0}},"s":{":":{"2":{":":{"1":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.4142135623730951},"56":{"tf":1.0}}},":":{"1":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\\"":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":35,"docs":{"0":{"tf":1.0},"14":{"tf":4.123105625617661},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.8284271247461903},"18":{"tf":2.23606797749979},"19":{"tf":3.7416573867739413},"20":{"tf":3.1622776601683795},"24":{"tf":1.0},"25":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"29":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":4.58257569495584},"39":{"tf":4.242640687119285},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"54":{"tf":2.449489742783178},"55":{"tf":2.6457513110645907},"56":{"tf":2.0},"57":{"tf":2.0},"60":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}}},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"n":{"d":{"df":3,"docs":{"1":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":16,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":2.0},"38":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"x":{"df":3,"docs":{"1":{"tf":1.0},"39":{"tf":1.0},"69":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":14,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":2.23606797749979},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"28":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":20,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.0},"39":{"tf":1.7320508075688772},"42":{"tf":1.0},"60":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"o":{",":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":3.1622776601683795}},"e":{"[":{"^":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"c":{"df":3,"docs":{"17":{"tf":1.0},"53":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}}},"k":{"df":1,"docs":{"36":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":9,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"38":{"tf":1.0},"7":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}}},"df":3,"docs":{"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"28":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"r":{"a":{"c":{"df":1,"docs":{"49":{"tf":2.0}},"{":{"1":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"3":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"x":{"^":{"2":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":2.8284271247461903},"65":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}},"’":{"df":2,"docs":{"42":{"tf":1.0},"60":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"s":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}},"l":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":1,"docs":{"86":{"tf":1.0}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"36":{"tf":1.0},"55":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":18,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{":":{":":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{">":{"(":{"\\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"(":{"\\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{">":{"(":{"\\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":2,"docs":{"29":{"tf":1.0},"75":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}}},"df":3,"docs":{"36":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951},"71":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"4":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"20":{"tf":2.23606797749979}}}}}}},"l":{"a":{"b":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0}},"n":{"df":5,"docs":{"23":{"tf":1.0},"36":{"tf":1.4142135623730951},"51":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":4,"docs":{"21":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":1,"docs":{"73":{"tf":1.0}}},"o":{"d":{"df":6,"docs":{"14":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"25":{"tf":1.7320508075688772},"6":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"1":{"df":1,"docs":{"25":{"tf":1.0}}},"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"77":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"29":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":2.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"33":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":9,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":2.449489742783178},"39":{"tf":1.0},"63":{"tf":2.6457513110645907},"65":{"tf":1.7320508075688772},"67":{"tf":2.6457513110645907},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"1":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":3,"docs":{"25":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"67":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"’":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"55":{"tf":1.0},"78":{"tf":1.0}}}},"p":{"df":5,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"67":{"tf":1.4142135623730951},"86":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"29":{"tf":1.0},"42":{"tf":2.0},"56":{"tf":1.0},"75":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":12,"docs":{"14":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.0}},"’":{"df":2,"docs":{"11":{"tf":1.0},"14":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"11":{"tf":1.0},"36":{"tf":1.7320508075688772},"51":{"tf":3.1622776601683795},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"51":{"tf":2.449489742783178},"56":{"tf":1.0},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"36":{"tf":2.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"39":{"tf":1.0},"45":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"j":{"df":4,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772}}}},"df":9,"docs":{"0":{"tf":1.0},"10":{"tf":2.0},"11":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"53":{"tf":1.0},"67":{"tf":1.7320508075688772},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"o":{"df":1,"docs":{"86":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"72":{"tf":1.0},"76":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"49":{"tf":1.0},"85":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":22,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"69":{"tf":1.0}},"s":{":":{"/":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{"/":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{">":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"<":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{">":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{"?":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{"/":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{">":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"<":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{">":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":2,"docs":{"36":{"tf":1.0},"71":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"i":{".":{"df":2,"docs":{"28":{"tf":1.0},"55":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"56":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"36":{"tf":3.1622776601683795},"42":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":2.23606797749979},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"’":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"d":{"=":{"\\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"42":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.7320508075688772}},"e":{"a":{"df":1,"docs":{"84":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.7320508075688772},"35":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"=":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"14":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"75":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"55":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"36":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.7320508075688772},"72":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"46":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":25,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":2.449489742783178},"37":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.449489742783178},"55":{"tf":4.123105625617661},"56":{"tf":2.23606797749979},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"}":{"df":0,"docs":{},"}":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"b":{"df":3,"docs":{"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"82":{"tf":1.0}},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":16,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":3.3166247903554},"75":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}},"r":{"a":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"44":{"tf":1.0}},"t":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":3.3166247903554},"39":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"i":{"df":2,"docs":{"13":{"tf":1.0},"56":{"tf":1.7320508075688772}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"49":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}},"df":5,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":3,"docs":{"48":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"5":{"tf":3.1622776601683795},"69":{"tf":3.605551275463989},"70":{"tf":2.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"n":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":11,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.7320508075688772},"39":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"]":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":6,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"68":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"20":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"6":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"14":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":8,"docs":{"1":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"67":{"tf":1.4142135623730951},"80":{"tf":1.0},"85":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"38":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":2.0}}},"r":{"df":2,"docs":{"77":{"tf":1.0},"81":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"6":{"tf":1.0},"67":{"tf":1.0}}}}}},"’":{"df":6,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}}},"v":{"a":{"df":1,"docs":{"44":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":2.449489742783178},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"86":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":1,"docs":{"36":{"tf":2.8284271247461903}},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":7,"docs":{"38":{"tf":1.0},"44":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.0},"36":{"tf":1.0}}}}}},"k":{"b":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"a":{"b":{"df":3,"docs":{"38":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"14":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}}},"y":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":15,"docs":{"10":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.7320508075688772},"49":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"55":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"25":{"tf":1.0},"40":{"tf":1.0},"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":2.0},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"36":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"/":{"0":{".":{"5":{".":{"2":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"36":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"=":{"\\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"41":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":14,"docs":{"0":{"tf":1.7320508075688772},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"36":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951}}}},"x":{"df":1,"docs":{"75":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"25":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.7320508075688772},"35":{"tf":1.0},"40":{"tf":1.0}}}}}}},"df":1,"docs":{"21":{"tf":2.23606797749979}},"e":{"a":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}},"v":{"df":2,"docs":{"13":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0}}}},"t":{"df":5,"docs":{"51":{"tf":1.0},"67":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"25":{"tf":1.7320508075688772},"36":{"tf":2.8284271247461903},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0}}}}}},"i":{">":{"<":{"a":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"21":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"42":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":23,"docs":{"0":{"tf":1.0},"11":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.6457513110645907},"38":{"tf":1.0},"51":{"tf":2.6457513110645907},"52":{"tf":1.0},"55":{"tf":3.872983346207417},"56":{"tf":2.6457513110645907},"57":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.0},"67":{"tf":2.23606797749979},"72":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"k":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":13,"docs":{"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":2.8284271247461903},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"65":{"tf":3.1622776601683795},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"4":{"tf":1.0},"69":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"14":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"67":{"tf":2.8284271247461903},"79":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":11,"docs":{"10":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":4,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"51":{"tf":1.0},"65":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"20":{"tf":1.0}}}}}}},"t":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":2,"docs":{"31":{"tf":1.0},"69":{"tf":2.0}}}},"df":1,"docs":{"86":{"tf":1.0}},"g":{"df":1,"docs":{"84":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"25":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}},"o":{"]":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"59":{"tf":1.4142135623730951},"66":{"tf":2.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"k":{"df":14,"docs":{"27":{"tf":1.0},"36":{"tf":2.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"df":3,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"41":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":2.0}}}},"u":{"a":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":13,"docs":{"36":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"36":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"81":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"56":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":20,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":2.6457513110645907},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"77":{"tf":2.449489742783178},"82":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907},"55":{"tf":1.7320508075688772},"67":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"\\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"h":{"df":1,"docs":{"49":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}},"j":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"25":{"tf":1.0},"36":{"tf":1.7320508075688772},"49":{"tf":2.6457513110645907},"75":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"86":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"=":{"\'":{"df":0,"docs":{},"{":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"38":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":58,"docs":{"0":{"tf":2.0},"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"16":{"tf":3.1622776601683795},"17":{"tf":2.6457513110645907},"18":{"tf":1.7320508075688772},"19":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":2.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":2.0},"25":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"35":{"tf":2.23606797749979},"36":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":3.1622776601683795},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":2.449489742783178},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":3.0},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"74":{"tf":2.6457513110645907},"76":{"tf":3.0},"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.6457513110645907},"82":{"tf":3.0},"84":{"tf":2.6457513110645907},"85":{"tf":1.0},"86":{"tf":1.0}},"’":{"df":2,"docs":{"61":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":2,"docs":{"18":{"tf":1.0},"65":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"72":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"73":{"tf":1.0},"82":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"85":{"tf":1.0}}}}}},"u":{"df":4,"docs":{"10":{"tf":1.0},"36":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"28":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":8,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"n":{"d":{"df":2,"docs":{"14":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"36":{"tf":1.0},"67":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0}}}},"t":{"df":2,"docs":{"42":{"tf":1.0},"60":{"tf":1.0}}},"x":{"df":1,"docs":{"25":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"d":{"df":1,"docs":{"76":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"55":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":10,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":26,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"38":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"67":{"tf":2.6457513110645907},"70":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"66":{"tf":1.0},"70":{"tf":1.0}}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"21":{"tf":1.4142135623730951},"3":{"tf":1.0},"36":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":1.0}}}},"df":6,"docs":{"52":{"tf":1.0},"77":{"tf":2.6457513110645907},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":20,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}}}},"v":{"df":1,"docs":{"36":{"tf":1.4142135623730951}},"i":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"39":{"tf":1.0}},"g":{"df":5,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"36":{"tf":2.0},"71":{"tf":1.0},"8":{"tf":2.0}}}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":21,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"40":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"25":{"tf":1.4142135623730951},"38":{"tf":1.0},"7":{"tf":1.0},"83":{"tf":1.0}}}},"w":{"df":15,"docs":{"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.4142135623730951},"69":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"39":{"tf":1.0},"5":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"25":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"44":{"tf":1.0}}},"x":{"df":1,"docs":{"44":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"77":{"tf":1.0},"82":{"tf":1.0}}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"76":{"tf":3.1622776601683795}},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"25":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":12,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"67":{"tf":2.0},"80":{"tf":1.0},"84":{"tf":1.0}}},"h":{"df":1,"docs":{"76":{"tf":1.4142135623730951}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"c":{"df":2,"docs":{"67":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"w":{"df":8,"docs":{"39":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.23606797749979}},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"25":{"tf":3.0},"36":{"tf":2.8284271247461903},"47":{"tf":2.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0}}}}},"df":1,"docs":{"56":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}},"h":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"k":{"(":{"_":{"df":1,"docs":{"76":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":1,"docs":{"77":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{":":{":":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}},"l":{"d":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":7,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}},"df":11,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":2.23606797749979},"39":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":2.0},"74":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.0}}}}},"p":{"df":1,"docs":{"76":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":2.23606797749979}}},"r":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":24,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":3.4641016151377544},"37":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"25":{"tf":1.0},"33":{"tf":1.4142135623730951},"47":{"tf":1.0},"64":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"71":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":13,"docs":{"13":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.7320508075688772},"74":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"35":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{".":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"36":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"36":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"27":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"71":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":2.0},"82":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":24,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":2.449489742783178},"36":{"tf":2.6457513110645907},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":2.23606797749979}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"46":{"tf":1.0}}}},"df":4,"docs":{"39":{"tf":1.0},"51":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"df":6,"docs":{"22":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"36":{"tf":1.4142135623730951},"45":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}}}},"p":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":18,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":4.0},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":2.8284271247461903},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":2.0}}}},"i":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":3,"docs":{"36":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}},"s":{"df":6,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"25":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.0}}}}},"t":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"25":{"tf":2.6457513110645907},"55":{"tf":1.0},"76":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"56":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"53":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":18,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"4":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":2,"docs":{"20":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"15":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"35":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"y":{"df":3,"docs":{"52":{"tf":1.7320508075688772},"53":{"tf":2.0},"57":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"11":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}},"’":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"28":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"65":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.0},"67":{"tf":2.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"25":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"86":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.0},"76":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"4":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"77":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"25":{"tf":2.6457513110645907},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"51":{"tf":3.1622776601683795}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"41":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"32":{"tf":1.0},"76":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}}},"k":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}}}}}}}},"df":16,"docs":{"0":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.0},"29":{"tf":3.0},"30":{"tf":2.8284271247461903},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":1.4142135623730951},"37":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":5.196152422706632},"77":{"tf":2.449489742783178},"78":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"18":{"tf":1.0}}}}},"s":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"23":{"tf":1.0},"8":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\\"":{">":{"<":{"/":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":7,"docs":{"23":{"tf":1.0},"36":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"11":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"51":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"69":{"tf":1.0},"76":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":11,"docs":{"28":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.0}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"21":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"73":{"tf":1.0}},"’":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":13,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":3.0},"47":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":4,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}},"df":4,"docs":{"1":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"25":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"t":{"df":4,"docs":{"28":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}},"k":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"w":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":2,"docs":{"44":{"tf":1.0},"76":{"tf":1.0}},"e":{"a":{"d":{"df":6,"docs":{"1":{"tf":1.0},"25":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"53":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"i":{"df":1,"docs":{"17":{"tf":1.0}}},"m":{"df":1,"docs":{"65":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"61":{"tf":1.0},"85":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"69":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"39":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"36":{"tf":1.0},"77":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":1.0},"36":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"36":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"=":{"\\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":13,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"69":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":3,"docs":{"11":{"tf":1.0},"28":{"tf":1.0},"55":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}},"v":{"df":6,"docs":{"10":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"77":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"36":{"tf":1.7320508075688772},"42":{"tf":1.0},"45":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}}}}},"df":33,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":2.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"37":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"57":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":3.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":5,"docs":{"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"65":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":2.6457513110645907}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"36":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"5":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"45":{"tf":1.0},"56":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}},"l":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":13,"docs":{"10":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"27":{"tf":1.0},"36":{"tf":3.872983346207417},"37":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"56":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":15,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"36":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"u":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"84":{"tf":1.0}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":25,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":2.23606797749979},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"36":{"tf":1.4142135623730951},"47":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"57":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"53":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},".":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"29":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":5,"docs":{"21":{"tf":2.23606797749979},"37":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}},"’":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"df":23,"docs":{"0":{"tf":2.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"21":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"36":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":2.23606797749979},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":2.23606797749979},"56":{"tf":2.0},"57":{"tf":2.23606797749979},"59":{"tf":1.0},"66":{"tf":1.7320508075688772},"69":{"tf":2.0},"70":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.7320508075688772}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"36":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":6,"docs":{"23":{"tf":1.4142135623730951},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"69":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":3,"docs":{"10":{"tf":1.0},"41":{"tf":1.0},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":2.449489742783178},"21":{"tf":1.0},"36":{"tf":5.385164807134504},"69":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"55":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"16":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"36":{"tf":3.0},"39":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":20,"docs":{"11":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":2.6457513110645907},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}},"n":{".":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.0},"59":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"69":{"tf":1.0},"80":{"tf":1.0}}}}}},"n":{"d":{"df":2,"docs":{"52":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"14":{"tf":1.0},"25":{"tf":2.0},"35":{"tf":1.0},"38":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":2,"docs":{"69":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":3.3166247903554},"28":{"tf":1.0},"69":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}},"e":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.7320508075688772},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"i":{"c":{"df":5,"docs":{"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"t":{"df":16,"docs":{"14":{"tf":1.7320508075688772},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":3.3166247903554},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"16":{"tf":1.0},"23":{"tf":2.449489742783178},"44":{"tf":1.0},"76":{"tf":1.0}},"’":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"w":{"df":7,"docs":{"10":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"72":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0}},"n":{"df":4,"docs":{"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"59":{"tf":1.0},"78":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"36":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"25":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"14":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":3,"docs":{"66":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"38":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"36":{"tf":2.449489742783178},"71":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"85":{"tf":1.0}}},"p":{"df":2,"docs":{"17":{"tf":1.0},"83":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"67":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"28":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772}}}}}}}},"o":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"36":{"tf":1.0},"42":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"(":{"\\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":19,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"51":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"42":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":17,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"82":{"tf":1.0}},"i":{"df":17,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":2.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"56":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"0":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"c":{"/":{"4":{"0":{"4":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"=":{"\\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":2.6457513110645907},"39":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"16":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":2.23606797749979},"38":{"tf":1.0},"76":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"14":{"tf":1.0},"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}}},"y":{"df":1,"docs":{"82":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"1":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"1":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":7,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"15":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}},"k":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":2,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":2.0}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"52":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":5,"docs":{"36":{"tf":2.0},"38":{"tf":1.4142135623730951},"51":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"55":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"36":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}}},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"14":{"tf":1.0},"25":{"tf":1.4142135623730951},"7":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"28":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"m":{"_":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"=":{"0":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":2.23606797749979},"25":{"tf":2.0}}},"y":{".":{"df":0,"docs":{},"m":{"d":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"14":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"28":{"tf":1.0},"41":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":16,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":2.449489742783178},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":2.23606797749979},"55":{"tf":1.0},"67":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"g":{"df":4,"docs":{"39":{"tf":1.0},"42":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"78":{"tf":1.0}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":12,"docs":{"0":{"tf":1.7320508075688772},"25":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"[":{"1":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":7,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":2.0},"74":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":2,"docs":{"23":{"tf":1.0},"53":{"tf":1.0}},"l":{"df":14,"docs":{"25":{"tf":2.0},"28":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.6457513110645907},"36":{"tf":3.4641016151377544},"37":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":2.23606797749979},"76":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"42":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.0}},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"p":{"df":2,"docs":{"51":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":1,"docs":{"69":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":2.6457513110645907}}}}},"df":1,"docs":{"83":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":2.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"76":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"67":{"tf":3.3166247903554}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"84":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":13,"docs":{"0":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":4.0},"28":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":2.6457513110645907},"56":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":2.23606797749979},"36":{"tf":1.7320508075688772},"62":{"tf":2.0},"63":{"tf":2.0},"65":{"tf":1.0},"67":{"tf":3.605551275463989},"77":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":2.23606797749979},"24":{"tf":1.0},"36":{"tf":3.605551275463989},"39":{"tf":3.872983346207417},"43":{"tf":1.0},"45":{"tf":2.6457513110645907},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.0}}}}},"’":{"df":3,"docs":{"70":{"tf":1.0},"80":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}},"k":{"df":2,"docs":{"17":{"tf":1.0},"46":{"tf":1.0}}}},"r":{"d":{"df":5,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"36":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"25":{"tf":1.0},"42":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":8,"docs":{"33":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}},"w":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"df":2,"docs":{"11":{"tf":1.0},"25":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"17":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"l":{"df":13,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":2.0},"25":{"tf":3.4641016151377544},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":2.23606797749979},"58":{"tf":2.23606797749979},"76":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.4142135623730951}},"e":{"=":{"\\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"c":{"df":1,"docs":{"42":{"tf":1.7320508075688772}},"}":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"df":0,"docs":{},"{":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"51":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"3":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"p":{"df":6,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"58":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.0},"77":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"85":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":8,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"28":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":5.830951894845301},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"77":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"61":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":5,"docs":{"31":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"83":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":4,"docs":{"14":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"df":1,"docs":{"39":{"tf":1.0}}},"l":{"df":1,"docs":{"42":{"tf":2.0}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"28":{"tf":1.4142135623730951},"49":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"35":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":2,"docs":{"11":{"tf":1.0},"47":{"tf":1.0}}}},"df":1,"docs":{"39":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"41":{"tf":1.0},"45":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{"df":0,"docs":{},"’":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.7320508075688772},"80":{"tf":1.0},"85":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}},"l":{"df":6,"docs":{"14":{"tf":1.0},"36":{"tf":3.4641016151377544},"65":{"tf":2.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":54,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"18":{"tf":1.7320508075688772},"19":{"tf":3.0},"20":{"tf":3.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":2.0},"28":{"tf":3.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":3.7416573867739413},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":3.1622776601683795},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":2.23606797749979},"49":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"63":{"tf":1.0},"65":{"tf":2.0},"67":{"tf":2.0},"68":{"tf":1.0},"69":{"tf":2.8284271247461903},"70":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":3.3166247903554},"77":{"tf":3.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":2.0},"82":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"25":{"tf":1.0},"36":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"77":{"tf":1.0},"81":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"v":{"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"23":{"tf":1.0},"36":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":13,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}}}},"r":{"df":1,"docs":{"42":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"26":{"tf":1.0},"38":{"tf":2.449489742783178},"39":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.0},"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"i":{"df":3,"docs":{"14":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":10,"docs":{"0":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":3.0},"60":{"tf":1.0},"69":{"tf":3.0},"70":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":2.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}}},"i":{"a":{"df":10,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"=":{"\\"":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"36":{"tf":1.0},"65":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":2.449489742783178},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"16":{"tf":1.0},"19":{"tf":2.6457513110645907},"20":{"tf":1.0},"28":{"tf":2.23606797749979},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"y":{"df":8,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}},"n":{"df":1,"docs":{"86":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{},"e":{"\'":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"b":{"df":10,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.7320508075688772},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"13":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.0},"45":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"v":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"+":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"36":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":5,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"25":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"83":{"tf":2.0},"84":{"tf":1.0}}}}}}}},"df":4,"docs":{"35":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}}}}},"df":7,"docs":{"10":{"tf":1.0},"36":{"tf":3.1622776601683795},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0}}},"df":0,"docs":{},"k":{"df":13,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":2.23606797749979},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}},"l":{"d":{"df":3,"docs":{"11":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":5,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":7,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"25":{"tf":1.4142135623730951},"36":{"tf":1.0},"67":{"tf":2.23606797749979},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":4,"docs":{"49":{"tf":1.4142135623730951},"51":{"tf":2.0},"56":{"tf":2.23606797749979},"67":{"tf":1.0}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"=":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"w":{"3":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"2":{"0":{"0":{"0":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":1,"docs":{"51":{"tf":2.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"45":{"tf":1.0},"5":{"tf":1.0},"86":{"tf":1.0}}}}}}},"’":{"d":{"df":3,"docs":{"1":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"71":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":1,"docs":{"86":{"tf":1.0}}},"v":{"df":2,"docs":{"15":{"tf":1.0},"84":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"_":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}}},"breadcrumbs":{"root":{"0":{".":{"4":{".":{"2":{"1":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.7320508075688772}}},"5":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"2":{"df":2,"docs":{"0":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":2.0}}},"7":{":":{"3":{"1":{":":{"1":{"5":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"36":{"tf":1.7320508075688772},"42":{"tf":2.6457513110645907},"67":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0}}},"1":{".":{"2":{".":{"1":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"8":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"7":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"5":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"55":{"tf":1.0}}},"2":{"6":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}},"7":{".":{"0":{".":{"0":{".":{"1":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"2":{"5":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"4":{".":{"1":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"3":{"3":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"82":{"tf":1.0}}},"6":{"df":1,"docs":{"82":{"tf":1.0}}},"8":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"82":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}}},"6":{".":{"6":{"2":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"42":{"tf":2.449489742783178},"82":{"tf":1.0},"84":{"tf":2.0}},"h":{"4":{"8":{"df":0,"docs":{},"v":{"9":{"6":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"z":{"df":0,"docs":{},"m":{"4":{"8":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"2":{"5":{"6":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"7":{".":{"6":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"7":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"df":0,"docs":{},"v":{"7":{"7":{".":{"2":{"5":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":11,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":2.23606797749979},"49":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}},"2":{".":{"1":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}},"8":{"df":3,"docs":{"27":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":2.0}}},"df":0,"docs":{}},"3":{"5":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"2":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},":":{"2":{"1":{":":{"3":{"9":{"df":1,"docs":{"84":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"6":{"3":{"df":1,"docs":{"42":{"tf":1.0}},"l":{"3":{"9":{"3":{".":{"3":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}},"h":{"1":{"2":{"8":{"df":0,"docs":{},"v":{"6":{"4":{"df":0,"docs":{},"h":{"1":{"9":{"2":{"df":0,"docs":{},"v":{"4":{"8":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"4":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":2.8284271247461903}},"s":{"2":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"z":{"\\"":{"/":{">":{"<":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{">":{"<":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"6":{"df":0,"docs":{},"h":{"1":{"2":{"8":{"df":0,"docs":{},"v":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"9":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"8":{".":{"6":{"5":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"9":{"2":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"36":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"67":{"tf":1.0},"84":{"tf":1.0}}},"3":{".":{"3":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"82":{"tf":1.0}}},"df":2,"docs":{"36":{"tf":2.0},"82":{"tf":1.0}}},"1":{"4":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"42":{"tf":2.0}},"h":{"3":{"2":{"0":{"c":{"1":{"7":{".":{"6":{"7":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"1":{"6":{"0":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}}},"5":{".":{"3":{"5":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"3":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"36":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772}}},"4":{"0":{"4":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"36":{"tf":1.7320508075688772},"71":{"tf":2.23606797749979}}},"df":0,"docs":{}},"4":{"7":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"5":{"1":{"2":{"\\"":{">":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951}}},"6":{"4":{"df":1,"docs":{"42":{"tf":2.6457513110645907}},"v":{"1":{"1":{"2":{"c":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":3,"docs":{"42":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"7":{".":{"1":{"6":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"2":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"8":{"4":{"df":1,"docs":{"82":{"tf":1.0}}},"8":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"4":{"9":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"8":{"4":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"9":{".":{"3":{"7":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}},"h":{"9":{"6":{"c":{"7":{"8":{".":{"3":{"3":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":0,"docs":{},"h":{"2":{"5":{"6":{"df":0,"docs":{},"v":{"9":{"6":{"df":0,"docs":{},"z":{"df":0,"docs":{},"m":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"c":{"8":{".":{"8":{"4":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"8":{"df":0,"docs":{},"f":{"4":{"2":{"8":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"_":{"df":1,"docs":{"38":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"_":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"_":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"_":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":3,"docs":{"38":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.0}}},"a":{"b":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\\"":{"a":{"df":1,"docs":{"76":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":8,"docs":{"33":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"78":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"36":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"r":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"68":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"86":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.4142135623730951}},"e":{"(":{"2":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":18,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"27":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}},"df":13,"docs":{"14":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951}}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"11":{"tf":1.0},"52":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":16,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"25":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"80":{"tf":1.0},"85":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"28":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"\\\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{":":{"\\\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":2,"docs":{"55":{"tf":3.0},"56":{"tf":1.4142135623730951}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.4142135623730951},"36":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"b":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"!":{"(":{"\\"":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"!":{"!":{"1":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"42":{"tf":1.0}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.0}}}},"i":{"df":2,"docs":{"0":{"tf":1.0},"74":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"36":{"tf":2.23606797749979},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":1,"docs":{"36":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\\"":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"7":{"tf":1.0},"84":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"67":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"42":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":2.449489742783178},"57":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"28":{"tf":1.0}}},"df":6,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}}},"o":{"df":2,"docs":{"16":{"tf":1.0},"23":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"8":{"tf":1.0},"83":{"tf":1.0}}}},"df":4,"docs":{"0":{"tf":1.0},"21":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"4":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"25":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.7320508075688772}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"38":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":3.872983346207417},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"79":{"tf":2.8284271247461903},"80":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"82":{"tf":3.0},"83":{"tf":1.4142135623730951},"84":{"tf":2.449489742783178},"85":{"tf":1.7320508075688772}},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"36":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979}},"e":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0}}},"h":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"i":{"c":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"61":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"67":{"tf":2.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.0}}}}},"df":4,"docs":{"11":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.0},"75":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":1.0}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"51":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"11":{"tf":1.0},"25":{"tf":1.7320508075688772},"3":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}},"n":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"39":{"tf":1.0},"4":{"tf":2.23606797749979},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}}}},"d":{"df":2,"docs":{"31":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":3,"docs":{"5":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0}}},"t":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"40":{"tf":1.0},"75":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"0":{"tf":1.0},"11":{"tf":2.23606797749979},"21":{"tf":2.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"67":{"tf":1.0},"77":{"tf":1.0}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"\'":{"df":1,"docs":{"78":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"|":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"j":{"df":2,"docs":{"39":{"tf":1.0},"48":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":27,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}},"[":{"\'":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"\'":{"]":{"[":{"0":{"]":{"[":{"\'":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\'":{"]":{"[":{"\'":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":52,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":2.0},"13":{"tf":3.4641016151377544},"14":{"tf":3.605551275463989},"15":{"tf":2.6457513110645907},"16":{"tf":2.23606797749979},"17":{"tf":3.605551275463989},"18":{"tf":2.449489742783178},"19":{"tf":2.449489742783178},"20":{"tf":2.6457513110645907},"21":{"tf":2.6457513110645907},"22":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":2.449489742783178},"26":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"28":{"tf":4.123105625617661},"29":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":3.4641016151377544},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"71":{"tf":2.6457513110645907},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":3.605551275463989},"77":{"tf":2.449489742783178},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.6457513110645907},"82":{"tf":2.6457513110645907},"84":{"tf":1.7320508075688772},"9":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"]":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"’":{"df":9,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"72":{"tf":1.0}}}},"l":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":3.4641016151377544}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"33":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"67":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}}},"d":{"df":3,"docs":{"36":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":5,"docs":{"36":{"tf":2.0},"39":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"25":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"65":{"tf":1.0},"9":{"tf":1.0}},"’":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"38":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}},"g":{"df":1,"docs":{"1":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}},"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":26,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":3.1622776601683795},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"36":{"tf":1.0},"38":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.449489742783178},"69":{"tf":2.8284271247461903},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":2.0},"66":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"\\"":{">":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"36":{"tf":2.23606797749979},"42":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":2.0},"8":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"21":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":11,"docs":{"17":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"80":{"tf":1.0},"83":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":7,"docs":{"21":{"tf":1.0},"5":{"tf":2.6457513110645907},"69":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"’":{"df":1,"docs":{"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"38":{"tf":1.4142135623730951},"41":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":5,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"69":{"tf":1.0},"84":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":2.0}}},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"d":{"df":3,"docs":{"13":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":3,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"&":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"83":{"tf":1.0}}}},"h":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":19,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":2.23606797749979},"20":{"tf":2.23606797749979},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"<":{"/":{"a":{">":{"<":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"2":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"3":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"4":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"1":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"17":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}}},"df":26,"docs":{"10":{"tf":1.0},"14":{"tf":3.872983346207417},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"25":{"tf":5.385164807134504},"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":3.3166247903554},"41":{"tf":2.449489742783178},"42":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":2.6457513110645907},"72":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":2.6457513110645907},"78":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"67":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}},"df":4,"docs":{"77":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"78":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}},"i":{"/":{"c":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"38":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"{":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"1":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"=":{"\\"":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"\\"":{">":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"36":{"tf":1.0},"59":{"tf":2.0},"67":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0}}}},"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"28":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"36":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":25,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"11":{"tf":3.1622776601683795},"16":{"tf":1.0},"21":{"tf":2.449489742783178},"28":{"tf":1.7320508075688772},"36":{"tf":3.872983346207417},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"47":{"tf":2.0},"51":{"tf":2.23606797749979},"52":{"tf":2.8284271247461903},"53":{"tf":2.23606797749979},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"70":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"36":{"tf":1.4142135623730951},"46":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.0},"67":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"25":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"80":{"tf":1.0}}},"m":{"a":{"df":2,"docs":{"21":{"tf":1.0},"53":{"tf":1.0}},"n":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":26,"docs":{"0":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.6457513110645907},"17":{"tf":2.8284271247461903},"18":{"tf":2.449489742783178},"19":{"tf":2.449489742783178},"20":{"tf":3.0},"21":{"tf":2.6457513110645907},"22":{"tf":2.449489742783178},"23":{"tf":2.23606797749979},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":2.23606797749979},"35":{"tf":2.0},"38":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":2.0},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"82":{"tf":2.23606797749979},"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"11":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"69":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"23":{"tf":3.4641016151377544},"39":{"tf":1.0},"56":{"tf":1.7320508075688772},"61":{"tf":1.0},"67":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":10,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":24,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":3.0},"27":{"tf":2.0},"28":{"tf":3.0},"29":{"tf":1.7320508075688772},"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":2.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":2.0}}}},"’":{"df":1,"docs":{"83":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"1":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"76":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"m":{"df":1,"docs":{"72":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":19,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":17,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"25":{"tf":2.449489742783178},"29":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"41":{"tf":1.0},"67":{"tf":2.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":8,"docs":{"15":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":2.0},"6":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"82":{"tf":1.0},"86":{"tf":2.0}},"s":{"]":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"85":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"36":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"i":{"df":8,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":3.1622776601683795},"39":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.0}}},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"24":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"s":{"(":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":6,"docs":{"36":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"66":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"74":{"tf":1.7320508075688772},"77":{"tf":2.0},"80":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":31,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":2.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"46":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":5,"docs":{"27":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.7320508075688772},"44":{"tf":1.0},"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"x":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"76":{"tf":2.0},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{},"j":{"df":1,"docs":{"36":{"tf":1.0}}}},"2":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"0":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"0":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}},"d":{"=":{"\\"":{"df":0,"docs":{},"m":{"4":{"4":{"8":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"36":{"tf":2.0},"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":5,"docs":{"25":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"a":{"df":3,"docs":{"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.0},"77":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"34":{"tf":1.0},"37":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":31,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":2.449489742783178},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":3.7416573867739413},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":6.48074069840786},"37":{"tf":1.0},"39":{"tf":2.449489742783178},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":1,"docs":{"67":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"51":{"tf":1.0},"76":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"67":{"tf":3.4641016151377544}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"49":{"tf":2.23606797749979}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"42":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":4,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":2.8284271247461903}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"16":{"tf":1.0},"36":{"tf":1.0},"61":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.4142135623730951}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"36":{"tf":1.0},"82":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"77":{"tf":1.0},"83":{"tf":2.0},"84":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0}}}},"t":{"df":5,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":16,"docs":{"29":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"78":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"r":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"35":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":2.23606797749979},"36":{"tf":1.0},"38":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":21,"docs":{"13":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":2.8284271247461903},"18":{"tf":2.8284271247461903},"19":{"tf":2.8284271247461903},"20":{"tf":3.0},"21":{"tf":2.6457513110645907},"22":{"tf":2.23606797749979},"28":{"tf":3.0},"35":{"tf":2.0},"36":{"tf":2.449489742783178},"39":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.7320508075688772}}},"y":{"=":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":10,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":2.23606797749979},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"59":{"tf":1.0}}}},"n":{"df":1,"docs":{"36":{"tf":1.0}}},"o":{"c":{"df":2,"docs":{"51":{"tf":1.0},"74":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"46":{"tf":1.0},"73":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"15":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"39":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":4,"docs":{"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":2.6457513110645907}}}},"w":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"74":{"tf":1.0}},"r":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}}},"x":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":5,"docs":{"36":{"tf":2.0},"49":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":11,"docs":{"10":{"tf":1.0},"14":{"tf":2.0},"20":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.23606797749979},"67":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":5,"docs":{"25":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"76":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"36":{"tf":3.4641016151377544},"47":{"tf":2.8284271247461903},"48":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"8":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"4":{"df":2,"docs":{"28":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":8,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"48":{"tf":2.8284271247461903},"53":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"36":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":2.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"37":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":4.47213595499958},"37":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"65":{"tf":1.0}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"28":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"76":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"85":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"77":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"58":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"38":{"tf":2.6457513110645907},"84":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"{":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"r":{"(":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"84":{"tf":2.6457513110645907}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"c":{"df":3,"docs":{"17":{"tf":1.0},"25":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":33,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":2.449489742783178},"21":{"tf":2.23606797749979},"25":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":2.23606797749979},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":2.449489742783178},"36":{"tf":2.6457513110645907},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":3.7416573867739413},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":2.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"]":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"56":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"25":{"tf":1.0},"41":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.7320508075688772},"73":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"t":{"df":4,"docs":{"28":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"29":{"tf":1.0},"36":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"36":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"74":{"tf":1.0}}}},"n":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"31":{"tf":1.0},"82":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"s":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":7,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":2.449489742783178}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":4,"docs":{"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"3":{"2":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"78":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":2.449489742783178}}}}}},"df":3,"docs":{"36":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"53":{"tf":1.0},"84":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"72":{"tf":1.0},"76":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0}}},"s":{"df":5,"docs":{"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"36":{"tf":3.7416573867739413},"52":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"38":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":19,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":2.6457513110645907},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"46":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"80":{"tf":1.0},"82":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0}},"s":{":":{"2":{":":{"1":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.4142135623730951},"56":{"tf":1.0}}},":":{"1":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\\"":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":35,"docs":{"0":{"tf":1.0},"14":{"tf":4.123105625617661},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.8284271247461903},"18":{"tf":2.23606797749979},"19":{"tf":3.7416573867739413},"20":{"tf":3.1622776601683795},"24":{"tf":1.0},"25":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"29":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":4.58257569495584},"39":{"tf":4.242640687119285},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"54":{"tf":2.6457513110645907},"55":{"tf":2.8284271247461903},"56":{"tf":2.23606797749979},"57":{"tf":2.23606797749979},"60":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}}},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"n":{"d":{"df":3,"docs":{"1":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":16,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":2.0},"38":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"x":{"df":3,"docs":{"1":{"tf":1.0},"39":{"tf":1.0},"69":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":14,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":2.23606797749979},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"28":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":20,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.0},"39":{"tf":1.7320508075688772},"42":{"tf":1.0},"60":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"o":{",":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":3.1622776601683795}},"e":{"[":{"^":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"c":{"df":3,"docs":{"17":{"tf":1.0},"53":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}}},"k":{"df":1,"docs":{"36":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":50,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"24":{"tf":2.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}}},"df":3,"docs":{"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"28":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"r":{"a":{"c":{"df":1,"docs":{"49":{"tf":2.0}},"{":{"1":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"3":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"x":{"^":{"2":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":2.8284271247461903},"65":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}},"’":{"df":2,"docs":{"42":{"tf":1.0},"60":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"s":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}},"l":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":1,"docs":{"86":{"tf":1.0}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"36":{"tf":1.0},"55":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":18,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"36":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{":":{":":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{">":{"(":{"\\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"(":{"\\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{">":{"(":{"\\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":2,"docs":{"29":{"tf":1.0},"75":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}}},"df":3,"docs":{"36":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951},"71":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"4":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"20":{"tf":2.23606797749979}}}}}}},"l":{"a":{"b":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0}},"n":{"df":5,"docs":{"23":{"tf":1.0},"36":{"tf":1.4142135623730951},"51":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":4,"docs":{"21":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":1,"docs":{"73":{"tf":1.0}}},"o":{"d":{"df":6,"docs":{"14":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"25":{"tf":1.7320508075688772},"6":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"1":{"df":1,"docs":{"25":{"tf":1.0}}},"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"77":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"29":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":2.23606797749979},"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"36":{"tf":1.0},"42":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"33":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":9,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":2.449489742783178},"39":{"tf":1.0},"63":{"tf":2.8284271247461903},"65":{"tf":1.7320508075688772},"67":{"tf":2.6457513110645907},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"1":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":3,"docs":{"25":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"67":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"’":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"55":{"tf":1.0},"78":{"tf":1.0}}}},"p":{"df":5,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"67":{"tf":1.4142135623730951},"86":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"29":{"tf":1.0},"42":{"tf":2.23606797749979},"56":{"tf":1.0},"75":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":12,"docs":{"14":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.0}},"’":{"df":2,"docs":{"11":{"tf":1.0},"14":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"11":{"tf":1.0},"36":{"tf":1.7320508075688772},"51":{"tf":3.1622776601683795},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"51":{"tf":2.6457513110645907},"56":{"tf":1.4142135623730951},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"36":{"tf":2.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"39":{"tf":1.0},"45":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"j":{"df":4,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772}}}},"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":2.0},"11":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.7320508075688772},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}},"o":{"df":1,"docs":{"86":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"72":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"49":{"tf":1.0},"85":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":22,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"69":{"tf":1.0}},"s":{":":{"/":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{"/":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{">":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"<":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{">":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{"?":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{"/":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{">":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"<":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{">":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":2,"docs":{"36":{"tf":1.0},"71":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"i":{".":{"df":2,"docs":{"28":{"tf":1.0},"55":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"56":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"36":{"tf":3.1622776601683795},"42":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":2.449489742783178},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"’":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"d":{"=":{"\\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"42":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.7320508075688772}},"e":{"a":{"df":1,"docs":{"84":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.7320508075688772},"35":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"=":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"14":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"75":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"55":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"36":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.7320508075688772},"72":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"46":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":25,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":2.449489742783178},"37":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.6457513110645907},"55":{"tf":4.242640687119285},"56":{"tf":2.449489742783178},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"}":{"df":0,"docs":{},"}":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"b":{"df":5,"docs":{"39":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.0},"82":{"tf":1.0}},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":16,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":3.3166247903554},"75":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}},"r":{"a":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"44":{"tf":1.0}},"t":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":3.605551275463989},"39":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"i":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"56":{"tf":2.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"49":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}},"df":5,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":3,"docs":{"48":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":14,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":2.449489742783178},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":3.3166247903554},"6":{"tf":1.0},"69":{"tf":3.7416573867739413},"70":{"tf":2.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"n":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":11,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.7320508075688772},"39":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"]":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":9,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"20":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"6":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"14":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":8,"docs":{"1":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"67":{"tf":1.4142135623730951},"80":{"tf":1.0},"85":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"38":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":2.0}}},"r":{"df":2,"docs":{"77":{"tf":1.0},"81":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"6":{"tf":1.0},"67":{"tf":1.0}}}}}},"’":{"df":6,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}}},"v":{"a":{"df":1,"docs":{"44":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":2.449489742783178},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"86":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":1,"docs":{"36":{"tf":2.8284271247461903}},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":7,"docs":{"38":{"tf":1.0},"44":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.0},"36":{"tf":1.0}}}}}},"k":{"b":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"a":{"b":{"df":3,"docs":{"38":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"14":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}}},"y":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":15,"docs":{"10":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.7320508075688772},"49":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"55":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"25":{"tf":1.0},"40":{"tf":1.0},"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":2.0},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"36":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"/":{"0":{".":{"5":{".":{"2":{"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"36":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"=":{"\\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"41":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":14,"docs":{"0":{"tf":1.7320508075688772},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"36":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951}}}},"x":{"df":1,"docs":{"75":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"25":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.7320508075688772},"35":{"tf":1.0},"40":{"tf":1.0}}}}}}},"df":1,"docs":{"21":{"tf":2.23606797749979}},"e":{"a":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}},"v":{"df":2,"docs":{"13":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0}}}},"t":{"df":5,"docs":{"51":{"tf":1.0},"67":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"25":{"tf":1.7320508075688772},"36":{"tf":2.8284271247461903},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0}}}}}},"i":{">":{"<":{"a":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"21":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"2":{"tf":1.7320508075688772},"42":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":28,"docs":{"0":{"tf":1.0},"11":{"tf":1.7320508075688772},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.6457513110645907},"38":{"tf":1.0},"51":{"tf":2.8284271247461903},"52":{"tf":1.0},"55":{"tf":3.872983346207417},"56":{"tf":2.8284271247461903},"57":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.0},"67":{"tf":2.23606797749979},"72":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"k":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":13,"docs":{"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":2.8284271247461903},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"65":{"tf":3.3166247903554},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"4":{"tf":1.0},"69":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"14":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"64":{"tf":2.0},"67":{"tf":2.8284271247461903},"79":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":11,"docs":{"10":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":4,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"51":{"tf":1.0},"65":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"20":{"tf":1.0}}}}}}},"t":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"69":{"tf":2.0}}}},"df":1,"docs":{"86":{"tf":1.0}},"g":{"df":1,"docs":{"84":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"25":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}},"o":{"]":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"59":{"tf":1.4142135623730951},"66":{"tf":2.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"k":{"df":14,"docs":{"27":{"tf":1.0},"36":{"tf":2.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"p":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"df":3,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"41":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":2.0}}}},"u":{"a":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":13,"docs":{"36":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"36":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"81":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"56":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":24,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":2.8284271247461903},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"77":{"tf":2.449489742783178},"82":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907},"55":{"tf":1.7320508075688772},"67":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"\\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"h":{"df":1,"docs":{"49":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}},"j":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"25":{"tf":1.0},"36":{"tf":1.7320508075688772},"49":{"tf":3.0},"75":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"86":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"=":{"\'":{"df":0,"docs":{},"{":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"38":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":62,"docs":{"0":{"tf":2.0},"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"16":{"tf":3.1622776601683795},"17":{"tf":2.6457513110645907},"18":{"tf":1.7320508075688772},"19":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":2.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":2.0},"25":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"35":{"tf":2.23606797749979},"36":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":3.1622776601683795},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":2.449489742783178},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":3.1622776601683795},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"74":{"tf":2.8284271247461903},"76":{"tf":3.1622776601683795},"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.6457513110645907},"82":{"tf":3.0},"84":{"tf":2.6457513110645907},"85":{"tf":1.0},"86":{"tf":1.0}},"’":{"df":2,"docs":{"61":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":2,"docs":{"18":{"tf":1.0},"65":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"72":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"73":{"tf":1.0},"82":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"85":{"tf":1.0}}}}}},"u":{"df":4,"docs":{"10":{"tf":1.0},"36":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.0}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"28":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":8,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"n":{"d":{"df":2,"docs":{"14":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"36":{"tf":1.0},"67":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0}}}},"t":{"df":2,"docs":{"42":{"tf":1.0},"60":{"tf":1.0}}},"x":{"df":1,"docs":{"25":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"d":{"df":1,"docs":{"76":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"55":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":10,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":26,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"38":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"67":{"tf":2.6457513110645907},"70":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"66":{"tf":1.0},"70":{"tf":1.0}}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"21":{"tf":1.4142135623730951},"3":{"tf":1.0},"36":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":1.0}}}},"df":6,"docs":{"52":{"tf":1.0},"77":{"tf":2.6457513110645907},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":20,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}}}},"v":{"df":1,"docs":{"36":{"tf":1.4142135623730951}},"i":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"39":{"tf":1.0}},"g":{"df":5,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"36":{"tf":2.0},"71":{"tf":1.0},"8":{"tf":2.23606797749979}}}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":21,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"40":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"25":{"tf":1.4142135623730951},"38":{"tf":1.0},"7":{"tf":1.0},"83":{"tf":1.0}}}},"w":{"df":15,"docs":{"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.4142135623730951},"69":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"39":{"tf":1.0},"5":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"25":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"44":{"tf":1.0}}},"x":{"df":1,"docs":{"44":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"77":{"tf":1.0},"82":{"tf":1.0}}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"76":{"tf":3.1622776601683795}},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"25":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":12,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"67":{"tf":2.0},"80":{"tf":1.0},"84":{"tf":1.0}}},"h":{"df":1,"docs":{"76":{"tf":1.4142135623730951}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"c":{"df":2,"docs":{"67":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"w":{"df":8,"docs":{"39":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.23606797749979}},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"25":{"tf":3.0},"36":{"tf":2.8284271247461903},"47":{"tf":2.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0}}}}},"df":1,"docs":{"56":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}},"h":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"k":{"(":{"_":{"df":1,"docs":{"76":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":1,"docs":{"77":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{":":{":":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}},"l":{"d":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":7,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}},"df":11,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":2.23606797749979},"39":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":2.0},"74":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.0}}}}},"p":{"df":1,"docs":{"76":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":2.23606797749979}}},"r":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":24,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":3.605551275463989},"37":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"25":{"tf":1.0},"33":{"tf":1.7320508075688772},"47":{"tf":1.0},"64":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"71":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":13,"docs":{"13":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.7320508075688772},"74":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"35":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{".":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"36":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"36":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"27":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"71":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":2.0},"82":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":24,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":2.6457513110645907},"36":{"tf":2.6457513110645907},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":2.449489742783178}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"46":{"tf":1.0}}}},"df":4,"docs":{"39":{"tf":1.0},"51":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"df":6,"docs":{"22":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"36":{"tf":1.4142135623730951},"45":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}}}},"p":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"df":18,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":4.0},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":2.8284271247461903},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":2.0}}}},"i":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":3,"docs":{"36":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951}}}}},"s":{"df":6,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"25":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.0}}}}},"t":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"25":{"tf":2.6457513110645907},"55":{"tf":1.0},"76":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"56":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"53":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":18,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"4":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":2,"docs":{"20":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"15":{"tf":1.0},"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"35":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"y":{"df":3,"docs":{"52":{"tf":1.7320508075688772},"53":{"tf":2.0},"57":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"11":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}},"’":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"28":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"65":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.0},"67":{"tf":2.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"25":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"86":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.0},"76":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"4":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"77":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"25":{"tf":2.6457513110645907},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"51":{"tf":3.1622776601683795}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"41":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"32":{"tf":1.0},"76":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}}},"k":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}}}}}}}},"df":16,"docs":{"0":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.0},"29":{"tf":3.3166247903554},"30":{"tf":3.1622776601683795},"31":{"tf":2.23606797749979},"32":{"tf":2.0},"33":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951},"37":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":5.291502622129181},"77":{"tf":2.8284271247461903},"78":{"tf":2.23606797749979}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"18":{"tf":1.0}}}}},"s":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"23":{"tf":1.0},"8":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\\"":{">":{"<":{"/":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":7,"docs":{"23":{"tf":1.0},"36":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"11":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"51":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"69":{"tf":1.0},"76":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":11,"docs":{"28":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.0}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"21":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"73":{"tf":1.0}},"’":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":13,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":3.0},"47":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":4,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"5":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}},"df":4,"docs":{"1":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"25":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"t":{"df":4,"docs":{"28":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}},"k":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"w":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":2,"docs":{"44":{"tf":1.0},"76":{"tf":1.0}},"e":{"a":{"d":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"25":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"53":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0}}}},"i":{"df":1,"docs":{"17":{"tf":1.0}}},"m":{"df":1,"docs":{"65":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"61":{"tf":1.0},"85":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"69":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"39":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"36":{"tf":1.0},"77":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":1.0},"36":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"36":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"=":{"\\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":13,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"69":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":3,"docs":{"11":{"tf":1.0},"28":{"tf":1.0},"55":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}},"v":{"df":6,"docs":{"10":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"77":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"36":{"tf":1.7320508075688772},"42":{"tf":1.0},"45":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}}}}},"df":34,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":2.23606797749979},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"36":{"tf":2.23606797749979},"37":{"tf":2.6457513110645907},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"57":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":3.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{},"s":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":5,"docs":{"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"65":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":2.6457513110645907}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"36":{"tf":1.0},"46":{"tf":1.0},"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":1.0},"33":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"5":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"45":{"tf":1.0},"56":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}},"l":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":13,"docs":{"10":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"27":{"tf":1.0},"36":{"tf":3.872983346207417},"37":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"56":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"36":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":15,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"36":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"u":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"84":{"tf":1.0}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":25,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":2.449489742783178},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"36":{"tf":1.4142135623730951},"47":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"57":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"53":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},".":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"29":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":5,"docs":{"21":{"tf":2.23606797749979},"37":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}},"’":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"df":23,"docs":{"0":{"tf":2.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"21":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"36":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"53":{"tf":2.449489742783178},"56":{"tf":2.0},"57":{"tf":2.449489742783178},"59":{"tf":1.0},"66":{"tf":1.7320508075688772},"69":{"tf":2.0},"70":{"tf":2.0},"78":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.7320508075688772}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"36":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":6,"docs":{"23":{"tf":1.4142135623730951},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"69":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":3,"docs":{"10":{"tf":1.0},"41":{"tf":1.0},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":2.6457513110645907},"21":{"tf":1.0},"36":{"tf":5.385164807134504},"69":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"55":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"16":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"36":{"tf":3.0},"39":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":20,"docs":{"11":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":2.6457513110645907},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}},"n":{".":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.0},"59":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"69":{"tf":1.0},"80":{"tf":1.0}}}}}},"n":{"d":{"df":2,"docs":{"52":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"14":{"tf":1.0},"25":{"tf":2.0},"35":{"tf":1.0},"38":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":2,"docs":{"69":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":3.605551275463989},"28":{"tf":1.0},"69":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}},"e":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.7320508075688772},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"i":{"c":{"df":5,"docs":{"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"t":{"df":16,"docs":{"14":{"tf":1.7320508075688772},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":3.3166247903554},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"16":{"tf":1.0},"23":{"tf":2.449489742783178},"44":{"tf":1.0},"76":{"tf":1.0}},"’":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"w":{"df":7,"docs":{"10":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"72":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0}},"n":{"df":4,"docs":{"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"59":{"tf":1.0},"78":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"36":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"25":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"14":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":3,"docs":{"66":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"38":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"36":{"tf":2.449489742783178},"71":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"85":{"tf":1.0}}},"p":{"df":2,"docs":{"17":{"tf":1.0},"83":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"67":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"28":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772}}}}}}}},"o":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"36":{"tf":1.0},"42":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"(":{"\\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":19,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.7320508075688772},"54":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"51":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"42":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"67":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":24,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"82":{"tf":1.0}},"i":{"df":17,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":2.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"28":{"tf":1.7320508075688772},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"56":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"0":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"c":{"/":{"4":{"0":{"4":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"=":{"\\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":2.6457513110645907},"39":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"16":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":2.23606797749979},"38":{"tf":1.0},"76":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"14":{"tf":1.0},"36":{"tf":1.4142135623730951},"42":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}}},"y":{"df":1,"docs":{"82":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"1":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"1":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":7,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"15":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}},"k":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":2,"docs":{"76":{"tf":1.4142135623730951},"77":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":2.0}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"52":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":5,"docs":{"36":{"tf":2.0},"38":{"tf":1.4142135623730951},"51":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"55":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"36":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}}},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"14":{"tf":1.0},"25":{"tf":1.4142135623730951},"7":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"28":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"m":{"_":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"=":{"0":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":2.23606797749979},"25":{"tf":2.0}}},"y":{".":{"df":0,"docs":{},"m":{"d":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"14":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":2.23606797749979},"28":{"tf":1.0},"41":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":16,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"49":{"tf":2.6457513110645907},"55":{"tf":1.0},"67":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"g":{"df":4,"docs":{"39":{"tf":1.0},"42":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"78":{"tf":1.0}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":14,"docs":{"0":{"tf":1.7320508075688772},"25":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"[":{"1":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":7,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":2.0},"74":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":2,"docs":{"23":{"tf":1.0},"53":{"tf":1.0}},"l":{"df":14,"docs":{"25":{"tf":2.0},"28":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.8284271247461903},"36":{"tf":3.4641016151377544},"37":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":2.23606797749979},"76":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"42":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.0}},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"p":{"df":2,"docs":{"51":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":1,"docs":{"69":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":2.6457513110645907}}}}},"df":1,"docs":{"83":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":2.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"76":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"36":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"67":{"tf":3.3166247903554}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"84":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":13,"docs":{"0":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":4.242640687119285},"28":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":2.6457513110645907},"56":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.6457513110645907},"76":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":2.23606797749979},"36":{"tf":1.7320508075688772},"62":{"tf":2.23606797749979},"63":{"tf":2.0},"65":{"tf":1.0},"67":{"tf":3.605551275463989},"77":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":16,"docs":{"0":{"tf":1.0},"17":{"tf":2.23606797749979},"24":{"tf":1.0},"36":{"tf":3.605551275463989},"39":{"tf":4.123105625617661},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":3.0},"46":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"82":{"tf":1.0},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.0}}}}},"’":{"df":3,"docs":{"70":{"tf":1.0},"80":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}},"k":{"df":2,"docs":{"17":{"tf":1.0},"46":{"tf":1.0}}}},"r":{"d":{"df":5,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"36":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"25":{"tf":1.0},"42":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":8,"docs":{"33":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}},"w":{"df":2,"docs":{"32":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"df":2,"docs":{"11":{"tf":1.0},"25":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"17":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"l":{"df":13,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":2.0},"25":{"tf":3.4641016151377544},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":2.23606797749979},"58":{"tf":2.449489742783178},"76":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.4142135623730951}},"e":{"=":{"\\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"c":{"df":1,"docs":{"42":{"tf":1.7320508075688772}},"}":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"df":0,"docs":{},"{":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"51":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"p":{"df":6,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"58":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.0},"77":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"85":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":8,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"28":{"tf":2.0},"30":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":5.830951894845301},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"77":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"61":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":5,"docs":{"31":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"83":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":4,"docs":{"14":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"df":1,"docs":{"39":{"tf":1.0}}},"l":{"df":1,"docs":{"42":{"tf":2.0}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"28":{"tf":1.4142135623730951},"49":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"35":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":2,"docs":{"11":{"tf":1.0},"47":{"tf":1.0}}}},"df":1,"docs":{"39":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"41":{"tf":1.0},"45":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{"df":0,"docs":{},"’":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}},"l":{"df":6,"docs":{"14":{"tf":1.0},"36":{"tf":3.4641016151377544},"65":{"tf":2.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":54,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"18":{"tf":1.7320508075688772},"19":{"tf":3.0},"20":{"tf":3.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":2.0},"28":{"tf":3.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":3.7416573867739413},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":3.1622776601683795},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":2.23606797749979},"49":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"63":{"tf":1.0},"65":{"tf":2.0},"67":{"tf":2.0},"68":{"tf":1.0},"69":{"tf":2.8284271247461903},"70":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":2.449489742783178},"75":{"tf":1.4142135623730951},"76":{"tf":3.3166247903554},"77":{"tf":3.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":2.0},"82":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"25":{"tf":1.0},"36":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"77":{"tf":1.0},"81":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"v":{"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"23":{"tf":1.0},"36":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":13,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}}}},"r":{"df":1,"docs":{"42":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"26":{"tf":1.0},"38":{"tf":2.8284271247461903},"39":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.0},"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"i":{"df":3,"docs":{"14":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":10,"docs":{"0":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":3.0},"60":{"tf":1.0},"69":{"tf":3.0},"70":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":2.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"76":{"tf":1.0}}}}}}}}}}},"i":{"a":{"df":10,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"=":{"\\"":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"36":{"tf":1.0},"65":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":2.449489742783178},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"]":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"16":{"tf":1.0},"19":{"tf":3.0},"20":{"tf":1.0},"28":{"tf":2.23606797749979},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"y":{"df":8,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}},"n":{"df":1,"docs":{"86":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{},"e":{"\'":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"b":{"df":10,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.7320508075688772},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"13":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.0},"45":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"v":{"df":2,"docs":{"82":{"tf":1.0},"84":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"+":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"36":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":5,"docs":{"29":{"tf":1.0},"34":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"25":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"83":{"tf":2.0},"84":{"tf":1.0}}}}}}}},"df":4,"docs":{"35":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}}}}},"df":7,"docs":{"10":{"tf":1.0},"36":{"tf":3.1622776601683795},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0}}},"df":0,"docs":{},"k":{"df":13,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":2.23606797749979},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}},"l":{"d":{"df":3,"docs":{"11":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":5,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":7,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"25":{"tf":1.4142135623730951},"36":{"tf":1.0},"67":{"tf":2.23606797749979},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":4,"docs":{"49":{"tf":1.4142135623730951},"51":{"tf":2.0},"56":{"tf":2.23606797749979},"67":{"tf":1.0}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"=":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"w":{"3":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"2":{"0":{"0":{"0":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":1,"docs":{"51":{"tf":2.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"45":{"tf":1.0},"5":{"tf":1.0},"86":{"tf":1.0}}}}}}},"’":{"d":{"df":3,"docs":{"1":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"71":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":1,"docs":{"86":{"tf":1.0}}},"v":{"df":2,"docs":{"15":{"tf":1.0},"84":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"_":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}}},"title":{"root":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"79":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"11":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"7":{"tf":1.0},"81":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"18":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"83":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"30":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"47":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"51":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"59":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"77":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"i":{"df":2,"docs":{"13":{"tf":1.0},"56":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"44":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0}}},"k":{"df":1,"docs":{"65":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"50":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"32":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"70":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"5":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"20":{"tf":1.0}}}},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"70":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"80":{"tf":1.0},"85":{"tf":1.0}}},"s":{"df":2,"docs":{"5":{"tf":1.0},"74":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":20,"teaser_word_count":30},"search_options":{"bool":"AND","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":2},"title":{"boost":2}}}}'));