import datetime
from typing import ClassVar

from ..core import WesternCalendar

class UnitedStates(WesternCalendar):
    include_veterans_day: ClassVar[bool]
    veterans_day_label: ClassVar[str]
    martin_luther_king_label: ClassVar[str]
    include_thanksgiving_friday: ClassVar[bool]
    thanksgiving_friday_label: ClassVar[str]
    include_federal_presidents_day: ClassVar[bool]
    presidents_day_label: ClassVar[str]
    include_lincoln_birthday: ClassVar[bool]
    include_columbus_day: ClassVar[bool]
    columbus_day_label: ClassVar[str]
    include_confederation_day: ClassVar[bool]
    include_jefferson_davis_birthday: ClassVar[bool]
    include_cesar_chavez_day: ClassVar[bool]
    include_patriots_day: ClassVar[bool]
    include_election_day_every_year: ClassVar[bool]
    include_election_day_even: ClassVar[bool]
    election_day_label: ClassVar[str]
    include_inauguration_day: ClassVar[bool]
    national_memorial_day_label: ClassVar[str]
    fat_tuesday_label: ClassVar[str]
    include_juneteenth: ClassVar[bool]
    shift_exceptions: ClassVar[tuple[tuple[int, int], ...] | list[tuple[int, int]]]
    def shift(self, holidays: list[tuple[datetime.date, str]], year: int) -> list[tuple[datetime.date, str]]: ...
    @staticmethod
    def is_presidential_year(year: int) -> bool: ...
    def get_election_date(self, year: int) -> datetime.date: ...
    def get_election_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_thanksgiving_friday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_confederate_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_jefferson_davis_birthday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_martin_luther_king_date(self, year: int) -> datetime.date: ...
    def get_martin_luther_king_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_presidents_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_cesar_chavez_days(self, year: int) -> list[tuple[datetime.date, str]]: ...
    def get_patriots_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_columbus_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_lincoln_birthday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_inauguration_date(self, year: int) -> datetime.date: ...
    def get_national_memorial_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_juneteenth_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_veterans_day(self, year: int) -> tuple[datetime.date, str]: ...

class FederalReserveSystem(UnitedStates): ...
