import datetime
from typing import ClassVar, Final

from ..core import WesternCalendar

class Brazil(WesternCalendar):
    include_sao_jose: ClassVar[bool]
    sao_jose_label: ClassVar[str]
    include_sao_pedro: ClassVar[bool]
    sao_pedro_label: ClassVar[str]
    include_sao_joao: ClassVar[bool]
    sao_joao_label: ClassVar[str]
    include_servidor_publico: ClassVar[bool]
    servidor_publico_label: ClassVar[str]
    include_consciencia_negra: ClassVar[bool]
    consciencia_negra_day: ClassVar[tuple[int, int]]
    consciencia_negra_label: ClassVar[str]

class BrazilAcre(Brazil): ...
class BrazilAlagoas(Brazil): ...
class BrazilAmapa(Brazil): ...
class BrazilAmazonas(Brazil): ...
class BrazilBahia(Brazil): ...
class BrazilCeara(Brazil): ...
class BrazilDistritoFederal(Brazil): ...
class BrazilEspiritoSanto(Brazil): ...
class BrazilGoias(Brazil): ...
class BrazilMaranhao(Brazil): ...
class BrazilMinasGerais(Brazil): ...
class BrazilMatoGrosso(Brazil): ...
class BrazilMatoGrossoDoSul(Brazil): ...
class BrazilPara(Brazil): ...
class BrazilParaiba(Brazil): ...
class BrazilPernambuco(Brazil): ...
class BrazilPiaui(Brazil): ...
class BrazilParana(Brazil): ...

class BrazilRioDeJaneiro(Brazil):
    fat_tuesday_label: ClassVar[str]
    def get_dia_do_comercio(self, year: int) -> datetime.date | None: ...

class BrazilRioGrandeDoNorte(Brazil): ...
class BrazilRioGrandeDoSul(Brazil): ...
class BrazilRondonia(Brazil): ...
class BrazilRoraima(Brazil): ...
class BrazilSantaCatarina(Brazil): ...
class BrazilSaoPauloState(Brazil): ...

class BrazilSaoPauloCity(BrazilSaoPauloState):
    fat_tuesday_label: ClassVar[str]

class BrazilSergipe(Brazil): ...
class BrazilTocantins(Brazil): ...
class BrazilVitoriaCity(BrazilEspiritoSanto): ...
class BrazilVilaVelhaCity(BrazilEspiritoSanto): ...
class BrazilCariacicaCity(BrazilEspiritoSanto): ...
class BrazilGuarapariCity(BrazilEspiritoSanto): ...

class BrazilSerraCity(BrazilEspiritoSanto):
    fat_tuesday_label: ClassVar[str]

class BrazilRioBrancoCity(BrazilAcre): ...
class BrazilMaceioCity(BrazilAlagoas): ...
class BrazilManausCity(BrazilAmazonas): ...
class BrazilMacapaCity(BrazilAmapa): ...
class BrazilSalvadorCity(BrazilBahia): ...
class BrazilFortalezaCity(BrazilCeara): ...
class BrazilGoianiaCity(BrazilGoias): ...
class BrazilBeloHorizonteCity(BrazilMinasGerais): ...
class BrazilCampoGrandeCity(BrazilMatoGrossoDoSul): ...
class BrazilCuiabaCity(BrazilMatoGrosso): ...
class BrazilBelemCity(BrazilPara): ...
class BrazilJoaoPessoaCity(BrazilParaiba): ...
class BrazilRecifeCity(BrazilPernambuco): ...
class BrazilTeresinaCity(BrazilPiaui): ...
class BrazilCuritibaCity(BrazilParana): ...
class BrazilNatalCity(BrazilRioGrandeDoNorte): ...
class BrazilPortoVelhoCity(BrazilRondonia): ...
class BrazilBoaVistaCity(BrazilRoraima): ...
class BrazilPortoAlegreCity(BrazilRioGrandeDoSul): ...
class BrazilChapecoCity(BrazilSantaCatarina): ...
class BrazilFlorianopolisCity(BrazilSantaCatarina): ...
class BrazilJoinvilleCity(BrazilSantaCatarina): ...
class BrazilAracajuCity(BrazilSergipe): ...
class BrazilSorocabaCity(BrazilSaoPauloState): ...
class BrazilPalmasCity(BrazilTocantins): ...

class BrazilBankCalendar(Brazil):
    fat_tuesday_label: ClassVar[str]
    def get_last_day_of_year_for_only_internal_bank_trans(self, year: int) -> datetime.date: ...

IBGE_TUPLE: Final[tuple[tuple[str, type[Brazil]], ...]]
IBGE_REGISTER: Final[dict[str, type[Brazil]]]
