"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const featureWorkers_1 = require("@volar/language-service/lib/utils/featureWorkers");
function register(htmlLs) {
    return (pugDoc, pos, options) => {
        for (const htmlStart of (0, featureWorkers_1.getGeneratedPositions)(pugDoc.docs, pos)) {
            const text = htmlLs.doQuoteComplete(pugDoc.docs[1], htmlStart, pugDoc.htmlDocument, options);
            return text;
        }
    };
}
//# sourceMappingURL=quoteComplete.js.map