"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = getElementAttrs;
const utils_1 = require("./utils");
function getElementAttrs(ts, program, fileName, tag) {
    const checker = program.getTypeChecker();
    const elements = (0, utils_1.getVariableType)(ts, program, fileName, '__VLS_elements');
    if (!elements) {
        return [];
    }
    const elementType = elements.type.getProperty(tag);
    if (!elementType) {
        return [];
    }
    const attrs = checker.getTypeOfSymbol(elementType).getProperties();
    return attrs.map(c => c.name);
}
//# sourceMappingURL=getElementAttrs.js.map