/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.LambdaExpression;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.ELParserTreeConstants;
import org.apache.el.parser.Node;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;

public final class AstFunction
extends SimpleNode {
    private String localName = "";
    private String prefix = "";

    public AstFunction(int n) {
        super(n);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix == null) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return method.getReturnType();
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object object;
        Serializable serializable;
        VariableMapper variableMapper;
        Object object2;
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null && this.prefix.isEmpty()) {
            object2 = null;
            if (evaluationContext.isLambdaArgument(this.localName)) {
                object2 = evaluationContext.getLambdaArgument(this.localName);
            }
            if (object2 == null && (variableMapper = evaluationContext.getVariableMapper()) != null && (object2 = variableMapper.resolveVariable(this.localName)) != null) {
                object2 = ((ValueExpression)object2).getValue((ELContext)evaluationContext);
            }
            if (object2 == null) {
                object2 = evaluationContext.getELResolver().getValue((ELContext)evaluationContext, null, (Object)this.localName);
            }
            if (object2 instanceof LambdaExpression) {
                int n;
                for (n = 0; object2 instanceof LambdaExpression && n < this.jjtGetNumChildren(); ++n) {
                    Node node = this.jjtGetChild(n);
                    object2 = ((LambdaExpression)object2).invoke(((AstMethodParameters)node).getParameters(evaluationContext));
                }
                if (n < this.jjtGetNumChildren()) {
                    throw new ELException(MessageFactory.get("error.lambda.tooManyMethodParameterSets"));
                }
                return object2;
            }
            object2 = evaluationContext.getImportHandler().resolveClass(this.localName);
            if (object2 != null) {
                return evaluationContext.getELResolver().invoke((ELContext)evaluationContext, (Object)new ELClass((Class)object2), (Object)"<init>", null, ((AstMethodParameters)this.children[0]).getParameters(evaluationContext));
            }
            object2 = evaluationContext.getImportHandler().resolveStatic(this.localName);
            if (object2 != null) {
                return evaluationContext.getELResolver().invoke((ELContext)evaluationContext, (Object)new ELClass((Class)object2), (Object)this.localName, null, ((AstMethodParameters)this.children[0]).getParameters(evaluationContext));
            }
        }
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        if (this.jjtGetNumChildren() != 1) {
            throw new ELException(MessageFactory.get("error.function.tooManyMethodParameterSets", this.getOutputName()));
        }
        object2 = this.jjtGetChild(0);
        variableMapper = method.getParameterTypes();
        Object[] objectArray = null;
        int n = object2.jjtGetNumChildren();
        int n2 = ((VariableMapper)variableMapper).length;
        if (n == 0 && n2 == 1 && method.isVarArgs()) {
            objectArray = new Object[]{null};
        } else if (n > 0) {
            objectArray = new Object[n2];
            try {
                for (int i = 0; i < n2; ++i) {
                    if (method.isVarArgs() && i == n2 - 1) {
                        if (n < n2) {
                            objectArray[i] = new Object[]{null};
                        } else if (n == n2 && this.isArray(object2.jjtGetChild(i).getValue(evaluationContext))) {
                            objectArray[i] = object2.jjtGetChild(i).getValue(evaluationContext);
                        } else {
                            Object[] objectArray2 = new Object[n - n2 + 1];
                            serializable = variableMapper[i].getComponentType();
                            for (int j = i; j < n; ++j) {
                                objectArray2[j - i] = object2.jjtGetChild(j).getValue(evaluationContext);
                                objectArray2[j - i] = ELSupport.coerceToType(evaluationContext, objectArray2[j - i], serializable);
                            }
                            objectArray[i] = objectArray2;
                        }
                    } else {
                        objectArray[i] = object2.jjtGetChild(i).getValue(evaluationContext);
                    }
                    objectArray[i] = ELSupport.coerceToType(evaluationContext, objectArray[i], variableMapper[i]);
                }
            }
            catch (ELException eLException) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)eLException);
            }
        }
        try {
            object = method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            serializable = invocationTargetException.getCause();
            if (serializable instanceof ThreadDeath) {
                throw (ThreadDeath)serializable;
            }
            if (serializable instanceof VirtualMachineError) {
                throw (VirtualMachineError)serializable;
            }
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), serializable);
        }
        return object;
    }

    private boolean isArray(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().isArray();
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

