#============================================================================#
# Dictionary that contains default keybinds and replacement names

# Keybinding: ['default command','description','user defined command']

# Note: Storing default command as string representation for comparison.
#       This may be removed in the future. Longer names are commented out and
#       truncated for this purpose.
#============================================================================#
shortcut_dict_ref = {
'left': ('_ backward',"previous movie frame",''),
'right': ('_ forward',"next movie frame",''),
'pgup': ('scene action=previous',"previous scene",''),
'pgdn': ('scene action=next',"last scene",''),
'home': ('zoom animate=-1',"zoom all",''),
'end': ('mtoggle','play/pause movie',''),
'insert': ('rock','',''),
'SHFT-left': ('backward','',''),
'SHFT-right': ('forward','',''),
'SHFT-pgup': ('scene action=previous','previous scene',''),
'SHFT-pgdn': ('scene action=next','next scene',''),
'SHFT-home': ('rewind','',''),
'SHFT-end': ('ending','',''),
'SHFT-insert': ('rock','',''),
'CTRL-left': ('backward','',''),
'CTRL-right': ('forward','',''),
'CTRL-pgup': ("_ scene new, insert_before",'insert scene before current',''),
'CTRL-pgdn': ("_ scene new, insert_after",'insert scene after current',''),
'CTRL-home': ('zoom animate=-1','zoom all',''),
'CTRL-end': ('scene new, store','store new scene',''),
'CTRL-insert': ('scene auto, store','store auto scene',''),
'CTRL-A': ('select sele, all, 1','select all',''),
'CTRL-C': ('editing_ring copy','copy',''),
'CTRL-F': ('wizard find','find',''),
'CTRL-H': ('help edit_keys','help',''),
'CTRL-I': ('editing_ring invert','invert selection',''),
'CTRL-L': ('util.ligand_zoom()','zoom next ligand',''),
'CTRL-T': ('bond;unpick','create bond',''),
'CTRL-V': ('editing_ring paste','paste',''),
'CTRL-X': ('editing_ring cut','cut',''),
'CTRL-Y': ('redo','',''),
'CTRL-Z': ('undo','',''),
'ALT-left': ('backward','',''),
'ALT-right': ('forward','',''),
'ALT-pgup': ('rewind','',''),
'ALT-pgdn': ('ending','',''),
'ALT-home': ('zoom animate=-1','zoom all',''),
'ALT-end': ('ending','',''),
'ALT-insert': ('rock','',''),
'ALT-1': ("editor.attach_fragment('pk1', 'formamide', 5, 0)",'attach amide N->C',''),
'ALT-2': ("editor.attach_fragment('pk1', 'formamide', 4, 0)",'attach amide C->N',''),
'ALT-3': ("editor.attach_fragment('pk1', 'sulfone', 3, 1)",'attach sulfone',''),
'ALT-4': ("editor.attach_fragment('pk1', 'cyclobutane', 4, 0)",'attach cyclobutane',''),
'ALT-5': ("editor.attach_fragment('pk1', 'cyclopentane', 5, 0)",'attach cyclopentane',''),
'ALT-6': ("editor.attach_fragment('pk1', 'cyclohexane', 7, 0)",'attach cyclohexane',''),
'ALT-7': ("editor.attach_fragment('pk1', 'cycloheptane', 8, 0)",'attach cycloheptane',''),
'ALT-8': ("editor.attach_fragment('pk1', 'cyclopentadiene', 5, 0)",'attach cyclopentadiene',''),
'ALT-9': ("editor.attach_fragment('pk1', 'benzene', 6, 0)",'attach benzene',''),
'ALT-0': ("editor.attach_fragment('pk1', 'formaldehyde', 2, 0)",'attach formaldehyde',''),
'ALT-A': ("editor.attach_amino_acid('pk1', 'ala')",'attach ala',''),
'ALT-B': ("editor.attach_amino_acid('pk1', 'ace')",'attach ace',''),
'ALT-C': ("editor.attach_amino_acid('pk1', 'cys')",'attach cys',''),
'ALT-D': ("editor.attach_amino_acid('pk1', 'asp')",'attach asp',''),
'ALT-E': ("editor.attach_amino_acid('pk1', 'glu')",'attach glu',''),
'ALT-F': ("editor.attach_amino_acid('pk1', 'phe')",'attach phe',''),
'ALT-G': ("editor.attach_amino_acid('pk1', 'gly')",'attach gly',''),
'ALT-H': ("editor.attach_amino_acid('pk1', 'his')",'attach his',''),
'ALT-I': ("editor.attach_amino_acid('pk1', 'ile')",'attach ile',''),
'ALT-J': ("editor.attach_fragment('pk1', 'acetylene', 2, 0)",'attach acetylene',''),
'ALT-K': ("editor.attach_amino_acid('pk1', 'lys')",'attach lys',''),
'ALT-L': ("editor.attach_amino_acid('pk1', 'leu')",'attach leu',''),
'ALT-M': ("editor.attach_amino_acid('pk1', 'met')",'attach met',''),
'ALT-N': ("editor.attach_amino_acid('pk1', 'asn')",'attach asn',''),
'ALT-P': ("editor.attach_amino_acid('pk1', 'pro')",'attach pro',''),
'ALT-Q': ("editor.attach_amino_acid('pk1', 'gln')",'attach gln',''),
'ALT-R': ("editor.attach_amino_acid('pk1', 'arg')",'attach arg',''),
'ALT-S': ("editor.attach_amino_acid('pk1', 'ser')",'attach ser',''),
'ALT-T': ("editor.attach_amino_acid('pk1', 'thr')",'attach thr',''),
'ALT-V': ("editor.attach_amino_acid('pk1', 'val')",'attach val',''),
'ALT-W': ("editor.attach_amino_acid('pk1', 'trp')",'attach trp',''),
'ALT-Y': ("editor.attach_amino_acid('pk1', 'tyr')",'attach tyr',''),
'ALT-Z': ("editor.attach_amino_acid('pk1', 'nme')",'attach nme',''),
'CTSH-left': ('backward','',''),
'CTSH-right': ('forward','',''),
'CTSH-pgup': ("scene new, insert_before",'insert scene before current',''),
'CTSH-pgdn': ("scene new, insert_after",'insert scene after current',''),
'CTSH-home': ('zoom animate=-1','zoom all',''),
'CTSH-end': ('mtoggle','',''),
'CTSH-insert': ('rock','',''),
'CTSH-A': ('redo','',''),
'CTSH-B': ('replace Br,1,1','',''),
'CTSH-C': ('replace C,4,4','',''),
'CTSH-D': ('remove_picked','',''),
'CTSH-E': ('invert','',''),
'CTSH-F': ('replace F,1,1','',''),
'CTSH-G': ('replace H,1,1','',''),
'CTSH-I': ('replace I,1,1','',''),
'CTSH-J': ('alter pk1,formal_charge=-1.','',''),
'CTSH-K': ('alter pk1,formal_charge=1.','',''),
'CTSH-L': ('replace Cl,1,1','',''),
'CTSH-N': ('replace N,4,3','',''),
'CTSH-O': ('replace O,4,2','',''),
'CTSH-P': ('replace P,4,1','',''),
'CTSH-R': ('h_fill','',''),
'CTSH-S': ('replace S,4,2','',''),
'CTSH-T': ('bond;unpick','',''),
'CTSH-U': ('alter pk1,formal_charge=0.','',''),
'CTSH-W': ('cycle_valence','',''),
'CTSH-X': ("cmd.auto_measure()",'auto measure',''),
'CTSH-Y': ('attach H,1,1','',''),
'CTSH-Z': ('undo','',''),
'CTRL-F1': ("scene F1, store",'',''),
'CTSH-F1': ("scene SHFT-F1, store",'',''),
'CTRL-F2': ("scene F2, store",'',''),
'CTSH-F2': ("scene SHFT-F2, store",'',''),
'CTRL-F3': ("scene F3, store",'',''),
'CTSH-F3': ("scene SHFT-F3, store",'',''),
'CTRL-F4': ("scene F4, store",'',''),
'CTSH-F4': ("scene SHFT-F4, store",'',''),
'CTRL-F5': ("scene F5, store",'',''),
'CTSH-F5': ("scene SHFT-F5, store",'',''),
'CTRL-F6': ("scene F6, store",'',''),
'CTSH-F6': ("scene SHFT-F6, store",'',''),
'CTRL-F7': ("scene F7, store",'',''),
'CTSH-F7': ("scene SHFT-F7, store",'',''),
'CTRL-F8': ("scene F8, store",'',''),
'CTSH-F8': ("scene SHFT-F8, store",'',''),
'CTRL-F9': ("scene F9, store",'',''),
'CTSH-F9': ("scene SHFT-F9, store",'',''),
'CTRL-F10': ("scene F10, store",'',''),
'CTSH-F10': ("scene SHFT-F10, store",'',''),
'CTRL-F11': ("scene F11, store",'',''),
'CTSH-F11': ("scene SHFT-F11, store",'',''),
'CTRL-F12': ("scene F12, store",'',''),
'CTSH-F12': ("scene SHFT-F12, store",'',''),
}
#============================================================================#
