/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.stats.IndexStatsBase;
import org.opensearch.client.opensearch.indices.stats.ShardCommit;
import org.opensearch.client.opensearch.indices.stats.ShardPath;
import org.opensearch.client.opensearch.indices.stats.ShardRetentionLeases;
import org.opensearch.client.opensearch.indices.stats.ShardRouting;
import org.opensearch.client.opensearch.indices.stats.ShardSequenceNumber;
import org.opensearch.client.util.ObjectBuilder;

public abstract class IndexShardStatsBase
extends IndexStatsBase {
    @Nullable
    private final ShardCommit commit;
    @Nullable
    private final ShardRetentionLeases retentionLeases;
    @Nullable
    private final ShardRouting routing;
    @Nullable
    private final ShardSequenceNumber seqNo;
    @Nullable
    private final ShardPath shardPath;

    protected IndexShardStatsBase(AbstractBuilder<?> builder) {
        super(builder);
        this.commit = ((AbstractBuilder)builder).commit;
        this.retentionLeases = ((AbstractBuilder)builder).retentionLeases;
        this.routing = ((AbstractBuilder)builder).routing;
        this.seqNo = ((AbstractBuilder)builder).seqNo;
        this.shardPath = ((AbstractBuilder)builder).shardPath;
    }

    @Nullable
    public final ShardCommit commit() {
        return this.commit;
    }

    @Nullable
    public final ShardRetentionLeases retentionLeases() {
        return this.retentionLeases;
    }

    @Nullable
    public final ShardRouting routing() {
        return this.routing;
    }

    @Nullable
    public final ShardSequenceNumber seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final ShardPath shardPath() {
        return this.shardPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.commit != null) {
            generator.writeKey("commit");
            this.commit.serialize(generator, mapper);
        }
        if (this.retentionLeases != null) {
            generator.writeKey("retention_leases");
            this.retentionLeases.serialize(generator, mapper);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.seqNo != null) {
            generator.writeKey("seq_no");
            this.seqNo.serialize(generator, mapper);
        }
        if (this.shardPath != null) {
            generator.writeKey("shard_path");
            this.shardPath.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupIndexShardStatsBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        IndexShardStatsBase.setupIndexStatsBaseDeserializer(op);
        op.add(AbstractBuilder::commit, ShardCommit._DESERIALIZER, "commit");
        op.add(AbstractBuilder::retentionLeases, ShardRetentionLeases._DESERIALIZER, "retention_leases");
        op.add(AbstractBuilder::routing, ShardRouting._DESERIALIZER, "routing");
        op.add(AbstractBuilder::seqNo, ShardSequenceNumber._DESERIALIZER, "seq_no");
        op.add(AbstractBuilder::shardPath, ShardPath._DESERIALIZER, "shard_path");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.commit);
        result = 31 * result + Objects.hashCode(this.retentionLeases);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.seqNo);
        result = 31 * result + Objects.hashCode(this.shardPath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexShardStatsBase other = (IndexShardStatsBase)o;
        return Objects.equals(this.commit, other.commit) && Objects.equals(this.retentionLeases, other.retentionLeases) && Objects.equals(this.routing, other.routing) && Objects.equals(this.seqNo, other.seqNo) && Objects.equals(this.shardPath, other.shardPath);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends IndexStatsBase.AbstractBuilder<BuilderT> {
        @Nullable
        private ShardCommit commit;
        @Nullable
        private ShardRetentionLeases retentionLeases;
        @Nullable
        private ShardRouting routing;
        @Nullable
        private ShardSequenceNumber seqNo;
        @Nullable
        private ShardPath shardPath;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(IndexShardStatsBase o) {
            super(o);
            this.commit = o.commit;
            this.retentionLeases = o.retentionLeases;
            this.routing = o.routing;
            this.seqNo = o.seqNo;
            this.shardPath = o.shardPath;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.commit = o.commit;
            this.retentionLeases = o.retentionLeases;
            this.routing = o.routing;
            this.seqNo = o.seqNo;
            this.shardPath = o.shardPath;
        }

        @Nonnull
        public final BuilderT commit(@Nullable ShardCommit value) {
            this.commit = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT commit(Function<ShardCommit.Builder, ObjectBuilder<ShardCommit>> fn) {
            return this.commit(fn.apply(new ShardCommit.Builder()).build());
        }

        @Nonnull
        public final BuilderT retentionLeases(@Nullable ShardRetentionLeases value) {
            this.retentionLeases = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT retentionLeases(Function<ShardRetentionLeases.Builder, ObjectBuilder<ShardRetentionLeases>> fn) {
            return this.retentionLeases(fn.apply(new ShardRetentionLeases.Builder()).build());
        }

        @Nonnull
        public final BuilderT routing(@Nullable ShardRouting value) {
            this.routing = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT routing(Function<ShardRouting.Builder, ObjectBuilder<ShardRouting>> fn) {
            return this.routing(fn.apply(new ShardRouting.Builder()).build());
        }

        @Nonnull
        public final BuilderT seqNo(@Nullable ShardSequenceNumber value) {
            this.seqNo = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT seqNo(Function<ShardSequenceNumber.Builder, ObjectBuilder<ShardSequenceNumber>> fn) {
            return this.seqNo(fn.apply(new ShardSequenceNumber.Builder()).build());
        }

        @Nonnull
        public final BuilderT shardPath(@Nullable ShardPath value) {
            this.shardPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT shardPath(Function<ShardPath.Builder, ObjectBuilder<ShardPath>> fn) {
            return this.shardPath(fn.apply(new ShardPath.Builder()).build());
        }
    }
}

