/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.FixedByteArrayOutputStream;
import oracle.security.pki.util.Streamable;
import oracle.security.pki.util.Utils;

public class ASN1Header
implements ASN1,
Streamable {
    private int M;
    private int N;
    private int O;
    private int P;

    public ASN1Header() {
    }

    public ASN1Header(int n, int n2) {
        this(n, n2, 2, -1);
    }

    public ASN1Header(int n, int n2, int n3, int n4) {
        this.M = n;
        this.N = n2;
        this.O = n3;
        this.P = n4;
    }

    public ASN1Header(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int a() {
        return this.M;
    }

    public int b() {
        return this.N;
    }

    public int c() {
        return this.O;
    }

    public int d() {
        return this.P;
    }

    @Override
    public int length() {
        return this.e() + this.f();
    }

    int e() {
        return 1 + (this.M < 31 ? 0 : ASN1Utils.b(this.M));
    }

    int f() {
        return 1 + (this.P < 128 ? 0 : ASN1Utils.c(this.P));
    }

    public int g() {
        return this.length() + this.P;
    }

    public String toString() {
        return this.a(this.N) + " " + (this.N == 0 ? this.b(this.M) : Integer.toString(this.M)) + " " + this.c(this.O) + " length=" + (this.O == 2 ? "unknown" : Integer.toString(this.P));
    }

    public String a(int n) {
        String[] stringArray = new String[]{"universal", "application", "context-specific", "private"};
        return stringArray[n >> 6];
    }

    public String b(int n) {
        String[] stringArray = new String[]{"END OF CONTENTS", "BOOLEAN", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "ObjectDescriptor", "EXTERNAL", "REAL", "ENUMERATED", "11", "12", "13", "14", "15", "SEQUENCE", "SET", "NumericString", "PrintableString", "T61String", "VideotexString", "IA5String", "UTCTime", "GeneralizedTime", "GraphicString", "VisibleString", "GeneralString", "UniversalString", "29", "BMPString"};
        return n < stringArray.length ? stringArray[n] : Integer.toString(n);
    }

    public String c(int n) {
        String[] stringArray = new String[]{"primitive", "constructed", "constructed"};
        return stringArray[n];
    }

    public void d(int n) throws ASN1FormatException {
        if (this.N != n) {
            throw new ASN1FormatException("Got tag class " + this.a(this.N) + " instead of " + this.a(n) + ".");
        }
    }

    public void e(int n) throws ASN1FormatException {
        if (this.M != n) {
            throw new ASN1FormatException("Got tag " + this.M + " instead of " + n + ".");
        }
    }

    public void f(int n) throws ASN1FormatException {
        if (this.O != n) {
            throw new ASN1FormatException("Got encoding method " + this.c(this.O) + " instead of " + this.c(n) + ".");
        }
    }

    void a(OutputStream outputStream) throws IOException {
        int n = this.M < 31 ? this.M : 31;
        int n2 = this.N | n;
        if (this.O != 0) {
            n2 |= 0x20;
        }
        outputStream.write(n2);
        if (this.M >= 31) {
            ASN1Utils.a(this.M, outputStream);
        }
    }

    void b(OutputStream outputStream) throws IOException {
        if (this.O == 2) {
            outputStream.write(128);
        } else {
            ASN1Utils.a(outputStream, this.P);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a(outputStream);
        this.b(outputStream);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(inputStream);
        this.b(inputStream);
    }

    void a(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        this.N = n & 0xC0;
        this.O = (n & 0x20) == 0 ? 0 : 1;
        this.M = n & 0x1F;
        if (this.M == 31) {
            this.M = ASN1Utils.b(inputStream);
        }
    }

    void b(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        if (n < 128) {
            this.P = n;
        } else if (n == 128) {
            this.O = 2;
            this.P = -1;
        } else {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new ASN1FormatException("Length is too big: takes " + n2 + " bytes");
            }
            this.P = 0;
            for (int i = 0; i < n2; ++i) {
                this.P <<= 8;
                this.P |= Utils.inputByte(inputStream) & 0xFF;
            }
        }
    }

    public void c(InputStream inputStream) throws IOException {
        if (this.O != 2) {
            for (int i = 0; i < this.P; ++i) {
                Utils.inputByte(inputStream);
            }
        } else {
            while (true) {
                ASN1Header aSN1Header = new ASN1Header();
                aSN1Header.input(inputStream);
                if (aSN1Header.N == 0 && aSN1Header.M == 0 && aSN1Header.P == 0) break;
                aSN1Header.c(inputStream);
            }
        }
    }

    public byte[] d(InputStream inputStream) throws IOException {
        if (this.O != 2) {
            byte[] byArray = new byte[this.P];
            Utils.inputByteArray(byArray, inputStream);
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            ASN1Header aSN1Header = new ASN1Header();
            aSN1Header.input(inputStream);
            if (aSN1Header.N == 0 && aSN1Header.M == 0 && aSN1Header.P == 0) break;
            aSN1Header.output(byteArrayOutputStream);
            byteArrayOutputStream.write(aSN1Header.d(inputStream));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] e(InputStream inputStream) throws IOException {
        byte[] byArray = this.d(inputStream);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length() + byArray.length);
        this.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(byArray);
        return fixedByteArrayOutputStream.toByteArray();
    }
}

