/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrack;

public class T4CTTIkpdnrdeq
extends T4CTTIfun {
    static final short COMMIT_KPNAQDEQ = 1;
    static final short ROLLBACK_KPNAQDEQ = 2;
    byte[] clientIdBytes = null;
    short opCode;
    T4CMAREngine mar;
    T4CConnection connection;
    String queue;
    long[] registrationIdArr;
    byte[][] messageIdArr = null;
    byte[][] queueNameBytesArr = null;
    int noOfAck = 1;

    T4CTTIkpdnrdeq(T4CConnection conn) {
        super(conn, (byte)3);
        this.mar = conn.mare;
        this.connection = conn;
        this.setFunCode((short)186);
    }

    void doOAQEMNDEQ(String clientId, short opCode, byte[][] messageIds, long[] registrationIds, String[] queues) throws SQLException, IOException {
        assert (clientId != null && queues != null) : "cliendId is " + clientId + ", queue is " + queues[0];
        this.clientIdBytes = this.mar.conv.StringToCharBytes(clientId);
        this.opCode = opCode;
        this.noOfAck = registrationIds.length;
        this.messageIdArr = messageIds;
        this.registrationIdArr = registrationIds;
        this.queueNameBytesArr = new byte[this.noOfAck][];
        for (int i = 0; i < this.noOfAck; ++i) {
            this.queueNameBytesArr[i] = this.mar.conv.StringToCharBytes(queues[i]);
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        if (this.clientIdBytes != null && this.clientIdBytes.length != 0) {
            this.mar.marshalPTR();
            this.mar.marshalSWORD(this.clientIdBytes.length);
        } else {
            this.mar.marshalNULLPTR();
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalUB1(this.opCode);
        if (this.noOfAck > 0) {
            this.mar.marshalPTR();
            this.mar.marshalUB4(this.noOfAck);
        } else {
            this.mar.marshalNULLPTR();
            this.mar.marshalUB4(0L);
        }
        if (this.clientIdBytes != null && this.clientIdBytes.length != 0) {
            this.mar.marshalCHR(this.clientIdBytes);
        }
        T4CTTIkpdnrack kpdnrack = new T4CTTIkpdnrack(this.connection);
        for (int i = 0; i < this.noOfAck; ++i) {
            kpdnrack.send(this.queueNameBytesArr[i], this.registrationIdArr[i], this.messageIdArr[i]);
        }
    }
}

