/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public class SwitchableBugFix {
    private static final EnumSet<BugNumber> DISABLED_BUG_FIXES = EnumSet.noneOf(BugNumber.class);

    private SwitchableBugFix() {
    }

    private static void disabledBugs() {
        String propertyName = "oracle.jdbc.disabledBugFixes";
        String defaultValue = "";
        String disabledBugFixesPropertyValue = System.getProperty("oracle.jdbc.disabledBugFixes", "");
        EnumSet<BugNumber> incompatibleBugs = EnumSet.noneOf(BugNumber.class);
        if (disabledBugFixesPropertyValue == null || disabledBugFixesPropertyValue.trim().isEmpty()) {
            return;
        }
        for (String bugNumber : disabledBugFixesPropertyValue.split(",")) {
            BugNumber bugFix;
            try {
                bugFix = BugNumber.fromValue(bugNumber.trim());
            }
            catch (IllegalArgumentException illegalArgument) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, "SwitchableBugFix", "disabledBugs", illegalArgument.getMessage(), "", illegalArgument);
                continue;
            }
            if (!bugFix.incompatibleBugs.isEmpty()) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, "SwitchableBugFix", "disabledBugs", "incompatible bugs with " + bugFix.name() + " are : " + bugFix.incompatibleBugs, "", null);
            }
            if (!bugFix.requiredBugs.isEmpty()) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, "SwitchableBugFix", "disabledBugs", "required bugs of " + bugFix.name() + " are : " + bugFix.requiredBugs, "", null);
            }
            DISABLED_BUG_FIXES.add(bugFix);
            DISABLED_BUG_FIXES.addAll(bugFix.requiredBugs);
            incompatibleBugs.addAll(bugFix.incompatibleBugs);
        }
        DISABLED_BUG_FIXES.removeAll(incompatibleBugs);
        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, "SwitchableBugFix", "disabledBugs", "Disabled bugs are : " + DISABLED_BUG_FIXES, "", null);
    }

    public static boolean isDisabled(BugNumber bug) {
        return DISABLED_BUG_FIXES.contains((Object)bug);
    }

    static {
        SwitchableBugFix.disabledBugs();
    }

    public static enum BugNumber {
        BUG_11891661,
        BUG_36125634;

        private final Set<BugNumber> requiredBugs;
        private final Set<BugNumber> incompatibleBugs;

        private BugNumber() {
            this.requiredBugs = Collections.emptySet();
            this.incompatibleBugs = Collections.emptySet();
        }

        private BugNumber(Collection<BugNumber> requiredBugs, Collection<BugNumber> incompatibleBugs) {
            this.requiredBugs = Collections.unmodifiableSet(new HashSet<BugNumber>(requiredBugs));
            this.incompatibleBugs = Collections.unmodifiableSet(new HashSet<BugNumber>(incompatibleBugs));
        }

        public static BugNumber fromValue(String value) throws IllegalArgumentException {
            String prefix;
            if ((value = value.toUpperCase().trim()).startsWith(prefix = "BUG_")) {
                prefix = "";
            }
            return BugNumber.valueOf(prefix + value);
        }
    }
}

