"use strict";

/**
 * Returns a display name for a value from a constructor
 * @param  {object} value A value to examine
 * @returns {(string|null)} A string or null
 */
function className(value) {
    const name = value.constructor && value.constructor.name;
    return name || null;
}

module.exports = className;
