/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther;

import ch.randelshofer.quaqua.BasicQuaquaLookAndFeel;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.color.AlphaColorUIResource;
import ch.randelshofer.quaqua.util.GroupBox;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.security.AccessControlException;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import sun.security.util.SecurityConstants;

public class Quaqua15PantherLookAndFeel
extends BasicQuaquaLookAndFeel {
    public Quaqua15PantherLookAndFeel() {
        super("apple.laf.AquaLookAndFeel");
    }

    public String getDescription() {
        return "The Quaqua Panther Look and Feel " + QuaquaManager.getVersion() + " for J2SE 5";
    }

    public String getName() {
        return "Quaqua Panther";
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaJaguarPrefix = "ch.randelshofer.quaqua.jaguar.QuaquaJaguar";
        String quaquaPantherPrefix = "ch.randelshofer.quaqua.panther.QuaquaPanther";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "ButtonUI", quaquaPrefix + "ButtonUI", "CheckBoxUI", quaquaPrefix + "CheckBoxUI", "ColorChooserUI", quaquaPrefix + "ColorChooserUI", "FileChooserUI", quaquaPantherPrefix + "FileChooserUI", "FormattedTextFieldUI", quaquaPrefix + "FormattedTextFieldUI", "RadioButtonUI", quaquaPrefix + "RadioButtonUI", "ToggleButtonUI", quaquaPrefix + "ToggleButtonUI", "SeparatorUI", quaquaPantherPrefix + "SeparatorUI", "ScrollBarUI", quaquaPrefix + "ScrollBarUI", "ScrollPaneUI", quaquaPrefix + "ScrollPaneUI", "SplitPaneUI", quaquaPrefix + "SplitPaneUI", "SliderUI", quaquaPrefix + "SliderUI", "SpinnerUI", quaquaPrefix + "SpinnerUI", "TabbedPaneUI", quaquaPantherPrefix + "TabbedPaneUI", "ToolBarSeparatorUI", quaquaPrefix + "ToolBarSeparatorUI", "PopupMenuSeparatorUI", quaquaPantherPrefix + "SeparatorUI", "TabbedPaneUI", quaquaPantherPrefix + "TabbedPaneUI", "TextAreaUI", quaquaPrefix + "TextAreaUI", "TextFieldUI", quaquaPrefix + "TextFieldUI", "PasswordFieldUI", quaquaPrefix + "PasswordFieldUI", "TextPaneUI", quaquaPrefix + "TextPaneUI", "EditorPaneUI", quaquaPrefix + "EditorPaneUI", "TreeUI", quaquaPrefix + "TreeUI", "LabelUI", quaquaPrefix + "LabelUI", "ListUI", quaquaPrefix + "ListUI", "ToolBarUI", quaquaPrefix + "ToolBarUI", "ComboBoxUI", quaquaPrefix + "ComboBoxUI", "TableUI", quaquaPrefix + "TableUI", "TableHeaderUI", quaquaPrefix + "TableHeaderUI", "OptionPaneUI", quaquaPrefix + "OptionPaneUI", "PanelUI", quaquaPrefix + "PanelUI", "ViewportUI", quaquaPrefix + "ViewportUI", "RootPaneUI", quaquaPrefix + "RootPaneUI"};
        this.putDefaults(table, uiDefaults);
        SecurityManager security = System.getSecurityManager();
        try {
            if (security != null) {
                security.checkPermission(SecurityConstants.ALL_AWT_EVENTS_PERMISSION);
            }
            uiDefaults = new Object[]{"PopupMenuUI", quaquaPrefix + "PopupMenuUI"};
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.putDefaults(table, uiDefaults);
        if (!this.isUseScreenMenuBar()) {
            uiDefaults = new Object[]{"MenuBarUI", quaquaPrefix + "MenuBarUI", "MenuUI", quaquaPrefix + "MenuUI", "MenuItemUI", quaquaPrefix + "MenuItemUI", "CheckBoxMenuItemUI", quaquaPrefix + "MenuItemUI", "RadioButtonMenuItemUI", quaquaPrefix + "MenuItemUI"};
            this.putDefaults(table, uiDefaults);
        }
    }

    private boolean isBrushedMetal() {
        String property;
        try {
            property = QuaquaManager.getProperty("apple.awt.brushMetalLook", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    private boolean isUseScreenMenuBar() {
        String property;
        try {
            property = QuaquaManager.getProperty("apple.laf.useScreenMenuBar", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        if (QuaquaManager.getOS() != 3) {
            boolean isBrushedMetal = this.isBrushedMetal();
            Object controlBackground = isBrushedMetal ? table.get("control") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/Panel.texture.png");
            Object menuBackground = isBrushedMetal ? table.get("menu") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png");
            Object menuHighlight = this.makeTextureColor(3437007, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.S.png");
            Object[] uiDefaults = new Object[]{"window", controlBackground, "control", controlBackground, "menu", menuBackground, "menuHighlight", menuHighlight, "listHighlight", table.get("textHighlight"), "listHighlightText", table.get("textHighlightText"), "listHighlightBorder", new ColorUIResource(0x808080)};
            this.putDefaults(table, uiDefaults);
        }
    }

    protected void initDesignDefaults(UIDefaults table) {
        boolean isBrushedMetal = this.isBrushedMetal();
        ColorUIResource disabledForeground = new ColorUIResource(128, 128, 128);
        ColorUIResource menuSelectionForeground = new ColorUIResource(255, 255, 255);
        Object panelBackground = isBrushedMetal ? table.get("TabbedPane.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/Panel.texture.png");
        Object[] uiDefaults = new Object[]{"Browser.expandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 0}), "Browser.expandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 1}), "Browser.focusedSelectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 2}), "Browser.focusedSelectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 3}), "Browser.selectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 4}), "Browser.selectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 5}), "FileChooser.cellTipOrigin", new Point(18, 0), "FileChooser.browserUseUnselectedExpandIconForLabeledFile", Boolean.TRUE, "Frame.titlePaneBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/panther/images/Frame.titlePaneBorders.png", new Insets(0, 0, 22, 0), 2, true), "Frame.titlePaneBorders.small", this.makeImageBevelBorders("/ch/randelshofer/quaqua/panther/images/Frame.titlePaneBorders.small.png", new Insets(0, 0, 16, 0), 2, true), "Frame.titlePaneBorders.mini", this.makeImageBevelBorders("/ch/randelshofer/quaqua/panther/images/Frame.titlePaneBorders.mini.png", new Insets(0, 0, 12, 0), 2, true), "Frame.titlePaneBorders.vertical", this.makeImageBevelBorders("/ch/randelshofer/quaqua/panther/images/Frame.titlePaneBorders.vertical.png", new Insets(0, 0, 0, 22), 2, false), "Frame.titlePaneBorders.vertical.small", this.makeImageBevelBorders("/ch/randelshofer/quaqua/panther/images/Frame.titlePaneBorders.vertical.small.png", new Insets(0, 0, 0, 16), 2, false), "Frame.titlePaneBorders.vertical.mini", this.makeImageBevelBorders("/ch/randelshofer/quaqua/panther/images/Frame.titlePaneBorders.vertical.mini.png", new Insets(0, 0, 0, 12), 2, false), "Label.embossForeground", new AlphaColorUIResource(0x7EFFFFFF), "Label.shadowForeground", new AlphaColorUIResource(0x7E000000), "RadioButtonMenuItem.checkIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "RootPane.background", panelBackground, "Separator.foreground", new ColorUIResource(139, 139, 139), "Separator.highlight", new ColorUIResource(243, 243, 243), "Separator.shadow", new ColorUIResource(213, 213, 213), "Separator.border", new VisualMarginBorder(), "TabbedPane.disabledForeground", disabledForeground, "TabbedPane.tabInsets", new InsetsUIResource(1, 10, 4, 9), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 2, 1), "TabbedPane.tabAreaInsets", new InsetsUIResource(4, 16, 0, 16), "TabbedPane.contentBorderInsets", new InsetsUIResource(5, 6, 6, 6), "TabbedPane.background", isBrushedMetal ? table.get("TabbedPane.background") : panelBackground, "TabbedPane.tabLayoutPolicy", this.isJaguarTabbedPane() ? 0 : 1, "TabbedPane.wrap.disabledForeground", disabledForeground, "TabbedPane.wrap.tabInsets", new InsetsUIResource(1, 10, 4, 9), "TabbedPane.wrap.selectedTabPadInsets", new InsetsUIResource(2, 2, 2, 1), "TabbedPane.wrap.tabAreaInsets", new InsetsUIResource(4, 16, 0, 16), "TabbedPane.wrap.contentBorderInsets", new InsetsUIResource(2, 3, 3, 3), "TabbedPane.wrap.background", isBrushedMetal ? table.get("TabbedPane.background") : panelBackground, "TabbedPane.scroll.selectedTabPadInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.scroll.tabRunOverlay", 0, "TabbedPane.scroll.tabInsets", new InsetsUIResource(1, 7, 2, 7), "TabbedPane.scroll.smallTabInsets", new InsetsUIResource(1, 5, 2, 5), "TabbedPane.scroll.outerTabInsets", new InsetsUIResource(1, 11, 2, 11), "TabbedPane.scroll.smallOuterTabInsets", new InsetsUIResource(1, 9, 2, 9), "TabbedPane.scroll.contentBorderInsets", new InsetsUIResource(2, 2, 2, 2), "TabbedPane.scroll.tabAreaInsets", new InsetsUIResource(-2, 16, 1, 16), "TabbedPane.scroll.contentBorder", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/GroupBox.png", new Insets(7, 7, 7, 7), true), "TabbedPane.scroll.emptyContentBorder", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/GroupBox.empty.png", new Insets(7, 7, 7, 7), true), "TabbedPane.scroll.tabBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/Toggle.borders.png", new Insets(8, 10, 15, 10), 10, true), "TabbedPane.scroll.tabFocusRing", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/Toggle.focusRing.png", new Insets(8, 10, 15, 10), true), "TabbedPane.scroll.eastTabBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/Toggle.east.borders.png", new Insets(8, 1, 15, 10), 10, true), "TabbedPane.scroll.eastTabFocusRing", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/Toggle.east.focusRing.png", new Insets(8, 4, 15, 10), true), "TabbedPane.scroll.centerTabBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/Toggle.center.borders.png", new Insets(8, 0, 15, 1), 10, true), "TabbedPane.scroll.centerTabFocusRing", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/Toggle.center.focusRing.png", new Insets(8, 4, 15, 4), false), "TabbedPane.scroll.westTabBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/Toggle.west.borders.png", new Insets(8, 10, 15, 1), 10, true), "TabbedPane.scroll.westTabFocusRing", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/Toggle.west.focusRing.png", new Insets(8, 10, 15, 4), true), "TitledBorder.border", new GroupBox(), "TitledBorder.titleColor", new ColorUIResource(0x303030), "ToolBar.background", isBrushedMetal ? table.get("ToolBar.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/ToolBar.texture.png"), "ToolBar.bottom.gradient", null, "ToolBar.bottom.inactiveGradient", null, "ToolBar.title.background", isBrushedMetal ? table.get("ToolBar.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/ToolBar.texture.png"), "ToolBarSeparator.foreground", new ColorUIResource(0x808080), "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 12, "Tree.sideBar.background", new ColorUIResource(0xFFFFFF), "Tree.sideBar.selectionBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.leopard.QuaquaLeopardSideBarSelectionBorder"), "Tree.sideBar.icons", Quaqua15PantherLookAndFeel.makeIcons("/ch/randelshofer/quaqua/leopard/images/Tree.sideBar.icons.png", 15, true), "Tree.sideBarCategory.foreground", new ColorUIResource(0), "Tree.sideBarCategory.selectionForeground", new ColorUIResource(0xFFFFFF), "Tree.sideBarCategory.font", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBarCategory.selectionFont", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBar.foreground", new ColorUIResource(0), "Tree.sideBar.selectionForeground", new ColorUIResource(0xFFFFFF), "Tree.sideBar.font", new FontUIResource("Lucida Grande", 0, 11), "Tree.sideBar.selectionFont", new FontUIResource("Lucida Grande", 1, 11)};
        this.putDefaults(table, uiDefaults);
        uiDefaults = this.isUseScreenMenuBar() ? new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6, new Rectangle(5, 1, 17, 12)), "CheckBoxMenuItem.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 2, 0), "Menu.checkIcon", Quaqua15PantherLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png", new Point(1, 0)), "Menu.arrowIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/MenuItem.arrowIcons.png", 2, new Rectangle(-12, 1, 0, 12)), "Menu.border", new BorderUIResource.EmptyBorderUIResource(0, 5, 2, 4), "Menu.margin", new InsetsUIResource(0, 8, 0, 8), "Menu.menuPopupOffsetX", 0, "Menu.menuPopupOffsetY", 1, "Menu.submenuPopupOffsetX", 0, "Menu.submenuPopupOffsetY", -4, "MenuItem.checkIcon", Quaqua15PantherLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png", new Point(1, 0)), "MenuItem.border", new BorderUIResource.EmptyBorderUIResource(0, 5, 2, 0), "RadioButtonMenuItem.checkIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6, new Rectangle(5, 0, 17, 12)), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 2, 0), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "PopupMenu.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png"), "PopupMenu.foreground", new ColorUIResource(Color.black)} : new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6, new Point(0, 1)), "CheckBoxMenuItem.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 2, 3), "CheckBoxMenuItem.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png"), "CheckBoxMenuItem.foreground", new ColorUIResource(0), "Menu.checkIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "Menu.arrowIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/MenuItem.arrowIcons.png", 2, new Point(0, 1)), "Menu.margin", new InsetsUIResource(0, 8, 0, 8), "Menu.menuPopupOffsetX", 0, "Menu.menuPopupOffsetY", 0, "Menu.submenuPopupOffsetX", 0, "Menu.submenuPopupOffsetY", -4, "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "Menu.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 2, 3), "Menu.selectionBackground", table.get("MenuItem.selectionBackground"), "Menu.selectionForeground", table.get("MenuItem.selectionForeground"), "Menu.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png"), "Menu.foreground", new ColorUIResource(0), "MenuBar.border", this.makeImageBevelBackgroundBorder("/ch/randelshofer/quaqua/tiger/images/MenuBar.border.png", new Insets(10, 0, 11, 0), new Insets(0, 0, 0, 0), true), "MenuBar.selectedBorder", this.makeImageBevelBackgroundBorder("/ch/randelshofer/quaqua/tiger/images/MenuBar.selectedBorder.png", new Insets(1, 0, 20, 0), new Insets(0, 0, 0, 0), true), "MenuBar.margin", new InsetsUIResource(1, 8, 2, 8), "MenuBar.shadow", null, "MenuBar.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png"), "MenuBar.foreground", new ColorUIResource(0), "MenuItem.checkIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 2, 3), "MenuItem.acceleratorSelectionForeground", menuSelectionForeground, "MenuItem.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png"), "MenuItem.foreground", new ColorUIResource(0), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "PopupMenu.background", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/panther/images/MenuBar.texture.png"), "PopupMenu.foreground", new ColorUIResource(Color.black), "RadioButtonMenuItem.checkIcon", Quaqua15PantherLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 2, 3), "RadioButtonMenuItem.background", panelBackground, "RadioButtonMenuItem.foreground", new ColorUIResource(0)};
        this.putDefaults(table, uiDefaults);
    }
}

