/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.tools.KafkaMigrationTool;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class MirrorMaker$
implements Logging,
ScalaObject {
    public static final MirrorMaker$ MODULE$;
    private Seq<ZookeeperConsumerConnector> connectors;
    private Seq<MirrorMaker.MirrorMakerThread> consumerThreads;
    private ListBuffer kafka$tools$MirrorMaker$$producerThreads;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private Seq<ZookeeperConsumerConnector> connectors() {
        return this.connectors;
    }

    private void connectors_$eq(Seq<ZookeeperConsumerConnector> seq2) {
        this.connectors = seq2;
    }

    private Seq<MirrorMaker.MirrorMakerThread> consumerThreads() {
        return this.consumerThreads;
    }

    private void consumerThreads_$eq(Seq<MirrorMaker.MirrorMakerThread> seq2) {
        this.consumerThreads = seq2;
    }

    public final ListBuffer kafka$tools$MirrorMaker$$producerThreads() {
        return this.kafka$tools$MirrorMaker$$producerThreads;
    }

    private void kafka$tools$MirrorMaker$$producerThreads_$eq(ListBuffer listBuffer) {
        this.kafka$tools$MirrorMaker$$producerThreads = listBuffer;
    }

    public void main(String[] args) {
        this.info((Function0<String>)new anonfun.main.1());
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> consumerConfigOpt = parser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> producerConfigOpt$1 = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> numProducersOpt = parser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> bufferSizeOpt = parser.accepts("queue.size", "Number of messages that are buffered between the consumer and producer").withRequiredArg().describedAs("Queue size in terms of number of messages").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(10000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
        OptionSet options$1 = parser.parse(args);
        if (options$1.has(helpOpt)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options$1, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt$1}));
        if (List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{whitelistOpt, blacklistOpt})).count(new anonfun.main.2(options$1)) != 1) {
            Predef$.MODULE$.println("Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        Integer numStreams$1 = options$1.valueOf(numStreamsOpt);
        int bufferSize = options$1.valueOf(bufferSizeOpt);
        IndexedSeq producers$1 = Predef$.MODULE$.intWrapper(1).to(options$1.valueOf(numProducersOpt)).map(new anonfun.1(producerConfigOpt$1, options$1), IndexedSeq$.MODULE$.canBuildFrom());
        this.connectors_$eq(((TraversableLike)JavaConversions$.MODULE$.asBuffer(options$1.valuesOf(consumerConfigOpt)).toList().map(new anonfun.main.3(), List$.MODULE$.canBuildFrom())).map(new anonfun.main.4(), List$.MODULE$.canBuildFrom()));
        TopicFilter filterSpec$1 = options$1.has(whitelistOpt) ? new Whitelist(options$1.valueOf(whitelistOpt)) : new Blacklist(options$1.valueOf(blacklistOpt));
        Seq<Nothing$> streams2 = Nil$.MODULE$;
        try {
            streams2 = (Seq)((GenericTraversableTemplate)this.connectors().map(new anonfun.main.5(numStreams$1, filterSpec$1), Seq$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.conforms());
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new anonfun.main.6());
            this.connectors().foreach(new anonfun.main.7());
        }
        KafkaMigrationTool.ProducerDataChannel producerDataChannel$1 = new KafkaMigrationTool.ProducerDataChannel(bufferSize);
        this.consumerThreads_$eq(((TraversableLike)streams2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map(new anonfun.main.8(producers$1, producerDataChannel$1), Seq$.MODULE$.canBuildFrom()));
        this.kafka$tools$MirrorMaker$$producerThreads_$eq(new ListBuffer());
        Runtime.getRuntime().addShutdownHook(new anon.2());
        IntRef i$1 = new IntRef(1);
        producers$1.foreach(new anonfun.main.9(producerDataChannel$1, i$1));
        this.consumerThreads().foreach(new anonfun.main.10());
        this.kafka$tools$MirrorMaker$$producerThreads().foreach(new anonfun.main.11());
        this.consumerThreads().foreach(new anonfun.main.12());
        this.cleanShutdown();
    }

    public void cleanShutdown() {
        if (this.connectors() != null) {
            this.connectors().foreach(new anonfun.cleanShutdown.1());
        }
        if (this.consumerThreads() != null) {
            this.consumerThreads().foreach(new anonfun.cleanShutdown.2());
        }
        if (this.kafka$tools$MirrorMaker$$producerThreads() != null) {
            this.kafka$tools$MirrorMaker$$producerThreads().foreach(new anonfun.cleanShutdown.3());
            this.kafka$tools$MirrorMaker$$producerThreads().foreach(new anonfun.cleanShutdown.4());
        }
        this.info((Function0<String>)new anonfun.cleanShutdown.5());
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.connectors = null;
        this.consumerThreads = null;
        this.kafka$tools$MirrorMaker$$producerThreads = null;
    }
}

