/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sparklyr.BackendConf$;
import sparklyr.BackendHandler;
import sparklyr.JVMObjectTracker;
import sparklyr.Logger;
import sparklyr.Serializer;
import sparklyr.Utils$;

@ScalaSignature(bytes="\u0006\u0005}4Aa\u0004\t\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!1\u0003A!A!\u0002\u00139\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b9\u0002A\u0011A\u0018\t\rU\u0002\u0001\u0015)\u00037\u0011\u0019\u0001\u0005\u0001)Q\u0005\u0003\"1a\t\u0001Q!\n\u001dCaA\u0013\u0001!B\u0013Y\u0005BB*\u0001A\u0003&A\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0003d\u0001\u0011\u0005A\rC\u0003}\u0001\u0011\u0005Q\u0010C\u0003\u007f\u0001\u0011\u0005QP\u0001\bCC\u000e\\WM\u001c3DQ\u0006tg.\u001a7\u000b\u0003E\t\u0001b\u001d9be.d\u0017P]\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0007Y><w-\u001a:\u0011\u0005qiR\"\u0001\t\n\u0005y\u0001\"A\u0002'pO\u001e,'/A\u0005uKJl\u0017N\\1uKB\u0019Q#I\u0012\n\u0005\t2\"!\u0003$v]\u000e$\u0018n\u001c81!\t)B%\u0003\u0002&-\t!QK\\5u\u0003)\u0019XM]5bY&TXM\u001d\t\u00039!J!!\u000b\t\u0003\u0015M+'/[1mSj,'/A\u0004ue\u0006\u001c7.\u001a:\u0011\u0005qa\u0013BA\u0017\u0011\u0005AQe+T(cU\u0016\u001cG\u000f\u0016:bG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0006aE\u00124\u0007\u000e\t\u00039\u0001AQAG\u0003A\u0002mAQaH\u0003A\u0002\u0001BQAJ\u0003A\u0002\u001dBQAK\u0003A\u0002-\nQb\u00195b]:,GNR;ukJ,\u0007CA\u001c?\u001b\u0005A$BA\u001d;\u0003\u001d\u0019\u0007.\u00198oK2T!a\u000f\u001f\u0002\u000b9,G\u000f^=\u000b\u0003u\n!![8\n\u0005}B$!D\"iC:tW\r\u001c$viV\u0014X-A\u0005c_>$8\u000f\u001e:baB\u0011!\tR\u0007\u0002\u0007*\u0011\u0001IO\u0005\u0003\u000b\u000e\u0013qbU3sm\u0016\u0014(i\\8ugR\u0014\u0018\r]\u0001\nE>\u001c8o\u0012:pkB\u0004\"a\u000e%\n\u0005%C$AD#wK:$Hj\\8q\u000fJ|W\u000f]\u0001\fS:,G/\u00113ee\u0016\u001c8\u000f\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006\u0019a.\u001a;\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018a\u00035pgR\u001cuN\u001c;fqR\u0004\"!\u0016/\u000f\u0005YS\u0006CA,\u0017\u001b\u0005A&BA-\u0013\u0003\u0019a$o\\8u}%\u00111LF\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\-\u0005q1/\u001a;I_N$8i\u001c8uKb$HCA\u0012b\u0011\u0015\u00117\u00021\u0001U\u0003AAwn\u001d;D_:$X\r\u001f;QCJ\fW.\u0001\u0003j]&$H#B3i[>\f\bCA\u000bg\u0013\t9gCA\u0002J]RDQ!\u001b\u0007A\u0002)\faA]3n_R,\u0007CA\u000bl\u0013\tagCA\u0004C_>dW-\u00198\t\u000b9d\u0001\u0019A3\u0002\tA|'\u000f\u001e\u0005\u0006a2\u0001\rA[\u0001\u0012I\u0016$XM]7j]&\u001cH/[2Q_J$\b\"\u0002:\r\u0001\u0004\u0019\u0018a\u00049sK\u000e{W.\\1oI\"{wn[:\u0011\u0007U!h/\u0003\u0002v-\t1q\n\u001d;j_:\u0004\"a\u001e>\u000e\u0003aT!!_(\u0002\t1\fgnZ\u0005\u0003wb\u0014\u0001BU;o]\u0006\u0014G.Z\u0001\u0004eVtG#A\u0012\u0002\u000b\rdwn]3")
public class BackendChannel {
    private final Logger logger;
    private final Function0<BoxedUnit> terminate;
    private final Serializer serializer;
    private final JVMObjectTracker tracker;
    private ChannelFuture channelFuture;
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private InetSocketAddress inetAddress;
    private String hostContext;

    public void setHostContext(String hostContextParam) {
        this.hostContext = hostContextParam;
    }

    public int init(boolean remote, int port, boolean deterministicPort, Option<Runnable> preCommandHooks) {
        if (remote) {
            byte[] anyIpAddress = new byte[]{0, 0, 0, 0};
            InetAddress anyInetAddress = InetAddress.getByAddress(null, anyIpAddress);
            int channelPort = deterministicPort ? Utils$.MODULE$.nextPort(port, anyInetAddress) : 0;
            this.logger.log(new StringBuilder(34).append("is using port ").append(channelPort).append(" for backend channel").toString());
            this.inetAddress = new InetSocketAddress(anyInetAddress, channelPort);
        } else {
            int channelPort = deterministicPort ? Utils$.MODULE$.nextPort(port, InetAddress.getLoopbackAddress()) : 0;
            this.logger.log(new StringBuilder(34).append("is using port ").append(channelPort).append(" for backend channel").toString());
            this.inetAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), channelPort);
        }
        EventLoopGroup workerGroup = this.bossGroup = new NioEventLoopGroup(BackendConf$.MODULE$.getNumThreads());
        BackendHandler handler = new BackendHandler((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.close(), this.logger, this.hostContext, this.serializer, this.tracker, preCommandHooks);
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, workerGroup).channel(NioServerSocketChannel.class);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(null, handler){
            private final BackendHandler handler$1;

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast("encoder", (ChannelHandler)new ByteArrayEncoder()).addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)).addLast("decoder", (ChannelHandler)new ByteArrayDecoder()).addLast("handler", (ChannelHandler)this.handler$1);
            }
            {
                this.handler$1 = handler$1;
            }
        });
        this.channelFuture = this.bootstrap.bind((SocketAddress)this.inetAddress);
        this.channelFuture.syncUninterruptibly();
        return ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
    }

    public void run() {
        this.channelFuture.channel().closeFuture().syncUninterruptibly();
    }

    public void close() {
        this.terminate.apply$mcV$sp();
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.group() != null) {
            this.bootstrap.group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.childGroup() != null) {
            this.bootstrap.childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }

    public BackendChannel(Logger logger, Function0<BoxedUnit> terminate, Serializer serializer, JVMObjectTracker tracker) {
        this.logger = logger;
        this.terminate = terminate;
        this.serializer = serializer;
        this.tracker = tracker;
        this.channelFuture = null;
        this.bootstrap = null;
        this.bossGroup = null;
        this.inetAddress = null;
        this.hostContext = null;
    }
}

