## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = FALSE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(rmonocypher)

# Using additional data to encrypt a message
file     <- tempfile()
key      <- argon2("my secret key2")
message  <- 'Meet me in St Louis' 
address  <- 'To: Judy'
enc      <- encrypt(message, file, key, additional_data = address)

## -----------------------------------------------------------------------------
# Package the additional data and deliver to recipient
letter <- list(address = address, message = file)
letter

# Recipient decodes message, and the 'address' forms part of the decryption.
decrypt(letter$message, key = key, additional_data = letter$address)

## ----error = TRUE-------------------------------------------------------------
try({
letter$address <- "To: Sandra"
decrypt(letter$message, key = key, additional_data = letter$address)
})

