/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

abstract class AbstractTriangBandMatrix
extends AbstractBandMatrix {
    private BLASkernel.UpLo uplo;
    private BLASkernel.Diag diag;
    int kd;

    AbstractTriangBandMatrix(int n, int kl, int ku, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        super(n, kl, ku);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangBandMatrix(Matrix A, int kl, int ku, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        this(A, kl, ku, true, uplo, diag);
    }

    AbstractTriangBandMatrix(Matrix A, int kl, int ku, boolean deep, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        super(A, kl, ku, deep);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    public Vector mult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        Interface.blas().tbmv(this.uplo, BLASkernel.Transpose.NoTranspose, this.diag, this.numRows, this.kd, this.data, this.kd + 1, yd);
        return y;
    }

    public Vector transMult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        Interface.blas().tbmv(this.uplo, BLASkernel.Transpose.Transpose, this.diag, this.numRows, this.kd, this.data, this.kd + 1, yd);
        return y;
    }

    public Matrix solve(Matrix B, Matrix X) {
        return this.solve(B, X, BLASkernel.Transpose.NoTranspose);
    }

    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X, BLASkernel.Transpose.Transpose);
    }

    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix solve(Matrix B, Matrix X, BLASkernel.Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().tbtrs(this.uplo, trans, this.diag, this.numRows, this.kd, X.numColumns(), this.data, Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }
}

