/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.inference.distribution.shrinkage.BayesianBridgeDistributionModel;
import dr.inference.distribution.shrinkage.BayesianBridgeRNG;
import dr.inference.model.Parameter;
import dr.inference.model.PriorPreconditioningProvider;
import dr.math.distributions.NormalDistribution;

public class JointBayesianBridgeDistributionModel
extends BayesianBridgeDistributionModel
implements PriorPreconditioningProvider {
    private final Parameter localScale;
    private final Parameter slabWidth;

    public JointBayesianBridgeDistributionModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, int n, boolean bl) {
        super(parameter, parameter3, n, bl);
        this.localScale = parameter2;
        this.slabWidth = parameter4;
        if (n != parameter2.getDimension()) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        this.addVariable(parameter2);
    }

    @Override
    public double getCoefficient(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Parameter getLocalScale() {
        return this.localScale;
    }

    @Override
    public Parameter getSlabWidth() {
        return this.slabWidth;
    }

    @Override
    double[] gradientLogPdf(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = NormalDistribution.gradLogPdf(dArray[i], 0.0, this.getStandardDeviation(i));
        }
        return dArray2;
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += NormalDistribution.logPdf(dArray[i], 0.0, this.getStandardDeviation(i));
        }
        if (this.includeNormalizingConstant) {
            throw new RuntimeException("Not yet implemented");
        }
        return d;
    }

    @Override
    public double getStandardDeviation(int n) {
        double d = this.globalScale.getParameterValue(0) * this.localScale.getParameterValue(n);
        if (this.slabWidth != null) {
            double d2 = d / this.slabWidth.getParameterValue(0);
            d /= Math.sqrt(1.0 + d2 * d2);
        }
        return d;
    }

    @Override
    public double[] hessianLogPdf(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = NormalDistribution.hessianLogPdf(dArray[i], 0.0, this.getStandardDeviation(i));
        }
        return dArray2;
    }

    @Override
    public double[] nextRandom() {
        double[] dArray = this.slabWidth != null ? BayesianBridgeRNG.nextRandom(this.globalScale.getParameterValue(0), this.exponent.getParameterValue(0), this.slabWidth.getParameterValue(0), this.dim) : BayesianBridgeRNG.nextRandom(this.globalScale.getParameterValue(0), this.exponent.getParameterValue(0), this.dim);
        return dArray;
    }
}

