/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeStatistic;
import dr.stats.DiscreteStatistics;

public class RateStatistic
extends TreeStatistic {
    private Tree tree = null;
    private BranchRateModel branchRateModel = null;
    private boolean internal = true;
    private boolean external = true;
    private String mode = "mean";

    public RateStatistic(String string, Tree tree, BranchRateModel branchRateModel, boolean bl, boolean bl2, String string2) {
        super(string);
        this.tree = tree;
        this.branchRateModel = branchRateModel;
        this.internal = bl2;
        this.external = bl;
        this.mode = string2;
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.external) {
            n4 = n3 += this.tree.getExternalNodeCount();
        }
        if (this.internal) {
            n3 += this.tree.getInternalNodeCount() - 1;
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n4; ++n2) {
            NodeRef nodeRef = this.tree.getExternalNode(n2);
            NodeRef nodeRef2 = this.tree.getParent(nodeRef);
            dArray2[n2] = this.tree.getNodeHeight(nodeRef2) - this.tree.getNodeHeight(nodeRef);
            dArray[n2] = this.branchRateModel.getBranchRate(this.tree, nodeRef);
        }
        if (this.internal) {
            n2 = this.tree.getInternalNodeCount();
            int n5 = n4;
            for (int i = 0; i < n2; ++i) {
                NodeRef nodeRef = this.tree.getInternalNode(i);
                if (this.tree.isRoot(nodeRef)) continue;
                NodeRef nodeRef3 = this.tree.getParent(nodeRef);
                dArray2[n5] = this.tree.getNodeHeight(nodeRef3) - this.tree.getNodeHeight(nodeRef);
                dArray[n5] = this.branchRateModel.getBranchRate(this.tree, nodeRef);
                ++n5;
            }
        }
        if (this.mode.equals("mean")) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray2[i];
                d2 += dArray2[i];
            }
            return d / d2;
        }
        if (this.mode.equals("variance")) {
            return DiscreteStatistics.variance(dArray);
        }
        if (this.mode.equals("coefficientOfVariation")) {
            double d = DiscreteStatistics.mean(dArray);
            return Math.sqrt(DiscreteStatistics.variance(dArray, d)) / d;
        }
        throw new IllegalArgumentException();
    }
}

