/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.speciation.MaskableSpeciationModel;
import dr.evomodel.speciation.SpeciationModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.List;

public class ModelAveragingSpeciationLikelihood
extends AbstractModelLikelihood
implements Units {
    List<MaskableSpeciationModel> speciationModels = null;
    List<Tree> trees = null;
    Variable<Integer> indexVariable = null;
    Variable<Double> maxIndexVariable = null;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;

    public ModelAveragingSpeciationLikelihood(List<Tree> list, List<MaskableSpeciationModel> list2, Variable<Integer> variable, Variable<Double> variable2, String string) {
        this("speciationLikelihood", list, list2, variable, variable2);
        this.setId(string);
    }

    public ModelAveragingSpeciationLikelihood(String string, List<Tree> list, List<MaskableSpeciationModel> list2, Variable<Integer> variable, Variable<Double> variable2) {
        super(string);
        int n;
        this.trees = list;
        this.speciationModels = list2;
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("The number of trees and the number of speciation models should be equal.");
        }
        for (Tree units : list) {
            if (!(units instanceof Model)) continue;
            this.addModel((Model)((Object)units));
        }
        for (SpeciationModel speciationModel : list2) {
            if (speciationModel == null) continue;
            this.addModel(speciationModel);
        }
        if (variable.getSize() + 1 != list.size()) {
            throw new IllegalArgumentException("Index parameter must be same size as the number of trees.");
        }
        this.indexVariable = variable;
        for (n = 0; n < variable.getSize(); ++n) {
            variable.setValue(n, n + 1);
        }
        variable.addBounds(new Bounds.Staircase(variable));
        this.addVariable(variable);
        for (n = 0; n < variable2.getSize(); ++n) {
            variable2.setValue(n, 0.0);
        }
        this.maxIndexVariable = variable2;
        this.addVariable(variable2);
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected final void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected final void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
    }

    private double calculateLogLikelihood() {
        double d = 0.0;
        if (!this.isValidate(this.indexVariable.getValues())) {
            return Double.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < this.trees.size(); ++i) {
            MaskableSpeciationModel maskableSpeciationModel = this.speciationModels.get(i);
            if (i > 0) {
                SpeciationModel speciationModel = this.speciationModels.get(this.indexVariable.getValue(i - 1));
                if (maskableSpeciationModel != speciationModel) {
                    maskableSpeciationModel.mask(speciationModel);
                } else {
                    maskableSpeciationModel.unmask();
                }
            }
            d += maskableSpeciationModel.calculateTreeLogLikelihood(this.trees.get(i));
        }
        Double d2 = this.getMaxIndex(this.indexVariable.getValues());
        this.maxIndexVariable.setValue(0, d2);
        return d;
    }

    private boolean isValidate(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            if (integerArray[i] > 0) {
                int n = integerArray[i] - 1;
                nArray[n] = nArray[n] + 1;
            }
            if (i <= 0 || integerArray[i] - integerArray[i - 1] <= 1) continue;
            for (int j = 0; j < i; ++j) {
                if (nArray[j] >= 1) continue;
                return false;
            }
        }
        return true;
    }

    private int getMaxIndex(Integer[] integerArray) {
        int n = 0;
        Integer[] integerArray2 = integerArray;
        int n2 = integerArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray2[i];
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    private void output(String string, Variable<Integer> variable) {
        System.out.print(string + ": ");
        for (int i = 0; i < variable.getSize(); ++i) {
            System.out.print(variable.getValue(i) + "\t");
        }
        System.out.println();
    }

    @Override
    public final LogColumn[] getColumns() {
        String string = this.getId();
        if (string == null) {
            string = this.getModelName() + ".likelihood";
        }
        return new LogColumn[]{new LikelihoodColumn(string)};
    }

    @Override
    public final void setUnits(Units.Type type) {
        for (SpeciationModel speciationModel : this.speciationModels) {
            speciationModel.setUnits(type);
        }
    }

    @Override
    public final Units.Type getUnits() {
        return this.speciationModels.get(0).getUnits();
    }

    private final class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ModelAveragingSpeciationLikelihood.this.getLogLikelihood();
        }
    }
}

