/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.GMRFSkyrideLikelihood;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GMRFDensityComponent
implements Likelihood {
    public static final String PARSER_NAME = "gmrfDensityComponent";
    public static final String COMPONENT = "component";
    public static final String COALESCENT_TAG = "coalescent";
    public static final String GMRF_TAG = "gmrf";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("component"), new ElementRule(GMRFSkyrideLikelihood.class)};

        @Override
        public String getParserName() {
            return GMRFDensityComponent.PARSER_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl;
            GMRFSkyrideLikelihood gMRFSkyrideLikelihood = (GMRFSkyrideLikelihood)xMLObject.getChild(GMRFSkyrideLikelihood.class);
            String string = (String)xMLObject.getAttribute(GMRFDensityComponent.COMPONENT);
            if (string.compareToIgnoreCase(GMRFDensityComponent.COALESCENT_TAG) == 0) {
                bl = true;
            } else if (string.compareToIgnoreCase(GMRFDensityComponent.GMRF_TAG) == 0) {
                bl = false;
            } else {
                throw new XMLParseException("Unknown component of GMRF Skyride");
            }
            return new GMRFDensityComponent(gMRFSkyrideLikelihood, bl);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a single component (coalescent or field) of the GMRF Skyride.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private GMRFSkyrideLikelihood skyride;
    private boolean returnCoalescent;
    private String tag;

    public GMRFDensityComponent(GMRFSkyrideLikelihood gMRFSkyrideLikelihood, boolean bl) {
        this.skyride = gMRFSkyrideLikelihood;
        this.returnCoalescent = bl;
        this.tag = bl ? ".coalescent" : ".gmrf";
    }

    @Override
    public Model getModel() {
        return this.skyride;
    }

    @Override
    public double getLogLikelihood() {
        double d = this.skyride.getLogLikelihood();
        d = this.returnCoalescent ? (d -= this.skyride.peakLogFieldLikelihood()) : (d -= this.skyride.peakLogCoalescentLikelihood());
        return d;
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    @Override
    public void makeDirty() {
        this.skyride.makeDirty();
    }

    @Override
    public String prettyName() {
        return this.skyride.prettyName() + this.tag;
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return this.skyride.isUsed();
    }

    @Override
    public void setUsed() {
        this.skyride.setUsed();
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId())};
    }

    @Override
    public String getId() {
        return this.skyride.getId() + this.tag;
    }

    @Override
    public void setId(String string) {
        this.skyride.setId(string);
    }

    protected class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return GMRFDensityComponent.this.getLogLikelihood();
        }
    }
}

