/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.wrightfisher.FitnessFunction;
import dr.evolution.wrightfisher.Genome;
import dr.evolution.wrightfisher.Mutator;
import dr.evolution.wrightfisher.SimpleGenome;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class Population {
    List<Genome> population = null;
    double meanFitness;
    Mutator mutator = null;
    FitnessFunction fitnessFunction = null;
    static double[] cumulativeFitness = null;

    public Population(int n, int n2, Mutator mutator, FitnessFunction fitnessFunction, boolean bl) {
        this.population = new ArrayList<Genome>();
        for (int i = 0; i < n; ++i) {
            this.population.add(new SimpleGenome(n2, fitnessFunction, bl));
        }
        this.mutator = mutator;
        this.fitnessFunction = fitnessFunction;
        cumulativeFitness = new double[n];
    }

    private Population(List<Genome> list, Mutator mutator, FitnessFunction fitnessFunction) {
        this.population = list;
        this.mutator = mutator;
        this.fitnessFunction = fitnessFunction;
    }

    public int pickParent() {
        return MathUtils.randomChoice(cumulativeFitness);
    }

    public final Mutator getMutator() {
        return this.mutator;
    }

    public final int getGenomeLength() {
        return this.population.get(0).getGenomeLength();
    }

    public final SimpleGenome getGenome(int n) {
        return (SimpleGenome)this.population.get(n);
    }

    public final Population nextGeneration() {
        this.calculateCumulativeRelativeFitnesses();
        int n = this.population.size();
        ArrayList<Genome> arrayList = new ArrayList<Genome>();
        for (int i = 0; i < n; ++i) {
            Genome genome = this.population.get(this.pickParent());
            arrayList.add(genome.replicate(this.mutator, this.fitnessFunction));
        }
        Population population = new Population(arrayList, this.mutator, this.fitnessFunction);
        return population;
    }

    private void calculateCumulativeRelativeFitnesses() {
        int n = this.population.size();
        if (cumulativeFitness == null) {
            cumulativeFitness = new double[n];
        }
        Population.cumulativeFitness[0] = ((SimpleGenome)this.population.get((int)0)).fitness;
        for (int i = 1; i < n; ++i) {
            Population.cumulativeFitness[i] = cumulativeFitness[i - 1] + ((SimpleGenome)this.population.get((int)i)).fitness;
        }
        double d = cumulativeFitness[n - 1];
        if (d == 0.0) {
            throw new RuntimeException("Population crashed! No viable children.");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            cumulativeFitness[n3] = cumulativeFitness[n3] / d;
        }
        this.meanFitness = d / (double)n;
    }

    public static Population forwardSimulation(Population population, int n) {
        Population population2 = population;
        for (int i = 0; i < n; ++i) {
            population2 = population2.nextGeneration();
        }
        return population2;
    }

    public int getAgeOfMRCA(double[] dArray) {
        int n;
        int n2 = this.population.size();
        for (n = 0; n < n2; ++n) {
            this.getGenome(n).mark();
        }
        n = 1;
        Genome genome = this.getGenome(0);
        while (genome != null && genome.getMarks() < n2) {
            genome = genome.getParent();
            ++n;
        }
        for (int i = 0; i < n2; ++i) {
            this.getGenome(i).unmark();
        }
        if (genome != null) {
            dArray[0] = genome.getFitness();
            return n;
        }
        dArray[0] = 0.0;
        return -1;
    }

    public Genome getMRCA() {
        Genome genome;
        int n = this.population.size();
        for (int i = 0; i < n; ++i) {
            this.getGenome(i).mark();
        }
        for (genome = this.getGenome(0); genome != null && genome.getMarks() < n; genome = genome.getParent()) {
        }
        for (int i = 0; i < n; ++i) {
            this.getGenome(i).unmark();
        }
        return genome;
    }

    public void unfoldedSiteFrequencies(List<Double>[] listArray) {
        int n = this.population.size();
        double[][] dArray = this.fitnessFunction.getFitnessTable();
        Genome genome = this.getMRCA();
        byte[] byArray = genome.getSequence();
        int n2 = this.getGenome(0).getGenomeLength();
        for (int i = 0; i < n2; ++i) {
            int n3;
            byte by = byArray[i];
            double d = dArray[i][by];
            double d2 = dArray[i][(by + 1) % 2];
            double d3 = d2 / d;
            if (d == 0.0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    System.err.print(byArray[n3]);
                }
                System.err.println();
                throw new RuntimeException("Progenitor fitness can not be zero!");
            }
            if (d3 == 0.0) continue;
            n3 = 0;
            for (int j = 0; j < n; ++j) {
                if (this.getGenome((int)j).sequence[i] == by) continue;
                ++n3;
            }
            listArray[n3].add(d3);
        }
    }

    public double getMeanParentFitness() {
        double d = 0.0;
        int n = this.population.size();
        for (int i = 0; i < n; ++i) {
            d += this.getGenome(i).getParent().getFitness();
        }
        return d / (double)n;
    }

    public double getProportionAsFit(double d) {
        int n = 0;
        int n2 = this.population.size();
        for (int i = 0; i < n2; ++i) {
            if (!(this.getGenome((int)i).fitness >= d)) continue;
            ++n;
        }
        return (double)n / (double)n2;
    }

    public void getTipHammingDistance(int n, List<Double>[] listArray) {
        int n2;
        int n3 = this.population.size();
        for (n2 = 0; n2 < n; ++n2) {
            this.getGenome(n2).mark();
        }
        for (n2 = 0; n2 < n; ++n2) {
            SimpleGenome simpleGenome;
            Genome genome = simpleGenome = this.getGenome(n2);
            int n4 = 0;
            while (genome.getMarks() < n3 && n4 < listArray.length) {
                listArray[n2].add(Double.valueOf(simpleGenome.hammingDistance(genome)));
                ++n4;
                genome = genome.getParent();
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.getGenome(n2).unmark();
        }
    }

    public void getMutationDensity(int n, List<Integer>[] listArray) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            this.getGenome(n2).mark();
        }
        for (n2 = 0; n2 < n; ++n2) {
            Genome genome = this.getGenome(n2);
            int n3 = 0;
            while (genome.getMarks() < n && n3 < listArray.length) {
                listArray[n3].add(genome.getMutations().length);
                ++n3;
                genome = genome.getParent();
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.getGenome(n2).unmark();
        }
    }

    public int getFirstActiveLineage() {
        int n = this.population.size();
        for (int i = 0; i < n; ++i) {
            if (this.getGenome(i).getMarks() <= 0) continue;
            return i;
        }
        return -1;
    }

    public int getActiveLineageCount() {
        int n = 0;
        int n2 = this.population.size();
        for (int i = 0; i < n2; ++i) {
            if (this.getGenome(i).getMarks() <= 0) continue;
            ++n;
        }
        return n;
    }

    public int getActiveMutationsCount() {
        int n = 0;
        int n2 = this.population.size();
        for (int i = 0; i < n2; ++i) {
            if (this.getGenome(i).getMarks() <= 0) continue;
            n += this.getGenome((int)i).mutations.length;
        }
        return n;
    }
}

