/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;

public class ScaledDemographic
extends DemographicFunction.Abstract {
    private final double scale;
    private final DemographicFunction demo;

    public ScaledDemographic(DemographicFunction demographicFunction, double d) {
        super(demographicFunction.getUnits());
        this.scale = d;
        this.demo = demographicFunction;
    }

    @Override
    public double getDemographic(double d) {
        return this.demo.getDemographic(d) * this.scale;
    }

    @Override
    public double getIntensity(double d) {
        return this.demo.getIntensity(d) / this.scale;
    }

    @Override
    public double getIntegral(double d, double d2) {
        return (this.demo.getIntensity(d2) - this.demo.getIntensity(d)) / this.scale;
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public int getNumArguments() {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public String getArgumentName(int n) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public double getArgument(int n) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public void setArgument(int n, double d) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public double getLowerBound(int n) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public double getUpperBound(int n) {
        throw new RuntimeException("unimplemented");
    }

    public DemographicFunction getCopy() {
        throw new RuntimeException("unimplemented");
    }
}

