/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.propagation.listener.IntPropagator;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractIntSConstraint
extends AbstractSConstraint<IntDomainVar>
implements IntPropagator {
    protected AbstractIntSConstraint(int priority, IntDomainVar[] vars) {
        super(priority, (Var[])vars);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (deltaDomain != null) {
            try {
                while (deltaDomain.hasNext()) {
                    int val = deltaDomain.next();
                    this.awakeOnRem(idx, val);
                }
            }
            finally {
                deltaDomain.dispose();
            }
        }
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.awakeOnInf(varIndex);
        this.awakeOnSup(varIndex);
    }

    @Override
    public boolean isConsistent() {
        return this.isEntailed() == Boolean.TRUE;
    }

    @Override
    public boolean isSatisfied() {
        int[] tuple = new int[this.getNbVars()];
        for (int i = 0; i < tuple.length; ++i) {
            assert (((IntDomainVar)this.getVar(i)).isInstantiated());
            tuple[i] = ((IntDomainVar)this.getVar(i)).getVal();
        }
        return this.isSatisfied(tuple);
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        throw new UnsupportedOperationException(this + " needs to implement isSatisfied(int[] tuple) to be embedded in reified constraints");
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.INTEGER;
    }
}

