/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.cp.solver.constraints.integer.MemberBound;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractUnIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class NotMemberBound
extends AbstractUnIntSConstraint {
    final int lower;
    final int upper;

    public NotMemberBound(IntDomainVar v0, int lower, int upper) {
        super(v0);
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.removeInterval(this.lower, this.upper, this, false)) {
            this.setEntailed();
        }
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new MemberBound(this.v0, this.lower, this.upper);
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder("NOT MEMBER(");
        sb.append(this.v0.pretty()).append(",[").append(this.lower).append(",").append(this.upper).append("])");
        return sb.toString();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] < this.lower || tuple[0] > this.upper;
    }

    @Override
    public boolean isSatisfied() {
        return this.v0.getVal() < this.lower && this.v0.getVal() > this.upper;
    }

    @Override
    public Boolean isEntailed() {
        DisposableIntIterator it = this.v0.getDomain().getIterator();
        int in = 0;
        int out = 0;
        while (it.hasNext()) {
            if (this.v0.canBeInstantiatedTo(it.next())) {
                ++in;
            } else {
                ++out;
            }
            if (in <= 0 || out <= 0) continue;
            return null;
        }
        if (in == this.v0.getDomainSize()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

