/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_multicostregular;

import choco.cp.solver.CPSolver;
import choco.kernel.common.Constant;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.model.constraints.automaton.penalty.IPenaltyFunction;
import choco.kernel.model.constraints.automaton.penalty.IsoPenaltyFunction;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.algo.SoftPathFinder;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.Node;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.SoftStoredMultiValuedDirectedMultiGraph;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntStack;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import org.jgrapht.graph.DirectedMultigraph;

public class SoftMultiCostRegular
extends AbstractLargeIntSConstraint {
    AbstractIntSConstraint[] tableConstraints;
    IntDomainVar[] x;
    IntDomainVar[] y;
    IntDomainVar[] z;
    IntDomainVar Z;
    IPenaltyFunction[] f;
    IAutomaton pi;
    int[][][][] costs;
    CPSolver solver;
    TIntHashSet indexes;
    SoftStoredMultiValuedDirectedMultiGraph graph;
    SoftPathFinder path;
    public final TObjectIntHashMap<IntDomainVar> map;
    public int[] lastSp;
    public double lastSpValue;
    public int[] lastLp;
    public double lastLpValue;
    static final int U0 = 10;
    int lastWorld = -1;
    int lastNbOfBacktracks = -1;
    int lastNbOfRestarts = -1;
    protected final TIntStack toRemove;
    protected final TIntStack[] toUpdateLeft;
    protected final TIntStack[] toUpdateRight;
    int xOff;
    int yOff;
    int zOff;
    int Zidx;
    private TIntHashSet boundUpdate;
    private boolean computed;
    private static final double PRECISION = Math.pow(10.0, 4.0);
    int count = 0;

    public SoftMultiCostRegular(IntDomainVar[] x, IntDomainVar[] y, IntDomainVar[] z, IntDomainVar Z, int[] indexes, IPenaltyFunction[] f, IAutomaton pi, int[][][][] costs, CPSolver solver) {
        super(ConstraintEvent.VERY_SLOW, ArrayUtils.append(x, y, z, {Z}));
        int i;
        this.x = x;
        this.y = y;
        this.z = z;
        this.Z = Z;
        this.f = f;
        this.pi = pi;
        this.costs = costs;
        this.indexes = new TIntHashSet(indexes);
        this.solver = solver;
        this.toRemove = new TIntStack();
        this.toUpdateLeft = new TIntStack[y.length];
        this.toUpdateRight = new TIntStack[y.length];
        for (i = 0; i < this.toUpdateLeft.length; ++i) {
            this.toUpdateLeft[i] = new TIntStack();
            this.toUpdateRight[i] = new TIntStack();
        }
        this.xOff = 0;
        this.yOff = x.length;
        this.zOff = this.yOff + y.length;
        this.Zidx = this.zOff + z.length;
        this.map = new TObjectIntHashMap();
        for (i = 0; i < x.length; ++i) {
            this.map.put(x[i], i);
        }
        this.boundUpdate = new TIntHashSet();
    }

    public void initGraph() {
        int k;
        TIntIterator layerIter;
        int j;
        DisposableIntIterator varIter;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[this.x.length];
        int[] sizes = new int[this.x.length];
        int[] starts = new int[this.x.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < this.x.length; ++i2) {
            offsets[i2] = this.x[i2].getInf();
            sizes[i2] = this.x[i2].getSup() - this.x[i2].getInf() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = this.x.length;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFacroty());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(this.pi.getInitialState());
        TIntHashSet nexts = new TIntHashSet();
        for (i = 0; i < n; ++i) {
            varIter = this.x[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    nexts.clear();
                    this.pi.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        ((TIntHashSet)layer.get(i + 1)).add(succ);
                    }
                    if (nexts.isEmpty()) continue;
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
            }
            varIter.dispose();
        }
        layerIter = ((TIntHashSet)layer.get(n)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (this.pi.isFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = this.pi.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[this.pi.getNbStates() * (n + 1)];
        Node tink = new Node(this.pi.getNbStates() + 1, n + 1, nid++);
        graph.addVertex(tink);
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            varIter = this.x[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l == null) continue;
                TIntIterator qijIter = l.iterator();
                while (qijIter.hasNext()) {
                    k = qijIter.next();
                    nexts.clear();
                    this.pi.delta(k, j, nexts);
                    if (nexts.size() > 1) {
                        System.err.println("STOP");
                    }
                    boolean added = false;
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        Node b;
                        int qn = it.next();
                        if (!((TIntHashSet)layer.get(i + 1)).contains(qn)) continue;
                        added = true;
                        Node a = in[i * this.pi.getNbStates() + k];
                        if (a == null) {
                            in[i * this.pi.getNbStates() + k] = a = new Node(k, i, nid++);
                            graph.addVertex(a);
                        }
                        if ((b = in[(i + 1) * this.pi.getNbStates() + qn]) == null) {
                            in[(i + 1) * this.pi.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                            graph.addVertex(b);
                        }
                        Arc arc = new Arc(a, b, j, aid++);
                        graph.addEdge(a, b, arc);
                        ((HashSet)tmp.get(idx)).add(arc);
                        mark.set(k);
                    }
                    if (added) continue;
                    qijIter.remove();
                }
            }
            varIter.dispose();
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        TIntHashSet th = new TIntHashSet();
        int[][] intLayer = new int[n + 2][];
        for (k = 0; k < this.pi.getNbStates(); ++k) {
            Node o = in[n * this.pi.getNbStates() + k];
            if (o == null) continue;
            Arc a = new Arc(o, tink, 0, aid++);
            graph.addEdge(o, tink, a);
        }
        for (i = 0; i <= n; ++i) {
            th.clear();
            for (k = 0; k < this.pi.getNbStates(); ++k) {
                Node o = in[i * this.pi.getNbStates() + k];
                if (o == null) continue;
                th.add(o.id);
            }
            intLayer[i] = th.toArray();
        }
        intLayer[n + 1] = new int[]{tink.id};
        if (intLayer[0].length > 0) {
            this.graph = new SoftStoredMultiValuedDirectedMultiGraph(this.solver.getEnvironment(), this, graph, intLayer, starts, offsets, totalSizes, this.costs, this.y);
        }
    }

    private void makePathFinder() {
        this.graph.pf = this.path = new SoftPathFinder(this.graph);
    }

    public boolean updateViolationLB() throws ContradictionException {
        double value;
        int[] sp;
        boolean modif;
        boolean modbound = false;
        double[] lambda = new double[this.y.length];
        Arrays.fill(lambda, 0.0);
        int k = 0;
        do {
            modif = false;
            double ghat = this.ghatSP(lambda);
            double gline = this.glineSP(lambda, ghat);
            sp = this.path.getShortestPath();
            value = ghat + gline;
            modbound |= this.Z.updateInf((int)Math.ceil((double)Math.round(value * PRECISION) / PRECISION), this, true);
            double step = 10.0 * Math.pow(0.7, k);
            for (int i = 0; i < lambda.length; ++i) {
                double dimcost = 0.0;
                for (int e = 0; e < this.x.length; ++e) {
                    dimcost += this.graph.GArcs.originalCost[sp[e]][i];
                }
                double move = step * (dimcost - (double)this.y[i].getSup());
                if (!(Math.abs(move) >= Constant.MCR_DECIMAL_PREC)) continue;
                int n = i;
                lambda[n] = lambda[n] + move;
                modif = true;
            }
        } while (k++ < 0 && modif);
        this.lastSp = sp;
        this.lastSpValue = value;
        return modbound;
    }

    private double glineSP(double[] lambda, double constante) throws ContradictionException {
        this.path.computeShortestPath(this.toRemove, (double)this.Z.getSup() - constante, lambda);
        return this.path.getShortestPathValue();
    }

    private double ghatSP(double[] lambda) {
        double ghat = 0.0;
        int R = lambda.length;
        for (int r = 0; r < R; ++r) {
            if (this.indexes.contains(r)) {
                ghat += this.f[r].minGHat(lambda[r], this.y[r]);
                continue;
            }
            ghat += -lambda[r] * (double)(lambda[r] > 0.0 ? this.y[r].getSup() : this.y[r].getInf());
        }
        return ghat;
    }

    public boolean updateViolationUB() throws ContradictionException {
        int[] lp;
        double value;
        boolean modif;
        boolean modBound = false;
        double[] lambda = new double[this.y.length];
        int k = 0;
        do {
            boolean tmp = true;
            modif = false;
            double ghat = this.ghatLP(lambda);
            double gline = this.glineLP(lambda, ghat);
            value = ghat + gline;
            lp = this.path.getLongestPath();
            modBound |= this.Z.updateSup((int)Math.floor((double)Math.round(value * PRECISION) / PRECISION), this, true);
            double step = 10.0 * Math.pow(0.7, k);
            for (int i = 0; i < lambda.length; ++i) {
                double dimcost = 0.0;
                for (int e = 0; e < this.x.length; ++e) {
                    dimcost += this.graph.GArcs.originalCost[lp[e]][i];
                }
                double move = step * (dimcost - (double)this.y[i].getInf());
                if (!(Math.abs(move) >= Constant.MCR_DECIMAL_PREC)) continue;
                int n = i;
                lambda[n] = lambda[n] - move;
                modif = true;
            }
        } while (k++ < 0 && modif);
        this.lastLp = lp;
        this.lastLpValue = value;
        return modBound;
    }

    private double glineLP(double[] lambda, double constante) throws ContradictionException {
        this.path.computeLongestPath(this.toRemove, (double)this.Z.getInf() - constante, lambda);
        return this.path.getLongestPathValue();
    }

    private double ghatLP(double[] lambda) {
        double ghat = 0.0;
        int R = lambda.length;
        for (int r = 0; r < R; ++r) {
            if (this.indexes.contains(r)) {
                ghat += this.f[r].maxGHat(lambda[r], this.y[r]);
                continue;
            }
            ghat += -lambda[r] * (double)(lambda[r] < 0.0 ? this.y[r].getSup() : this.y[r].getInf());
        }
        return ghat;
    }

    public void makeTableConstraints() throws ContradictionException {
        this.tableConstraints = new AbstractIntSConstraint[this.y.length];
        for (int i = 0; i < this.tableConstraints.length; ++i) {
            AbstractIntSConstraint table;
            if (this.y[i].getDomain().isEnumerated()) {
                ArrayList<int[]> tuples = new ArrayList<int[]>();
                DisposableIntIterator it = this.y[i].getDomain().getIterator();
                while (it.hasNext()) {
                    int val = it.next();
                    int other = this.f[i].penalty(val);
                    if (!this.z[i].canBeInstantiatedTo(other)) continue;
                    tuples.add(new int[]{val, other});
                }
                it.dispose();
                table = (AbstractIntSConstraint)this.solver.feasiblePairAC(this.y[i], this.z[i], tuples, 32);
            } else if (this.f[i] instanceof IsoPenaltyFunction) {
                int fact = ((IsoPenaltyFunction)this.f[i]).getFactor();
                table = (AbstractIntSConstraint)this.solver.eq(CPSolver.mult(fact, this.y[i]), (IntExp)this.z[i]);
            } else {
                LOGGER.severe("Cannot create table constraint! domain is too big.");
                throw new UnsupportedOperationException();
            }
            table.awake();
            this.tableConstraints[i] = table;
        }
    }

    private void makeRedondantSumConstraint() {
        IntVar[] summed = new IntDomainVar[this.indexes.size()];
        int idx = 0;
        TIntIterator it = this.indexes.iterator();
        while (it.hasNext()) {
            summed[idx++] = this.z[it.next()];
        }
        this.solver.post(this.solver.eq(CPSolver.sum(summed), (IntExp)this.Z));
    }

    public void checkWorld() throws ContradictionException {
        int currentworld = this.solver.getEnvironment().getWorldIndex();
        int currentbt = this.solver.getBackTrackCount();
        int currentrestart = this.solver.getRestartCount();
        if (currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts) {
            for (int i = 0; i < this.y.length; ++i) {
                this.toUpdateLeft[i].reset();
                this.toUpdateRight[i].reset();
            }
            this.toRemove.reset();
            this.graph.inStack.clear();
            this.path.computeShortestAndLongestPath(this.toRemove, this.y, this.tableConstraints);
            this.computed = true;
        }
        this.lastWorld = currentworld;
        this.lastNbOfBacktracks = currentbt;
        this.lastNbOfRestarts = currentrestart;
    }

    @Override
    public void awake() throws ContradictionException {
        this.makeTableConstraints();
        this.initGraph();
        this.makePathFinder();
        for (int i = 0; i < this.x.length; ++i) {
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            int j = this.x[i].getInf();
            while (j <= this.x[i].getSup()) {
                StoredIndexedBipartiteSetWithOffset sup = this.graph.getSupport(i, j);
                if (sup == null || sup.isEmpty()) {
                    if (j == right + 1) {
                        right = j;
                    } else {
                        this.x[i].removeInterval(left, right, this, false);
                        left = right = j;
                    }
                }
                j = this.x[i].getNextDomainValue(j);
            }
            this.x[i].removeInterval(left, right, this, false);
        }
        this.propagate();
    }

    @Override
    public void awakeOnRem(int idx, int val) throws ContradictionException {
        this.checkWorld();
        if (idx < this.yOff) {
            StoredIndexedBipartiteSetWithOffset support = this.graph.getSupport(idx, val);
            if (support != null) {
                int[] list = support._getStructure();
                int size = support.size();
                for (int i = 0; i < size; ++i) {
                    int e = list[i];
                    if (this.graph.isInStack(e)) continue;
                    this.graph.setInStack(e);
                    this.toRemove.push(e);
                }
                if (this.toRemove.size() > 0) {
                    this.constAwake(false);
                }
            }
        } else if (idx < this.zOff) {
            this.tableConstraints[idx - this.yOff].awakeOnRem(0, val);
            this.boundChange(idx);
        } else if (idx < this.Zidx) {
            this.tableConstraints[idx - this.zOff].awakeOnRem(1, val);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.checkWorld();
        if (idx >= this.yOff) {
            if (idx < this.zOff) {
                this.tableConstraints[idx - this.yOff].awakeOnInst(0);
                this.boundChange(idx);
            } else if (idx < this.Zidx) {
                this.tableConstraints[idx - this.zOff].awakeOnInst(1);
            }
        }
        if (idx == this.Zidx) {
            System.err.print("");
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.checkWorld();
        if (idx >= this.yOff) {
            if (idx < this.zOff) {
                this.tableConstraints[idx - this.yOff].awakeOnSup(0);
                this.boundChange(idx);
            } else if (idx < this.Zidx) {
                this.tableConstraints[idx - this.zOff].awakeOnSup(1);
            }
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.checkWorld();
        if (idx >= this.yOff) {
            if (idx < this.zOff) {
                this.tableConstraints[idx - this.yOff].awakeOnInf(0);
                this.boundChange(idx);
            } else if (idx < this.Zidx) {
                this.tableConstraints[idx - this.zOff].awakeOnInf(1);
            }
        }
        this.constAwake(false);
    }

    public void boundChange(int idx) {
        this.boundUpdate.add(idx - this.yOff);
        this.computed = false;
    }

    @Override
    public void propagate() throws ContradictionException {
        ++this.count;
        this.checkWorld();
        this.delayedBoundUpdate();
        boolean b = this.delayedGraphUpdate();
        b |= this.updateViolationLB();
        b |= this.updateViolationUB();
        b |= this.delayedGraphUpdate();
        while (b) {
            b = this.updateViolationLB();
            if (b) {
                b = this.updateViolationUB();
            }
            this.delayedGraphUpdate();
        }
        assert (this.check());
    }

    private void delayedBoundUpdate() throws ContradictionException {
        if (!this.computed && this.boundUpdate.size() > 0) {
            this.getGraph().delayedBoundUpdate(this.toRemove, this.y, this.boundUpdate.toArray());
            this.boundUpdate.clear();
        }
    }

    protected boolean delayedGraphUpdate() throws ContradictionException {
        boolean modBound = false;
        while (true) {
            if (this.toRemove.size() > 0) {
                int n = this.toRemove.pop();
                this.graph.removeArc(n, this.toRemove, this.toUpdateLeft, this.toUpdateRight);
                continue;
            }
            for (int k = 0; k < this.y.length; ++k) {
                while (this.toUpdateLeft[k].size() > 0) {
                    modBound |= this.graph.updateLeft(this.toUpdateLeft[k], this.toRemove, k, this.tableConstraints[k]);
                    if (this.toRemove.size() <= 0) continue;
                }
                while (this.toUpdateRight[k].size() > 0) {
                    modBound |= this.graph.updateRight(this.toUpdateRight[k], this.toRemove, k, this.tableConstraints[k]);
                    if (this.toRemove.size() <= 0) continue;
                }
            }
            if (this.toRemove.size() <= 0) break;
        }
        return modBound;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx < this.yOff ? 4 : 11;
    }

    public boolean check() {
        int[] word = new int[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            if (!this.x[i].isInstantiated()) {
                return true;
            }
            word[i] = this.x[i].getVal();
        }
        for (IntDomainVar aZ : this.z) {
            if (aZ.isInstantiated()) continue;
            return true;
        }
        return this.check(word);
    }

    public boolean check(int[] word) {
        if (!this.pi.run(word)) {
            System.err.println("Word is not accepted by the automaton");
            System.err.print("{" + word[0]);
            for (int i = 1; i < word.length; ++i) {
                System.err.print("," + word[i]);
            }
            System.err.println("}");
            return false;
        }
        int[] gcost = new int[this.z.length];
        for (int l = 0; l < this.graph.layers.length - 2; ++l) {
            DisposableIntIterator it = this.graph.layers[l].getIterator();
            while (it.hasNext()) {
                int orig = it.next();
                DisposableIntIterator arcIter = this.graph.GNodes.outArcs[orig].getIterator();
                while (arcIter.hasNext()) {
                    int arc = arcIter.next();
                    for (int i = 0; i < this.z.length; ++i) {
                        int n = i;
                        gcost[n] = (int)((double)gcost[n] + this.graph.GArcs.originalCost[arc][i]);
                    }
                }
                arcIter.dispose();
            }
            it.dispose();
        }
        for (int i = 0; i < gcost.length; ++i) {
            if (!this.z[i].isInstantiated() || !this.y[i].isInstantiated()) {
                LOGGER.severe("Error, z[" + i + "] in SMCR should be instantiated : " + this.z[i]);
                return false;
            }
            if (this.y[i].getVal() != gcost[i]) {
                LOGGER.severe("counter: " + gcost[i] + " != y:" + this.y[i].getVal());
                return false;
            }
            if (this.z[i].getVal() == this.f[i].penalty(gcost[i])) continue;
            LOGGER.severe("penalty_" + i + ": " + this.f[i].penalty(gcost[i]) + " != z:" + this.z[i].getVal());
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int[] tmp = new int[this.x.length];
        System.arraycopy(tuple, 0, tmp, 0, tmp.length);
        return this.check(tmp);
    }

    public final boolean needPropagation() {
        int currentworld = this.solver.getEnvironment().getWorldIndex();
        int currentbt = this.solver.getBackTrackCount();
        int currentrestart = this.solver.getRestartCount();
        return currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts;
    }

    public SoftStoredMultiValuedDirectedMultiGraph getGraph() {
        return this.graph;
    }

    public int getMinPathCostForAssignment(int col, int val, int ... resources) {
        return this.graph.getMinPathCostForAssignment(col, val, resources);
    }

    public int[] getMinMaxPathCostForAssignment(int col, int val, int ... resources) {
        return this.graph.getMinMaxPathCostForAssignment(col, val, resources);
    }

    public int getMinPathCost(int ... resources) {
        return this.graph.getMinPathCost(resources);
    }

    public double[] getInstantiatedLayerCosts(int layer) {
        return this.graph.getInstantiatedLayerCosts(layer);
    }
}

