/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace;

import java.util.Arrays;
import java.util.stream.Collectors;
import jd2.workspace.util.Id;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class WorkspaceFamily
implements Id {
    private static final WorkspaceFamily EMPTY = new WorkspaceFamily(new String[0]);
    private final String[] data;
    public static final WorkspaceFamily SA_MULTI = WorkspaceFamily.parse("Seasonal adjustment@multi-documents");
    public static final WorkspaceFamily SA_DOC_X13 = WorkspaceFamily.parse("Seasonal adjustment@documents@x13");
    public static final WorkspaceFamily SA_DOC_TRAMOSEATS = WorkspaceFamily.parse("Seasonal adjustment@documents@tramoseats");
    public static final WorkspaceFamily SA_SPEC_X13 = WorkspaceFamily.parse("Seasonal adjustment@specifications@x13");
    public static final WorkspaceFamily SA_SPEC_TRAMOSEATS = WorkspaceFamily.parse("Seasonal adjustment@specifications@tramoseats");
    public static final WorkspaceFamily MOD_DOC_REGARIMA = WorkspaceFamily.parse("Modelling@documents@regarima");
    public static final WorkspaceFamily MOD_DOC_TRAMO = WorkspaceFamily.parse("Modelling@documents@tramo");
    public static final WorkspaceFamily MOD_SPEC_REGARIMA = WorkspaceFamily.parse("Modelling@specifications@regarima");
    public static final WorkspaceFamily MOD_SPEC_TRAMO = WorkspaceFamily.parse("Modelling@specifications@tramo");
    public static final WorkspaceFamily UTIL_CAL = WorkspaceFamily.parse("Utilities@Calendars");
    public static final WorkspaceFamily UTIL_VAR = WorkspaceFamily.parse("Utilities@Variables");

    public static @NonNull WorkspaceFamily of(@NonNull Id id) {
        if (id instanceof WorkspaceFamily) {
            return (WorkspaceFamily)id;
        }
        if (id.getCount() == 0) {
            return EMPTY;
        }
        return new WorkspaceFamily(id.toArray());
    }

    public static @NonNull WorkspaceFamily parse(@NonNull String input) {
        return !input.isEmpty() ? new WorkspaceFamily(input.split("@", -1)) : EMPTY;
    }

    private WorkspaceFamily(String[] data) {
        this.data = data;
    }

    @Override
    public String get(int index) {
        return this.data[index];
    }

    @Override
    public WorkspaceFamily extend(String tail) {
        String[] result = Arrays.copyOf(this.data, this.data.length + 1);
        result[this.data.length] = tail;
        return new WorkspaceFamily(result);
    }

    @Override
    public WorkspaceFamily parent() {
        switch (this.getCount()) {
            case 0: {
                return null;
            }
            case 1: {
                return EMPTY;
            }
        }
        return new WorkspaceFamily(Arrays.copyOf(this.data, this.data.length - 1));
    }

    @Override
    public int getCount() {
        return this.data.length;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof WorkspaceFamily && this.equals((WorkspaceFamily)obj);
    }

    private boolean equals(WorkspaceFamily that) {
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public String toString() {
        return Arrays.stream(this.data).collect(Collectors.joining("@"));
    }

    @Override
    public String[] toArray() {
        return (String[])this.data.clone();
    }
}

