/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;

public class BetaDistribution
extends AbstractContinuousDistribution
implements Distribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private double alpha;
    private double beta;
    private double z;
    private final double solverAbsoluteAccuracy;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return BetaDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return 1.0;
        }
    };

    public BetaDistribution(double d, double d2) {
        this.alpha = d;
        this.beta = d2;
        this.z = Double.NaN;
        this.solverAbsoluteAccuracy = 1.0E-9;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    private void recomputeZ() {
        if (Double.isNaN(this.z)) {
            this.z = Gamma.logGamma(this.alpha) + Gamma.logGamma(this.beta) - Gamma.logGamma(this.alpha + this.beta);
        }
    }

    @Override
    public double pdf(double d) {
        this.recomputeZ();
        if (d < 0.0 || d > 1.0) {
            return 0.0;
        }
        if (d == 0.0) {
            if (this.alpha < 1.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        if (d == 1.0) {
            if (this.beta < 1.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        double d2 = Math.log(d);
        double d3 = Math.log1p(-d);
        return Math.exp((this.alpha - 1.0) * d2 + (this.beta - 1.0) * d3 - this.z);
    }

    @Override
    public double logPdf(double d) {
        this.recomputeZ();
        if (d < 0.0 || d > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 0.0) {
            if (this.alpha < 1.0) {
                return Double.NaN;
            }
            if (this.alpha == 1.0) {
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            if (this.beta < 1.0) {
                return Double.NaN;
            }
            if (this.beta == 1.0) {
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = Math.log(d);
        double d3 = Math.log1p(-d);
        return (this.alpha - 1.0) * d2 + (this.beta - 1.0) * d3 - this.z;
    }

    @Override
    public double quantile(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        try {
            return super.inverseCumulativeProbability(d);
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
    }

    @Override
    protected double getInitialDomain(double d) {
        return d;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return 1.0;
    }

    @Override
    public double cdf(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        try {
            return Beta.regularizedBeta(d, this.alpha, this.beta);
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        return Beta.regularizedBeta(d, this.alpha, this.beta);
    }

    @Override
    public double cumulativeProbability(double d, double d2) throws MathException {
        return this.cumulativeProbability(d2) - this.cumulativeProbability(d);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double mean() {
        return this.alpha / (this.alpha + this.beta);
    }

    @Override
    public double variance() {
        return this.alpha * this.beta / ((this.alpha + this.beta) * (this.alpha + this.beta) * (this.alpha + this.beta + 1.0));
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }
}

