/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.ISystem;
import org.apache.commons.configuration.Configuration;

public abstract class DecoratedMutator
implements IMutator,
IConfigure {
    protected IMutator decorated;
    protected ISystem context;

    public DecoratedMutator() {
    }

    public DecoratedMutator(ISystem context) {
        this.contextualize(context);
    }

    public final IMutator getDecorated() {
        return this.decorated;
    }

    public final void setDecorated(IMutator decorated) {
        this.decorated = decorated;
        if (this.context != null) {
            decorated.contextualize(this.context);
        }
    }

    @Override
    public void contextualize(ISystem context) {
        this.context = context;
        if (this.decorated != null) {
            this.decorated.contextualize(context);
        }
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String decoratedClassname = settings.getString("decorated[@type]");
            Class<?> decoratedClass = Class.forName(decoratedClassname);
            IMutator decorated = (IMutator)decoratedClass.newInstance();
            if (decorated instanceof IConfigure) {
                ((IConfigure)((Object)decorated)).configure(settings.subset("decorated"));
            }
            this.setDecorated(decorated);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

