/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import keel.Algorithms.Associative_Classification.ClassifierCMAR.AssocRuleMining;
import org.core.Files;

public class RuleList
extends AssocRuleMining {
    protected RuleNode startRulelist = null;
    protected RuleNodeCMAR startCMARrulelist = null;
    private double[] obsValues = new double[4];
    private double[] expValues = new double[4];
    private static final double THRESHOLD_25 = 1.3233;
    private static final double THRESHOLD_20 = 1.6424;
    private static final double THRESHOLD_10 = 2.7055;
    private static final double THRESHOLD_5 = 3.8415;
    private static final double THRESHOLD_2HALF = 5.0239;
    private static final double THRESHOLD_1 = 6.6349;
    private static final double THRESHOLD_HALF = 7.8794;
    private static int MIN_COVER = 4;
    private double supAntecedent;
    private double supNotAntecedent;
    private double supConsequent;
    private double supNotConsequent;
    private double supRule;
    private double numRecords;
    private double threshold = 1.6424;

    public RuleList(int delta) {
        MIN_COVER = delta;
    }

    protected void insertRinRlistCMARranking(short[] antecedent, short[] consequent, double supportForAntecedent, double supportForConsequent, double supportForRule, double confidenceForRule) {
        if (!this.testRuleUsingChiSquaredTesting(supportForAntecedent, supportForConsequent, supportForRule, this.numRows)) {
            return;
        }
        RuleNodeCMAR newNode = new RuleNodeCMAR(antecedent, consequent, supportForRule, supportForAntecedent, supportForConsequent, confidenceForRule);
        if (this.startCMARrulelist == null) {
            this.startCMARrulelist = newNode;
            return;
        }
        if (this.moreGeneralRuleExists(newNode)) {
            return;
        }
        if (this.ruleIsCMARgreater(newNode, this.startCMARrulelist)) {
            newNode.next = this.startCMARrulelist;
            this.startCMARrulelist = newNode;
            return;
        }
        RuleNodeCMAR markerNode = this.startCMARrulelist;
        RuleNodeCMAR linkRuleNode = this.startCMARrulelist.next;
        while (linkRuleNode != null) {
            if (this.ruleIsCMARgreater(newNode, linkRuleNode)) {
                markerNode.next = newNode;
                newNode.next = linkRuleNode;
                return;
            }
            markerNode = linkRuleNode;
            linkRuleNode = linkRuleNode.next;
        }
        markerNode.next = newNode;
    }

    private boolean moreGeneralRuleExists(RuleNodeCMAR rule) {
        RuleNodeCMAR linkRef = this.startCMARrulelist;
        while (linkRef != null) {
            if (this.ruleIsMoreGeneral(rule, linkRef) && this.ruleIsCMARgreater2(rule, linkRef)) {
                return true;
            }
            linkRef = linkRef.next;
        }
        return false;
    }

    private boolean ruleIsMoreGeneral(RuleNodeCMAR rule1, RuleNodeCMAR rule2) {
        return rule1.antecedent.length < rule2.antecedent.length;
    }

    private boolean ruleIsCMARgreater(RuleNodeCMAR rule1, RuleNodeCMAR rule2) {
        if (rule1.confidenceForRule > rule2.confidenceForRule) {
            return true;
        }
        if (this.similar2dec(rule1.confidenceForRule, rule2.confidenceForRule)) {
            if (rule1.supportForRule > rule2.supportForRule) {
                return true;
            }
            if (this.similar2dec(rule1.supportForRule, rule2.supportForRule) && rule1.antecedent.length < rule2.antecedent.length) {
                return true;
            }
        }
        return false;
    }

    private boolean ruleIsCMARgreater2(RuleNodeCMAR rule1, RuleNodeCMAR rule2) {
        if (rule1.confidenceForRule > rule2.confidenceForRule) {
            return true;
        }
        return this.similar2dec(rule1.confidenceForRule, rule2.confidenceForRule) && rule1.supportForRule > rule2.supportForRule;
    }

    public boolean testRuleUsingChiSquaredTesting(double supA, double supC, double supAC, double numR) {
        double chiSquaredValue = this.getChiSquaredValue(supA, supC, supAC, numR);
        return chiSquaredValue > this.threshold;
    }

    private double getChiSquaredValue(double supA, double supC, double supAC, double numR) {
        this.supAntecedent = supA;
        this.supConsequent = supC;
        this.supRule = supAC;
        this.numRecords = numR;
        this.calculateObsValues();
        this.calculateExpValues();
        return this.calcChiSquaredValue();
    }

    private void calculateObsValues() {
        this.obsValues[0] = this.supRule;
        this.obsValues[1] = this.supAntecedent - this.supRule;
        this.obsValues[2] = this.supConsequent - this.supRule;
        this.obsValues[3] = this.numRecords - this.supAntecedent - this.supConsequent + this.supRule;
        this.supNotAntecedent = this.numRecords - this.supAntecedent;
        this.supNotConsequent = this.numRecords - this.supConsequent;
    }

    private void calculateExpValues() {
        this.expValues[0] = this.supConsequent * this.supAntecedent / this.numRecords;
        this.expValues[1] = this.supNotConsequent * this.supAntecedent / this.numRecords;
        this.expValues[2] = this.supConsequent * this.supNotAntecedent / this.numRecords;
        this.expValues[3] = this.supNotConsequent * this.supNotAntecedent / this.numRecords;
    }

    private double calcChiSquaredValue() {
        double sumChiSquaredValues = 0.0;
        for (int index = 0; index < this.obsValues.length; ++index) {
            double chiValue = Math.pow(this.obsValues[index] - this.expValues[index], 2.0) / this.expValues[index];
            sumChiSquaredValues += chiValue;
        }
        return sumChiSquaredValues;
    }

    protected void pruneUsingCover(short[][] trainingSet) {
        int[] cover = new int[trainingSet.length];
        RuleNodeCMAR newStartRef = null;
        RuleNodeCMAR markerRef = null;
        RuleNodeCMAR linkRef = this.startCMARrulelist;
        while (linkRef != null && !this.emptyDataSet(trainingSet)) {
            int index;
            boolean coverFlag = false;
            for (index = 0; index < trainingSet.length; ++index) {
                if (!this.isSubset(linkRef.antecedent, trainingSet[index])) continue;
                int n = index;
                cover[n] = cover[n] + 1;
                coverFlag = true;
            }
            if (coverFlag) {
                if (newStartRef == null) {
                    newStartRef = linkRef;
                } else {
                    markerRef.next = linkRef;
                }
                markerRef = linkRef;
                linkRef = linkRef.next;
                markerRef.next = null;
            } else {
                linkRef = linkRef.next;
            }
            for (index = 0; index < cover.length; ++index) {
                if (cover[index] <= MIN_COVER) continue;
                trainingSet[index] = null;
            }
        }
        this.startCMARrulelist = newStartRef;
    }

    private boolean emptyDataSet(short[][] dataSet) {
        for (int index = 0; index < dataSet.length; ++index) {
            if (dataSet[index] == null) continue;
            return false;
        }
        return true;
    }

    protected short classifyRecordWCS(short[] itemSet) {
        RuleNodeCMAR linkRef = this.startCMARrulelist;
        RuleNodeCMAR tempRulelist = this.startCMARrulelist;
        this.startCMARrulelist = null;
        this.obtainallRulesForRecord(linkRef, itemSet);
        if (this.startCMARrulelist == null) {
            this.startCMARrulelist = tempRulelist;
            return 0;
        }
        if (this.startCMARrulelist.next == null) {
            short answer = this.startCMARrulelist.consequent[0];
            this.startCMARrulelist = tempRulelist;
            return answer;
        }
        if (this.onlyOneClass()) {
            short answer = this.startCMARrulelist.consequent[0];
            this.startCMARrulelist = tempRulelist;
            return answer;
        }
        RuleNodeCMAR[] ruleGroups = this.groupRules();
        double[] wcsValues = this.calcWCSvalues(ruleGroups);
        short consequent = this.selectBestWCS(wcsValues);
        this.startCMARrulelist = tempRulelist;
        return consequent;
    }

    private RuleNodeCMAR[] groupRules() {
        RuleNodeCMAR[] ruleGroups = new RuleNodeCMAR[this.numClasses];
        for (int index = 0; index < ruleGroups.length; ++index) {
            ruleGroups[index] = null;
        }
        RuleNodeCMAR linkRef = this.startCMARrulelist;
        while (linkRef != null) {
            int index = this.numOneItemSets - linkRef.consequent[0];
            RuleNodeCMAR ruleCopy = new RuleNodeCMAR(linkRef.antecedent, linkRef.consequent, linkRef.supportForRule, linkRef.suppAntecedent, linkRef.suppConsequent, linkRef.confidenceForRule);
            ruleCopy.next = ruleGroups[index];
            ruleGroups[index] = ruleCopy;
            linkRef = linkRef.next;
        }
        return ruleGroups;
    }

    private boolean onlyOneClass() {
        RuleNodeCMAR linkRef = this.startCMARrulelist;
        short firstClass = linkRef.consequent[0];
        linkRef = linkRef.next;
        while (linkRef != null) {
            if (linkRef.consequent[0] != firstClass) {
                return false;
            }
            linkRef = linkRef.next;
        }
        return true;
    }

    private double[] calcWCSvalues(RuleNodeCMAR[] ruleGroups) {
        double[] wcsArray = new double[ruleGroups.length];
        for (int index = 0; index < ruleGroups.length; ++index) {
            RuleNodeCMAR linkRuleNode = ruleGroups[index];
            double wcsValue = 0.0;
            while (linkRuleNode != null) {
                double chiSquaredValue = this.getChiSquaredValue(linkRuleNode.suppAntecedent, linkRuleNode.suppConsequent, linkRuleNode.supportForRule, this.numRecords);
                double chiSquaredUB = this.calcChiSquaredUpperBound(linkRuleNode.suppAntecedent, linkRuleNode.suppConsequent);
                wcsValue += chiSquaredValue * chiSquaredValue / chiSquaredUB;
                linkRuleNode = linkRuleNode.next;
            }
            wcsArray[index] = wcsValue;
        }
        return wcsArray;
    }

    private short selectBestWCS(double[] wcsValues) {
        double bestValue = wcsValues[0];
        int bestIndex = 0;
        for (int index = 1; index < wcsValues.length; ++index) {
            if (!(wcsValues[index] > bestValue)) continue;
            bestValue = wcsValues[index];
            bestIndex = index;
        }
        return (short)(this.numOneItemSets - bestIndex);
    }

    private double calcChiSquaredUpperBound(double suppAnte, double suppCons) {
        double term = suppAnte < suppCons ? Math.pow(suppAnte - suppAnte * suppCons / this.numRecords, 2.0) : Math.pow(suppCons - suppAnte * suppCons / this.numRecords, 2.0);
        double eVlaue = this.calcWCSeValue(suppAnte, suppCons);
        return term * eVlaue * this.numRecords;
    }

    private double calcWCSeValue(double suppAnte, double suppCons) {
        double term1 = 1.0 / (suppAnte * suppCons);
        double term2 = 1.0 / (suppAnte * (this.numRecords - suppCons));
        double term3 = 1.0 / (suppCons * (this.numRecords - suppAnte));
        double term4 = 1.0 / ((this.numRecords - suppAnte) * (this.numRecords - suppCons));
        return term1 + term2 + term3 + term4;
    }

    private void obtainallRulesForRecord(RuleNodeCMAR linkRef, short[] itemSet) {
        RuleNodeCMAR newStartRef = null;
        RuleNodeCMAR markerRef = null;
        while (linkRef != null) {
            if (this.isSubset(linkRef.antecedent, itemSet)) {
                RuleNodeCMAR newNode = new RuleNodeCMAR(linkRef.antecedent, linkRef.consequent, linkRef.supportForRule, linkRef.suppAntecedent, linkRef.suppConsequent, linkRef.confidenceForRule);
                if (newStartRef == null) {
                    newStartRef = newNode;
                } else {
                    markerRef.next = newNode;
                }
                markerRef = newNode;
            }
            linkRef = linkRef.next;
        }
        this.startCMARrulelist = newStartRef;
    }

    public int getNumCRs() {
        int number = 0;
        RuleNode linkRuleNode = this.startRulelist;
        while (linkRuleNode != null) {
            ++number;
            linkRuleNode = linkRuleNode.next;
        }
        return number;
    }

    public int getNumCMAR_CRs() {
        int number = 0;
        RuleNodeCMAR linkRuleNode = this.startCMARrulelist;
        while (linkRuleNode != null) {
            ++number;
            linkRuleNode = linkRuleNode.next;
        }
        return number;
    }

    protected void setNumRows(int numR) {
        this.numRows = numR;
    }

    protected void setNumClasses(int numC) {
        this.numClasses = numC;
    }

    protected void setNumOneItemSets(int nois) {
        this.numOneItemSets = nois;
    }

    protected void setStartCMARrulelistToNull() {
        this.startCMARrulelist = null;
    }

    protected void setReconversionArrayRefs(int[][] conversionArrayRef, short[] reconversionArrayRef) {
        this.conversionArray = conversionArrayRef;
        this.reconversionArray = reconversionArrayRef;
    }

    public void outputCMARrules(String filename) {
        String stringOut = new String("");
        stringOut = this.outputRules(this.startCMARrulelist);
        Files.writeFile(filename, stringOut);
    }

    public void outputCMARrulesWithReconversion() {
        this.outputRulesWithReconversion(this.startCMARrulelist);
    }

    public String outputRules(RuleNodeCMAR ruleList) {
        String stringOut = new String("");
        if (ruleList == null) {
            return "No rules generated!";
        }
        int number = 1;
        int nAnt = 0;
        RuleNodeCMAR linkRuleNode = ruleList;
        while (linkRuleNode != null) {
            nAnt += linkRuleNode.antecedent.length;
            stringOut = stringOut + "(" + number + ") ";
            stringOut = stringOut + this.outputRule(linkRuleNode);
            stringOut = stringOut + "\n";
            stringOut = stringOut + " Conf: " + this.twoDecPlaces(linkRuleNode.confidenceForRule) + "%, (SuppRule: " + linkRuleNode.supportForRule + ", SuppAnt: " + linkRuleNode.suppAntecedent + ", SuppCons: " + linkRuleNode.suppConsequent + ")";
            stringOut = stringOut + "\n\n";
            ++number;
            linkRuleNode = linkRuleNode.next;
        }
        stringOut = stringOut + "\n\n";
        stringOut = "@Number of rules: " + this.getNumCMAR_CRs() + " Number of Antecedents by rule: " + (double)nAnt * 1.0 / (double)this.getNumCMAR_CRs() + "\n\n" + stringOut;
        return stringOut;
    }

    private String outputRule(RuleNodeCMAR rule) {
        String stringOut = new String("");
        stringOut = stringOut + this.outputItemSet(rule.antecedent);
        stringOut = stringOut + " -> ";
        stringOut = stringOut + this.outputItemSet(rule.consequent);
        return stringOut;
    }

    public void outputRulesWithReconversion(RuleNodeCMAR ruleList) {
        if (ruleList == null) {
            System.out.println("No rules generated!");
        }
        this.outputConversionArrays();
        int number = 1;
        RuleNodeCMAR linkRuleNode = ruleList;
        while (linkRuleNode != null) {
            System.out.print("(" + number + ") ");
            this.outputItemSetWithReconversion(linkRuleNode.antecedent);
            System.out.print(" -> ");
            this.outputItemSet(linkRuleNode.consequent);
            System.out.println(" " + linkRuleNode.confidenceForRule + "%");
            ++number;
            linkRuleNode = linkRuleNode.next;
        }
    }

    public void outputNumRules() {
        System.out.println("Number of rules         = " + this.getNumCRs());
    }

    public void outputNumCMARrules() {
        System.out.println("Number of CMAR rules    = " + this.getNumCMAR_CRs());
    }

    protected class RuleNodeCMAR {
        protected short[] antecedent;
        protected short[] consequent;
        double confidenceForRule = 0.0;
        double supportForRule = 0.0;
        double suppAntecedent = 0.0;
        double suppConsequent = 0.0;
        RuleNodeCMAR next = null;

        private RuleNodeCMAR(short[] ante, short[] cons, double suppValue, double suppAnte, double suppCons, double confValue) {
            this.antecedent = ante;
            this.consequent = cons;
            this.supportForRule = suppValue;
            this.suppAntecedent = suppAnte;
            this.suppConsequent = suppCons;
            this.confidenceForRule = confValue;
        }
    }

    protected class RuleNode {
        protected short[] antecedent;
        protected short[] consequent;
        double confidenceForRule = 0.0;
        RuleNode next = null;

        private RuleNode(short[] ante, short[] cons, double confValue) {
            this.antecedent = ante;
            this.consequent = cons;
            this.confidenceForRule = confValue;
        }
    }
}

