/*
 * Decompiled with CFR 0.152.
 */
package kea.filters;

import java.util.StringTokenizer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;

public class NumbersFilter
extends Filter {
    private static final long serialVersionUID = 1L;

    public String globalInfo() {
        return "Removes all numbers from all the string attributes in the given dataset. Assumes that words are separated by whitespace.";
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    public static void main(String[] argv) {
        try {
            if (Utils.getFlag((char)'b', (String[])argv)) {
                Filter.batchFilterFile((Filter)new NumbersFilter(), (String[])argv);
            } else {
                Filter.filterFile((Filter)new NumbersFilter(), (String[])argv);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void convertInstance(Instance instance) throws Exception {
        double[] instVals = new double[instance.numAttributes()];
        int i = 0;
        while (i < instance.numAttributes()) {
            if (!instance.attribute(i).isString() || instance.isMissing(i)) {
                instVals[i] = instance.value(i);
            } else {
                String str = instance.stringValue(i);
                StringBuffer resultStr = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(str, " \t\n", true);
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    boolean isNumber = true;
                    int j = 0;
                    while (j < token.length()) {
                        if (Character.isLetter(token.charAt(j))) {
                            isNumber = false;
                            break;
                        }
                        ++j;
                    }
                    if (!isNumber) {
                        resultStr.append(token);
                        continue;
                    }
                    if (token.equals(" ") || token.equals("\t") || token.equals("\n")) {
                        resultStr.append(token);
                        continue;
                    }
                    resultStr.append(" \n ");
                }
                int index = this.getOutputFormat().attribute(i).addStringValue(resultStr.toString());
                instVals[i] = index;
            }
            ++i;
        }
        Instance inst = new Instance(instance.weight(), instVals);
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
    }
}

