/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.FatalParsingErrorException;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.SAX2Model;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class DOM2Model
extends SAX2Model {
    public static DOM2Model createD2M(String base, Model m) throws SAXParseException {
        return new DOM2Model(base, m, "", true);
    }

    public static DOM2Model createD2M(String base, Model m, String lang) throws SAXParseException {
        return new DOM2Model(base, m, lang, true);
    }

    public DOM2Model(String base, Model m) throws MalformedURIException {
        this(base, m, "");
    }

    public DOM2Model(String base, Model m, String lang) throws MalformedURIException {
        super(base, m, lang);
    }

    DOM2Model(String base, Model m, String lang, boolean dummy) throws SAXParseException {
        super(base, m, lang, 0);
    }

    public void load(Node document) {
        DOMSource input = new DOMSource(document);
        SAXResult output = new SAXResult(this);
        output.setLexicalHandler(this);
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        try {
            Transformer idTransform = xformFactory.newTransformer();
            idTransform.transform(input, output);
        }
        catch (FatalParsingErrorException e) {
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception nrte) {
            throw new JenaException(nrte);
        }
        finally {
            this.close();
        }
    }
}

