/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.sarima.SarmaSpecification;

public class SarimaSpecification
implements Cloneable {
    private static final BackFilter m10 = SarimaSpecification.differencingFilter(12, 1, 0);
    private static final BackFilter m20 = SarimaSpecification.differencingFilter(12, 2, 0);
    private static final BackFilter m01 = SarimaSpecification.differencingFilter(12, 0, 1);
    private static final BackFilter m11 = SarimaSpecification.differencingFilter(12, 1, 1);
    private static final BackFilter q10 = SarimaSpecification.differencingFilter(4, 1, 0);
    private static final BackFilter q20 = SarimaSpecification.differencingFilter(4, 2, 0);
    private static final BackFilter q01 = SarimaSpecification.differencingFilter(4, 0, 1);
    private static final BackFilter q11 = SarimaSpecification.differencingFilter(4, 1, 1);
    int frequency;
    int P;
    int D;
    int Q;
    int BP;
    int BD;
    int BQ;

    private static BackFilter differencingFilter(int freq, int d, int bd) {
        Polynomial X = null;
        if (d > 0) {
            X = UnitRoots.D(1, d);
        }
        if (bd > 0) {
            Polynomial XD = UnitRoots.D(freq, bd);
            X = X == null ? XD : X.times(XD);
        }
        if (X == null) {
            X = Polynomial.ONE;
        }
        return new BackFilter(X);
    }

    public SarimaSpecification() {
    }

    public SarimaSpecification(int freq) {
        this.frequency = freq;
        this.BQ = 0;
        this.BD = 0;
        this.BP = 0;
        this.Q = 0;
        this.D = 0;
        this.P = 0;
    }

    public SarimaSpecification(SarmaSpecification spec) {
        this.frequency = spec.getFrequency();
        this.P = spec.getP();
        this.Q = spec.getQ();
        this.BP = spec.getBP();
        this.BQ = spec.getBQ();
    }

    public void airline() {
        this.airline(this.frequency > 1);
    }

    public void airline(boolean seas) {
        this.P = 0;
        this.D = 1;
        this.Q = 1;
        this.BP = 0;
        if (seas) {
            this.BD = 1;
            this.BQ = 1;
        } else {
            this.BD = 0;
            this.BQ = 0;
        }
    }

    public SarimaSpecification clone() {
        try {
            return (SarimaSpecification)super.clone();
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void copy(SarmaSpecification arma) {
        this.P = arma.getP();
        this.Q = arma.getQ();
        this.BP = arma.getBP();
        this.BQ = arma.getBQ();
    }

    public SarmaSpecification doStationary() {
        try {
            SarmaSpecification arma = new SarmaSpecification();
            arma.setFrequency(this.frequency);
            arma.setP(this.P);
            arma.setQ(this.Q);
            arma.setBP(this.BP);
            arma.setBQ(this.BQ);
            return arma;
        }
        catch (ArimaException aexc) {
            throw new RuntimeException(aexc);
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SarimaSpecification && this.equals((SarimaSpecification)obj);
    }

    private boolean equals(SarimaSpecification other) {
        return other.frequency == this.frequency && other.P == this.P && other.D == this.D && other.Q == this.Q && other.BP == this.BP && other.BD == this.BD && other.BQ == this.BQ;
    }

    public int getBD() {
        return this.BD;
    }

    public int getBP() {
        return this.BP;
    }

    public int getBQ() {
        return this.BQ;
    }

    public int getD() {
        return this.D;
    }

    public int getDifferenceOrder() {
        int d = this.D;
        if (this.frequency > 1 && this.BD > 0) {
            d += this.frequency * this.BD;
        }
        return d;
    }

    public BackFilter getDifferencingFilter() {
        if (this.D == 0 && this.BD == 0) {
            return BackFilter.ONE;
        }
        if (this.frequency == 12) {
            if (this.BD == 0) {
                if (this.D == 1) {
                    return m10;
                }
                if (this.D == 2) {
                    return m20;
                }
            } else if (this.BD == 1) {
                if (this.D == 0) {
                    return m01;
                }
                if (this.D == 1) {
                    return m11;
                }
            } else if (this.frequency == 4) {
                if (this.BD == 0) {
                    if (this.D == 1) {
                        return q10;
                    }
                    if (this.D == 2) {
                        return q20;
                    }
                } else if (this.BD == 1) {
                    if (this.D == 0) {
                        return q01;
                    }
                    if (this.D == 1) {
                        return q11;
                    }
                }
            }
        }
        return SarimaSpecification.differencingFilter(this.frequency, this.D, this.BD);
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getP() {
        return this.P;
    }

    public int getParametersCount() {
        return this.P + this.BP + this.Q + this.BQ;
    }

    public int getQ() {
        return this.Q;
    }

    public UnitRoots getUnitRoots() {
        int i;
        UnitRoots ur = new UnitRoots();
        if (this.frequency > 1) {
            for (i = 0; i < this.getBD(); ++i) {
                ur.add(this.frequency);
            }
        }
        for (i = 0; i < this.getD(); ++i) {
            ur.add(1);
        }
        return ur;
    }

    public int hashCode() {
        return this.frequency + this.P + this.D + this.Q + this.BP + this.BD + this.BQ;
    }

    public void initialize(int freq) {
        this.frequency = freq;
        this.BQ = 0;
        this.BD = 0;
        this.BP = 0;
        this.Q = 0;
        this.D = 0;
        this.P = 0;
    }

    public boolean isAirline(boolean seas) {
        boolean ok;
        boolean bl = ok = this.P == 0 && this.Q == 1 && this.D == 1;
        if (!ok || !seas) {
            return ok;
        }
        return this.BP == 0 && this.BQ == 1 && this.BD == 1;
    }

    public boolean hasSeasonalPart() {
        return this.BP > 0 || this.BQ > 0 || this.BD == 1;
    }

    public void setBD(int value) throws ArimaException {
        this.BD = value;
    }

    public void setBP(int value) throws ArimaException {
        this.BP = value;
    }

    public void setBQ(int value) throws ArimaException {
        this.BQ = value;
    }

    public void setD(int value) throws ArimaException {
        this.D = value;
    }

    public void setFrequency(int value) {
        this.frequency = value;
    }

    public void setP(int value) throws ArimaException {
        this.P = value;
    }

    public void setQ(int value) throws ArimaException {
        this.Q = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.getP()).append(',');
        builder.append(this.getD()).append(',');
        builder.append(this.getQ()).append(')');
        if (this.getFrequency() > 1) {
            builder.append('(');
            builder.append(this.getBP()).append(',');
            builder.append(this.getBD()).append(',');
            builder.append(this.getBQ()).append(')');
        }
        return builder.toString();
    }
}

