/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.information;

import ec.tstoolkit.information.InformationConverter;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;
import java.util.List;

public class InformationLinker<T> {
    private final List<ConverterNode<? extends T>> nodes = new ArrayList<ConverterNode<? extends T>>();

    public <S extends T> void register(String desc, Class<S> sclass, InformationConverter<S> converter) {
        if (this.getNode(sclass) != null) {
            return;
        }
        this.nodes.add(new ConverterNode<S>(converter, desc, sclass));
    }

    public T decode(InformationSet info) {
        String contentType = info.getContentType();
        InformationConverter<T> decoder = this.getConverter(contentType);
        if (decoder == null) {
            return null;
        }
        return decoder.decode(info);
    }

    public InformationConverter<? extends T> getConverter(String s) {
        for (ConverterNode<? extends T> converterNode : this.nodes) {
            if (!converterNode.description.equals(s)) continue;
            return converterNode.converter;
        }
        return null;
    }

    public <S extends T> InformationConverter<S> getConverter(Class<S> sclass) {
        for (ConverterNode<? extends T> converterNode : this.nodes) {
            if (!converterNode.type.equals(sclass)) continue;
            return converterNode.converter;
        }
        return null;
    }

    private <S extends T> ConverterNode<S> getNode(Class<S> sclass) {
        for (ConverterNode<? extends T> converterNode : this.nodes) {
            if (!converterNode.type.equals(sclass)) continue;
            return converterNode;
        }
        return null;
    }

    public <S extends T> InformationSet encode(S obj, boolean verbose) {
        ConverterNode<?> node = this.getNode(obj.getClass());
        if (node == null) {
            return null;
        }
        InformationSet info = node.converter.encode(obj, verbose);
        info.setContent(node.description, null);
        return info;
    }

    private class ConverterNode<S extends T> {
        final InformationConverter<S> converter;
        final String description;
        final Class<S> type;

        ConverterNode(InformationConverter<S> converter, String description, Class<S> type) {
            this.converter = converter;
            this.description = description;
            this.type = type;
        }
    }
}

