/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.special.MaSpecification;
import ec.tstoolkit.arima.special.MixedAirlineCompositeModel;
import ec.tstoolkit.arima.special.MixedAirlineMapper;
import ec.tstoolkit.arima.special.MixedAirlineModel;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfAlgorithm;
import ec.tstoolkit.ssf.SsfComposite;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.SsfFunction;
import ec.tstoolkit.ssf.SsfFunctionInstance;
import ec.tstoolkit.ssf.SsfModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Arrays2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MixedAirlineMonitor {
    private TsData m_series;
    private int m_best = -1;
    private HashSet<String> m_computed = new HashSet();
    private ArrayList<MixedEstimation> m_models = new ArrayList();

    public boolean process(TsData series, MaSpecification spec) {
        boolean switched;
        if (series == null) {
            return false;
        }
        this.m_series = series;
        this.m_computed.clear();
        this.m_models.clear();
        this.m_best = -1;
        int freq = series.getFrequency().intValue();
        MixedAirlineModel m = new MixedAirlineModel();
        m.setNoisyPeriods(Arrays2.EMPTY_INT_ARRAY);
        if (spec.airline != null) {
            m.setAirline(spec.airline);
        } else {
            m.setFrequency(freq);
        }
        MixedEstimation rslt = this.estimate(m);
        if (rslt == null) {
            return false;
        }
        SarimaModel airline = rslt.model.getAirline();
        this.m_models.add(rslt);
        double refll = rslt.ll.getLogLikelihood() + 2.0;
        this.m_best = 0;
        if (spec.noisyPeriods != null || spec.allPeriods) {
            m = new MixedAirlineModel();
            m.setAirline(airline);
            if (spec.allPeriods) {
                int[] np = new int[freq];
                for (int i = 0; i < freq; ++i) {
                    np[i] = i;
                }
                m.setNoisyPeriods(np);
            } else {
                m.setNoisyPeriods(spec.noisyPeriods);
            }
            rslt = this.estimate(m);
            if (rslt != null) {
                this.m_models.add(rslt);
                double ll = rslt.ll.getLogLikelihood();
                this.m_best = ll > refll ? 1 : 0;
                refll = ll;
                return true;
            }
            return false;
        }
        int iter = 0;
        boolean[] noisy = new boolean[freq];
        do {
            switched = false;
            for (int i = 0; i < freq; ++i) {
                noisy[i] = !noisy[i];
                m = new MixedAirlineModel();
                m.setAirline(airline.clone());
                int[] noisyPeriods = this.buildNoisyPeriods(noisy);
                boolean success = false;
                if (noisyPeriods != null) {
                    m.setNoisyPeriods(noisyPeriods);
                    String name = m.toString();
                    if (!this.m_computed.contains(name)) {
                        this.m_computed.add(name);
                        rslt = this.estimate(m);
                        if (rslt != null) {
                            this.m_models.add(rslt);
                            double ll = rslt.ll.getLogLikelihood();
                            if (ll > refll) {
                                this.m_best = this.m_models.size() - 1;
                                refll = ll;
                                switched = true;
                                success = true;
                            }
                        }
                    }
                }
                if (success) continue;
                noisy[i] = !noisy[i];
            }
        } while (iter++ <= 5 && switched);
        return true;
    }

    public MixedEstimation getBestModel() {
        if (this.m_best < 0) {
            return null;
        }
        return this.m_models.get(this.m_best);
    }

    public int getBestModelPosition() {
        return this.m_best;
    }

    private MixedEstimation estimate(MixedAirlineModel model) {
        try {
            if (model.getNoisyPeriods().length > 0) {
                model.setNoisyPeriodsVariance(1.0);
            }
            ProxyMinimizer fmin = new ProxyMinimizer(new LevenbergMarquardtMethod());
            MixedAirlineMapper mapper = new MixedAirlineMapper(model);
            SsfFunction<ISsf> fn = this.buildFunction(model, mapper);
            boolean converged = fmin.minimize(fn, fn.evaluate(mapper.map(model.makeSsf())));
            SsfFunctionInstance rfn = (SsfFunctionInstance)fmin.getResult();
            MixedEstimation rslt = new MixedEstimation();
            rslt.ll = rfn.getLikelihood();
            SsfComposite c = (SsfComposite)rfn.ssf;
            rslt.model = ((MixedAirlineCompositeModel)c.getCompositeModel()).toModel();
            rslt.model.stabilize();
            return rslt;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private SsfFunction<ISsf> buildFunction(MixedAirlineModel model, MixedAirlineMapper mapper) {
        SsfData data = new SsfData(this.m_series.internalStorage(), null);
        SsfAlgorithm alg = new SsfAlgorithm();
        SsfFunction<ISsf> eval = new SsfFunction<ISsf>(new SsfModel<ISsf>(model.makeSsf(), data, null, null), mapper, alg, false, true);
        return eval;
    }

    private int[] buildNoisyPeriods(boolean[] noisy) {
        int n = 0;
        for (int i = 0; i < noisy.length; ++i) {
            if (!noisy[i]) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] p = new int[n];
        int i = 0;
        int j = 0;
        while (j < n) {
            if (noisy[i]) {
                p[j++] = i;
            }
            ++i;
        }
        return p;
    }

    public List<MixedEstimation> getAllResults() {
        return this.m_models;
    }

    public static class MixedEstimation {
        public DiffuseConcentratedLikelihood ll;
        public MixedAirlineModel model;
    }
}

