/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IModelEstimator;
import ec.satoolkit.seats.SeatsException;
import ec.satoolkit.seats.SeatsSpecification;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.List;

public class SeatsContext {
    private SeatsSpecification.ApproximationMode changeModel;
    private boolean logTransformed;
    private IModelEstimator estimator;
    public final List<ProcessingInformation> processingLog;

    @Deprecated
    public SeatsContext() {
        this.changeModel = SeatsSpecification.ApproximationMode.Legacy;
        this.processingLog = new ArrayList<ProcessingInformation>();
    }

    public SeatsContext(SeatsSpecification.ApproximationMode changeModel, boolean logTransformed) {
        this.changeModel = changeModel;
        this.logTransformed = logTransformed;
        this.processingLog = new ArrayList<ProcessingInformation>();
    }

    public SeatsContext(SeatsSpecification.ApproximationMode changeModel, boolean logTransformed, boolean uselog) {
        this.changeModel = changeModel;
        this.logTransformed = logTransformed;
        this.processingLog = uselog ? new ArrayList<ProcessingInformation>() : null;
    }

    public IModelEstimator getEstimator() {
        return this.estimator;
    }

    public SeatsSpecification.ApproximationMode getApproximationMode() {
        return this.changeModel;
    }

    public boolean isLogTransformed() {
        return this.logTransformed;
    }

    public void setApproximationMode(SeatsSpecification.ApproximationMode changeModel) {
        this.changeModel = changeModel;
    }

    public void setEstimator(IModelEstimator estimator) {
        this.estimator = estimator;
    }

    public void setLogTransformed(boolean logTransformed) {
        this.logTransformed = logTransformed;
    }

    public void check(TsData s) {
        int freq = s.getFrequency().intValue();
        if (s.getLength() < 3 * freq) {
            throw new SeatsException("Not enough observations");
        }
        if (s.hasMissingValues()) {
            throw new SeatsException("Missing values are not allowed");
        }
    }
}

