/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class MatrixVectorProductParameter
extends Parameter.Abstract
implements VariableListener {
    private final MatrixParameter matrix;
    private final Parameter vector;
    private Bounds bounds = null;

    public MatrixVectorProductParameter(MatrixParameter matrixParameter, Parameter parameter) {
        this.matrix = matrixParameter;
        this.vector = parameter;
        matrixParameter.addVariableListener(this);
        parameter.addVariableListener(this);
        Parameter.CONNECTED_PARAMETER_SET.add(matrixParameter);
        Parameter.CONNECTED_PARAMETER_SET.add(parameter);
    }

    @Override
    public int getDimension() {
        return this.matrix.getRowDimension();
    }

    @Override
    public void setDimension(int n) {
        this.throwError("setDimension()");
    }

    public Parameter getVector() {
        return this.vector;
    }

    public MatrixParameter getMatrix() {
        return this.matrix;
    }

    @Override
    protected void storeValues() {
        this.matrix.storeParameterValues();
        this.vector.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.matrix.restoreParameterValues();
        this.vector.restoreVariableValues();
    }

    @Override
    protected void acceptValues() {
        this.matrix.acceptParameterValues();
        this.vector.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getParameterValue(int n) {
        double d = 0.0;
        for (int i = 0; i < this.matrix.getColumnDimension(); ++i) {
            d += this.matrix.getParameterValue(n, i) * this.vector.getParameterValue(i);
        }
        return d;
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.throwError("setParameterValue()");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.throwError("setParameterValueQuietly()");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.throwError("setParameterValueNotifyChangedAll()");
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    private void throwError(String string) throws RuntimeException {
        throw new RuntimeException("Object " + this.getId() + " is a deterministic function. Calling " + string + " is not allowed");
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            StringBuilder stringBuilder = new StringBuilder("product");
            stringBuilder.append(".").append(this.matrix.getId());
            stringBuilder.append(".").append(this.vector.getId());
            this.setId(stringBuilder.toString());
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        return null;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent();
    }
}

