/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedMultivariateParameter;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.util.CorrelationToCholesky;

public class DiagonalCorrelationMatrix
extends CompoundParameter
implements MatrixParameterInterface {
    private final Parameter diagonalParameter;
    private final Parameter offDiagonalParameter;
    private final boolean asCorrelation;
    private final boolean isCholesky;
    private final int dim;

    public DiagonalCorrelationMatrix(String string, Parameter parameter, Parameter parameter2, boolean bl, boolean bl2) {
        super(string, new Parameter[]{parameter, parameter2});
        assert (bl || !bl2);
        this.diagonalParameter = parameter;
        this.dim = this.diagonalParameter.getDimension();
        this.offDiagonalParameter = !bl2 ? parameter2 : new TransformedMultivariateParameter(parameter2, new CorrelationToCholesky(this.dim), true);
        this.addParameter(this.diagonalParameter);
        this.addParameter(parameter2);
        this.asCorrelation = bl;
        this.isCholesky = bl2;
    }

    @Override
    public double[] getAttributeValue() {
        double[] dArray = new double[this.dim * this.dim];
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[n] = this.getParameterValue(i, j);
                ++n;
            }
        }
        return dArray;
    }

    @Override
    public String toString() {
        return this.toStringCompoundParameter(this.dim * (this.dim + 1) / 2);
    }

    @Override
    public int getDimension() {
        return this.getColumnDimension() * this.getRowDimension();
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = this.getColumnDimension();
        return this.getParameterValue(n / n2, n % n2);
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = this.getColumnDimension();
        String string = Integer.toString(n / n2);
        String string2 = Integer.toString(n % n2);
        return this.getId() + string + string2;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (n != n2) {
            if (this.asCorrelation) {
                return this.offDiagonalParameter.getParameterValue(this.getUpperTriangularIndex(n, n2)) * Math.sqrt(this.diagonalParameter.getParameterValue(n) * this.diagonalParameter.getParameterValue(n2));
            }
            return this.offDiagonalParameter.getParameterValue(this.getUpperTriangularIndex(n, n2));
        }
        return this.diagonalParameter.getParameterValue(n);
    }

    private int getUpperTriangularIndex(int n, int n2) {
        assert (n != n2);
        if (n < n2) {
            return this.upperTriangularTransformation(n, n2);
        }
        return this.upperTriangularTransformation(n2, n);
    }

    private int upperTriangularTransformation(int n, int n2) {
        return n * (2 * this.dim - n - 1) / 2 + (n2 - n - 1);
    }

    @Override
    public double[][] getParameterAsMatrix() {
        int n = this.dim;
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = this.getParameterValue(i, i);
            for (int j = i + 1; j < n; ++j) {
                double d = this.getParameterValue(i, j);
                dArray[i][j] = d;
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    @Override
    public int getColumnDimension() {
        return this.diagonalParameter.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diagonalParameter.getDimension();
    }

    @Override
    public int getUniqueParameterCount() {
        return 0;
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return null;
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
    }

    @Override
    public String toSymmetricString() {
        return null;
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return true;
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Do not set entries of a DiagonalCorrelationMatrix directly");
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Do not set entries of a DiagonalCorrelationMatrix directly");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
    }

    @Override
    public double[] getColumnValues(int n) {
        return new double[0];
    }

    public boolean isCholesky() {
        return this.isCholesky;
    }

    public boolean asCorrelation() {
        return this.asCorrelation;
    }

    public double[] getDiagonal() {
        return this.diagonalParameter.getParameterValues();
    }

    public Parameter getDiagonalParameter() {
        return this.diagonalParameter;
    }

    public Parameter getOffDiagonalParameter() {
        return this.offDiagonalParameter;
    }

    public double[][] getCorrelationMatrix() {
        SymmetricMatrix symmetricMatrix = SymmetricMatrix.compoundCorrelationSymmetricMatrix(this.offDiagonalParameter.getParameterValues(), this.dim);
        if (!this.asCorrelation) {
            for (int i = 0; i < this.dim; ++i) {
                for (int j = i + 1; j < this.dim; ++j) {
                    symmetricMatrix.setSymmetric(i, j, symmetricMatrix.component(i, j) / Math.sqrt(this.diagonalParameter.getParameterValue(i) * this.diagonalParameter.getParameterValue(j)));
                }
            }
        }
        return symmetricMatrix.toComponents();
    }

    public double[] updateGradientCorrelation(double[] dArray) {
        if (!this.isCholesky) {
            return dArray;
        }
        CorrelationToCholesky correlationToCholesky = new CorrelationToCholesky(this.dim);
        double[][] dArray2 = correlationToCholesky.computeJacobianMatrixInverse(((TransformedMultivariateParameter)this.offDiagonalParameter).getParameterUntransformedValues());
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i; j < dArray.length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray2[i][j] * dArray[j];
            }
        }
        return dArray3;
    }

    static enum CorrelationParametrization {
        AS_CORRELATION,
        AS_CHOLESKY;

    }

    static enum SpaceTransform {
        NONE,
        INVERSE;

    }
}

