/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.util.Units;
import dr.evomodel.speciation.MasBirthDeathSerialSamplingModel;
import dr.inference.model.Parameter;

public class TwoParamBirthDeathSerialSamplingModel
extends MasBirthDeathSerialSamplingModel {
    public TwoParamBirthDeathSerialSamplingModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, boolean bl, int n, double d, Units.Type type) {
        super(parameter, parameter2, parameter3, parameter4, parameter5, parameter6, bl, n, d, type);
    }

    @Override
    final void accumulateGradientForInterval(double[] dArray, int n, int n2, double[] dArray2, double d, double[] dArray3, double d2) {
        for (int i = 0; i <= n; ++i) {
            int n3 = i * 5 + 0;
            dArray[n3] = dArray[n3] + (double)n2 * (dArray2[i * 4 + 0] / d - dArray3[i * 4 + 0] / d2);
            int n4 = i * 5 + 2;
            dArray[n4] = dArray[n4] + (double)n2 * (dArray2[i * 4 + 2] / d - dArray3[i * 4 + 2] / d2);
        }
    }

    @Override
    final void accumulateGradientForSerialSampling(double[] dArray, int n, double d, double[] dArray2) {
        for (int i = 0; i <= n; ++i) {
            int n2 = i * 5 + 0;
            dArray[n2] = dArray[n2] + d * dArray2[i * 4 + 0];
            int n3 = i * 5 + 2;
            dArray[n3] = dArray[n3] + d * dArray2[i * 4 + 2];
        }
    }

    @Override
    final void accumulateGradientForIntensiveSampling(double[] dArray, int n, double d, double[] dArray2) {
        for (int i = 0; i < n; ++i) {
            int n2 = i * 5 + 0;
            dArray[n2] = dArray[n2] + d * dArray2[i * 4 + 0];
            int n3 = i * 5 + 2;
            dArray[n3] = dArray[n3] + d * dArray2[i * 4 + 2];
        }
    }

    @Override
    final void dBCompute(int n, double[] dArray) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i * 4 + j] = -2.0 * (1.0 - this.rho) * this.lambda / this.A * this.dPModelEnd[i * 4 + j];
            }
        }
        double d = 1.0 - 2.0 * (1.0 - this.rho) * this.previousP;
        dArray[n * 4 + 0] = (this.A * d - this.dA[0] * (d * this.lambda + this.mu + this.psi)) / (this.A * this.A);
        dArray[n * 4 + 2] = (this.A - this.dA[2] * (d * this.lambda + this.mu + this.psi)) / (this.A * this.A);
    }

    @Override
    final void dPCompute(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        int n2;
        double d4 = this.g1(d3);
        double d5 = -this.A / this.lambda * ((1.0 - this.B) * (d3 - 1.0) + d4) / (d4 * d4);
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < 4; ++i) {
                dArray[n2 * 4 + i] = d5 * this.dB[n2 * 4 + i];
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            double d6 = d3 * (1.0 + this.B) * this.dA[n2] * (d - d2) + (d3 - 1.0) * this.dB[n * 4 + n2];
            dArray2[n2] = this.dA[n2] - 2.0 * (d4 * (this.dA[n2] * (1.0 - this.B) - this.dB[n * 4 + n2] * this.A) - (1.0 - this.B) * d6 * this.A) / (d4 * d4);
        }
        double d7 = this.g2(d4);
        dArray[n * 4 + 0] = (-this.mu - this.psi - this.lambda * dArray2[0] + d7) / (2.0 * this.lambda * this.lambda);
        dArray[n * 4 + 2] = (1.0 - dArray2[2]) / (2.0 * this.lambda);
    }

    @Override
    final void dQCompute(int n, double d, double[] dArray, double d2) {
        double d3 = d - this.modelStartTimes[n];
        double d4 = this.g1(d2);
        double d5 = 8.0 * d2;
        double d6 = d4 / 2.0 - d2 * (1.0 + this.B);
        double d7 = d2 - 1.0;
        double d8 = d4 * d4 * d4;
        double d9 = -d5 * d7 / d8;
        for (int i = 0; i < n; ++i) {
            dArray[i * 4 + 0] = d9 * this.dB[i * 4 + 0];
            dArray[i * 4 + 2] = d9 * this.dB[i * 4 + 2];
        }
        double d10 = d5 / d8;
        double d11 = d3 * d6;
        dArray[n * 4 + 0] = d10 * (this.dA[0] * d11 - this.dB[n * 4 + 0] * d7);
        dArray[n * 4 + 2] = d10 * (this.dA[2] * d11 - this.dB[n * 4 + 2] * d7);
    }
}

