/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.real.exp;

import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.constraints.real.exp.AbstractRealCompoundTerm;
import choco.kernel.solver.variables.real.RealVar;
import java.util.List;
import java.util.Set;

public abstract class AbstractRealBinTerm
extends AbstractRealCompoundTerm {
    protected RealExp exp1;
    protected RealExp exp2;

    public AbstractRealBinTerm(Solver solver, RealExp exp1, RealExp exp2) {
        super(solver);
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    @Override
    public List<RealExp> subExps(List<RealExp> l) {
        this.exp1.subExps(l);
        this.exp2.subExps(l);
        l.add(this);
        return l;
    }

    @Override
    public Set<RealVar> collectVars(Set<RealVar> s) {
        this.exp1.collectVars(s);
        this.exp2.collectVars(s);
        return s;
    }

    @Override
    public boolean isolate(RealVar var, List<RealExp> wx, List<RealExp> wox) {
        boolean dependsOnX = this.exp1.isolate(var, wx, wox) | this.exp2.isolate(var, wx, wox);
        if (dependsOnX) {
            wx.add(this);
        } else {
            wox.add(this);
        }
        return dependsOnX;
    }
}

