/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.AbstractEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateDouble;
import choco.kernel.memory.IStateDoubleVector;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.IStateLong;
import choco.kernel.memory.IStateLongVector;
import choco.kernel.memory.IStateObject;
import choco.kernel.memory.IStateVector;
import choco.kernel.memory.trailing.StoredBinaryTree;
import choco.kernel.memory.trailing.StoredBool;
import choco.kernel.memory.trailing.StoredDouble;
import choco.kernel.memory.trailing.StoredDoubleVector;
import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.memory.trailing.StoredIntProcedure;
import choco.kernel.memory.trailing.StoredIntVector;
import choco.kernel.memory.trailing.StoredLong;
import choco.kernel.memory.trailing.StoredLongVector;
import choco.kernel.memory.trailing.StoredVector;
import choco.kernel.memory.trailing.trail.ITrailStorage;
import choco.kernel.memory.trailing.trail.StoredBinaryTreeTrail;
import choco.kernel.memory.trailing.trail.StoredBoolTrail;
import choco.kernel.memory.trailing.trail.StoredDoubleTrail;
import choco.kernel.memory.trailing.trail.StoredDoubleVectorTrail;
import choco.kernel.memory.trailing.trail.StoredIntTrail;
import choco.kernel.memory.trailing.trail.StoredIntVectorTrail;
import choco.kernel.memory.trailing.trail.StoredLongTrail;
import choco.kernel.memory.trailing.trail.StoredLongVectorTrail;
import choco.kernel.memory.trailing.trail.StoredVectorTrail;

public final class EnvironmentTrailing
extends AbstractEnvironment {
    private int maxWorld = 100;
    private static final int MaxHist = 5000;
    private StoredIntTrail intTrail;
    private StoredBoolTrail boolTrail;
    private StoredVectorTrail vectorTrail;
    private StoredLongTrail longTrail;
    private StoredIntVectorTrail intVectorTrail;
    private StoredDoubleVectorTrail doubleVectorTrail;
    private StoredDoubleTrail doubleTrail;
    private StoredBinaryTreeTrail btreeTrail;
    private StoredLongVectorTrail longVectorTrail;
    private ITrailStorage[] trails = new ITrailStorage[0];
    private int trailSize = 0;

    @Override
    public void worldPush() {
        int wi = this.currentWorld + 1;
        for (int i = 0; i < this.trailSize; ++i) {
            this.trails[i].worldPush(wi);
        }
        ++this.currentWorld;
        if (wi == this.maxWorld - 1) {
            this.resizeWorldCapacity(this.maxWorld * 3 / 2);
        }
    }

    @Override
    public void worldPop() {
        int wi = this.currentWorld;
        for (int i = this.trailSize - 1; i >= 0; --i) {
            this.trails[i].worldPop(wi);
        }
        --this.currentWorld;
    }

    @Override
    public void worldCommit() {
        if (this.currentWorld == 0) {
            throw new IllegalStateException("Commit in world 0?");
        }
        int wi = this.currentWorld;
        for (int i = this.trailSize - 1; i >= 0; --i) {
            this.trails[i].worldCommit(wi);
        }
        --this.currentWorld;
    }

    @Override
    public void clear() {
        for (int i = this.trailSize - 1; i >= 0; --i) {
            this.trails[i].clear();
        }
    }

    @Override
    public IStateInt makeInt() {
        return this.makeInt(0);
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return new StoredInt(this, initialValue);
    }

    @Override
    public IStateInt makeIntProcedure(IStateIntProcedure procedure, int initialValue) {
        return new StoredIntProcedure(this, procedure, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return new StoredBool(this, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector() {
        return new StoredIntVector(this);
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return new StoredIntVector(this, size, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int[] entries) {
        return new StoredIntVector(this, entries);
    }

    @Override
    public IStateLongVector makeLongVector() {
        return new StoredLongVector(this);
    }

    @Override
    public IStateLongVector makeLongVector(int size, long initialValue) {
        return new StoredLongVector(this, size, initialValue);
    }

    @Override
    public IStateLongVector makeLongVector(long[] entries) {
        return new StoredLongVector(this, entries);
    }

    @Override
    public IStateDoubleVector makeDoubleVector() {
        return new StoredDoubleVector(this);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(int size, double initialValue) {
        return new StoredDoubleVector(this, size, initialValue);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(double[] entries) {
        return new StoredDoubleVector(this, entries);
    }

    @Override
    public <T> IStateVector<T> makeVector() {
        return new StoredVector(this);
    }

    @Override
    public IStateDouble makeFloat() {
        return this.makeFloat(Double.NaN);
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return new StoredDouble(this, initialValue);
    }

    @Override
    public IStateBinaryTree makeBinaryTree(int inf, int sup) {
        return new StoredBinaryTree(this, inf, sup);
    }

    @Override
    public IStateLong makeLong() {
        return this.makeLong(0);
    }

    @Override
    public IStateLong makeLong(int init) {
        return new StoredLong(this, init);
    }

    @Override
    public IStateObject makeObject(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int getTrailSize() {
        int s = 0;
        for (int i = 0; i < this.trailSize; ++i) {
            s += this.trails[i].getSize();
        }
        return s;
    }

    private void resizeWorldCapacity(int newWorldCapacity) {
        for (int i = 0; i < this.trailSize; ++i) {
            this.trails[i].resizeWorldCapacity(newWorldCapacity);
        }
        this.maxWorld = newWorldCapacity;
    }

    private void increaseTrail() {
        ITrailStorage[] tmp = this.trails;
        this.trails = new ITrailStorage[tmp.length + 1];
        System.arraycopy(tmp, 0, this.trails, 0, tmp.length);
    }

    protected StoredIntTrail getIntTrail() {
        if (this.intTrail == null) {
            this.intTrail = new StoredIntTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.intTrail;
        }
        return this.intTrail;
    }

    protected StoredLongTrail getLongTrail() {
        if (this.longTrail == null) {
            this.longTrail = new StoredLongTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.longTrail;
        }
        return this.longTrail;
    }

    protected StoredBoolTrail getBoolTrail() {
        if (this.boolTrail == null) {
            this.boolTrail = new StoredBoolTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.boolTrail;
        }
        return this.boolTrail;
    }

    protected StoredDoubleTrail getDoubleTrail() {
        if (this.doubleTrail == null) {
            this.doubleTrail = new StoredDoubleTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.doubleTrail;
        }
        return this.doubleTrail;
    }

    protected StoredVectorTrail getVectorTrail() {
        if (this.vectorTrail == null) {
            this.vectorTrail = new StoredVectorTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.vectorTrail;
        }
        return this.vectorTrail;
    }

    protected StoredIntVectorTrail getIntVectorTrail() {
        if (this.intVectorTrail == null) {
            this.intVectorTrail = new StoredIntVectorTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.intVectorTrail;
        }
        return this.intVectorTrail;
    }

    protected StoredDoubleVectorTrail getDoubleVectorTrail() {
        if (this.doubleVectorTrail == null) {
            this.doubleVectorTrail = new StoredDoubleVectorTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.doubleVectorTrail;
        }
        return this.doubleVectorTrail;
    }

    protected StoredLongVectorTrail getLongVectorTrail() {
        if (this.longVectorTrail == null) {
            this.longVectorTrail = new StoredLongVectorTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.longVectorTrail;
        }
        return this.longVectorTrail;
    }

    public StoredBinaryTreeTrail getBinaryTreeTrail() {
        if (this.btreeTrail == null) {
            this.btreeTrail = new StoredBinaryTreeTrail(5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.btreeTrail;
        }
        return this.btreeTrail;
    }
}

